<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert and ecosoft
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup rate
 * @module rate_ins
 * @package rate
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("rate","ins");
 loadmodule("rate");

 /* Check Input */
 $gotourl = "rate/rate_new.php";

 $msg = "";
 $u = new rate($dbconn);

 if ( isset($_POST['id']) ) {
   $u->read($_POST['id']);
   $gotourl= addUrlParameter($gotourl,"id=". $u->id,true);
 } else {
   $u->creator = $current_user;
 }
 # name
 if ( empty($_POST['name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['RateName']) ."<br>";
 } else {
   $u->setName(StripSlashes($_POST['name']));
   $gotourl= addUrlParameter($gotourl,"name=". UrlEncode($u->name),true);
 }
 # cph
 if ( empty($_POST['cph']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['Rate']) ."<br>";
 } else {
   $u->setCph($_POST['cph']);
   $gotourl= addUrlParameter($gotourl,"cph=". UrlEncode($u->cph),true);
 }
 # currency
 if ( empty($_POST['currency']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['Rate']) ."<br>";
 } else {
   $u->setCurrency($_POST['currency']);
   $gotourl= addUrlParameter($gotourl,"currency=". UrlEncode($u->currency),true);
 }
 # priority
 if ( isset($_POST['priority']) ) {
   $u->setPriority($_POST['priority']);
   $gotourl= addUrlParameter($gotourl,"priority=". UrlEncode($u->priority),true);
 }
 # vat
 if ( isset($_POST['vat']) ) {
   $u->setVat($_POST['vat']);
   $gotourl= addUrlParameter($gotourl,"vat=". UrlEncode($u->vat),true);
 }
 # state
 if ( isset($_POST['state']) ) {
   $u->setState($_POST['state']);
   $gotourl= addUrlParameter($gotourl,"state=". UrlEncode($u->state),true);
 }
 # role
 if ( isset($_POST['role_id']) ) {
   $u->setRole($_POST['role_id']);
   $gotourl= addUrlParameter($gotourl,"role_id=". UrlEncode($u->role_id),true);
 }
 # worker
 if ( isset($_POST['worker']) ) {
   $u->setWorker($_POST['worker']);
   $gotourl= addUrlParameter($gotourl,"worker=". UrlEncode($u->worker),true);
 }
 # reference
 if ( empty($_POST['link_id']) ) {
   $msg .= "No Link ID given !<br>";
 } else {
   $u->setReference($_POST['link_id']);
   $gotourl= addUrlParameter($gotourl,"link_id=". $u->link_id,true);
   $u->read_reference();
 }

 # other modules
 $msg .= module_parseforms($current_user,$u,$gotourl);
 
 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   $msg .= $u->save();
   $dbconn->Commit("WORK");
   $gotourl = $u->ref->getURL();
 }
 
 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);
 
 Header("Status: 302 Moved Temporarily");
 Header("Location: ". dirname(getBaseUrl()) ."/". $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info: $Id: rate_ins.php,v 1.3 2004/02/07 17:06:57 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>