<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * display all product info
 *
 * @modulegroup product
 * @module product_show
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'appointment.pinc';
 include_once 'timetrack.pinc';
 include_once 'task.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','show');

 /**
  * display a product
  */
 class product_show extends layout {
   /**
    * List Roles
    */
   Function showrole($role) {
     global $lang;

     $result = array();
     if( isset($this->obj->role[$role])
	 && (count($this->obj->role[$role]) > 0) ) {

       $result = array();
       
       foreach( $this->obj->role[$role] as $i => $r) {
	 if ( $r->getType() == "department" )
	   $label = $r->getLink($r->getFullName()
				." / ". $r->company->getFullName());
	 else
	   // $label = $r->getLink();
	   $label = array('name'  => $r->getFullName(),
			  'title' => $r->getFullName(),
			  'link'  => $r->getUrl());
	 
	 if ( !empty($this->obj->roledesc[$role][$i]) )
	   $desc = $this->obj->roledesc[$role][$i];
	 else
	   $desc = "";
	 
	 $result[] = array('label' => $label, 'desc' => $desc);
       }
     }
     return $result;
   }
   /**
    * display the info
    */
   Function info() {
     global $tutos,$lang;

     if ( $this->obj->id < 0 ) {
       return;
     }

     $this->assign('title', sprintf($lang['Showing'],
				    $lang[$this->obj->getType()]));

     $this->assign('created_by',
		   array('label' => $lang['createdby'],
			 'name'  => $this->obj->creator->getFullName(),
			 'title' => $this->obj->creator->getFullName(),
			 'link'  => $this->obj->creator->getUrl()));

     $this->assign('created_date',
		   array('label' => $lang['atDateTime'],
			 'value' => $this->obj->creation->getLinkDateTime()));

     $this->assign('ProdName',
		   array('label' => $lang['ProdName'],
			 'value' => myentities($this->obj->name)));

     $this->assign('ProdVersion',
		   array('label' => $lang['ProdVersion'],
			 'value' => myentities($this->obj->version)));

     $this->assign('ProdState',
		   array('label' => $lang['ProdState'],
			 'value' => $lang['ProdStates'][$this->obj->state]));

     /**
      * Parent project
      */
     $parent = "";
     if( $this->obj->parent != -1 && is_object($this->obj->parent) )
       $this->assign('ProdParent',
		     array('label' => $lang['ProdRole'][10],
			   'value' => $this->obj->parent->getFullName(),
			   'title' => $this->obj->parent->getFullName(),
			   'link'  => $this->obj->parent->getUrl()));
     else
       $this->assign('ProdParent',
		     array('label' => $lang['ProdRole'][10],
			   'value' => ""));

     /**
      * Sub Projects
      */
     $sps = array();
     foreach( $this->obj->getSubProjects() as $sp ) {
       $sps[] = array('name'  => $sp->getFullName(),
		      'title' => $sp->getFullName(),
		      'link'  => $sp->getUrl());
     }

     $this->assign("SubProjects",
		   array('label' => $lang['SubProjects'],
			 'value' => $sps));

     if( in_array($this->obj->state, array(0, 4, 5))
	 && ( $this->obj->probability != "" ) )
       $this->assign('ProdProb',
		     array('label' => $lang['ProdProb'],
			   'value' => $this->obj->probability));
     else
       $this->assign('ProdProb', 'none');

     // Roles
     $roles = array();
     $this->obj->readroles();
     foreach( $lang['ProdRole'] as $role => $x ) {
       $tmp = $this->showrole($role);
       if( count($tmp) > 0 )
	 $roles[] = array('name' => $x, 'role' => $tmp);
     }
     $this->assign('roles', $roles);

     // Descriptions
     $this->assign('ProdDesc',
		   array('label' => $lang['ProdDesc'],
			 'value' => myentities($this->obj->description)));

     $this->assign('ProdDesc1',
		   array('label' => $lang['ProdDesc1'],
			 'value' => myentities($this->obj->desc1)));

     $this->assign('ProdDesc2',
		   array('label' => $lang['ProdDesc2'],
			 'value' => myentities($this->obj->desc2)));

     // Classification
     $classes = array();
     for ( $cl = 1;$cl <= $this->obj->classes; $cl++) {
       $options = $this->obj->cl[$cl];
       if( isset($options) && count($options) > 0 ) {
	 $label = $lang['ProdClass'.$cl];
	 $value = array();

         @reset($this->obj->cl[$cl]);
         while( list ($i, $f) = @each($this->obj->cl[$cl]) ) {
           if( isset($lang['ProdClasses'.$cl][$f]) ) {
             $value[] = $lang['ProdClasses'.$cl][$f];
           } else {
	     $value[] = $f;
           }
	 }
	 if( count($value) > 0 )
	   $classes[] = array('label' => $label, 'value' => $value);
       }
     }
     $this->assign("classes", $classes);


     // Product price and cost
     $this->assign('ProdPrice',
		   array('label' => $lang['ProdPrice'],
			 'value' => number_format($this->obj->price, 2,
						  $lang['DecPoint'],
						  $lang['ThousandPoint']),
			 'currency' => $this->obj->currency));

     $this->assign('ProdCost',
		   array('label' => $lang['ProdCost'],
			 'value' => number_format($this->obj->cost, 2,
						  $lang['DecPoint'],
						  $lang['ThousandPoint']),
			 'currency' => $this->obj->currency));

     // Product dates
     $this->assign('ProdStart',
		   array('label' => $lang['ProdStart'],
			 'value' => $this->obj->p_start->GetLinkDate()));
     
     $this->assign('ProdEnd',
		   array('label' => $lang['ProdEnd'],
			 'value' => $this->obj->p_end->GetLinkDate()));

     // TODO
     // appointment::infolist($this->user,$this->obj,4,$this->format);

     $this->assign('ProdPath',
		   array('label' => $lang['ProdPath'],
			 'value' => myentities($this->obj->path),
			 'link'  => $this->obj->path));

     /**
      * Get the task list
      */
     $tasklist = array();
     if ( $this->user->feature_ok(usetaskmanagement, PERM_SEE) ) {
       $this->obj->readTasks();

       foreach( $this->obj->tasklist as $i => $f ) {
	 $tmp = $this->obj->tasklist[$i]->printRow($this->obj);
	 if( count($tmp) > 0 )
	   $tasklist[] = $tmp;
       }
     }
     $this->assign('tasklist',
		   array('label'  => $lang['Tasks'],
			 'llabel' => $lang['TaskOverview'],
			 'link'   => "task_overview.php?id=".$this->obj->id,
			 'ltitle' => sprintf($lang['TaskOverviewInfo'],
					     $this->obj->getFullName()),
			 'image'  => 'folder',
			 'value'  => task::flatten_tasks($tasklist)));
     
     /**
      * Get the modules lists
      */

     // We will need hours for bug summary
     $this->assign('hours', $lang['hours']);
     

     // TODO
     // $list = product::infolist($this->user,$this->obj,4,$this->format);
     // $this->debug($list);
     $infos = show_module_infolists($this->user,$this->obj,4,$this->format);
     // $this->debug($infos);
     $this->assign('modules', $infos);

     // Show product timetrack entries
     if( $this->user->feature_ok(usetimetrack, PERM_SEE) ) {
       $timesum = 0.0;
       $costsum = 0.0;
       $this->obj->readTimetrackSum();

       $this->assign('TimeTrack',
		     array('label' => $lang['Timetrack'],
			   'title' => $lang['TimetrackOverview'],
			   'link'  => "timetrack_overview.php?link_id=".$this->obj->id,
			   'value' => number_format($this->obj->timetracksum,2),
			   'hours' => $lang['hours']
			   ));
     }

     // We have the data, we call the template
     $this->template('product_show');
   }

   /**
    * navigation
    */
   Function navigate() {
     global $tutos, $lang;

     if ( ($this->obj->id > 0) && $this->obj->see_ok() ) {
       if ( $this->user->feature_ok(usetaskmanagement,PERM_SEE) ) {

	 $x = array('url'   => "task_overview.php?id=".$this->obj->id,
		    'text'  => $lang['TaskOverview'],
		    'image' => 'task_overview',
		    'info'  => sprintf($lang['TaskOverviewInfo'],
				       $this->obj->getFullName()),
		    'category' => array("task", "product_show"));
	 $this->addMenu($x);

         if( $tutos[usejpgraph] ) {
	   $x = array( 'url'   => "task_gantt.php?id=".$this->obj->id,
		       'text'  => $lang['TaskGantt'],
		       'image' => 'gantt',
		       'info'  => $lang['TaskGantt'],
		       'category' => array("task", "product_show"));
	   $this->addMenu($x);
         }
       }
       if ( $this->user->feature_ok(usetaskmanagement,PERM_NEW) ) {
         if ( $this->obj->mod_ok() > 0 ) {
	   $x = array( 'url'   => "task_import_csv.php?p_id=".$this->obj->id,
		       'text'  => $lang['TaskImport'],
		       'image' => 'task',
		       'info'  => $lang['TaskImport'],
		       'category' => array("task", "product_show"));
	   $this->addMenu($x);
         }
       }
     }
     $x = array('url'   => "product_show.php?format=paper&amp;id=".$this->obj->id,
		'text'  => $lang['Printable'],
		'image' => 'format',
		'info'  => $lang['PrintableInfo'],
		'category' => array("obj", "product_show"));
     $this->addMenu($x);

     $this->menuprint("task", true);
     $this->menuprint("bug", true);
     $this->menuprint("timetrack", true);
   }

   /**
    * prepare
    */
   Function prepare() {
     global $msg, $lang;

     $this->name = $lang['ProductsDetail'];
     $this->obj = new product($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     }

     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     else {
       $this->name =
	  $lang['ProductsDetail'].": ". myentities($this->obj->getFullName());
     }

     # Menu      
     $x = product::getSelectLink($this->user,$lang['Search']);
     $x['category'][] = "obj";
     $x['image'] = 'search';
     $this->addMenu($x);

     if( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array('url'   => "product_new.php",
                  'text'  => $lang['NewEntry'],
		  'image' => 'new',
		  'info'  => $lang['ProdCreateInfo'],
		  'category' => array("product","new","obj")
		  );
       $this->addMenu($x);

       $x = array('url'   => "product_new.php?pid=".$this->obj->id,
                  'text'  => $lang['ProdSubNew'],
		  'image' => 'new',
		  'info'  => $lang['ProdCreateInfo'],
		  'category' => array("product","new","obj")
		  );
       $this->addMenu($x);
     }

     if( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( 'url'   => $this->obj->getModURL(),
                   'text'  => $lang['Modify'],
		   'image' => 'modify',
                   'info'  => sprintf($lang['ProdModInfo'],
				      $this->obj->getFullname()),
                   'category' => array("product","mod","obj")
                 );
       $this->addMenu($x);
     }

     if( ($this->obj->id > 0) && $this->obj->see_ok() ) {
       $x = array( 'url'   => "acl_show.php?id=".$this->obj->id,
                   'text'  => $lang['AclDetail'],
		   'image' => 'acls',
                   'info'  => sprintf($lang['AclDetailI'],
				      $this->obj->getFullname()),
                   'category' => array("acl","obj")
                 );
       $this->addMenu($x);
     }

     if ( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array( 'url'   => $this->obj->getCloneURL(),
                   'text'  => $lang['CloneEntry'],
		   'image' => 'clone',
                   'info'  => sprintf($lang['ProdCloneInfo'],
				      $this->obj->getFullname()),
                   'category' => array("product","clone","obj")
                 );
       $this->addMenu($x);
     }

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( 'url'   => $this->obj->getDelURL(),
                   'text'  => $lang['Delete'],
		   'image' => 'delete',
                   'info'  => sprintf($lang['ProdDelInfo'],
				      $this->obj->getFullname()),
                   'category' => array("product","del","obj"),
                   'confirm' => true
                 );
       $this->addMenu($x);
     }

     if( $this->obj->id > 0
	 && $this->user->feature_ok(usebugtracking, PERM_SEE) ) {
       $x = array('url'   => "bugtracking/bug_overview.php?show=all&pid=".$this->obj->id,
		  'text'  => $lang['BugsOverview'],
		  'image' => 'bugs',
		  'info'  => $lang['BugsOverview'],
		  'category' => array("bug")
		  );
       $this->addMenu($x);
     }

     if ( ($this->obj->id > 0)
	  && $this->user->feature_ok(usecalendar,PERM_SEE) ) {
       $x = array( 'url' => "calendar.php?team=". $this->obj->id,
                   'text' => $lang['Calendar'],
                   'info' => sprintf($lang['ShowCal'],
				     $this->obj->getFullName()),
                   'category' => array("app","module")
                 );
       $this->addMenu($x);
     }

     $x = timetrack::getaddlink($this->user,$this->obj);
     $this->addMenu($x);

     $x = array('url'   => "timetrack_overview.php?show=all&link_id=".$this->obj->id,
		'text'  => sprintf($lang['TimetrackBookedI'],
				   $this->obj->getFullName()),
		'image' => 'timetrack',
		'info'  => sprintf($lang['TimetrackBookedI'],
				   $this->obj->getFullName()),
		'category' => array("timetrack")
		);
     $this->addMenu($x);


     $x= task::getaddlink($this->user,$this->obj);
     $x['image'] = 'new';
     $this->addMenu($x);

     $x = $this->obj->getMailLink();
     $this->addMenu($x);

     # module
     add_module_addlinks($this, $this->obj);

     # add this page to the browsehistory of the users session
     /*
     $this->addtohistory();
     web_StackStartLayoutObj($this);
     */

   }
 }

 $l = new product_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: product_show.php,v 1.90.2.19 2005/02/10 14:33:36 tapoueh Exp $
    $Author: tapoueh $
-->