<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup product
 * @module select
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','select');

 /**
  * display a project selection form
  */
 class product_select extends layout {
   /**
    *
    */
   Function info() {
     global $lang;

     $this->assign('action', 'product_overview.php');
     $this->assign('ext', $this->ext);

     if( $this->ext == 0 ) {
       $this->assign('title', $lang['SearchForProd']);

       $this->assign('name',
		     array('id'    => 'name',
			   'label' => $lang['AdrName'],
			   'value' => ""));


       $this->assign('search',
		     array('label' => $lang['Search'],
			   'title' => $lang['SearchForProd']));

       $this->assign('info', $lang['ProdSelInfo']);
       
       $this->assign('extlink',
		     array('label' => $lang['extended'],
			   'link'  => "product_select.php?ext=1",
			   'title' => $lang['extended']));
     }
     else {
       $this->assign('title', $lang['SearchForProdExt']);
       
       $this->assign('adrname',
		     array('id'    => 'name',
			   'label' => $lang['AdrName'],
			   'value' => ""));

       $this->assign('search',
		     array('label' => $lang['Search'],
			   'title' => $lang['SearchForBugExt']));

       $states = array();
       $states[-1] = $lang['any'];
       foreach($lang['ProdStates'] as $i => $f)
	 $states[$i] = $f;

       $this->assign('state',
		     array('id'      => 'state',
			   'label'   => $lang['ProdState'],
			   'options' => $states));

       
       // Classification
       $p = new product($this->dbconn);
       $classes = array();
       for ( $cl = 1;$cl <= $p->classes; $cl++) {
	 $options = $p->cl[$cl];

	 if( isset($options) && count($options) > 0 )
	   $classes[] = array('name'    =>  "cl".$cl,
			      'label'   => $lang['ProdClass'.$cl],
			      'options' => $options,
			      'wanted'  => $tutos[classify_products] == 1);
       }
       $this->assign("classes", $classes);

       $this->assign_date($lang['ProdBetween'], "f");
       $this->assign_date("", "t");
     }
     $this->template('product_select');
   }

   /**
    * navigate
    */
   Function navigate() {
   }

   /**
    * prepare
    */
   Function prepare() {
     global $lang;

     $this->name = $lang['ProductsSearch'];

     # Defaults for search
     $this->from = new DateTime(0);
     $this->to = new DateTime(0);

     if ( isset($_SESSION['prodsearchfrom']) ) {
       $this->from->setDateTime($_SESSION['prodsearchfrom']);
     }
     if ( isset($_SESSION['prodsearchto']) ) {
       $this->to->setDateTime($_SESSION['prodsearchto']);
     }
     if ( isset($_SESSION['prodsearchstate']) ) {
       $this->state = $_SESSION['prodsearchstate'];
     } else {
       $this->state = 0;
     }
     $p = new product($this->dbconn);
     $this->class = array();
     for ( $cl = 1;$cl <= $p->classes; $cl++) {
       $y = sprintf("prodsearchcl%d",$cl);
       if ( isset($_SESSION[$y]) ) {
         $this->class[$cl] = $_SESSION[$y];
       } else {
         $this->class[$cl] = 0;
       }
     }
     if ( ! isset($_GET['ext']) ) {
       $this->ext = 0;
     } else {
       $this->ext = $_GET['ext'];
     }
     if ( ! $this->user->feature_ok(useprojects,PERM_SEL) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     if ( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array('url'   => "product_new.php",
                  'text'  => $lang['NewEntry'],
		  'image' => 'new',
                  'info'  => $lang['ProdCreateInfo'],
                  'category' => array("product","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new product_select($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: product_select.php,v 1.26.2.2 2004/05/13 10:37:30 tapoueh Exp $
    $Author: tapoueh $
-->
