<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 * cloning option added by Michal Salaban 2003
 *
 * create a new product_role or modify/clone an existing one
 *
 * @modulegroup product
 * @module product_role_new
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';

 include_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','new');

 /**
  * change/modify a project role
  */
 class product_role_new extends layout {

   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     $this->assign('action', "product_role_ins.php");

     $this->assign('ProdRole',     $lang['ProdRoles']);
     $this->assign('ProdFunc',     $lang['ProdFunc']);
     $this->assign('AdrName',      $lang['AdrName']);
     $this->assign('ProdRoleDesc', $lang['ProdRoleDesc']);
     $this->assign('Remove',       $lang['Remove']);

     if ( $this->template ) {
       $this->assign("tplid", $this->obj->id);
     }
     else if ( $this->obj->id > 0 ) {
       $this->assign("id", $this->obj->id);
     }
     $this->assign("nbadd", count($this->rid));

     // List all roles in this project
     $roles = array();
     if ( $this->obj->id > 0 ) {
       $n = 0;
       foreach ($lang['ProdRole'] as $role => $x) {
         if ( isset($this->obj->role[$role]) ) {
           foreach ($this->obj->role[$role] as $i => $o) {
             if ( $o->id < 1 ) {
               continue;
             }
             if ( $o->getType() == "product" ) {
               continue;
             }

             $val = $o->id .",". $role;
             if ( ! isset($this->obj->rdel[$val]) ) {
               $this->obj->rdel[$val] = "";
             }

	     $roles[] = array('prodrole' => $lang['ProdRole'][$role],
			      'name'  => $o->getFullName(),
			      'title' => $o->getFullName(),
			      'link'  => $o->getUrl(),
			      'desc'  => $this->obj->roledesc[$role][$i],
			      'val'   => $val,
			      'rdel'  => $this->obj->rdel[$val]);
           }
         }
       }
     }

     $this->assign('ProdRolesNew', $lang['ProdRolesNew']);

     $opt_role = array();
     foreach ($lang['ProdRole'] as $role => $x) {
       // No Product Roles
       if ( $tutos[rolecheck][$role] == "p") {
	 continue;
       }
       $opt_role[$role] = myentities($lang['ProdRole'][$role]);
     }

     $newroles = array();
     for($i=0; $i < count($this->rid); $i++) {
       $worker = getObject($this->dbconn, $this->rid[$i]);

       $newroles[] =
	  array('id'       => $i+1,
		'options'  => $opt_role,
		'selected' => $tutos[defaultrole],
		'worker'   => $worker->getFullName(),
		'wtitle'   => $worker->getFullName(),
		'wlink'    => $worker->getUrl(),
		'desc'     => myentities($this->r1desc),
		'size'     => min(30, $table['product2']['description'][size]),
		'maxl'     => $table['product2']['description'][size]);
     }
     $this->assign('newroles', $newroles);

     $this->assign('InputOk',   $lang['InputOk']);
     $this->assign('ChangesOk', $lang['ChangesOk']);
     $this->assign('Enter', $lang['Enter']);
     $this->assign('Reset', $lang['Reset']);
       
     $this->template('product_role_new');
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos;

     $this->name = $lang['Product'];
     $this->obj = new product($this->dbconn);
     $this->r1desc = "";
     $this->r2desc = "";

     $this->template = false;

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
       $this->name = sprintf($lang['ProdRoleAddT'],myentities($this->obj->getFullName()));
       $this->obj->readroles();
     } else if ( isset($_GET['tplid']) ) {
       $this->obj->read($_GET['tplid']);
       $this->template = true;
       if ( $this->obj->tplid < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true;
       }
       $this->name = sprintf($lang['ProdCloneT'],myentities($this->obj->getFullName()));;
       $this->obj->readroles();
     } else {
       $this->name = $lang['ProdCreateT'];
       $this->obj->r1 = $this->user;
     }

     # Set the default role according to config file
     $this->obj->rsel1 = $tutos[defaultrole];

     # People Team Relations
     if( isset($_GET['rid']) ) {
       $rid = $_GET['rid'];

       if( is_array($rid) )
	 $this->rid = $rid;

       $this->obj->r1 = new tutos_user($this->dbconn);
       $this->obj->r1->read($this->rid[0]);
     }
     
     if ( (($this->obj->id < 0) || ($this->template)) && !$this->user->feature_ok(useprojects,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     $x = product::getSelectLink($this->user,$lang['Search']);
     $x['category'][] = "obj";
     $this->addmenu($x);
     if ( $this->user->feature_ok(useprojects,PERM_NEW) ) {
       $x = array('url'   => "product_new.php",
		  'image' => 'new',
                  'text'  => $lang['NewEntry'],
                  'info'  => $lang['ProdCreateInfo'],
                  'category' => array("product","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( 'url'   => "product_del.php?id=".$this->obj->id,
		   'image' => 'delete',
                   'text'  => $lang['Delete'],
                   'info'  => sprintf($lang['ProdDelInfo'],
				     $this->obj->getFullname()),
                   'category' => array("product","del","obj"),
                   'confirm'  => true
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new product_role_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: product_role_new.php,v 1.3.2.4 2005/04/07 16:43:24 tapoueh Exp $
    $Author: tapoueh $
-->