<?php
/**
 * Copyright 2000 - 2002 by Gero Kohnert
 *
 * @modulegroup phpweater
 * @module pw_show
 * @package phpweather
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'pw.pinc';

 include(PHPWEATHER_BASE_DIR . "/output/pw_text_en.php");
 include(PHPWEATHER_BASE_DIR . "/output/pw_images.php");

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("phpweather","show");
 loadlayout();
 /**
  * display a note 
  */
 class pw_show extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$tutos;

     $type = 'pw_text_en';
     $text = new $type($this->obj);
     $icons = new pw_images($this->obj);
	 $icons->properties['icons_path'] = "../../phpweather/icons/";
     echo $this->DataTableStart();
     echo "<tr><th colspan=\"4\">". $lang['WeatherReport'] ."</th></tr>\n";
     echo "<tr>\n";
     echo $this->showfield($lang['createdby']);
     echo $this->showdata(PHPWEATHER_BASE_DIR,3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td colspan=\"4\">\n";
     echo '<p>This is the current weather in ' .
          $this->obj->get_location() . ":</p>\n<blockquote>\n" .
          $text->print_pretty() . "\n</blockquote>\n" .
          "<p>The matching icons are:</p>\n<blockquote>\n" .
          '<img src="' . $icons->get_sky_image() .
          '" height="50" width="80" border="1" alt="Current weather in ' .
          $this->obj->get_location() . '" /> ' .
          '<img src="' . $icons->get_winddir_image() .
          '" height="40" width="40" border="1" alt="Current wind in ' .
          $this->obj->get_location() . '" /> ' .
          '<img src="' . $icons->get_temp_image() .
          '" height="50" width="20" border="1" alt="Current temperature in ' .
          $this->obj->get_location() . '" />' .
          "\n</blockquote>\n" .
          "<p>The raw METAR is <code>" .
          $this->obj->get_metar() . "</code></p>\n";
     echo " </td>\n";
     echo "</tr>\n";
#     $country = "";
#     $icaos = $this->obj->db->get_icaos("DE",$country);
#     foreach($icaos as $i => $f) {
#       echo "<tr>\n";
#       echo $this->showfield($i);
#       echo $this->showdata($f,1);
#       echo $this->showdata(similar_text($f,$this->city,$x)." ". $x,1);
#       echo $this->showdata(levenshtein($f,$this->city),1);
#       echo "</tr>\n";
#     }

     # References to modules
     show_module_infolists($this->user,$this->obj,4);
     echo $this->DataTableEnd();
   }
   /**
    * navigation
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $x = new pw($this->dbconn);
     $this->name = $lang['WeatherReport'];
     $this->obj = &$x->pw;
     $this->ask_cc = false;
     $this->icao = "EDDF";

	 if (isset($_GET['l'])) {
       $l = new location($this->dbconn);
       $l->read($_GET['l']);
       $this->city = $l->city;
	   $this->name .= " ". $this->city;
       $this->cc = $l->country;
	   $this->name .= " / ". $this->cc;

       # search for some useful ICAO
       $countries = $this->obj->db->get_countries();
#	   var_dump($countries);
#	   var_dump($this->cc);
	   if ( !in_array($this->cc, array_keys($countries))) {
         $this->ask_cc = true;
	   }
	   if ( $this->ask_cc == false) {
         $icaos = $this->obj->db->get_icaos($this->cc,$country);
		 $dist1 = 0.0;
		 $dist2 = 255;
         foreach($icaos as $i => $f) {
           $d1 = similar_text($f,$this->city,$d3);
           $d2 = levenshtein($f,$this->city);
           if ($d1 > $dist1) {
             $dist1 = $d1;
             $i1 = $i;
             $i3 = $i;
           }
           if ($d2 < $dist2) {
             $dist2 = $d2;
             $i2 = $i;
           }
		 }
		 $this->icao=$i1;
#		 echo $icaos[$i1] ." sim<br>";
#		 echo $icaos[$i2] ." lev<br>";
	   }
     }
     $this->obj->set_icao($this->icao);
   }
 }

 $l = new pw_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: pw_show.php,v 1.1 2002/12/10 21:05:28 gokohnert Exp $
    $Author: gokohnert $
-->
