<?php
/*
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * based on some work/ideas of Michael Somers( Twent First Century Communication <msomers at tfcci.com>)
 */

 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'calendar.p3';
 include_once 'product.pinc';
 include_once 'appointment.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';

 require_once 'layout/layout.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('mytutos','show');
 loadmodule("watchlist");
 
 /* Web stack start */
 web_StackStart('mytutos.php','mytutos.php',$current_user->getFullName(),sprintf($lang['PersonalPageFor'],$current_user->getFullname()));

 /**
  * display an overview of everything that's interessting for an user
  */
 class mytutos extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $lang , $tutos;

     $this->assign('title', sprintf($lang['PersonalPageFor'],
				    $this->adr->getFullname()));

     $usecalendar = $this->user->feature_ok(usecalendar, PERM_SEE); 
     $this->assign('usecalendar', $usecalendar);
     if( $usecalendar ) {
       /**
	* Prepare the display of the current week calendar
	* This assign vars to our $layout->smarty object.
	*/
       $weeks = cal_week($this->adr, $this->t);
       $this->assign('weeks', $weeks);

       $this->assign('last_week', $weeks[0]['last']);
       $this->assign('next_week', $weeks[0]['next']);
       
       $this->assign('week', $lang['week']);
       $this->assign('wdays', $weeks[0]['wdays']);
       $this->assign('calendar', $lang['Calendar']);
       
       $this->assign('lastw_href',  "?t=".$weeks[0]['last']);
       $this->assign('lastw_img',   'left');
       $this->assign('lastw_label', $lang['lastweek']);
       
       $this->assign('nextw_href',  "?t=".$weeks[0]['next']);
       $this->assign('nextw_img',   'right');
       $this->assign('nextw_label', $lang['nextweek']);
     }

     $this->assign('ProductP', $lang['ProductP']);
     $this->assign('ProdName', $lang['ProdName']);
     $this->assign('ProdFunc', $lang['ProdFunc']);
     $this->assign('ProdCreationS', $lang['ProdCreationS']);

     // $this->assign('products', product::mytutos($this->adr));
     // We want running only projects
     $this->assign('products',
		   product::infolist($this->user, $this->adr, True));

     $this->assign('Bugs',         $lang['Bugs']);
     $this->assign('BugID',        $lang['BugID']);
     $this->assign('BugReference', $lang['BugReference']);
     $this->assign('BugClass',     $lang['BugClass']);
     $this->assign('BugState',     $lang['BugState']);

     $blist = bug::mytutos($this->adr);
     $this->assign('bugs', bug::mytutos($this->adr));

     /*
     foreach($tutos[activemodules] as $i => $f) {
       $x = new $tutos[modules][$f][name]($this->dbconn);
       $r = $x->mytutos($this->adr);

       $this->assign($f, $r);
     }
     */
     $this->template('mytutos');
   }

   /**
    * navigation
    */
   Function navigate() {
     global $tutos, $lang ;

     if ( $this->user->feature_ok(usetimetrack,PERM_SEE) ) {
       $x = array('url'   => "timetrack_overview.php?worker=".$this->adr->id,
                  'text'  => $lang['TimetrackBooked'],
		  'image' => 'timetrack',
                  'info'  => sprintf($lang['TimetrackBookedI'],
				     $this->adr->getFullName()),
		   'category' => array("mytutos", "obj")
		   );
       $this->addMenu($x);
     }

     if ( $this->adr->mod_ok() ) {
       $x = array('url'  => "user_new.php?id=".$this->adr->id,
                  'text' => $lang['PersonalSettings'],
                  'info'  => sprintf($lang['PersonalPageFor'],
				     $this->adr->getFullName()),
		  'image' => 'user',
		  'category' => array("mytutos", "obj")
		   );
       $this->addMenu($x);
     }

     if ( $this->user->feature_ok(usetaskmanagement,PERM_SEE)
	  &&  $this->user->feature_ok(usecalendar,PERM_SEE) ) {

       $x = array('url'   => "res_cal.php?id=".$this->adr->id,
                  'text'  => $lang['ResCal'],
                  'info'  => $lang['ResCal'],
		  'image' => 'resource',
		  'category' => array("mytutos", "task")
		   );
       $this->addMenu($x);
     }     
     
     $x = watchlist::getOverviewLink($this->user);
     $x['category'] = array("obj");
     $this->addMenu($x);
     
     // FIXME: The menu points to parts not yet implemented
     // $this->menuprint("mytutos", true);
     $this->menuprint("task", true);
   }

   /**
    * prepare
    */
   Function prepare() {
     global $lang ;

     $this->name = $lang['PersonalPage'];
     $this->t = Date("Ymd");
     $this->adr = new tutos_user($this->dbconn);

     if ( isset($_GET['t']) ) {
       $this->t = $_GET['t'];
     }
     if ( isset($_GET['adr']) ) {
       $this->adr->read($_GET['adr']);
	   $this->adr->layout = $this->user->layout;
     }
     if ( $this->adr->id == -1 ) {
       $this->adr = &$this->user;
     }
     if (! $this->adr->see_ok() ) {
       $this->adr = &$this->user;
     }

     $x = task::getaddlink($this->user,$this->adr);
     $this->addMenu($x);

     /**
      * The timetrack menu entries will be displayed in the  obj 
      * menu part.
      */ 
     $x = timetrack::getaddlink($this->user, $this->adr);
     $x['category'] = array('obj');
     $this->addMenu($x);

     $x = timetrack::getSelectLink($this->user,$lang['TimetrackSearch']);
     $this->addMenu($x);

     if ( $this->user->feature_ok(usetaskmanagement,PERM_SEE) ) {
       $x = array('url'   => "task_overview.php?id=".$this->adr->id,
                  'image' => 'task_overview',
                  'text'  => $lang['TaskOverview'],
                  'info'  => sprintf($lang['TaskOverviewInfo'],
				    $this->adr->getFullName()),
                   'category' => array("overview","task")
                 );
       $this->addMenu($x);
     }

    if ( $this->user->feature_ok(usehistory,PERM_SEE) ) {
       $x = array('url'  => "history_show.php?adr_id=".$this->adr->id,
                  'text' => $lang['HistoryLink'],
                  'info' => sprintf($lang['HistoryLinkI'],
				   $this->adr->getFullName()),
                   'category' => array("overview","history")
                 );
       $this->addMenu($x);
    }
   }
 }

 $l = new mytutos($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: mytutos.php,v 1.84.2.22 2005/03/09 15:54:28 tapoueh Exp $
    $Author: tapoueh $
-->
