<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup installation
 * @module installation_overview
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("installation","overview");
 loadmodule("installation");
 loadlayout();

 /**
  * display an overview of installations
  */
 class installation_overview extends layout {
   /**
    * the real overview part
    */
   Function info() {
     global $lang,$tutos;

     $result = $this->dbconn->Exec($this->q);
     $n = $result->numrows();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }
     # Make a big array of all visible installations
     $x = 0;
     while ( $x < $n ) {
       $b = new installation($this->dbconn);
       $b->read_result($result,$x);
       $x++;
       if ( ! $b->see_ok() ) {
         continue;
       }
       $blist[] = &$b;
       unset($b);
     }
     $n = count($blist);
     $result->free();
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       return;
     }
     $cols = 5;
     echo $this->actionformStart("installation_overview.php");
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("","#",$this->link1);
     echo $this->orderHeader("",$lang['Product'],$this->link1);
     echo $this->orderHeader("",$lang['Customer'],$this->link1);
     echo $this->orderHeader("description",$lang['Description'],$this->link1);
     echo $this->orderHeader("instdate",$lang['Date'],$this->link1);
     $cols += show_module_overviewheader($this->user,"installation");
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
       $cols++;
     }
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $i = &$blist[$a];
       $a++;
       echo $this->OverviewRowStart($line);
       echo " <td align=\"right\">". $i->getLink(sprintf("%03d",$a)) ."</td>\n";
       echo " <td>";
       if ( $i->product != -1 ) {
         echo $i->product->getLink();
       } else {
         echo "<i>". $lang['HistoryDeleted'] ."</i>";
       }
       echo "</td>\n";
       if ( $i->customer == -1 ) {
         echo " <td><i>". $lang['HistoryDeleted'] ."</i></td>\n";
       } else if ( $i->customer->id != -1 ) {
         echo " <td>". $i->customer->getLink() ."</td>\n";
       } else {
         echo " <td>&nbsp;</td>\n";
       }
       echo " <td>". myentities($i->description) ."&nbsp;</td>\n";
       echo " <td>". $i->instdate->getLinkDate() ."</td>\n";
       show_module_overviewdata($this->user,$i);
       if ( $tutos[massupdate] == 1 ) {
         echo " <td align=\"center\">\n";
         if ( $i->mod_ok() ) {
           echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $i->id ."\">\n";
         } else {
           echo "-\n";
         }
         echo "</td>\n";
       }
       echo $this->OverviewRowEnd($line++);
     }

     echo $this->list_navigation($this->link1,$cols,$this->start,$a,$n);

     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart($cols -2);
       echo sprintf($lang['withmarked'],$lang['Bugs']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option value=\"-2\">". $lang['Delete'] ."</option>\n";
       echo " <option value=\"-4\">". $lang['AclModify'] ."</option>\n";
       if (class_exists('watchlist')) {
         echo " <option value=\"WatchAdd\">". $lang['WatchAdd'] ."</option>\n";
         echo " <option value=\"WatchDel\">". $lang['WatchDel'] ."</option>\n";
       }
       echo "</select>\n";
       echo $this->UpdateRowEnd(2);
     }

     echo $this->OverviewTableEnd();
     echo $this->actionformEnd("installation_overview.php");
   }
   /**
    * navigation
    */
   Function navigate() {
   }
   /**
    * action via massupdate
    */
   Function action() {
     global $lang,$msg;

     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $b = new installation($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }
         if ( $b->del_ok() ) {
           $msg .= sprintf($lang['InstDelI'], $b->getFullName()) ."<br>";
           $msg .= $b->delete();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0023'],$lang[$b->getType()]) ."<br>\n";
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
       return;
     }
     if ( $_GET['action'] == -4 ) {
       $this->redirect = acl_action();
       return;
     }
     if (class_exists('watchlist')) {
       watchlist::parse_action($this->user);
     }
   }
   /**
    * preapre everything read data , parse args etc
    */
   Function prepare() {
	 global $lang;

     $this->name = $lang['InstOverview'];

     if ( ! $this->user->feature_ok(useinstmanagement,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     $link1 = "installation/installation_overview.php";
     $q = "SELECT * FROM ". $this->dbconn->prefix ."installations";
     $pre = " WHERE ";

     if ( isset($_GET['link_id']) ) {
       $link1 = addUrlParameter($link1,"link_id=". $_GET['link_id']);
       $o = getObject($this->dbconn,$_GET['link_id']);
       if ( $o->id > 0 ) {
         if ( $o->getType() == "product" ) {
           $q .= $pre ."product_id = ". $o->id;
           $pre = " AND ";
         } else if ( $o->getType() == "company" ) {
           $q .= $pre ."customer_id = ". $o->id;
           $pre = " AND ";
         } else if ( $o->getType() == "address" ) {
           $q .= $pre ."customer_id = ". $o->id;
           $pre = " AND ";
         }
       }
     }
     check_dbacl( $q, $this->user->id);
     # sorting
     $xxx = "";
     order_parse($q,$link1,$xxx,$xxx,"instdate");
 
     $this->q = $q;
     $this->link1 = $link1;
     if ( isset($_GET['start']) )  {
       $this->start = $_GET['start'];
     } else {
       $this->start = 0;
     }

     if ( $this->user->feature_ok(useinstmanagement,PERM_NEW) ) {
       $x = array( url => "installation/installation_new.php",
                   confirm => false,
                   text => $lang['NewEntry'],
                   info => sprintf($lang['InstCreateI'],""),
                   category => array("installation","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new installation_overview($current_user);
 $l->display();


 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: installation_overview.php,v 1.16 2003/10/22 17:47:21 gokohnert Exp $
    $Author: gokohnert $
-->
