<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup installation
 * @module installation_new
 * @package installation
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("installation","new");
 loadmodule("installation");
 loadlayout();

 /**
  * change/modify a installation
  */
 class installation_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang,$table;

     echo "<form name=\"instadd\" METHOD=\"post\" action=\"installation_ins.php\">\n";
     echo $this->DataTableStart();
     echo "<tr><th colspan=\"4\">". $lang['Installation'] ."</th></tr>\n";
     echo "<tr><td align=\"right\" colspan=\"4\">". acl_link($this->obj) ."</td></tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['Product'],1,"pid");
     echo " <td colspan=\"3\">";
     if ( $this->obj->product == -1 ) {
       echo "<select name=\"pid\">\n";
       foreach ($this->obj->plist as $i => $f) {
         echo "<option value=\"". $i ."\"". ($i == $this->obj->product->id ? " selected>* ":">") . $lang[$f->getType()] .": ". $f->getFullName() ."</option>\n";
       }
       echo "</select>\n";
     } else {
       echo $this->obj->product->getLink();
       $this->addHidden("pid",$this->obj->product->id);
     }
     echo "</td></tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['Customer'],1,"c");
     echo " <td colspan=\"3\">\n";
     select_from_array_or_input($this->obj,"c",$this->obj->customer,0);
     echo "</td></tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['Description'],0,"desc");
     echo " <td colspan=\"3\"><input id=\"desc\" name=\"desc\" size=\"". min($table['installation']['description'][size],60) ."\" maxlength=\"". $table['installation']['description'][size] ."\" value=\"". $this->obj->description ."\">\n";
     echo "</td></tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['InstalledBy'],0,"i");
     echo " <td>\n";
     select_from_array_or_input($this->obj,"i",$this->obj->installer,1);
     echo " </td>\n";
     echo $this->showfieldc($lang['atDateTime'],0);
     echo " <td>\n";
     $this->obj->instdate->EnterDate("inst");
     echo "</td></tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['SoldBy'],0,"s");
     echo " <td>\n";
     select_from_array_or_input($this->obj,"s",$this->obj->seller,1);
     echo " </td>\n";

     echo $this->showfieldc($lang['atDateTime'],0);
     echo " <td>\n";
     $this->obj->salesdate->EnterDate("sale");
     echo "</td></tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['Money'],0,"money");
     echo "<td><input id=\"money\" size=\"10\" maxlength=\"10\" name=\"money\" value=\"". $this->obj->money ."\"></td>";
     echo $this->showfieldc($lang['Currency'],0);
     echo "<td colspan=\"1\" valign=\"top\">";
     Currency_Select("currency",$this->obj->currency);
     echo "</td></tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,4);

     if ( $this->obj->mod_ok() != 0 ) {
       echo "<tr>\n";
       if ( $this->obj->id > 0 ) {
         submit_reset(0,1,1,1,1,0);
       } else {
         submit_reset(0,-1,1,1,1,0);
       }
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("instadd.desc");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos;

     $this->obj = new installation($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->name = $lang['InstModify'] .": ". $this->obj->getFullName();
       $this->addHidden("id",$this->obj->id);
     } else {
       $this->name = $lang['InstCreate'];
     }
     if ( isset($_GET['pid']) ) {
       $this->obj->product = getObject($this->dbconn,$_GET['pid']);
       $this->obj->money = $this->obj->product->price;
       $this->obj->currency = $this->obj->product->currency;
     } else {
       $this->obj->read_relations();
     }

     if ( isset($_GET['money']) ) {
       $this->obj->money = $_GET['money'];
     }
     if ( isset($_GET['currency']) ) {
       $this->obj->currency = $_GET['currency'];
     }
     if ( isset($_GET['desc']) ) {
       $this->obj->description = $_GET['desc'];
     }

     # Installer
     preset_from_array_or_input($this->obj,'installer',"i");

     if ( $this->obj->installer->id == -1 ) {
       if ( $this->obj->product->id != -1 ) {
         # Defaults to manager
         $this->obj->installer = $this->obj->product->role[1];
       } else {
         $this->obj->installer = $this->user;
       }
     }

     # Seller
     preset_from_array_or_input($this->obj,'seller',"s");

     if ( $this->obj->seller->id == -1 ) {
       if ( $this->obj->product->id != -1 ) {
         # Defaults to manager
         $this->obj->seller = $this->obj->product->role[4];
       } else {
         $this->obj->seller = $this->user;
       }
     }

     # Customer
     preset_from_array_or_input($this->obj,'customer',"c");

     if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     $m = installation::getOverviewLink($this->user,$lang['Installations']);
     $m[category][] = "obj";
     $this->addmenu($m);
     if ( $this->user->feature_ok(useinstmanagement,PERM_NEW) ) {
       $x = array( url => "installation/installation_new.php",
                   confirm => false,
                   text => $lang['NewEntry'],
                   info => sprintf($lang['InstCreateI'],""),
                   category => array("installation","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => $this->obj->getDelURL(),
                   text => $lang['Delete'],
                   info => sprintf($lang['InstDelI'],$this->obj->getFullname()),
                   category => array("installation","del","obj"),
                   confirm => true
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new installation_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: installation_new.php,v 1.11 2003/10/22 17:47:21 gokohnert Exp $
    $Author: gokohnert $
-->