<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup installation
 * @module installation_ins
 * @package installation
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("installation","ins");
 loadmodule("installation");

 $obj = new installation($dbconn);
 $gotourl = "installation/installation_new.php";
 $msg = "";
 if ( isset($_POST['id']) ) {
   $obj->read($_POST['id']);
   $gotourl= addUrlParameter($gotourl,"id=". $_POST['id'],true);
 }

 if ( empty($_POST['pid']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['Product']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"pid=". $_POST['pid'],true);
 }

 if ( isset($_POST['cfn']) ) {
   if ( empty($_POST['cfn']) ) {
     $msg .= sprintf($lang['Err0009'],$lang['Customer']) ."<br>";
   } else {
     $x = check_field($_POST['cfn'],"cfn","cl","acd");
     $obj->setCustomer($x->id);
   }
 }

 if ( isset($_POST['ifn']) ) {
   $x = check_field($_POST['ifn'],"ifn","il");
   $obj->setInstaller($x->id);
 }
 if ( isset($_POST['desc']) ) {
   $obj->setDescription(trim(StripSlashes($_POST['desc'])));
   $gotourl= addUrlParameter($gotourl,"desc=". UrlEncode(StripSlashes($_POST['desc'])),true);
 }

 if ( isset($_POST['sfn']) ) {
   $x = check_field($_POST['sfn'],"sfn","sl","at");
   $obj->setSeller($x->id);
 }

 $money = 0.0;
 list($money) = sscanf($_POST['money'],"%f");
 if ( !empty($money) && !is_double($money) ) {
   $msg .= sprintf($lang['Err0017'],$lang['Money']) ."<br>";
 }
 $gotourl= addUrlParameter($gotourl,"money=". UrlEncode($money),true);
 $gotourl= addUrlParameter($gotourl,"currency=". UrlEncode($_POST['currency']),true);

 $sd = new DateTime();
 $id = new DateTime();
 $sd->setDateTimeF("sale");
 $id->setDateTimeF("inst");

 $obj->setInstdate($id);
 $obj->setSalesdate($sd);

 # other modules
 $msg .= module_parseforms($current_user,$obj,$gotourl);


 if ( $msg == "" ) {
   $obj->setMoney($money);
   $obj->setCurrency($_POST['currency']);
   $obj->product = getObject($dbconn,$_POST['pid']);

   if ( isset($_POST['iid']) ) {
     $obj->setInstaller($_POST['iid']);
   }

   if ( isset($_POST['cid']) ) {
     $obj->setCustomer($_POST['cid']);
   }

   if ( isset($_POST['sid']) ) {
     $obj->setSeller($_POST['sid']);
   }

   $dbconn->Begin("WORK");
   $msg .= $obj->save();
   $dbconn->Commit("WORK");

   $gotourl = $obj->getUrl();
 }

 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 /* Go back to user mask */
 Header("Status: 302 Moved Temporarily");
 Header("Location: ". dirname(getBaseUrl()) ."/". $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: installation_ins.php,v 1.10 2003/08/24 09:50:47 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>