<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup bug
 * @module bug_ins
 * @package bug
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'location.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';
 include_once 'mail.pinc';


 /* Check if user is allowed to use it */
 check_user();
 loadmodules("bugtracking","new");
 loadmodule("bugtracking");


 $gotourl = "bug_new.php";
 $msg = "";

/**
 * Creating a bug means creating a bug element and its firts history entry.
 *
 * Editing a bug may implies bug edition, and always implies creation
 * a a new bug history entry.
 */

$b = new bug($dbconn);
$h = new bugdata($dbconn);

 if ( isset($_POST['id']) ) {
   $gotourl= addUrlParameter($gotourl,"id=". $_POST['id'],true);
   $b->read($_POST['id']);
   $b->read_bughistory();
 }

 $h->description = "";

 if ( empty($_POST['name']) || !isset($_POST['name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['BugID']) ."<br>";
 } else {
   $name = StripSlashes($_POST['name']);
   $gotourl= addUrlParameter($gotourl,"name=". UrlEncode($name),true);
 }

 if ( (empty($_POST['description']) || !isset($_POST['description']) ) && ($b->id < 0 )) {
   $msg .= sprintf($lang['Err0009'],$lang['BugAdditional']) ."<br>";
 } else {
   $description = StripSlashes($_POST['description']);
   $gotourl= addUrlParameter($gotourl,"description=". UrlEncode($description),true);
 }

 if ( empty($_POST['short']) || !isset($_POST['short']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['BugShort']) ."<br>";
 } else {
   $short = StripSlashes($_POST['short']);
   $gotourl= addUrlParameter($gotourl,"short=". UrlEncode($short),true);
 }

 if ( isset($_POST['pid']) ) {
   $gotourl= addUrlParameter($gotourl,"pid=". $_POST['pid'],true);
   $oldparent = $b->parent;
   $b->setParent(getObject($dbconn,$_POST['pid']));
 } else {
   $msg .= sprintf($lang['Err0009'],$lang['Product']) ."<br>";
 }

 if ( empty($_POST['state']) || !isset($_POST['state']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['BugState']) ."<br>";
 } else {
   $state = $_POST['state'];
   $gotourl= addUrlParameter($gotourl,"state=". $state,true);
 }
 if ( empty($_POST['class']) || !isset($_POST['class']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['BugClass']) ."<br>";
 } else {
   $class = $_POST['class'];
   $gotourl= addUrlParameter($gotourl,"class=". $class,true);
 }

 if ( empty($_POST['sfn']) || !isset($_POST['sfn']) ) {
   if ( isset($_POST['sid']) ) {
     $solver = getObject($dbconn,$_POST['sid']);
   } else {
     $msg .= sprintf($lang['Err0009'],$lang['BugAssignedTo']) ."<br>";
   }
 } else {
   $solver = check_field($_POST['sfn'],"sfn","sl");
 }

 if ( !checkfloat($_POST['volume'],false) ) {
   $msg .= sprintf($lang['Err0009'],$lang['TaskVolumeDone']) ."<br>";
 }
 else {
   $volume = $_POST['volume'];
   $gotourl= addUrlParameter($gotourl, "volume=". UrlEncode($volume), true);
 }

 # other modules
 $msg .= module_parseforms($current_user,$b,$gotourl);

 if ( $msg != "" ) {
   $gotourl = addMessage($gotourl,$msg,true);
   $gotourl = addSessionKey($gotourl,true);
   Header("Status: 302 Moved Temporarily");
   Header("Location:". getBaseUrl() . $gotourl);
   return;
 }

 if( $b->id < 0 ) {
   /**
    * On bug creation the user may choose who the bug is affected to
    */
   if( is_object($solver) ) {
     $h->solver = $solver;
   }
   else {
     if ( $b->parent->getType() == "product" ) {
       $b->parent->readroles();
       if ( count($b->parent->role[PROD_ROLE_MANAGER]) > 0 )
	 $h->solver = current($b->parent->role[PROD_ROLE_MANAGER]);
       else if ( count($b->parent->role[PROD_ROLE_MANAGER2]) > 0 )
	 $h->solver = current($b->parent->role[PROD_ROLE_MANAGER2]);
       else
	 $h->solver = $current_user;
     }
     else
       $h->solver = $current_user;
   }
 }
 else
  $h->solver = $solver;

// To be able to send the mail, we still need the solver in the bug
// object itself
 $b->solver = $h->solver;
 $b->description = $h->description;

 $b->setName($name);
 $b->setShort($short);

 $h->state  = $state;
 $h->class  = $class;
 $h->volume = $volume;
 $h->description = $description;

if( $b->id > 0 ) {
  $h->bugid = $b->id;

  $dbconn->Begin("WORK");
  $msg .= $b->save();
  $msg .= $h->save();
  $dbconn->Commit("WORK");
}
else {
  // We have to create the bug first, then give its ID to $h
  $dbconn->Begin("WORK");
  $msg .= $b->save();
  $dbconn->Commit("WORK");

  if( $b->id > 0 ) {
    $h->bugid = $b->id;

    $dbconn->Begin("WORK");
    $msg .= $h->save();
    $dbconn->Commit("WORK");
  }
}

 $gotourl = $b->getUrl();
 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location:". dirname(getBaseUrl()) ."/". $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: bug_ins.php,v 1.7.2.3 2004/12/10 15:41:36 tapoueh Exp $
  *  $Author: tapoueh $
  */
?>
