<?php

$tutos['base'] = "../..";
ini_set("include_path","..");

include_once 'acl.pinc';
include_once 'webelements.p3';
include_once 'permission.p3';

include_once 'task.pinc';
include_once 'product.pinc';
include_once 'timetrack.pinc';
include_once 'bugtracking/bug.pinc';

include_once 'layout/layout.pinc';

check_user();

function read_acl($dbconn, $obj) {
  acl_read($obj);

  $acl = array();
  foreach( $obj->acl as $id => $perm ) {
    if( isset($id) && $id != "" && $id != -1 ) {
      $object = getObject($dbconn, $id);
      
      if( $object != -1 ) 
	$acl[] = array('id'   => $object->id,
		       'type' => $object->getType(),
		       'name' => $object->getFullName(),
		       'link' => $object->getUrl(),
		       'perm' => $perm,
		       'creator' => $object->creator->id);
    }
  }
  return $acl;
}

class admin_acl_clean extends layout {

  function info() {
    global $tutos, $lang;

    switch( $this->action ) {
    case "addresses": {
      // Get a list of all tutos users in the system
      $q =
	 "SELECT adr_id FROM ". $this->dbconn->prefix ."people ".
	 "ORDER BY adr_id";
      $r = $this->dbconn->Exec($q);
      $n = $r->numrows();
      break;
    }
    case "projects":
      $q =
	 "SELECT id FROM ".$this->dbconn->prefix."products ".
	 "ORDER BY id DESC";
      $r = $this->dbconn->Exec($q);
      $n = $r->numrows();
      break;

    case "task":
      $q =
	 "SELECT id FROM ".$this->dbconn->prefix."tasks ".
	 "ORDER BY id";
      $r = $this->dbconn->Exec($q);
      $n = $r->numrows();
      break;

    case "bugs":
      $q =
	 "SELECT id FROM ".$this->dbconn->prefix."bugs ".
	 "ORDER BY id";
      $r = $this->dbconn->Exec($q);
      $n = $r->numrows();
      break;

    case "timetrack":
      $q =
	 "SELECT id FROM ".$this->dbconn->prefix."timetrack ".
	 "ORDER BY id";
      $r = $this->dbconn->Exec($q);
      $n = $r->numrows();
      break;

    }

    if ( $this->start == -1 ) {
      $a = $n - $tutos[maxshow];
      $end = $n;
      $this->start = $a;
    }
    else {
      $a = $this->start;
      $end = $this->start + $tutos[maxshow];
    }

    $this->assign('prev_start', $a == 0 ? $a : $a - $tutos[maxshow]);
    $this->assign('next_start', $end);
    
    $this->assign('NavBack',         $lang['NavBack']);
    $this->assign('NavNext',         $lang['NavNext']);
    
    $this->assign('nb', $n);
    $this->assign('astart', $a);
    $this->assign('aend',   $end > $n ? $n : $end);
    $this->assign('n_per_page', $tutos[maxshow]);

    // Generate direct links to page results
    $nb_pages   = ceil($n / $tutos[maxshow]);
    $direct_nav = array();
    for($i=0; $i < $nb_pages; $i++)
      $direct_nav[] =
	array('label'  => $i + 1,
	      'astart' => $i * $tutos[maxshow],
	      'title'  => sprintf($lang['pageof'], $i+1, $nb_pages));
    
    $this->assign('direct_nav', $direct_nav);


    $list = array();

    for(; ($a < $n) && ($a < $end); $a++) {
      switch( $this->action ) {
      case "addresses": {
	$adr_id = $r->get($a, 'adr_id');
	$user = new tutos_user($this->dbconn);
	$user->read($adr_id);
	
	if( $user->id == "" || $user->id == -1 )
	  continue;

	$acl = read_acl($this->dbconn, $user);

	$list[] = array('id'      => $adr_id,
			'name'    => $user->getFullName(),
			'link'    => $user->getUrl(),
			'creator' => $user->creator->id,
			'acl'     => $acl,
			'rowspan' => count($acl) + 1);

      }
	break;

      case "projects":
	$id = $r->get($a, 'id');
	$project = new product($this->dbconn);
	$project->read($id);

	if( $project->id == "" || $project->id == -1 )
	  continue;

	$acl = read_acl($this->dbconn, $project);
	      
	$list[] = array('id'      => $project->id,
			'name'    => $project->getFullName(),
			'link'    => $project->getUrl(),
			'creator' => $project->creator->id,
			'acl'     => $acl,
			'rowspan' => count($acl) + 1);
	break;

      case "task":
	$id = $r->get($a, 'id');
	$task = new task($this->dbconn);
	$task->read($id);

	if( $task->id == "" || $task->id == -1 )
	  continue;

	$acl = read_acl($this->dbconn, $task);

	$list[] = array('id'      => $task->id,
			'name'    => $task->getFullName(),
			'link'    => $task->getUrl(),
			'creator' => $task->creator->id,
			'acl'     => $acl,
			'rowspan' => count($acl) + 1);
	break;


      case "bugs":
	$id = $r->get($a, 'id');
	$bug = new bug($this->dbconn);
	$bug->read($id);

	if( $bug->id == "" || $bug->id == -1 )
	  continue;

	$acl = read_acl($this->dbconn, $bug);

	$list[] = array('id'      => $bug->id,
			'name'    => $bug->getFullName(),
			'link'    => $bug->getUrl(),
			'creator' => $bug->creator->id,
			'solver'  => $bug->solver->id,
			'acl'     => $acl,
			'rowspan' => count($acl) + 1);
	break;

      case "timetrack":
	$id = $r->get($a, 'id');
	$tt = new timetrack($this->dbconn);
	$tt->read($id);

	if( $tt->id == "" || $tt->id == -1 )
	  continue;

	$acl = read_acl($this->dbconn, $tt);

	$list[] = array('id'      => $tt->id,
			'name'    => $tt->desc,
			'link'    => $tt->getUrl(),
			'creator' => $tt->wid,
			'acl'     => $acl,
			'rowspan' => count($acl) + 1);
	break;
      }
    }
    $r->free();

    // $this->debug($list);
    $this->assign('list', $list);
    $this->template('admin/acl_clean');
  }

  function navigate() {
    $this->menuprint("acl_clean");
  }

  function prepare() {
    global $tutos, $lang;

    $actions = array("addresses", "projects", "task", "bugs", "timetrack");
    $this->action = "addresses";

    if( isset($_GET['action']) && $_GET['action'] != "" )
      if( in_array($_GET['action'], $actions) ) {
	$this->action = $_GET['action'];
	$this->search['action'] = $this->action;
      }

    $this->assign('actions', $actions);
    $this->assign('search', $this->search);

    if( isset($_GET['start']) && $_GET['start'] != "" )
      $this->start = $_GET['start'];
    else
      $this->start = 0;


    foreach( $actions as $action ) {
      $x = array('url'   => "admin/acl_clean.php?action=".$action,
		 'text'  => $action,
		 'info'  => $action,
		 'image' => $action,
		 'category' => array("acl_clean")
		 );
      $this->addMenu($x);
    }
  }
}

$l = new admin_acl_clean($current_user);
$l->display();

?>