/**********************************************************************
 *
 *	FILE:			PositionAttitudeTransform.cpp
 *
 *	DESCRIPTION:	Read/Write osg::PositionAttitudeTransform in binary format to disk.
 *
 *	CREATED BY:		Auto generated by iveGenerate
 *					and later modified by Rune Schmidt Jensen.
 *
 *	HISTORY:		Created 25.3.2003
 *
 *	Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "PositionAttitudeTransform.h"
#include "Transform.h"

using namespace ive;

void PositionAttitudeTransform::write(DataOutputStream* out){
	// Write PositionAttitudeTransform's identification.
	out->writeInt(IVEPOSITIONATTITUDETRANSFORM);
	// If the osg class is inherited by any other class we should also write this to file.
	osg::Transform*  trans = dynamic_cast<osg::Transform*>(this);
	if(trans){
		((ive::Transform*)(trans))->write(out);
	}
	else
		throw Exception("PositionAttitudeTransform::write(): Could not cast this osg::PositionAttitudeTransform to an osg::Transform.");
	// Write PositionAttitudeTransform's properties.
      
	out->writeVec3(getPosition());
	out->writeQuat(getAttitude());
	out->writeVec3(getScale());
	out->writeVec3(getPivotPoint());
}

void PositionAttitudeTransform::read(DataInputStream* in){
	// Peek on PositionAttitudeTransform's identification.
	int id = in->peekInt();
	if(id == IVEPOSITIONATTITUDETRANSFORM){
		// Read PositionAttitudeTransform's identification.
		id = in->readInt();
		// If the osg class is inherited by any other class we should also read this from file.
		osg::Transform*  trans = dynamic_cast<osg::Transform*>(this);
		if(trans){
			((ive::Transform*)(trans))->read(in);
		}
		else
			throw Exception("PositionAttitudeTransform::read(): Could not cast this osg::PositionAttitudeTransform to an osg::Transform.");
		// Read PositionAttitudeTransform's properties
		setPosition(in->readVec3());
		setAttitude(in->readQuat());
		setScale(in->readVec3());
		setPivotPoint(in->readVec3());

	}
	else{
		throw Exception("PositionAttitudeTransform::read(): Expected PositionAttitudeTransform identification.");
	}
}
