<?php
# $Id: serviceescalations.php,v 1.1 2002/06/21 10:28:45 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","serviceescalations");
define("PAGE_TITLE","Service Escalations");
define("OBJECTTYPE","serviceescalation");

require_once("local.inc");
include_once(NGT_LIB."head.inc");

$alter = '';
$rows = array();
$objects = PluginGetObjects(OBJECTTYPE);

if( is_array($objects) ) {
	uasort($objects,NagiosUasortObjectService);
	foreach($objects as $key => $object) {

		$alter = ($alter != "alter1") ? "alter1" : "alter2";

		if( !empty($object['service_description']) ) {
			$name = $object['service_description'];
		} else {
			$name = '';
		}



		if( !empty($object['host_name']) ) {
			$hosts = $object['host_name'];
		} else {
			$hosts = '-';
		}
		
		if( !empty($object['hostgroup_name']) ) {
			$hostgroups = $object['hostgroup_name'];
		} else {
			$hostgroups = '';
		}




		$rows[] = <<<HTML
<tr class="$alter">
  <td><a href="serviceescalationedit.php?objectid={$key}">Edit</a></td>
  <td>{$name}</td>
  <td>{$hosts}</td>
  <td>{$hostgroups}</td>
</tr>
HTML;

	} # foreach
} else {
	$message = "No '".OBJECTTYPE."'-objects found.";
}

?>
<table border="0" cellpadding="5" cellspacing="0">
<tr>
  <td colspan="6" align="left">
  <b><?=ErrorMsg($errmsg)?>
  <?=$message?>&nbsp;</b>
  </td>
</tr>
<tr>
  <td colspan="6">
  <form action="serviceescalationedit.php">
  <input type="hidden" name="serviceescalationname" value="newobject">
  <input type="submit" value="New">
  </form>
  </td>
</tr>
<tr class="rowsep">
  <td>&nbsp;</td>
  <td>Name</td>
  <td>Host Name</td>
  <td>Hostgroup Name</td>
</tr>
<?=implode("\n",$rows)?>
</table>

<?
# Beautification
if( !is_array($objects) ) {
	print "<br><br><br><br><br><br><br><br>";
}
include_once(NGT_LIB."tail.inc");
?>
