package com.mysql.grt;

import java.rmi.dgc.VMID;
import java.rmi.server.UID;

/**
 * @author Mike
 *
 */
public class GrtObjectDataLocal implements GrtObjectData {
	
	protected GrtObject grtObject;
	
	protected String name;

	protected String _id = new VMID().toString() + new UID().toString();

	protected String owner;
	
	public GrtObjectDataLocal(GrtObject grtObject) {
		this.grtObject = grtObject;
	}

	public String getName() {
		return name;
	}

	public String setName(String name) {
		this.name = name;

		return getName();
	}

	public String get_id() {
		return _id;
	}

	public String set_id(String _id) {
		// remove old _id
		Grt.getInstance().removeFromObjectCache(grtObject);

		this._id = _id;

		Grt.getInstance().addToObjectCache(grtObject);
			
		return get_id();
	}

	public GrtObject getOwner() {
		return (GrtObject) Grt.getInstance().getObjectByRefId(owner);
	}

	public GrtObject setOwner(GrtObject owner) {
		if (owner != null)
			this.owner = owner.get_id();

		return getOwner();
	}
	
	public String getOwnerById() {
		return owner;
	}
	
	public void setOwnerById(String owner_id) {
		this.owner = owner_id; 
	}
}
