package com.mysql.grt;

public class GrtMessage implements GrtXml {
	private int msgType; // 0..log message, 1..error

	private String msg;

	private GrtStringList msgDetails = new GrtStringList();

	final static int logMessage = 0;

	final static int logError = 1;

	public GrtMessage() {
		this.msg = "";
		this.msgType = logError;
	}

	public GrtMessage(String msg, int msgType) {
		this.msg = msg;
		this.msgType = msgType;
	}

	public void addMessageDetail(String msgDetail) {
		msgDetails.add(msgDetail);
	}

	public String getGrtXml() {
		return getGrtXml("");
	}

	public String getGrtXml(String keyTag) {
		return "<value type=\"dict\" struct-name=\"GrtMessage\" key=\""
				+ keyTag + "\">" + "<value type=\"int\" key=\"msgType\">"
				+ Integer.toString(msgType) + "</value>\n"
				+ "<value type=\"string\" key=\"msg\">" + msg + "</value>\n"
				+ msgDetails.getGrtXml(" key=\"details\"") + "</value>\n";
	}
}