/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */


#ifndef __GRT_PRIVATE_H__
#define __GRT_PRIVATE_H__

#include "myx_grt_public_interface.h"


struct MYX_GRT 
{
  // the external modules that we know about
  unsigned int modules_num;
  MYX_GRT_MODULE **modules;

  // the structure definitions that we know about
  unsigned int structs_num;
  MYX_GRT_STRUCT *structs;

  // the root GRT object
  MYX_GRT_VALUE *root;

  unsigned int loaders_num;
  MYX_GRT_MODULE_LOADER **loaders;

  struct MYX_GRT_LUA_SHELL *lshell;
  
  MYX_GRT_PRINT_CALLBACK print;
  void *print_data;

  GHashTable *struct_icon_cache;

  GHashTable *reference_cache;
  
  MYX_GRT_MSGS *msgs;


  MYX_SOCKET comm_server_sock;  // the listening socket. modules connect to this
  int comm_server_port;  // grt listens at this port

  MYX_SOCKET comm_sock;   // socket to a connected module
  char *comm_cookie; // cookie setup by the grt and passed to modules

  MYX_GRT_LOG_CALLBACK logfunc;
};


struct MYX_GRT_MODULE_LOADER
{
  MYX_GRT *grt;
  MYX_GRT_MODULE_TYPE loader_type;

  unsigned int extensions_num;
  char **extensions;
  
  MYX_GRT_ERROR (*init_module)(MYX_GRT_MODULE_LOADER *loader, const char *file, MYX_GRT_MODULE **retmodule);
  MYX_GRT_ERROR (*call_function)(MYX_GRT_FUNCTION *function, MYX_GRT_VALUE *argument, MYX_GRT_VALUE **retval);
  MYX_GRT_ERROR (*fetch_messages)(MYX_GRT_MODULE_LOADER *loader, MYX_GRT_MSGS *msgs);
  
  struct MYX_GRT_MODULE_LOADER_PRIVATE *priv;
};

MYX_GRT_ERROR myx_grt_module_init_loaders(MYX_GRT *grt);

MYX_GRT_MODULE_LOADER *myx_grt_get_loader_of_type(MYX_GRT *grt, MYX_GRT_MODULE_TYPE type);

MYX_GRT_MODULE_LOADER *myx_builtin_init_loader(MYX_GRT *grt);

void myx_grt_parse_function_spec(const char *spec, MYX_GRT_FUNCTION *func);

MYX_GRT_ERROR myx_grt_add_module(MYX_GRT *grt, MYX_GRT_MODULE *module);

MYX_GRT_ERROR myx_grt_fetch_module_messages(MYX_GRT *grt);

#define MYX_PRINT(grt, msg) grt->print(msg, grt->print_data)

int myx_grt_printf(MYX_GRT *grt, const char *fmt, ...);

int myx_grt_free_list(MYX_GRT_LIST *list);
int myx_grt_free_dict(MYX_GRT_DICT *dict);

int myx_grt_setup_messaging(MYX_GRT *grt);

void myx_grt_rescan_reference_cache(MYX_GRT *grt);



#if !defined(__WIN__) && !defined(_WIN32) && !defined(_WIN64)
#define NL "\n"
#define NLNL "\n\n"
#else
#define NL "\r\n"
#define NLNL "\r\n\r\n"
#endif

#endif

