// cmdstate.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifndef COMMANDSTATE_H
#define COMMANDSTATE_H

#include <InterViews/subject.h>

// Possible states for CommandState

enum {
	Nothing_Selected			= 0x00000000,
	Target_Selected				= 0x00000001,	// insert or selection
	Target_Region_Selected		= 0x00000002,	// selection highlighted
	Source_Selected				= 0x00000004,	// source selection made

	File_Is_Modified			= 0x00000010,
	Undo_Is_Available			= 0x00000020,
	Redo_Is_Available			= 0x00000040,
	LPC_Source_Selected			= 0x00000080,	// special for LPC resynthesis
	PVOC_Source_Selected		= 0x00000100,	// special for PVOC resynthesis

	// The remainder of these form mutually-exclusive sets.  First the menu
	// command bit is shown for each, then the state which represents the
	// OR'd bits for the other menu(s) in the set.

	Display_As_Lines			= 0x00001000,	// for menuitems
	Display_As_Bars				= 0x00002000,
	Displayed_As_Lines			= 0x00002000,	// for state
	Displayed_As_Bars			= 0x00001000,

	HDisplay_As_Frames			= 0x00004000,	// for menuitems
	HDisplay_As_Time			= 0x00008000,
	HDisplay_As_SMPTE			= 0x00010000,
	HDisplay_As_CDDA			= 0x00020000,
	HDisplayed_As_Frames		= 0x00038000,	// for state
	HDisplayed_As_Time			= 0x00034000,
	HDisplayed_As_SMPTE			= 0x0002c000,
	HDisplayed_As_CDDA			= 0x0001c000,
	HDisplayed_As_Anything		= 0x0003c000,	// for state reset

	View_As_Channels			= 0x00100000,	// for menuitems
	View_As_Frames				= 0x00200000,
	Viewed_As_Channels			= 0x00200000,	// for state
	Viewed_As_Frames			= 0x00100000,

	Unviewed_Channel_Above		= 0x00400000,
	Unviewed_Channel_Below		= 0x00800000,

	Peak_Rescan_Off				= 0x01000000,	// for menuitems
	Peak_Rescan_On				= 0x02000000,
	Peak_Rescan_Is_Off			= 0x02000000,	// for state
	Peak_Rescan_Is_On			= 0x01000000,

	Command_Inactive			= 0x10000000	// Inactive command
};

class CommandState : public Subject {
public:
	CommandState();
	virtual ~CommandState();
	void Set(unsigned int stateFlag, bool set);
	void Reset(unsigned int stateFlags);
	bool IsSet(unsigned int flags) { return (_flags & flags) == flags; }
private:
	unsigned _flags;
};

#endif
