#!/usr/bin/env ruby

require "mkmf"

def have_libwrap
  lib = "wrap"
  func = "main"
  printf "checking for %s() in -l%s... ", func, lib
  STDOUT.flush
  if func && func != ""
    libs = append_library($libs, lib)
    if /mswin32|mingw/ =~ RUBY_PLATFORM
      r = try_link(<<"SRC", libs)
#include <windows.h>
#include <winsock.h>
int allow_severity = 0;
int deny_severity = 0;
int main() { return 0; }
int t() { #{func}(); return 0; }
SRC
      unless r
        r = try_link(<<"SRC", libs)
#include <windows.h>
#include <winsock.h>
int allow_severity = 0;
int deny_severity = 0;
int main() { return 0; }
int t() { void ((*p)()); p = (void ((*)()))#{func}; return 0; }
SRC
      end
    else
      r = try_link(<<"SRC", libs)
int allow_severity = 0;
int deny_severity = 0;
int main() { return 0; }
int t() { #{func}(); return 0; }
SRC
    end
    unless r
      print "no\n"
      return false
    end
  else
    libs = append_library($libs, lib)
  end
  $libs = libs
  print "yes\n"
  return true
end

dir_config("wrap")
dir_config("ident")
if have_header("ident.h") and
    have_library("ident", "ident_id")
  have_func("ident_id")
end
if have_header("tcpd.h") and
    have_libwrap
  create_makefile("tcpwrap")
end

