/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__BAR_HPP)
#include <Bar.hpp>
#endif

using namespace corelinux;

//
// Default constructor
//

Bar::Bar( void )
   :
   theVertical( 0 ),
   theHorizontal( 0 )
{
   ;  // do nothing
}

//
// Constructor with coords
//

Bar::Bar( Int aX, Int aY )
   :
   theVertical( aY ),
   theHorizontal( aX )
{
   ;  // do nothing
}

//
// Copy constructor
//

Bar::Bar( BarCref aRef )
   :
   theVertical( aRef.getVertical() ),
   theHorizontal( aRef.getHorizontal() )
{
   ;  // do nothing
}

//
// Destructor
//

Bar::~Bar( void )
{
   theVertical = 0;
   theHorizontal = 0;
}

//
// Assignment operator
//

BarRef  Bar::operator =( BarCref aRef )
{
   if( *this == aRef )
   {
      ;  // do nothing
   }
   else
   {
      theVertical = aRef.getVertical();
      theHorizontal = aRef.getHorizontal();
   }
   return (*this);
}

//
// Equality operator
//

bool  Bar::operator ==( BarCref aRef )
{
   bool  isSame(false);

   if( aRef.getVertical() == theVertical &&
       aRef.getHorizontal() == theHorizontal )
   {
      isSame = true;
   }
   else
   {
      ;  // do nothing
   }

   return (isSame);
}

//
// Get Y coordinate
//

IntCref  Bar::getVertical( void ) const
{
   return theVertical;
}

//
// Get X coordinate
//

IntCref  Bar::getHorizontal( void ) const
{
   return theHorizontal;
}

//
// Set Y coordinate
//

void  Bar::setVertical( Int aY )
{
   theVertical = aY;
}

//
// Set X coordinate
//

void Bar::setHorizontal( Int aX )
{
   theHorizontal = aX;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/01/19 14:30:07 $
   $Locker:  $
*/

