#!/bin/sh

#####
# This file is the default startup script used by ledcontrol. It tests
# the conditions and sets the LEDs accordingly.
#
# NOTE: Previously this file also contained the configuration, now it
# has been moved to a separate file, /etc/ledcontrol.conf
#####

# Read the configuration
if [ ! -r /etc/ledcontrol.conf ]; then
    echo "Unable to read configuration file /etc" >&2
    exit 1
fi

source /etc/ledcontrol.conf


# Source the scripts...
LEDDSCRIPTS="/usr/share/ledcontrol"

# All scripts ending in .sh in ${LEDDSCRIPTS} are executed.
for SCRIPT in ${LEDDSCRIPTS}/*.sh ; do
    # Don't re-execute myself!
    if test "`basename $SCRIPT`" = "`basename $0`"; then
	continue;
    fi
    if test -r ${SCRIPT}; then
	source ${SCRIPT}
    fi
done

### Check bash version...
# Disable backgrounding if using bash 2.xx.xx
if echo "${BASH_VERSION}" | grep -q "^2\." ; then
    if test "${USE_BACKGROUNDING}" = YES -o "${USE_BACKGROUNDING}" = yes; then
	echo "bash 2.xx.xx detected, disabling backgrounding" >&2
    fi
    USE_BACKGROUNDING=NO
fi


### Find out how many tests are to be done
# Also tests that SUCCESS_n is defined.
MAX_TESTS=0;
while eval 'test -n "$COMMAND_'$[${MAX_TESTS}+1]'"'; do
    MAX_TESTS=$[${MAX_TESTS}+1]
    # Set the next execution time (immediately)
    eval 'TIME_'${MAX_TESTS}'=`date +%s`'
    if eval 'test -z "$SUCCESS_'${MAX_TESTS}'"' ; then
	echo "SUCCESS_${MAX_TESTS} not defined" >&2
	exit 1
    fi
    if eval 'test -z "$FAILURE_'${MAX_TESTS}'"' ; then
	echo "FAILURE_${MAX_TESTS} not defined" >&2
	exit 1
    fi
done

### Number of tests >= 1
if test ${MAX_TESTS} -lt 1; then
    echo "no tests defined" >&2
    exit 1
fi


### Do the animation if requested.
# DELAY is delay between each LED setting in ms. Total delay of animation
# will be about 6 times this.
# Don't do it is DISPLAY defined (in X).
DELAY=100
if test "$STARTUP_ANIM" = "YES" -o "$STARTUP_ANIM" = "yes"; then
    if test -z "$DISPLAY"; then
	echo "anim ${DELAY} S ${DELAY} C ${DELAY} N ${DELAY} xs ${DELAY} xc ${DELAY} xn ${DELAY}"
	sleep 1
    fi
fi



### Set the default settings
if test -n "${DEFAULT_SETTINGS}" ; then
    echo "${DEFAULT_SETTINGS}"
fi

### Do the infinite loop
while : ; do
    for COUNT in `seq 1 ${MAX_TESTS}`; do
	if test "`eval 'echo $TIME_'$COUNT`" -le `date +%s`; then
	    eval COMMAND='$COMMAND_'$COUNT
	    # The built-in functions can change these:
	    eval SUCCESS='$SUCCESS_'$COUNT
	    eval FAILURE='$FAILURE_'$COUNT

	    if eval "$COMMAND" ; then
		echo "$SUCCESS"
	    else
		echo "$FAILURE"
	    fi
	    # Set the next execution time
	    eval 'TIME_'$COUNT'=$[`date +%s`+0$DELAY_'$COUNT']'
	fi
    done
    sleep $MINIMUM_DELAY
done
