#ifndef WORKSHEET_H
#define WORKSHEET_H

#include <qwidget.h>
#include <qpainter.h>
#include <qstring.h>
#include <qfont.h>
#include <qcolor.h>
#include <qtextstream.h>
#include <qdatetime.h>
#include <kprinter.h>
#include "MainWin.h"
#include "Plot.h"
#include "Label.h"
#include "Line.h"
#include "Rect.h"
#include "Ellipse.h"
#include "LImage.h"

#define NR_PLOTS 16
#define NR_OBJECTS 10

class MainWin;

class Worksheet: public QWidget
{
	Q_OBJECT
	Q_PROPERTY(QString title READ Title WRITE setTitle)
	Q_PROPERTY(bool title_enabled READ TitleEnabled WRITE setTitleEnabled)
	Q_PROPERTY(bool timestamp_enabled READ TimeStampEnabled WRITE setTimeStampEnabled)
	Q_PROPERTY(QDateTime timestamp READ TimeStamp WRITE setTimeStamp)
	Q_PROPERTY(QColor background READ Background WRITE setBackground)
private:
	MainWin *mw;					// reference to the main window (for plotlist & messages)
	class Plot *plot[NR_PLOTS];		// list of plots
	KPrinter *printer;				// printer for printing
	QPixmap *pixmap;				// pixmap for drawing
	QString title;					//!< title of Worksheet
	bool title_enabled;				//!< title enabled
	QDateTime timestamp;			//!< time stamp
	bool timestamp_enabled;		//!< timestamp enabled
	QColor background;
	Label *label[NR_OBJECTS];
	Line line[NR_OBJECTS];
	Rect rect[NR_OBJECTS];
	Ellipse ellipse[NR_OBJECTS];
	LImage image[NR_OBJECTS];
	int X, Y;						// window dimension
	int lx, ly;						// temp. legend position
	int ax, ay, anumber;				// temp. axis position and axis number
	int tx, ty;						// temp. title position
	int bx, by;						// temp. border position
	int tlx, tly;						// temp. tic label position
	int tmagx, tmagy,tmagx2,tmagy2;	// temp. maglens position
	double tpanx, tpany;			// temp. pan zoom value (real data point)
	int linesx,linesy,lineex,lineey,labelx,labely,rectx,recty;
	int ellipsex,ellipsey,imagex,imagey;
	bool moving_cornerF1, moving_cornerF2;
	bool moving_cornerB1, moving_cornerB2;
	bool moving_borderx1, moving_borderx2;
	bool moving_bordery1, moving_bordery2;
	bool moving_center;
	int object_index;	// index of moving object
	int tmp_object_index;	// index when defining object
	unsigned int api, nr_plots;	// active plot index and number of plots
public:
	Worksheet(QWidget *parent, MainWin *mw, const char *name);
	QStringList Info();
	MainWin *getMainWin() { return mw; }	// for project dialog
	void updatePixmap();
	void New();
	class Plot *getPlot(int i) { return plot[i]; }
	void save(QTextStream *t);
	void open(QTextStream *t,int version, PType oldtype);

	int NrObjects() { return NR_OBJECTS; }
	Line getLine(int i) { return line[i]; }
	void setLine(int i, Line l) { line[i]=l; }
	Label *getLabel(int i) { return label[i]; }
	void setLabel(int i, Label *l) { label[i]=l; }
	Rect getRect(int i) { return rect[i]; }
	void setRect(int i, Rect r) { rect[i]=r; }
	Ellipse getEllipse(int i) { return ellipse[i]; }
	void setEllipse(int i, Ellipse e) { ellipse[i]=e; }
	LImage getImage(int i) { return image[i]; }
	void setImage(int i, LImage im) { image[i]=im; }

	// TODO : add to which plot ? -> check this
	void addGraph2D(Graph2D *g,PType type=P2D);
	void addGraph3D(Graph3D *g,PType type=P3D);
	void addGraphM(GraphM *g,PType type=PSURFACE);
	void addGraphGRASS(GraphGRASS *g);
	void addGraphVTK(GraphVTK *g);
	void addGraph4D(Graph4D *g);
	void addGraphIMAGE(GraphIMAGE *g);
	
	int API() { return api; }
	unsigned int NrPlots() { return nr_plots; }

	void resetRanges();
public slots:
	void Export(QString filename, QString format);								//!< export to filename with format
	void ExportPS(QString filename);											//!< export to filename as PS
	void ExportEPS(QString filename);											//!< export to filename as EPS
	void ExportPDF(QString filename);											//!< export to filename as PDF
	void ExportSVG(QString filename);											//!< export to filename as SVG
	void ExportPIC(QString filename);											//!< export to filename as PIC
	void Print(QString filename);												//!< print to filename

	void newPlot(PType type);			// TODO
	void deleteActivePlot();				// TODO

	QString Title() const { return title; }										//!< get title
	void setTitle(QString t) { title = t;updatePixmap(); }							//!< set title to t
	bool TitleEnabled() const { return title_enabled; }							//!< title enabled ?
	void setTitleEnabled(bool e) { title_enabled = e; updatePixmap(); }				//!< enable title	
	QDateTime TimeStamp() const { return timestamp; }								//!< get timestamp 
	void setTimeStamp(QDateTime ts) { timestamp = ts; updatePixmap(); }			//!< set timestamp
	bool TimeStampEnabled() const { return timestamp_enabled; }					//!< enable timestamp
	void setTimeStampEnabled(bool e) { timestamp_enabled = e;updatePixmap(); }	//!< timestamp enabled ?
	QColor Background() const { return background; }							//!< get background color
	void setBackground(QColor c) { background = c; updatePixmap(); }				//!< set background color to c
protected:
	void resizeEvent( QResizeEvent * );
	void paintEvent( QPaintEvent * );
	void mousePressEvent( QMouseEvent *);
	void mouseReleaseEvent( QMouseEvent *);
	void mouseDoubleClickEvent( QMouseEvent * );
	void mouseMoveEvent( QMouseEvent * );
	void closeEvent(QCloseEvent *);
	void Draw(QPainter *,int w, int h);
	void setupPrinter(KPrinter *pr, QString fn);
	double XCoordinate(double x, double xmin, double xmax);
	double YCoordinate(double y, double ymin, double ymax);
};

#endif //WORKSHEET
