/* -*- c++ -*-
 *
 * donkeyentry.cpp
 *
 * Copyright (C) 2003, 2004 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "donkeyentry.h"

#include <klocale.h>

DonkeyEntry::DonkeyEntry(QListBox* box, const QString& name, const QString& address,
			 int port, int httpPort, const QString& username, const QString& password,
			 int hostMode, const QString& binary, const QString& root, int startupMode,
			 bool isDefault)
    : QListBoxText(box, name)
    , m_name(name)
    , m_address(address)
    , m_username(username)
    , m_password(password)
    , m_binary(binary)
    , m_root(root)
    , m_port(port)
    , m_httpPort(httpPort)
    , m_hostMode(hostMode)
    , m_startupMode(startupMode)
    , m_default(isDefault)
{
    if (isDefault)
	setText(m_name + i18n(" (Default)"));
}

void DonkeyEntry::setName(const QString& name)
{
    m_name = name;
    if (m_default)
	setText(m_name + i18n(" (Default)"));
    else
	setText(m_name);
}

void DonkeyEntry::setDefault(bool isDefault)
{
    if (isDefault == m_default) return;
    m_default = isDefault;
    setName(m_name);
}



