/***************************************************************************
                          deinterlacequality.h  -
                          in this dialog the user can select the quality of deinterlacing
                             -------------------
    begin                : Mon Apr 19 2004
    revision             : $Revision: 1.2 $
    last modified        : $Date: 2005/02/02 10:08:27 $ by $Author: juergenk $    
    copyright            : (C) 2004-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DEINTERLACEQUALITY_H
#define DEINTERLACEQUALITY_H

#include <kdialogbase.h>

/**
  *@author Juergen  Kofler
  */

class QCheckBox;
class QSlider;
class QString;
class QStringList;
class KPushButton;    

class DeinterlacerConfigDialog : public KDialogBase
{
  Q_OBJECT
public:
  DeinterlacerConfigDialog(QWidget *parent=0, const char *name=0)
  : KDialogBase( parent, name, true, i18n("Configure tvtime Deinterlace Plugin"), KDialogBase::Close )
  {
    setInitialSize(QSize(450,400), true);

    mainWidget = makeVBoxMainWidget();
  }

  ~DeinterlacerConfigDialog() {}
  QWidget* getMainWidget() const { return (QWidget*)mainWidget; }

private:
  QVBox* mainWidget;
};

class DeinterlaceQuality : public KDialogBase  {
   Q_OBJECT
public: 
  DeinterlaceQuality(QWidget* filterDialog, QWidget *parent=0, const char *name=0);
  ~DeinterlaceQuality();  

  void setQuality(uint);
  uint getQuality() const;
  
signals:
  void signalSetDeinterlaceConfig(const QString&);

private slots:
  void slotLevelChanged(int);
  void slotCustomBoxToggled(bool);

private:
  QStringList m_configStrings;
  QSlider* m_qualitySlider;
  QCheckBox* m_customBox;
  KPushButton* m_customConfigButton;
};

#endif
