/*
**  EditWindowController.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**          Jonathan B. Leffert <jonathan@leffert.net>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_EditWindowController
#define _GNUMail_H_EditWindowController

#import <AppKit/AppKit.h>

#include "AddressTaker.h"

@class AutoCompletingTextField;
@class EditWindow;
@class Folder;
@class Message;
@class Part;
@class ExtendedTextView;

@interface EditWindowController: NSWindowController <AddressTaker>
{
  // Outlets
  IBOutlet NSTextField *subjectText;
  IBOutlet AutoCompletingTextField *toText;
  IBOutlet AutoCompletingTextField *ccText;
  IBOutlet AutoCompletingTextField *bccText;

  IBOutlet NSTextField *subjectLabel;
  IBOutlet NSTextField *toLabel;
  IBOutlet NSTextField *ccLabel;
  IBOutlet NSTextField *bccLabel;

  IBOutlet NSTextField *sizeLabel;

  IBOutlet NSScrollView *scrollView;
  IBOutlet ExtendedTextView *textView;

  IBOutlet id send;
  IBOutlet id insert;
  IBOutlet id addBcc;
  IBOutlet id addCc;
  IBOutlet id addresses;

  IBOutlet NSPopUpButton *accountPopUpButton;
  IBOutlet NSPopUpButton *transportMethodPopUpButton;
  
  // Other ivars
  Message *message;
  Message *unmodifiedMessage;

  NSString *charset;

  BOOL showCc;
  BOOL showBcc;
  BOOL updateColors;

  NSRange affectedRangeForColors;

  int forceEndEditingOfTextField;
  int signaturePosition;

  BOOL editingDraftMessage;

#ifdef MACOSX
  NSMutableArray *allowedToolbarItemIdentifiers;
  NSMutableDictionary *additionalToolbarItems;
#endif

  @private
    NSMutableArray *addressCompletionCandidates;
    NSString *previousSignatureValue;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;

- (void) dealloc;


//
// action methods
//
- (IBAction) insertFile: (id) sender;;
- (IBAction) sendMessage: (id) sender;
- (IBAction) showBcc: (id) sender;
- (IBAction) showCc: (id) sender;
- (IBAction) accountSelectionHasChanged: (id) sender;


//
// delegate methods
//
- (void) controlTextDidChange: (NSNotification *) aNotification;
- (BOOL) shouldChangeTextInRange: (NSRange) affectedCharRange 
               replacementString: (NSString *) replacementString;
- (void) textDidChange: (NSNotification *) aNotification;
- (BOOL) windowShouldClose: (id) sender;
- (void) windowWillClose: (NSNotification *) theNotification;
- (void) windowDidBecomeMain: (NSNotification *) theNotification;
- (void) windowDidLoad;


//
// access/mutation methods
//
- (Message *) message;
- (void) setMessage: (Message *) theMessage;

- (Message *) unmodifiedMessage;
- (void) setUnmodifiedMessage: (Message *) theUnmodifiedMessage;

- (void) setMessageFromDraftsFolder: (Message *) theMessage;

- (BOOL) showCc;
- (void) setShowCc: (BOOL) theBOOL;

- (BOOL) showBcc;
- (void) setShowBcc: (BOOL) theBOOL;

- (int) signaturePosition;
- (void) setSignaturePosition: (int) thePosition;

- (BOOL) editingDraftMessage;
- (void) setEditingDraftMessage: (BOOL) flag;

- (NSPopUpButton *) accountPopUpButton;

- (void) setAccountName: (NSString *) theAccountName;

- (NSString *) charset;
- (void) setCharset: (NSString *) theCharset;


//
// Other methods
//
- (BOOL) updateMessageContentFromTextView;
- (void) insertFileWithName: (NSString *) theFileName;

@end


//
// private methods
//
@interface EditWindowController (Private)

- (void) _adjustNextKeyViews;

- (void) _adjustWidgetsPosition;

- (void) _loadAccessoryViews;

- (void) _loadAccounts;
- (void) _loadCharset;

- (NSString *) _loadSignature;

- (void) _openPanelDidEnd: (NSOpenPanel *) theOpenPanel
               returnCode: (int) theReturnCode
              contextInfo: (void *) theContextInfo;

- (void) _replaceSignature;

- (NSString *) _plainTextContentFromTextView;

- (NSArray *) _recipientsFromString: (NSString *) theString;

- (void) _setPlainTextContentFromString: (NSString *) theString
                                 inPart: (Part *) thePart;

- (void) _sheetDidEnd: (NSWindow *) sheet
           returnCode: (int) returnCode
          contextInfo: (void *) contextInfo;

- (void) _sheetDidDismiss: (NSWindow *) sheet
               returnCode: (int) returnCode
              contextInfo: (void *) contextInfo;

- (void) _showAlertPanelWithString: (NSString *) theString;

- (void) _updateViewWithMessage: (Message *) theMessage
                appendSignature: (BOOL) aBOOL;

- (void) _updateSizeLabel;

- (void) _updatePart: (Part *) thePart
 usingTextAttachment: (NSTextAttachment *) theTextAttachment;

@end

#endif // _GNUMail_H_EditWindowController
