/****************************************************************************
** clparam.cc
**
** Michael S. Borella <mike@borella.net>
**
** Methods for the command line parameter class
**
** $Id: clparam.cc,v 1.4 2000/10/25 22:52:05 mborella Exp $
**
****************************************************************************/

#include <strstream>
#include "clparam.h"

//---------------------------------------------------------------------------
//
// Clparam::Clparam()
//
// Constructor method.  Initialize some of the variables.  Strings should
// initialize to empty.
//
//---------------------------------------------------------------------------

Clparam::Clparam()
{
  _short_rep = '\0';
  _type = null_t;
  _longopt_value = 0;
  _long_only = false;
}

//---------------------------------------------------------------------------
//
// Clparam::operator=()
//
// Copy constructor.
//
//---------------------------------------------------------------------------

Clparam& Clparam::operator=(const Clparam &rhs)
{
  // guard against self-assignment
  if (this != &rhs)
    {
      _short_rep = rhs._short_rep;
      _long_rep = rhs._long_rep;
      _internal_name = rhs._internal_name;
      _external_name = rhs._external_name;
      _type = rhs._type;
      _default_value = rhs._default_value;
      _low_range = rhs._low_range;
      _high_range = rhs._high_range;
      _callback  = rhs._callback;
      _descriptions = rhs._descriptions;
      _longopt_value = rhs._longopt_value;
      _long_only = rhs._long_only;
    }
  
  return *this;
}

//---------------------------------------------------------------------------
//
// Clparam::logdump()
//
// Dump contents to a Logfile
//
//---------------------------------------------------------------------------

void Clparam::logdump(Logfile& l)
{
  l.write("  dumping parameter...");
  l.write(LOG_OPTION_NO_CR, "    short representation: ");
  l.write(LOG_OPTION_NO_TS, _short_rep);
  l.write("    long representation: " + _long_rep);
  l.write("    internal name: " + _internal_name);
  l.write("    external name: " + _external_name);
  l.write(LOG_OPTION_NO_CR, "    parameter type: ");
  switch(_type)
    {
    case int_t:
      l.write(LOG_OPTION_NO_TS, "int");
      break;
    case float_t:
      l.write(LOG_OPTION_NO_TS, "float");
      break;
    case string_t:
      l.write(LOG_OPTION_NO_TS, "string");
      break;
    case char_t:
      l.write(LOG_OPTION_NO_TS, "char");
      break;
    case flag_t:
      l.write(LOG_OPTION_NO_TS, "flag");
      break;
    default:
      break;
    }
  l.write("    default_value: " + _default_value);
  l.write("    low range: " + _low_range);
  l.write("    high range: " + _high_range);
  l.write("    callback: " + _callback);
  l.write("    descriptions:");
  
  list<string>::iterator iter;
  if (!_descriptions.empty())
    {
      for (iter = _descriptions.begin(); iter != _descriptions.end(); iter++)
	l.write((string) "      " + *iter);
    }

  char buf [32];
  strstream ss(buf, sizeof buf);
  ss << _longopt_value << ends;

  l.write((string) "    longopt value: " + buf);
  l.write("  finished dumping parameter");
}

//---------------------------------------------------------------------------
//
// Clparam::get_description()
//
// Return the indexed description or "" if the input value is invalid
// NOTE: should probably rasie an exception
//
//---------------------------------------------------------------------------

string Clparam::get_description(int i)
{
  if (i > _descriptions.size())
    return "";
  else
    {
      list<string>::iterator iter;
      int count = 0;
      for (iter = _descriptions.begin(); iter != _descriptions.end(); iter++)
	{
	  if (count == i)
	    return *iter;
	  count ++;
	}
    }
}
