/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#ifndef __c_mathml_editor_h__
#define __c_mathml_editor_h__

#include <gdome.h>

typedef struct Editor Editor;

const char*    c_mathml_editor_get_default_dictionary_path(void);
const char*    c_mathml_editor_get_default_mathml_stylesheet_path(void);
const char*    c_mathml_editor_get_default_tex_stylesheet_path(void);
Editor*        c_mathml_editor_new(int, const char*, const char*, const char*, void (*)(int, const char*, void*), void*);
void           c_mathml_editor_destroy(Editor*);
int            c_mathml_editor_freeze(Editor*);
int            c_mathml_editor_thaw(Editor*);
void           c_mathml_editor_reset(Editor*);
void           c_mathml_editor_push(Editor*, char);
void           c_mathml_editor_drop(Editor*, int);
int            c_mathml_editor_cursor_hide(Editor*);
int            c_mathml_editor_cursor_show(Editor*);
char*          c_mathml_editor_get_tex(const Editor*);
GdomeDocument* c_mathml_editor_get_tml(const Editor*);
GdomeDocument* c_mathml_editor_get_mml(const Editor*);

#endif /* __c_mathml_editor_h__ */
