create SEQUENCE seq_accounts;
create SEQUENCE seq_attributesets;
create SEQUENCE seq_views;
create SEQUENCE seq_tickets;
create SEQUENCE seq_ticketresolutions;
create SEQUENCE seq_faq;
create SEQUENCE seq_faqtopics;
create SEQUENCE seq_faqquestions;
create SEQUENCE seq_faqanswers;
create SEQUENCE seq_timecards;
create SEQUENCE seq_severities;
create SEQUENCE seq_departments;
create SEQUENCE seq_jcn;
create SEQUENCE seq_projects;
create SEQUENCE seq_watches;
create SEQUENCE seq_personnel;
create SEQUENCE seq_actions;
create SEQUENCE seq_priorities;
create SEQUENCE seq_products;
create SEQUENCE seq_statuses;
create SEQUENCE seq_dcl_chklst;
create SEQUENCE seq_dcl_chklst_tpl;
create SEQUENCE seq_dcl_product_module;
Create SEQUENCE seq_dcl_wo_type;

create TABLE personnel (
		id number(11,0) not null primary key,
		short char(10) not null unique,
		lastname varchar2(25), 
		firstname varchar2(20), 
		reportto number(11,0), 
		department number(11,0), 
		pwd varchar2(50), 
		security number(11,0), 
		email varchar2(80),
		active varchar2(1) default 'Y'
	);

create TABLE accounts (
		id number(11,0) not null primary key, 
		short char(10) not null unique, 
		name varchar2(30) not null unique, 
		add1 varchar2(30), 
		add2 varchar2(30), 
		city varchar2(50), 
		state char(2), 
		zip char(11), 
		contact varchar2(50), 
		voice char(10), 
		fax char(10), 
		data1 char(10), 
		data2 char(10), 
		notes varchar2(4000),
		active varchar2(1) default 'Y'
	);

create TABLE actions (
		id number(11,0) not null primary key, 
		short char(10) not null, 
		name varchar2(20) not null,
		active varchar2(1) default 'Y'
	);

create TABLE priorities (
		id number(11,0) not null primary key, 
		short char(10) not null unique, 
		name varchar2(20) not null, 
		weight number(11,0) not null,
		active varchar2(1) default 'Y'
	);

create TABLE products (
		id number(11,0) not null primary key, 
		short char(10) not null unique, 
		name varchar2(50) not null, 
		reportto number(11,0),
		active varchar2(1) default 'Y',
		ticketsto number(11,0) not null,
		wosetid number(11,0) not null,
		tcksetid number(11,0) not null
	);

create TABLE statuses (
		id number(11,0) not null primary key, 
		short char(10) not null unique, 
		name varchar2(20) not null,
		dcl_status_type number(11, 0) default '1' not null,
		active varchar2(1) default 'Y'
	);

create TABLE timecards (
		id number(11,0) not null primary key, 
		jcn number(11,0) not null, 
		seq number(11,0) not null, 
		actionon date not null, 
		inputon date default sysdate not null, 
		actionby number(11,0) not null, 
		status number(11,0) not null, 
		action number(11,0) not null, 
		hours number(12,4) not null, 
		summary varchar2(100) not null, 
		description varchar2(4000), 
		revision varchar2(20)
	);

create TABLE severities (
		id number(11,0) not null primary key, 
		short char(10) not null unique, 
		name varchar2(20) not null, 
		weight number(11,0) not null,
		active varchar2(1) default 'Y'
	);

create TABLE departments (
		id number(11,0) not null primary key, 
		short char(10) not null unique, 
		name varchar2(30) not null,
		active varchar2(1) default 'Y'
	);

create TABLE workorders (
		jcn number(11,0) not null, 
		seq number(11,0) not null, 
		product number(11,0) not null, 
		createby number(11,0) not null,
		createdon date not null,
		closedby number(11,0),
		closedon date,
		status number(11,0) not null,
		statuson date not null,
		lastactionon date,
		deadlineon date,
		eststarton date,
		estendon date,
		starton date,
		esthours number(12,4),
		totalhours number(12,4),
		priority number(11,0) not null,
		severity number(11,0) not null,
		contact varchar2(50),
		contactphone char(10),
		summary varchar2(100) not null,
		notes varchar2(1024),
		description varchar2(1024) not null,
		responsible number(11,0),
		revision varchar2(20),
		publicview number(1),
		notifycreateby number(1),
		notifyproductlead number(1),
		notifyresponsible number(1),
		etchours number(12,4),
		module_id number(11, 0),
		wo_type_id number(11,0)
	);

create table dcl_projects (
		projectid number(11,0) not null primary key,
		name varchar2(100) unique, 
		reportto number(11,0) not null, 
		createdby number(11,0) not null, 
		createdon date default sysdate not null, 
		projectdeadline date, 
		description varchar2(1024) not null, 
		status number(11,0) not null, 
		lastactivity date, 
		finalclose date,
		parentprojectid number(11,0) default('0') not null
	);

create table projectmap (
		projectid number(11,0) not null, 
		jcn number(11,0) not null, 
		seq number(11,0) not null, 
		primary key(projectid, jcn, seq)
	);

create table watches (
		watchid number(11,0) primary key not null,
		typeid number(11,0) not null,
		whatid1 number(11,0) not null,
		whatid2 number(11,0) not null,
		whoid number(11,0) not null,
		actions number(11,0) not null
	);

create TABLE tickets (
		ticketid number(11,0) not null primary key,
		product number(11,0) not null,
		account number(11,0),
		createdby number(11,0) not null,
		createdon date default sysdate not null,
		responsible number(11,0) not null,
		closedby number(11,0),
		closedon date,
		status number(11,0) not null,
		statuson date not null,
		lastactionon date,
		priority number(11,0) not null,
		type number(11,0) not null,
		contact varchar2(80),
		contactphone varchar2(20),
		issue clob not null,
		version varchar2(20),
		summary varchar2(100),
		seconds number(11,0) default '0' not null,
		contactemail varchar2(100),
		module_id number(11, 0)
	);

create TABLE ticketresolutions (
		resid number(11,0) not null primary key,
		ticketid number(11,0) not null,
		loggedby number(11,0) not null,
		loggedon date default sysdate not null,
		status number(11,0) not null,
		resolution clob not null,
		startedon date not null
	);

create TABLE faq (
		faqid number(11,0) not null primary key,
		name varchar2(80) not null,
		createby number(11,0),
		createon date default sysdate not null,
		modifyby number(11,0),
		modifyon date,
		active char(1) default 'Y' not null,
		description clob
	);

create TABLE faqtopics (
		topicid number(11,0) not null primary key,
		seq number(11,0) not null,
		faqid number(11,0) not null,
		name varchar2(80) not null,
		description clob not null,
		createby number(11,0),
		createon date default sysdate not null,
		modifyby number(11,0),
		modifyon date,
		active char(1) default 'Y' not null
	);

create TABLE faqquestions (
		questionid number(11,0) not null primary key,
		seq number(11,0) not null,
		topicid number(11,0) not null,
		questiontext clob not null,
		createby number(11,0),
		createon date default sysdate not null,
		modifyby number(11,0),
		modifyon date,
		active char(1) default 'Y' not null
	);

create TABLE faqanswers (
		answerid number(11,0) not null primary key,
		questionid number(11,0) not null,
		answertext clob not null,
		createby number(11,0) not null,
		createon date default sysdate not null,
		modifyby number(11,0),
		modifyon date,
		active char(1) default 'Y' not null
	);

create TABLE views (
		viewid number(11,0) not null primary key,
		whoid number(11,0) not null,
		name varchar2(100) not null,
		ispublic char(1) default 'N' not null,
		viewurl clob not null,
		tablename varchar2(30) not null
	);


create TABLE attributesets (
		id number(11,0) not null,
		short varchar2(20) not null,
		name varchar2(100) not null,
		active char(1) default 'Y' not null 
	);

create TABLE attributesetsmap (
		setid number(11,0) not null,
		typeid number(11,0) not null,
		keyid number(11,0) not null,
		weight number(11,0) not null
	);

create TABLE dcl_config (
		dcl_config_name varchar2(50) not null primary key,
		dcl_config_field varchar2(30) not null,
		dcl_config_int number(11,0),
		dcl_config_double number(12,4),
		dcl_config_date date,
		dcl_config_datetime date,
		dcl_config_varchar varchar2(255)
	);


create TABLE dcl_chklst (
		dcl_chklst_id number(11,0) not null primary key,
		dcl_chklst_tpl_id number(11,0) not null,
		dcl_chklst_summary varchar2(255) not null,
		dcl_chklst_createby number(11,0) not null,
		dcl_chklst_createon date default sysdate not null,
		dcl_chklst_modifyby number(11,0),
		dcl_chklst_modifyon date,
		dcl_chklst_status varchar2(255)
	);

create TABLE dcl_chklst_tpl (
		dcl_chklst_tpl_id number(11,0) not null primary key,
		dcl_chklst_tpl_name varchar2(255) not null,
		dcl_chklst_tpl_active char(1) default 'Y' not null
	);

Create Table dcl_product_module (
		product_module_id number(11, 0) Not Null Primary Key,
		product_id number(11, 0) Not Null,
		module_name varchar2(50) Not Null,
		active char(1) Not Null
	);

create or replace package DCL as
	FUNCTION next_seq(injcn number) return number;
	PRAGMA RESTRICT_REFERENCES(next_seq,WNDS,RNPS);
end DCL;
/

create or replace package body DCL as
	function next_seq(injcn number) return number is
		aseq number;
	begin
		select max(seq)+1 into aseq from workorders where jcn=injcn;
		return aseq;
	exception 
		when NO_DATA_FOUND then
			return 1;
	end next_seq;
end DCL;
/


INSERT INTO personnel 
	(id, short,lastname,firstname,reportto,department,pwd,security,email,active) 
	VALUES( seq_personnel.nextval, 'sa', 'Administrator', 'System', 0, 0, 
		'c12e01f2a13ff5587e1e9e4aedb8242d', 9, '', 'Y');
commit;

INSERT INTO actions 
	VALUES(seq_actions.nextval, 'DBG', 'Debug', 'Y');
INSERT INTO actions 
	VALUES(seq_actions.nextval, 'RES', 'Research', 'Y');
INSERT INTO actions 
	VALUES(seq_actions.nextval, 'DOC', 'Document', 'Y');
INSERT INTO actions 
	VALUES(seq_actions.nextval, 'TST', 'Testing', 'Y');
INSERT INTO actions 
	VALUES(seq_actions.nextval, 'DES', 'Design', 'Y');
INSERT INTO actions 
	VALUES(seq_actions.nextval, 'IMP', 'Implementation', 'Y');
INSERT INTO actions 
	VALUES(seq_actions.nextval, 'CORR', 'Correction', 'Y');
commit;

INSERT INTO statuses 
	VALUES( seq_statuses.nextval, 'OP', 'Open', 'Y');
INSERT INTO statuses 
	VALUES( seq_statuses.nextval,'CL', 'Closed', 'Y');
INSERT INTO statuses 
	VALUES( seq_statuses.nextval,'DF', 'Deferred', 'Y');
INSERT INTO statuses 
	VALUES( seq_statuses.nextval,'UA', 'Unassigned', 'Y');
commit;

INSERT INTO attributesets(id,short,name,active) 
	VALUES (seq_attributesets.nextval, 'WO', 'Work Orders', 'Y');
INSERT INTO attributesets(id,short,name,active) 
	VALUES (seq_attributesets.nextval, 'TCK', 'Tickets', 'Y');
commit;

INSERT INTO attributesetsmap SELECT 1, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 1, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 1, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 1, 4, id, 1 FROM statuses;
commit;

INSERT INTO attributesetsmap SELECT 2, 1, id, 1 FROM actions;
INSERT INTO attributesetsmap SELECT 2, 2, id, weight FROM priorities;
INSERT INTO attributesetsmap SELECT 2, 3, id, weight FROM severities;
INSERT INTO attributesetsmap SELECT 2, 4, id, 1 FROM statuses;
commit;

INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_VERSION','dcl_config_varchar',NULL,NULL,NULL,NULL,'0.9.3');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_DATE_FORMAT','dcl_config_varchar',NULL,NULL,NULL,NULL,'m/d/Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_DATE_FORMAT_DB','dcl_config_varchar',NULL,NULL,NULL,NULL,'Y-m-d');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_TIMESTAMP_FORMAT_DB','dcl_config_varchar',NULL,NULL,NULL,NULL,'Y-m-d H:i:s');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_TIMESTAMP_FORMAT','dcl_config_varchar',NULL,NULL,NULL,NULL,'m/d/Y H:i:s');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_MAX_UPLOAD_FILE_SIZE','dcl_config_int',1048576,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_default_LANGUAGE','dcl_config_varchar',NULL,NULL,NULL,NULL,'en');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_PRIVATE_KEY','dcl_config_varchar',NULL,NULL,NULL,NULL,'IloveDCL');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_ROOT','dcl_config_varchar',NULL,NULL,NULL,NULL,'http://localhost/dcl/');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_ADD_USER','dcl_config_int',9,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_DEL_WO','dcl_config_int',8,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_MOD_WO','dcl_config_int',7,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_ASSIGN_WO','dcl_config_int',5,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_ADD_WO','dcl_config_int',3,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_HAVE_WO','dcl_config_int',4,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_CHG_PWD','dcl_config_int',2,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_DEF_STATUS_ASSIGN_WO','dcl_config_int',1,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_DEF_STATUS_UNASSIGN_WO','dcl_config_int',4,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_DEF_PRIORITY','dcl_config_int',1,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_DEF_SEVERITY','dcl_config_int',2,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_AUTO_DATE','dcl_config_varchar',NULL,NULL,NULL,NULL,'Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_TIME_CARD_ORDER','dcl_config_varchar',NULL,NULL,NULL,NULL,'ASC');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_PROJECT_XML_TEMPLATES','dcl_config_varchar',NULL,NULL,NULL,NULL,'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_GD_TYPE','dcl_config_varchar',NULL,NULL,NULL,NULL,'png');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_CQQ_PERCENT','dcl_config_int',0,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_CQQ_FROM','dcl_config_varchar',NULL,NULL,NULL,NULL,'Somebody <someone@somewhere.org>');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_CQQ_SUBJECT','dcl_config_varchar',NULL,NULL,NULL,NULL,'Thank You For Calling');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_CQQ_TEMPLATE','dcl_config_varchar',NULL,NULL,NULL,NULL,'cqqmail.tpl');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_DEF_TEMPLATE_SET','dcl_config_varchar',NULL,NULL,NULL,NULL,'default');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_COLOR_LIGHT','dcl_config_varchar',NULL,NULL,NULL,NULL,'#eeeef8');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_COLOR_DARK','dcl_config_varchar',NULL,NULL,NULL,NULL,'#737b9c');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_SMTP_SERVER','dcl_config_varchar',NULL,NULL,NULL,NULL,'localhost');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_SMTP_ENABLED','dcl_config_varchar',NULL,NULL,NULL,NULL,'Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_SMTP_PORT','dcl_config_int',25,NULL,NULL,NULL,NULL);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int, dcl_config_double, dcl_config_date, dcl_config_datetime, dcl_config_varchar) 
	VALUES ('DCL_SMTP_TIMEOUT','dcl_config_int',30,NULL,NULL,NULL,NULL);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_datetime)
	values ('LAST_CONFIG_UPDATE', 'dcl_config_datetime', sysdate);
commit;

INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) 
	VALUES ('DCL_PROJECT_BROWSE_PARENTS_ONLY', 'dcl_config_varchar', 'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) 
	VALUES ('DCL_PROJECT_INCLUDE_PARENT_STATS', 'dcl_config_varchar', 'N');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) 
	VALUES ('DCL_PROJECT_INCLUDE_CHILD_STATS', 'dcl_config_varchar', 'Y');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar)
	VALUES ('DCL_FILE_PATH', 'dcl_config_varchar', '.');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar)
	VALUES ('DCL_HTML_TITLE', 'dcl_config_varchar', 'Double Choco Latte - Copyright (C) 1998-2001 Michael L. Dean and Tim R. Norman');
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int)
	VALUES ('DCL_DEFAULT_PROJECT_STATUS', 'dcl_config_int', 1);
INSERT INTO dcl_config (dcl_config_name, dcl_config_field, dcl_config_int)
	VALUES ('DCL_DEFAULT_TICKET_STATUS', 'dcl_config_int', 1);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPOND', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_REPLY', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_TICKET_FILE_PATH', 'dcl_config_varchar', '/tmp');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_STATUS', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_PRIORITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_SEVERITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_ACCOUNT', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_TICKET_REPLY_LOGGED_BY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_SMTP_DEFAULT_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_NOTIFICATION_HTML', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_wo_en.tpl');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_NOTIFICATION_HTML', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_TCK_EMAIL_TEMPLATE', 'dcl_config_varchar', 'notify_tck_en.tpl');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPOND', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_AUTORESPONSE_EMAIL', 'dcl_config_varchar', 'nobody@localhost');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_FILE_PATH', 'dcl_config_varchar', '/tmp');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_PRIORITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_GATEWAY_WO_REPLY', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_SEVERITY', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_GATEWAY_WO_STATUS', 'dcl_config_int', 0);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WO_SECONDARY_ACCOUNTS_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_SESSION_TIMEOUT', 'dcl_config_int', 20);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_varchar) values ('DCL_WIKI_ENABLED', 'dcl_config_varchar', 'N');
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_VIEW', 'dcl_config_int', 4);
insert into dcl_config (dcl_config_name, dcl_config_field, dcl_config_int) values ('DCL_WIKI_EDIT', 'dcl_config_int', 5);
commit;

Create Table dcl_wo_account (
	wo_id number(11, 0) not null,
	seq number(11, 0) not null,
	account_id number(11, 0) not null,
	primary key(wo_id, seq, account_id)
);

Create Table dcl_wo_type (
	wo_type_id number(11, 0) not null primary key,
	type_name varchar2(50) not null,
	active char(1) not null
);

Create Table dcl_session (
	dcl_session_id varchar2(32) not null primary key,
	personnel_id number(11, 0) not null,
	create_date date not null,
	update_date date not null,
	session_data clob
);

Create Table dcl_preferences (
	personnel_id number(11, 0) not null primary key,
	preferences_data clob
);

create table dcl_status_type (
		dcl_status_type_id number(11,0) not null primary key,
		dcl_status_type_name varchar2(50) not null
	);

insert into dcl_status_type values (1, 'Open');
insert into dcl_status_type values (2, 'Completed');
insert into dcl_status_type values (3, 'Deferred');
commit;

Create Table dcl_wiki (
	dcl_entity_type_id number(11, 0) not null,
	dcl_entity_id number(11, 0) not null,
	dcl_entity_id2 number(11, 0) not null,
	page_name varchar2(255) not null,
	page_text clob null,
	page_date date null,
	page_ip varchar2(255) null,
	primary key (dcl_entity_type_id, dcl_entity_id, dcl_entity_id2, page_name)
);
