<?php
/*
 * $Id: class.htmlTimeCardForm.inc.php,v 1.3.2.1.2.4 2003/11/03 04:41:40 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('tc');

class htmlTimeCardForm
{
	function Show($jcn, $seq, $obj = '', $selected = '')
	{
		echo $this->GetForm($jcn, $seq, $obj, $selected);
	}

	function GetForm($jcn, $seq, $obj = '', $selected = '')
	{
		global $dcl_info;

		$isBatch = is_array($selected) && count($selected) > 0;
		$isEdit = is_object($obj) && !$isBatch; // Don't allow batch updates for now...

		if (!$GLOBALS['g_oSec']->HasSecLvl($isEdit ? $dcl_info['DCL_MOD_WO'] : $dcl_info['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlTimeCardForm.tpl'));
		IncludeCalendar();
		if (!$isBatch)
		{
			$objWorkorder = CreateObject('dcl.dbWorkorders');
			$objWorkorder->Connect();
			$objWorkorder->Load($jcn, $seq);

			$objProduct = CreateObject('dcl.dbProducts');
			$objProduct->Connect();
			$objProduct->Query('SELECT wosetid FROM products WHERE id=' . $objWorkorder->product);
			$objProduct->next_record();
			$setid = $objProduct->f(0);

			$Template->set_var('VAL_WOETCHOURS', $objWorkorder->etchours);
			$Template->set_var('VAL_UPDATEWOETCHOURS', 'true');
		}
		else
		{
			$Template->set_var('VAL_WOETCHOURS', '0');
			$Template->set_var('VAL_UPDATEWOETCHOURS', 'false');
			$setid = 0;
		}


		$Template->set_block('hForm', 'modify', 'hModify');
		$Template->set_block('hForm', 'batch', 'hBatch');
		$Template->set_block('hForm', 'reassign', 'hReassign');

		$Template->set_var('hModify', '');
		$Template->set_var('hBatch', '');
		$Template->set_var('hReassign', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		// if editing, we go 100%
		if ($isEdit)
			$Template->set_var('VAL_OUTERTABLEWIDTH', '100%');
		else
			$Template->set_var('VAL_OUTERTABLEWIDTH', '');

		$title = '';
		if ($isEdit)
			$title = STR_TC_EDIT;
		else if ($isBatch)
			$title = STR_TC_BATCHUPDATE;
		else
			$title = 'Add New Time Card';

		$Template->set_var('TXT_TITLE', $title);

		$hiddenvars = '';
		if ($isBatch)
		{
			$hiddenvars .= GetHiddenVar('menuAction', 'boTimecards.dbbatchadd');
		}
		elseif ($isEdit)
		{
			$hiddenvars .= GetHiddenVar('menuAction', 'boTimecards.dbmodify');
			$hiddenvars .= GetHiddenVar('id', $obj->id);
		}
		else
			$hiddenvars .= GetHiddenVar('menuAction', 'boTimecards.dbadd');

		if (IsSet($GLOBALS['return_to']))
		{
			$hiddenvars .= GetHiddenVar('return_to', $GLOBALS['return_to']);
			// FIXME: specific to projects
			if (IsSet($GLOBALS['project']))
				$hiddenvars .= GetHiddenVar('project', $GLOBALS['project']);
		}

		if ($isBatch)
		{
			$objView = CreateObject('dcl.boView');
			$objView->SetFromURL();
			$hiddenvars .= $objView->GetForm();
			reset($selected);
			while (list($key, $val) = each($selected))
				$hiddenvars .= GetHiddenVar('selected[]', $val);
		}
		else
		{
			$hiddenvars .= GetHiddenVar('jcn', $jcn);
			$hiddenvars .= GetHiddenVar('seq', $seq);
		}

		$Template->set_var('HIDDEN_VARS', $hiddenvars);

		$objStatuses = CreateObject('dcl.htmlStatuses');
		$objActions = CreateObject('dcl.htmlActions');
		$objPersonnel = CreateObject('dcl.htmlPersonnel');

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('TXT_DATE', STR_TC_DATE);
		$Template->set_var('TXT_BY', STR_TC_BY);
		$Template->set_var('TXT_STATUS', STR_TC_STATUS);
		$Template->set_var('TXT_ACTION', STR_TC_ACTION);
		$Template->set_var('TXT_HOURS', STR_TC_HOURS);
		$Template->set_var('TXT_ETC', STR_TC_ETC);
		$Template->set_var('TXT_VERSION', STR_TC_VERSION);
		$Template->set_var('TXT_SUMMARY', STR_TC_SUMMARY);
		$Template->set_var('TXT_DESCRIPTION', STR_TC_DESCRIPTION);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_TC_HIGHLIGHTEDNOTE);
		$Template->set_var('TXT_MODIFYNOTE', STR_TC_MODIFYNOTE);
		$Template->set_var('TXT_ATTRIBUTENOTE', '');
		$Template->set_var('TXT_REASSIGN', STR_CMMN_REASSIGN);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);

		$Template->set_var('VAL_ETCHOURS', '');

		if ($isEdit)
		{
			$Template->set_var('VAL_ACTIONON', $obj->actionon);
			$Template->set_var('VAL_HOURS', $obj->hours);
			$Template->set_var('VAL_REVISION', htmlspecialchars($obj->revision));
			$Template->set_var('VAL_SUMMARY', htmlspecialchars($obj->summary));
			$Template->set_var('VAL_DESCRIPTION', htmlspecialchars($obj->description));
			$Template->set_var('CMB_ACTIONBY', $objPersonnel->GetCombo($obj->actionby, 'actionby', 'lastfirst', 0, false, $dcl_info['DCL_HAVE_WO']));
			$Template->set_var('CMB_STATUS', $objStatuses->GetCombo($obj->status, 'status', 'name', 0, false, $setid));
			$Template->set_var('CMB_ACTION', $objActions->GetCombo($obj->action, 'action', 'name', 0, false, $setid));

			$Template->parse('hModify', 'modify');
		}
		else
		{
			$Template->set_var('VAL_ACTIONON', date($dcl_info['DCL_DATE_FORMAT']));
			$Template->set_var('VAL_HOURS', '');
			$Template->set_var('VAL_REVISION', '');
			$Template->set_var('VAL_SUMMARY', '');
			$Template->set_var('VAL_DESCRIPTION', '');
			$Template->set_var('CMB_ACTIONBY', $objPersonnel->GetCombo($GLOBALS['DCLID'], 'actionby', 'lastfirst', 0, true, $dcl_info['DCL_HAVE_WO']));
			$Template->set_var('CMB_ACTION', $objActions->GetCombo(0, 'action', 'name', 0, true, $setid));

			if ($GLOBALS['g_oSec']->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			{
				$Template->set_var('CMB_REASSIGN', $objPersonnel->GetCombo(0, 'reassign_to_id', 'lastfirst', 0, true, $dcl_info['DCL_HAVE_WO']));
				$Template->parse('hReassign', 'reassign');
			}

			if ($isBatch)
			{
				$Template->set_var('CMB_STATUS', $objStatuses->GetCombo(1, 'status', 'name', 0, true, $setid));
				$Template->parse('hBatch', 'batch');
			}
			else
				$Template->set_var('CMB_STATUS', $objStatuses->GetCombo($objWorkorder->status, 'status', 'name', 0, true, $setid));
		}

		return $Template->parse('out', 'hForm');
	}
}
?>
