<?php
/*
 * $Id: class.htmlProjects.inc.php,v 1.5.2.1.2.14 2003/12/10 05:54:06 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('prj');
LoadStringResource('wo');

class htmlProjects
{
	function createCombo($default = 0, $cbName = 'project', $reportTo = 0, $size = 0, $dontshowid = -1)
	{
		print $this->GetCombo($default, $cbName, $reportTo, $size, $dontshowid);
	}

	function GetCombo($default = 0, $cbName = 'project', $reportTo = 0, $size = 0, $dontshowid = -1, $bHideClosed = false)
	{
		$whereClause = '';

		if ($bHideClosed)
		{
			$whereClause = ', statuses ';
		}

		if ($reportTo > 0)
		{
			$whereClause .= " WHERE reportto=$reportTo";
		}

		if ($dontshowid != -1)
		{
			if ($whereClause == '' || $whereClause == ', statuses ')
				$whereClause .= ' WHERE ';
			else
				$whereClause .= ' AND ';

			$whereClause .= "dcl_projects.projectid != $dontshowid";
		}

		if ($bHideClosed)
		{
			if ($whereClause == '' || $whereClause == ', statuses ')
				$whereClause .= ' WHERE ';
			else
				$whereClause .= ' AND ';

			$whereClause .= 'dcl_projects.status = statuses.id AND statuses.dcl_status_type != 2';
		}

		$oSelect = CreateObject('dcl.htmlSelect');
		$oSelect->vDefault = $default;
		$oSelect->sName = $cbName;
		$oSelect->iSize = $size;
		$oSelect->sZeroOption = STR_CMMN_SELECTONE;
		$oSelect->SetFromQuery('SELECT dcl_projects.projectid, dcl_projects.name FROM dcl_projects' . $whereClause . ' ORDER BY dcl_projects.name');

		return $oSelect->GetHTML();
	}

	function RenderOptions(&$aRecord)
	{
		global $dcl_info, $g_oSec;
		
		$str = '<td>';
		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boProjects.viewproject&project=' . $aRecord['projectid']) . '">' . 'Detail' . '</a>';
		$str .= '&nbsp;|&nbsp;';
		$str .= '<a class="adark" href="' . menuLink('', 'menuAction=boProjects.showtree&project=' . $aRecord['projectid']) . '">' . 'Tree' . '</a>';
		if ($dcl_info['DCL_WIKI_ENABLED'] == 'Y' && $g_oSec->HasSecLvl($dcl_info['DCL_WIKI_VIEW']))
		{
			$str .= '&nbsp;|&nbsp;';
			$str .= '<a class="adark" href="' . menuLink('', 'menuAction=htmlWiki.show&type=1&id=' . $aRecord['projectid']) . '">' . STR_CMMN_WIKI . '</a>';
		}
		$str .= '</td>';
		echo $str;
	}

	function RenderFilter(&$sPagerFormElements)
	{
		$oStatus = CreateObject('dcl.htmlStatuses');
		$oReport = CreateObject('dcl.htmlPersonnel');

		$filterStatus = IsSet($GLOBALS['filterStatus']) ? $GLOBALS['filterStatus'] : 1;
		$filterReportto = IsSet($GLOBALS['filterReportto']) ? $GLOBALS['filterReportto'] : 0;

		echo '<form method="post" action="' . menuLink('') . '">';
		echo $sPagerFormElements;
		echo '<br><b>', STR_PRJ_STATUS, ':</b>';
		$oStatus->createCombo($filterStatus, 'filterStatus');
		echo '&nbsp;<b>', STR_PRJ_LEAD, ':</b>';
		$oReport->createCombo($filterReportto, 'filterReportto', 'short', 0, false);
		echo '&nbsp;<input type="submit" value="Filter">';
		echo '</form>';
	}

	function show()
	{
		global $dcl_info;

		commonHeader();

		$oView = CreateObject('dcl.boView');
		$oView->numrows = 15;

		$filterStatus = '0';
		$filterReportto = '0';
		if (IsSet($GLOBALS['filterStatus']))
			$filterStatus = $GLOBALS['filterStatus'];
		if (IsSet($GLOBALS['filterReportto']))
			$filterReportto = $GLOBALS['filterReportto'];

		$oView->table = 'dcl_projects';
		$oView->style = 'report';
		$oView->title = 'Projects';
		$oView->AddDef('columnhdrs', '', array(STR_CMMN_ID, STR_PRJ_LEAD, STR_PRJ_STATUS, STR_PRJ_NAME));
		$oView->AddDef('columns', '', array('projectid', 'reportto.short', 'statuses.name', 'dcl_projects.name'));
		if ($dcl_info['DCL_PROJECT_BROWSE_PARENTS_ONLY'] == 'Y')
			$oView->AddDef('filter', 'parentprojectid', 0);

		$oView->AddDef('order', '', array('dcl_projects.name'));
		
		if ($filterStatus != '0')
			$oView->AddDef('filter', 'dcl_projects.status', $filterStatus);
		else
			$oView->AddDef('filternot', 'statuses.dcl_status_type', '2');

		if ($filterReportto != '0')
			$oView->AddDef('filter', 'dcl_projects.reportto', $filterReportto);

		$oHtml = CreateObject('dcl.htmlProjectsBrowse');
		$oHtml->Render($oView);
	}

	function DisplaySearchForm()
	{
		global $dcl_info;

		$Template = CreateTemplate(array('hForm' => 'htmlProjectsSearch.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_PRJ_SEARCH);
		$Template->set_var('TXT_CHOOSEPRJ', STR_PRJ_CHOOSEPRJ);
		$Template->set_var('CMB_PROJECT', $this->GetCombo(0, 'project', 0, 0, -1, true));
		$Template->set_var('BTN_VIEW', STR_CMMN_VIEW);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->pparse('out', 'hForm');
	}

	function ShowUploadFileForm($projectid)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlProjectsUpload.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_PRJ_UPLATTACH);
		$Template->set_var('TXT_ATTACH', STR_PRJ_ATTACH);
		$Template->set_var('VAL_MAXUPLOADFILESIZE', $dcl_info['DCL_MAX_UPLOAD_FILE_SIZE']);
		$Template->set_var('VAL_PROJECTID', $projectid);
		$Template->set_var('BTN_UPLOAD', STR_CMMN_UPLOAD);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('LNK_CANCEL', menuLink('', 'menuAction=boProjects.viewproject&project=' . $projectid));
		$Template->pparse('out', 'hForm');
	}

	function ShowDeleteAttachmentYesNo($projectid, $filename)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlProjectsDeleteAttachment.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_TITLE', STR_PRJ_DELATTACH);
		$Template->set_var('VAL_PROJECTID', $projectid);
		$Template->set_var('VAL_FILENAME', htmlspecialchars($filename));
		$Template->set_var('TXT_DELCONFIRM', sprintf(STR_PRJ_DELCONFIRM, $filename));
		$Template->set_var('BTN_YES', STR_CMMN_YES);
		$Template->set_var('BTN_NO', STR_CMMN_NO);
		$Template->pparse('out', 'hForm');
	}

	function changeLog()
	{
		global $dcl_info;

		commonHeader();

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_HAVE_WO']))
			return PrintPermissionDenied();

		$id = intval($GLOBALS['projectid']);

		$o = CreateObject('dcl.dbSccsXref');
		$o->Connect();
		if ($o->ListChangeLog(DCL_ENTITY_PROJECT, $id) != -1)
		{
			$allRecs = array();
			while ($o->next_record())
			{
				$allRecs[] = array($o->f(0) . ': ' . $o->f(2), $o->f(1), $o->f(3), $o->f(4), $o->f(5), $o->FormatTimestampForDisplay($o->f(6)));
			}

			$titleLink = '<a class="adark" href="' . menuLink('', "menuAction=boProjects.viewproject&project=$id") . '">' . 'Back' . '</a>';

			if (count($allRecs) > 0)
			{
				$allName = array(
						0 => 'Project',
						1 => 'Changed By',
						2 => 'File',
						3 => 'Version',
						4 => 'Comments',
						5 => 'Date');

				PrintArrayAsChocoTable($allName, $allRecs, "ChangeLog for Project $id", '', $titleLink, false, 0);
			}
			else
			{
				print('<center>');
				print("No ChangeLog for Project $id<p>");
				print('</center>');

				$obj = CreateObject('dcl.htmlProjectsdetail');
				if (!IsSet($GLOBALS['wostatus']))
					$GLOBALS['wostatus'] = 0;

				if (!IsSet($GLOBALS['woresponsible']))
					$GLOBALS['woresponsible'] = 0;

				$obj->show($id, $GLOBALS['wostatus'], $GLOBALS['woresponsible']);
			}
		}
	}

	function my($rowlimit = 5)
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbProjects');
		$obj->Connect();

		$query = sprintf('SELECT projectid,name FROM dcl_projects WHERE reportto=%d AND status=%d ORDER BY name ',
				$GLOBALS['DCLID'], $dcl_info['DCL_DEFAULT_PROJECT_STATUS']);

		$obj->LimitQuery($query, 0, $rowlimit);

		$t = CreateTemplate(array('hForm' => 'htmlMy.tpl'));
		$t->set_block('hForm', 'row', 'hRow');
		$t->set_block('hForm', 'nothing', 'hNothing');
		$t->set_var('hRow', '');
		$t->set_var('hNothing', '');

		$t->set_var('TXT_TITLE', STR_PRJ_MYPRJ);
		$t->set_var('TXT_TOP', sprintf(STR_CMMN_TOPNUM, $rowlimit));
		$t->set_var('LNK_MY', menuLink('', 'menuAction=htmlProjects.show&filterReportto=' . $GLOBALS['DCLID']));

		if ($obj->next_record())
		{
			$i = 0;
			do
			{
				$t->set_var('COLOR_ROW', ($i++ % 2 == 0 ? '#cecece' : $dcl_info['DCL_COLOR_LIGHT']));
				$t->set_var('LNK_ROW', menuLink('', 'menuAction=boProjects.viewproject&wostatus=0&project=' . $obj->f('projectid')));
				$t->set_var('VAL_ROW', $obj->f('name'));
				$t->parse('hRow', 'row', true);
			}
			while ($obj->next_record());
		}
		else
		{
			$t->set_var('TXT_NOTHING', STR_PRJ_NOTLEAD);
			$t->parse('hNothing', 'nothing');
		}

		$t->pparse('out', 'hForm');
	}
}
?>
