# mysql.pl - part of dbengine
# see closer information at http://www.cis-computer.com/dbengine
#
# Version 1.1 <c> 2001
# Ingo Ciechowski		ic	<ciechowski@cis-computer.com>
#


sub db_connect2database {
	$descdb		=~ s/\/(\w+)//;
	$dbdesc		=~ s/\/(\w+)//;
	$uniqOID	= "";

	#
	# contact our database server to connect to the database with our data and die properly if this attempt fails...
	$dbase  = $defdb unless $dbase;
	my $dsn = "dbi:mysql:dbname=$dbase;port=$port;host=$server";
	$dbconn=DBI->connect($dsn,"$user","$passwd");
	&connError("could not connect to $dbase on server $server port $port *** try $scriptname?dbase='aValidDatabaseName' ***");

	#
	# contact our database to connect to the database with additional display information
	# if we can't contact this database we'll have to die :-((
	if($dbdesc) {
		my $descdsn = "dbi:mysql:dbname=$dbdesc;port=$port;host=$server";
   	 	$dbdconn=DBI->connect($descdsn,"$user","$passwd");
		&connError("could not connect to $dbdesc on server $server port $port *** try $scriptname?dbdesc='aValidDatabaseName' ***");

	#
	# if there was no additional name specified we try to access the default $descdb database,
	# but if that fails we simply assume that our user wants to store this information in the same database
	} else {
		my $descdsn = "dbi:mysql:dbname=$descdb;port=$port;host=$server";
		$dbdconn=DBI->connect($descdsn,"$user", "$passwd");
 		$dbdconn=$dbconn unless (defined($dbdconn));
		$dbdesc	= $descdb;
	}

	# Useful for debugging
	$dbconn->{RaiseError} = 1;
	$dbdconn->{RaiseError} = 1;

} # db_connect2database


sub db_getUniqOIDField {
	# Returns the name of the first field in the table
	# Parameters:
	#	$dbh - valid handle to a database
	#	$table - name of the table for which to look for uniqOID field
	# Return values:
	#	0 - operation failed
	#	$oid - name of field determined to be the primary key, or uniq OID, for the table;
	#		string returned by the NAME function and is not lc'ed or uc'ed which is advisable
	my ($dbh, $table) = @_;
	die "No table specified." unless $table;
	my $sql = "SELECT * FROM $table";
	my $sth = $dbh->prepare($sql);
	$sth->execute or die "Invalid OID";
	my $oid = $sth->{NAME}->[0] or "Invalid OID";
	return $oid;
} # db_getUniqOIDField


sub db_isView {
	#
	# returns 1 if the given table is a view,
	# i.e. read-only
	my ($name)	= @_;
	my ($isView)	= 0;

	# Views are not yet supported by MySQL (maybe in ver 4.1 according to docs)
	return 0;

 	if($dbasetype eq "oracle") {
	} elsif ($dbasetype eq "mysql") {
return 0;
 	} else {
		$cmd	= "select definition from pg_views where viewname = '$name'";
 	}

	$result = $dbdconn->prepare($cmd);
	$result->execute || $log->debug("Could not view definition. SQL Error:$DBI::errstr");
	$isView = 1 if($result->rows > 0);

 	return $isView;
} # db_isView



sub db_initVars {
	$dbVar{'childRM'}	= "removeChildOnParentDelete='t'";
#	$dbVar{'offset'}	= 1;
} # db_initVars




# wlm Added support for mysql
sub db_getDbaseFieldTypes {
	# create local versions of global variables
	my ($dbh) = $dbconn;
	# wlm I concur with rl. I noticed this behavior in the test db-(list vendors, select edit hofmann); price data would get duplicated because there was only 1 record; this behavior occurs when a related set of tables is discovered by the script which causes the frame to get split (see &plainDialog) and search mode to be entered in the bottom frame; thus listTable will call this routine and so will plainDialog - see test code below for example (need to have CGI::Carp enabled)
	#use CGI::Carp qw / confess fatalsToBrowser /; if (%fielddisporder) { confess "here!"; }
	#
	# Determine fieldname and types
	my $i = 0;
	my $sql = "SELECT * FROM $table";
	$fieldresult = $dbh->prepare($sql) or return 0;
	$fieldresult->execute or return 0;
	my @field_types = map { scalar $dbh->type_info($_)->{TYPE_NAME} } @{ $fieldresult->{TYPE} };
	my @field_sizes = map { scalar $dbh->type_info($_)->{COLUMN_SIZE} } @{ $fieldresult->{TYPE} };
	my $fields = $fieldresult->{NAME};
	foreach my $fld (@$fields) {
		$fieldtype{$fld} = $field_types[$i];
		$fieldlength{$fld} = $field_sizes[$i];
		$i++;
	}

	foreach my $name ( @{ $fieldresult->{NAME} } ) {
		push @fieldnames, $name;
	}
} # db_getDbaseFieldTypes

1;

