;*=====================================================================*/
;*    serrano/prgm/project/bigloo/fthread/src/Llib/_thread.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu May 29 07:43:14 2003                          */
;*    Last change :  Sat Aug 16 15:03:25 2003 (serrano)                */
;*    Copyright   :  2003 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The private FairThreads implementation.                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __ft_%thread

   (include "_thread.sch"
	    "debug.sch")
   
   (import  __ft_types
            __ft_%types
            __ft_signal
	    __ft_%scheduler)
   
   (export  (%thread-setup! ::thread)
	    (%thread-awake! ::thread)
	    (%thread-cooperate ::thread)
	    (%thread-yield! ::thread)
	    (%thread-timeout! ::thread ::int)
	    (%thread-kill! ::thread)
	    (inline %thread-unregister-signals! ::thread)
	    (%thread-attached?::bool ::thread)
	    (%thread-is-dead::bool ::thread . ::obj)
	    (%thread-is-toterminate::bool ::thread . ::obj)
	    (%thread-is-terminated::bool ::thread . ::obj)
	    (%thread-asynchronize! t::thread id::symbol)
	    (%thread-synchronize! t)
	    
	    (%thread-add-mutex! ::thread ::mutex)
	    (%thread-del-mutex! ::thread ::mutex)))

;*---------------------------------------------------------------------*/
;*    *thread-counter* ...                                             */
;*---------------------------------------------------------------------*/
(define *thread-counter* 0)

;*---------------------------------------------------------------------*/
;*    %thread-setup! ...                                               */
;*---------------------------------------------------------------------*/
(define (%thread-setup! t::thread)
   (set! *thread-counter* (+fx 1 *thread-counter*))
   (with-access::thread t (%builtin %ident)
      ($bglthread-setup! %builtin t)
      (set! %ident *thread-counter*)
      thread))

;*---------------------------------------------------------------------*/
;*    %thread-awake! ...                                               */
;*---------------------------------------------------------------------*/
(define (%thread-awake! t::thread)
   (with-access::thread t (scheduler %timeout)
      (with-access::%scheduler scheduler (threads-runnable)
	 (set! %timeout 1)
	 (set! threads-runnable (cons t threads-runnable)))))

;*---------------------------------------------------------------------*/
;*    %thread-cooperate ...                                            */
;*---------------------------------------------------------------------*/
(define (%thread-cooperate t::thread)
   (with-access::thread t (scheduler %terminate)
      (with-debug 3 '%thread-cooperate
	 (debug-item "thread=" (debug-string t))
	 (debug-item "toterminate=" (%thread-is-toterminate t))
	 (debug-item "terminated=" (%thread-is-terminated t))
	 (%scheduler-switch-to-next-thread t scheduler)
	 (if (%thread-is-terminated t)
	     (%terminate t)))))
   
;*---------------------------------------------------------------------*/
;*    %thread-yield! ...                                               */
;*---------------------------------------------------------------------*/
(define (%thread-yield! t::thread)
   (with-access::thread t (scheduler)
      (with-access::%scheduler scheduler (threads-yield %threads-ready)
	 (set! threads-yield (cons t threads-yield))
	 (set! %threads-ready #t)
	 (%thread-cooperate t))))

;*---------------------------------------------------------------------*/
;*    %thread-timeout! ...                                             */
;*---------------------------------------------------------------------*/
(define (%thread-timeout! t::thread tmt::int)
   (with-access::thread t (scheduler %timeout)
      (set! %timeout tmt)
      (with-access::%scheduler scheduler (threads-timeout %threads-ready)
	 (set! threads-timeout (cons t threads-timeout))
	 (set! %threads-ready #t)
	 (%thread-cooperate t))))
	 
;*---------------------------------------------------------------------*/
;*    %thread-kill! ...                                                */
;*---------------------------------------------------------------------*/
(define (%thread-kill! t::thread)
   (with-access::thread t (%builtin scheduler %state)
      (with-debug 3 '%thread-kill!
	 (%thread-kill-debug t)
	 (%thread-is-dead t #t)
	 (with-access::%scheduler scheduler (threads-runnable %live-thread-number)
	    (set! %live-thread-number (-fx %live-thread-number 1))
	    (set! threads-runnable (remq! t threads-runnable))
	    (%thread-unregister-signals! t)
	    (%scheduler-switch-to-next-thread t scheduler)
	    #unspecified))))

;*---------------------------------------------------------------------*/
;*    %thread-kill-debug ...                                           */
;*---------------------------------------------------------------------*/
(define (%thread-kill-debug t)
   (debug-item "thread=" (debug-string t)))

;*---------------------------------------------------------------------*/
;*    %thread-unregister-signals! ...                                  */
;*    -------------------------------------------------------------    */
;*    Unregister the thread from its waiting signal queues             */
;*---------------------------------------------------------------------*/
(define-inline (%thread-unregister-signals! t::thread)
   (with-access::thread t (%signals)
      (for-each (lambda (s) (signal-unbind-thread! s t)) %signals)))

;*---------------------------------------------------------------------*/
;*    %thread-attached? ...                                            */
;*---------------------------------------------------------------------*/
(define (%thread-attached? t::thread)
   (scheduler? (thread-scheduler t)))

;*---------------------------------------------------------------------*/
;*    %thread-is-dead ...                                              */
;*---------------------------------------------------------------------*/
(define (%thread-is-dead t::thread . v)
   (with-access::thread t (%state)
      (if (and (pair? v) (car v))
	  (set! %state 'dead)
	  (eq? %state 'dead))))

;*---------------------------------------------------------------------*/
;*    %thread-is-toterminate ...                                       */
;*---------------------------------------------------------------------*/
(define (%thread-is-toterminate t::thread . v)
   (with-access::thread t (%state)
      (if (and (pair? v) (car v))
	  (set! %state 'toterminate)
	  (eq? %state 'toterminate))))

;*---------------------------------------------------------------------*/
;*    %thread-is-terminated ...                                        */
;*---------------------------------------------------------------------*/
(define (%thread-is-terminated t::thread . v)
   (with-access::thread t (%state)
      (if (and (pair? v) (car v))
	  (set! %state 'terminated)
	  (eq? %state 'terminated))))

;*---------------------------------------------------------------------*/
;*    %thread-asynchronize! ...                                        */
;*---------------------------------------------------------------------*/
(define (%thread-asynchronize! t::thread id::symbol)
   (with-debug 3 '%thread-asynchronize!
      (debug-item "thread=" (debug-string t))
      (debug-item "id=" id))
   (with-access::thread t (scheduler %builtin)
      ($bglthread-id-set! %builtin id)
      (let ((nt (%scheduler-next-thread t scheduler)))
	 ($bglthread-switch %builtin (thread-%builtin nt)))
      #unspecified))

;*---------------------------------------------------------------------*/
;*    %thread-synchronize! ...                                         */
;*---------------------------------------------------------------------*/
(define (%thread-synchronize! t)
   (with-access::thread t (name %builtin scheduler)
      ;; add the current thread to the list of asynchronous thread
      ;; ready to be synchronized (i.e. cooperative)
      (%scheduler-add-async-runnable! scheduler t)
      ;; wait for the cooperative token
      ($bglthread-wait %builtin)
      (with-debug 3 '%thread-synchronize!
	 (debug-item "thread=" (debug-string t)))
      ($bglthread-id-set! %builtin name)))

;*---------------------------------------------------------------------*/
;*    %thread-add-mutex! ...                                           */
;*---------------------------------------------------------------------*/
(define (%thread-add-mutex! t m)
   (with-access::thread t (%mutexes)
      (set! %mutexes (cons t %mutexes))))

;*---------------------------------------------------------------------*/
;*    %thread-del-mutex! ...                                           */
;*---------------------------------------------------------------------*/
(define (%thread-del-mutex! t m)
   (with-access::thread t (%mutexes)
      (set! %mutexes (remq! t %mutexes))))

   
