
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvsroot/aolserver/aolserver/doc/ns_httptime.n,v 1.1.2.2 2002/12/03 15:00:23 schaudhri Exp $
'\"
'\" 
.so man.macros

.TH ns_httptime n 4.0 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_httptime, ns_parsehttptime \- commands
.SH SYNOPSIS
\fBns_httptime\fR \fItime\fR
.sp
\fBns_parsehttptime \fIhttptime\fR
.BE
.SH DESCRIPTION
.PP
\fBns_httptime\fR
.RS
This function converts the time (specified as the number of seconds from 00:00:00 UTC, January 1, 1970) to the appropriate format for an HTTP header or log file. The time and date is returned with a four digit year, for example: "Sun, 06 Nov 1994 08:49:37 GMT".
.RE
.PP
\fBns_parsehttptime\fR
.RS
ns_parsehttptime takes a properly formatted HTTP time and returns the number of seconds since 00:00:00 UTC Jan 1, 1970.
.RE
.PP
.SH EXAMPLES
\fBns_httptime\fR
.DS
set time [ns_httptime [ns_time]]
Returns: Thu, 14 Nov 2002 17:29:06 GMT
.DE
.PP
\fBns_parsehttptime\fR
.DS
set time "Thu, 14 Nov 2002 17:29:06 GMT"
ns_parsehttptime $time
Returns: 1037294946
.DE
.SH "SEE ALSO"
ns_time(n)
.SH KEYWORDS
time

