"""Header set folder implementation

$Id: $
"""

__authors__ = 'Geoff Davis <geoff@geoffdavis.net>'
__docformat__ = 'restructuredtext'

from AccessControl import ClassSecurityInfo
from Products.Archetypes import public as atapi
try:
    from Products.CMFCore import permissions
except ImportError:
    from Products.CMFCore import CMFCorePermissions as permissions
from Products.CacheSetup.content.interfaces import ICacheToolFolder

class HeaderSetFolder(atapi.OrderedBaseFolder):
    """A container for header set objects"""

    __implements__ = (atapi.OrderedBaseFolder.__implements__, ICacheToolFolder)

    security = ClassSecurityInfo()
    archetype_name = 'Header Set Folder'
    portal_type = meta_type = 'HeaderSetFolder'
    global_allow = 0
    allowed_content_types = ('HeaderSet',)

    actions = (
        {'action':      'string:$object_url/cache_setup_config',
         'category':    'object',
         'id':          'view',
         'name':        'Cache Setup',
         'permissions': (permissions.ManagePortal,),
         'visible':     False},
    )

    aliases = {
        '(Default)':    'cache_setup_config',
        'view' :        'cache_setup_config',
        'edit' :        'base_edit'
    }

atapi.registerType(HeaderSetFolder)
