#!/usr/bin/env python
# -*- coding: latin-1 -*-
#
# Time-stamp: <2004-07-11 12:39:10 graham>
#
#  COPYRIGHT
# Togaware 2004 All rights are reserved.
#
# Authors: Graham Williams
#

"""Perform the latest fix of all XML entries!"""

########################################################################
# IMPORTS
#

import re
import sys
import os
import shutil
import string
from xml.dom.ext.reader.Sax import FromXmlFile
from xml.dom.ext import PrettyPrint

from tcutils import commify, list_packages, loadXML

########################################################################
# SYSTEM VARIABLES
#
__version__ = "$Revision: 1.15 $".split()[1]
__verdate__ = "$Date: 2004/07/11 05:29:07 $".split()[1:3]
__source__  = "$Source: /cvsroot/texcatalogue/texcatalogue/src/fix.py,v $".\
              split()[1]
__program__ = re.sub('^.RCSfile: (.*).py,v .', "\\1",
                     "$RCSfile: fix.py,v $")

########################################################################
#
# READ AND ADD DOCTYPE
#

def fix_documentation(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = FromXmlFile(xmlfname)
        doc_changed = False
        #
        # Modifications - USE XML
        #------------------------------------------------------------
        documentation = doc.getElementsByTagName('documentation')
        ctan = doc.getElementsByTagName('ctan')
        for d in documentation:
            if d.getAttribute('href'): continue
            doct = d.getAttribute('type')
            docl = d.getAttribute('location')
            try:
                docv = d.firstChild.nodeValue
            except:
                continue
            if docl == 'ctan':
                location = ctan[0].childNodes[0].nodeValue
                url = "ctan:/" + location + "/" + docv
            elif docl in ("http", "ftp"):
                url = docv
            d.removeAttribute('type')
            d.removeAttribute('location')
            d.removeAttribute('compressed')
            d.setAttribute('href', url)
            d.removeChild(d.firstChild)
            doc_changed = True
        # PrettyPrint(doc)
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Fixed documentation of %s." % p
            shutil.copy(xmlfname, xmlfname + ".documentation.bak")
            xmlfile = open(xmlfname, "w")
            PrettyPrint(doc, xmlfile)
            xmlfile.close()
            #sys.exit(0) # For testing
            
def fix_double_doctypes(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        if doc[2] == '<!DOCTYPE entry SYSTEM "entries/catalogue.dtd">\n':
            ndoc = "".join(doc[0:2] + doc[3:])
            doc_changed = True
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Remove duplicated DOCTYPE from %s." % p
            shutil.copy(xmlfname, xmlfname + ".double.doctype.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def fix_remove_platform(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = FromXmlFile(xmlfname)
        doc_changed = False
        #
        # Modifications - USE XML
        #------------------------------------------------------------
        platform = doc.getElementsByTagName('platform')
        description = doc.getElementsByTagName('description')
        if platform:
            # print p, description
            # print description[0].firstChild
            description[0].removeChild(platform[0])
            doc_changed = True
            # PrettyPrint(doc)
            # sys.exit(1) # Testing
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Removed platform from %s." % p
            shutil.copy(xmlfname, xmlfname + ".platform.bak")
            xmlfile = open(xmlfname, "w")
            PrettyPrint(doc, xmlfile)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def fix_version(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = FromXmlFile(xmlfname)
        doc_changed = False
        #
        # Modifications - USE XML
        #------------------------------------------------------------
        version = doc.getElementsByTagName('version')
        if version:
            if version[0].getAttribute('number'): continue
            number = version[0].getElementsByTagName('number')
            if number:
                number = number[0].firstChild.nodeValue
                # print p, number
                version[0].setAttribute('number', number)
                while len(version[0].childNodes):
                    version[0].removeChild(version[0].firstChild)
                    doc_changed = True
                # PrettyPrint(doc)
                # sys.exit(1) # Testing
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Reformed version from %s." % p
            shutil.copy(xmlfname, xmlfname + ".version.bak")
            xmlfile = open(xmlfname, "w")
            PrettyPrint(doc, xmlfile)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def fix_home(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = FromXmlFile(xmlfname)
        doc_changed = False
        #
        # Modifications - USE XML
        #------------------------------------------------------------
        home = doc.getElementsByTagName('home')
        if home and home[0].hasChildNodes():
            url = home[0].firstChild.nodeValue
            home[0].setAttribute('href', url)
            while len(home[0].childNodes):
                home[0].removeChild(home[0].firstChild)
                doc_changed = True
            # PrettyPrint(doc)
            # sys.exit(1) # Testing
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Reformed home for %s." % p
            shutil.copy(xmlfname, xmlfname + ".home.bak")
            xmlfile = open(xmlfname, "w")
            PrettyPrint(doc, xmlfile)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def fix_distr(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = FromXmlFile(xmlfname)
        doc_changed = False
        #
        # Modifications - USE XML
        #------------------------------------------------------------
        entry = doc.getElementsByTagName('entry')
        distribution = doc.getElementsByTagName('distribution')
        if distribution and distribution[0].hasChildNodes():
            print p
            doc_changed = True
            ctan = distribution[0].getElementsByTagName('ctan')
            tetex = distribution[0].getElementsByTagName('tetex')
            texlive = distribution[0].getElementsByTagName('texlive')
            entry[0].removeChild(distribution[0])
            if ctan:
                cpath = ctan[0].firstChild.nodeValue
                if cpath[0] <> '/': cpath = '/' + cpath
                # Create new ctan element with path, add as last element.
                ctan[0].setAttribute('path', cpath)
                while len(ctan[0].childNodes):
                    ctan[0].removeChild(ctan[0].firstChild)
                nctan = ctan[0].cloneNode(True)
                entry[0].appendChild(nctan)
            if tetex:
                # Simply move it up one level
                ntetex = tetex[0].cloneNode(True)
                entry[0].appendChild(ntetex)
            if texlive:
                # Get value, create new element with location, add as last.
                location = texlive[0].firstChild.nodeValue
                texlive[0].setAttribute('location', location)
                while len(texlive[0].childNodes):
                    texlive[0].removeChild(texlive[0].firstChild)
                ntexlive = texlive[0].cloneNode(True)
                entry[0].appendChild(ntexlive)
            # PrettyPrint(doc)
            # sys.exit(1) # Testing
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Reformed distributions for %s." % p
            shutil.copy(xmlfname, xmlfname + ".dist.bak")
            xmlfile = open(xmlfname, "w")
            PrettyPrint(doc, xmlfile)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def remove_description(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = ""
        for i in doc:
            if i == '  <description>\n':
                doc_changed = True
                continue
            if i == '  </description>\n':
                doc_changed = True
                continue
            ndoc += i
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Remove description from %s." % p
            shutil.copy(xmlfname, xmlfname + ".remove.description.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def remove_empty_email(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = ""
        for i in doc:
            if i == '      <email/>\n':
                doc_changed = True
                continue
            ndoc += i
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Remove empty email from %s." % p
            shutil.copy(xmlfname, xmlfname + ".remove.emptyemail.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def abstract_to_description(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = ""
        for i in doc:
            if i == '    <abstract>\n':
                ndoc += '  <description>\n'
                doc_changed = True
                continue
            if i == '    </abstract>\n':
                ndoc += '  </description>\n'
                doc_changed = True
                continue
            ndoc += i
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Remove description from %s." % p
            shutil.copy(xmlfname, xmlfname + ".abstract.description.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def remove_about(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = ""
        for i in doc:
            if i == '  <about>\n':
                doc_changed = True
                continue
            if i == '  </about>\n':
                doc_changed = True
                continue
            ndoc += i
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Remove about from %s." % p
            shutil.copy(xmlfname, xmlfname + ".remove.about.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def xref_to_also(packages, path = "./entries"):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        # print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = ""
        xr = re.compile("<xref refid='\S+'/>")
        for i in doc:
            if xr.search(i):
                doc_changed = True
                ndoc += i.replace('xref', 'also')
                continue
            if i == '  </about>\n':
                doc_changed = True
                continue
            ndoc += i
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Convert xref to see in %s." % p
            shutil.copy(xmlfname, xmlfname + ".xref.see.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            # sys.exit(0) # For testing
            
def fix_author(packages, path = "./entries", verbose=True, testing=False):
    def vprint(s):
        if verbose: print s
    #
    # Build a CSV file of authors to convert later to XML
    #
    afile = open("authors.csv", "a+")
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        vprint(p)
        doc = FromXmlFile(xmlfname)
        doc_changed = False
        #
        # Modifications - USE XML
        #------------------------------------------------------------
        entry = doc.getElementsByTagName('entry')
        authors = doc.getElementsByTagName('author')
        if authors:
            for a in authors:
                vprint(a)
                if a.hasChildNodes() and len(a.childNodes) > 1:
                    doc_changed = True
                    namel = a.getElementsByTagName('name')
                    if namel:
                        name = namel[0].firstChild.nodeValue
                        vprint(name)
                    emaill = a.getElementsByTagName('email')
                    if emaill:
                        email = emaill[0].firstChild.nodeValue
                        user = email.split("@")[0]
                        vprint(email)
                    if namel and emaill:
                        afile.write("%s,%s,%s,%s\n" % (user, name, email, p))
                        a.removeChild(namel[0])
                        a.removeChild(emaill[0])
                        a.setAttribute('id', user)
                    elif namel:
                        if name == "unknown":
                            afile.write("%s,,,%s\n" % (name, p))
                            a.removeChild(namel[0])
                            a.setAttribute('id', 'unknown')
                        else:
                            user = name.split()
                            user = user[len(user)-1].lower()
                            afile.write("%s,%s,,%s\n" % (user, name, p))
                            a.removeChild(namel[0])
                            a.setAttribute('id', user)
                    elif emaill:
                        print "TODO: Email only"
                        sys.exit(1)
#            ctan = distribution[0].getElementsByTagName('ctan')
#            tetex = distribution[0].getElementsByTagName('tetex')
#            texlive = distribution[0].getElementsByTagName('texlive')
#            entry[0].removeChild(distribution[0])
#            if ctan:
#                cpath = ctan[0].firstChild.nodeValue
#                if cpath[0] <> '/': cpath = '/' + cpath
#                # Create new ctan element with path, add as last element.
#                ctan[0].setAttribute('path', cpath)
#                while len(ctan[0].childNodes):
#                    ctan[0].removeChild(ctan[0].firstChild)
#                nctan = ctan[0].cloneNode(True)
#                entry[0].appendChild(nctan)
#            if tetex:
#                # Simply move it up one level
#                ntetex = tetex[0].cloneNode(True)
#                entry[0].appendChild(ntetex)
#            if texlive:
#                # Get value, create new element with location, add as last.
#                location = texlive[0].firstChild.nodeValue
#                texlive[0].setAttribute('location', location)
#                while len(texlive[0].childNodes):
#                    texlive[0].removeChild(texlive[0].firstChild)
#                ntexlive = texlive[0].cloneNode(True)
#                entry[0].appendChild(ntexlive)
#            PrettyPrint(doc)
            #sys.exit(1) # Testing
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Update author for %s." % p
            shutil.copy(xmlfname, xmlfname + ".auth.bak")
            xmlfile = open(xmlfname, "w")
            PrettyPrint(doc)
            PrettyPrint(doc, xmlfile)
            xmlfile.close()
            if testing: sys.exit(0)
            
def remove_end_auth(packages, path = "./entries", verbose=True, testing=False):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        if verbose: print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = ""
        for i in doc:
            if '<author ' in i and '/>' not in i:
                doc_changed = True
                ndoc += string.replace(i,'>','/>')
                continue
            if i == '  </author>\n':
                doc_changed = True
                continue
            ndoc += i
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Remove author end from %s." % p
            shutil.copy(xmlfname, xmlfname + ".remove.authend.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            if verbose: os.system("cat " + xmlfname)
            if testing: sys.exit(0)
            
def auth_to_ref(packages, path = "./entries", verbose=False, testing=False):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        if verbose: print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = ""
        for i in doc:
            if '<author ' in i:
                doc_changed = True
                ndoc += string.replace(i,'author ','authorref ')
                continue
            ndoc += i
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Author to AuthorRef %s." % p
            shutil.copy(xmlfname, xmlfname + ".remove.authref.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            if verbose: os.system("cat " + xmlfname)
            if testing: sys.exit(0)
            
def orig_update_authid(packages, path = "./entries", verbose=False, testing=False):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        if verbose: print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = doc
        map = {'A.Kielhorn': 'kielhorn',
               'B.Jackowski': 'jackowski',
               'Bausa': 'bausa',
               'Beat.Steiner': 'steiner',
               'Bil.Kleb': 'kleb',
               'Bjoern.Pedersen': 'pedersen',
               'C.Walshaw': 'walshaw',
               'Carl-Gustav.Werner': 'werner',
               'Carsten.Schurig': 'schurig',
               'Christophe.Geuzaine': 'geuzaine',
               'Daniel.Flipo': 'flipo',
               'David.Kastrup': 'kastrup',
               'Denis.Megevand': 'megevand',
               'Denis.Roegel': 'roegel',
               'E.H.M.Frambach': 'frambach',
               'Emmanuel.Beffara': 'beffara',
               'Eric.Domenjoud': 'domenjoud',
               'Fabrice.Popineau': 'popineau',
               'Frank.Mittelbach': 'mittelbach',
               'Frederic.Goualard': 'goualard',
               'Georg.Verweyen': 'verweyen',
               'George': 'george',
               'Helge.Baumann': 'baumann',
               'J.Goldberg': 'goldberg',
               'J.Nowacki': 'nowacki',
               'J.Smart': 'smart',
               'JLBraams': 'jlbraams',
               'James.Ashton': 'ashton',
               'Jan.Busa': 'busa',
               'Jean-Pierre.Drucbert': 'drucbert',
               'JimHurt': 'jimhurt',
               'Jochen': 'jochen',
               'Johannes.Sixt': 'sixt',
               'John.Lavagnino': 'lavagnino',
               'Juergen.Vollmer': 'vollmer',
               'KNAPPEN': 'knappen',
               'Lackas': 'lackas',
               'Lapko.O': 'Lapko',
               'M.Heldoorn': 'heldoorn',
               'M.Marvan': 'marvan',
               'M.Olko': 'olko',
               'M.Piff': 'piff',
               'M.Potse': 'potse',
               'M.Rycko': 'rycko',
               'MC1194': 'mc1194',
               'MMuecke': 'mmuecke',
               'Maibaum': 'maibaum',
               'Mark.Trettin': 'trettin',
               'Markus.Kohm': 'kohm',
               'Martin.Hairer': 'hairer',
               'Martin.Schroeder': 'schroeder',
               'Martin.Ward': 'ward',
               'N.Poppelier': 'poppelier',
               'O.Motygin': 'motygin',
               'Oyvind.Breivik': 'breivik',
               'P.T.H.Tutelaers': 'tutelaers',
               'P.Taylor': 'taylor',
               'Pascal.Kockaert': 'kockaert',
               'Peter.Vanroose': 'vanroose',
               'Peter.Williams': 'williams',
               'Peter.Wilson': 'wilson',
               'Petr.Novak': 'novak',
               'Pierre.Basso': 'basso',
               'Piet.van.Oostrum': 'oostrum',
               'R.Maloney': 'maloney',
               'Ralf.Goertz': 'goertz',
               'Robin.Fairbairns': 'fairbairns',
               'Rolf.Niepraschk': 'niepraschk',
               'S.Pepping': 'pepping',
               'Scherer': 'scherer',
               'Sebastian_Kirsch': 'kirsch',
               'Serguei.Dachian': 'dachian',
               'Stephan.Lehmke': 'lehmke',
               'TeXmacs': 'texmacs',
               'Tech-Support': 'techsupport',
               'Tom': 'tom',
               'W.Hennings': 'hennings',
               'W.Mueller': 'mueller',
               'Willadt': 'willadt',
               'Yannis.Haralambous': 'haralambous',
               'Yvon.Henel': 'henel',
               'a7621gac': 'lemberg',
               'a7971428': 'lemberg',
               'a8603365': 'franz',
               'adam': 'lewenberg',
               'asnd': 'arseneau',
               'authors': 'unknown',
               'axel.reichert': 'reichert',
               }
        for a in map:
            orig = "<authorref id='" + a + "'"
            repl = "<authorref id='" + map[a] + "'"
            #print orig
            #if orig in "  <authorref id='A.Kielhorn'/>": print "YES"
            #print "".join(doc)
            if orig in "".join(doc):
                doc_changed = True
                ndoc = ""
                for l in doc:
                    ndoc += string.replace(l, orig, repl)
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Update AuthorRef ID %s." % p
            shutil.copy(xmlfname, xmlfname + ".replace.authrefid.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            if verbose: os.system("cat " + xmlfname)
            if testing: sys.exit(0)
            
def update_authid(packages, path = "./entries", verbose=True, testing=True):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        if verbose: print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = doc
        map = {'walter.schmidt': 'schmidt',
               'w.a.schmidt': 'schmidt',
               'w-a-schmidt': 'schmidt',
               'was': 'schmidt',
               }
        for a in map:
            orig = "<authorref id='auth:" + a + "'"
            repl = "<authorref id='auth:" + map[a] + "'"
            if orig in "".join(doc):
                doc_changed = True
                ndoc = ""
                for l in doc:
                    ndoc += string.replace(l, orig, repl)
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Update AuthorRef ID %s." % p
            shutil.copy(xmlfname, xmlfname + ".replace.authrefid.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            if verbose: os.system("cat " + xmlfname)
            if testing: sys.exit(0)
            
def add_auth(packages, path = "./entries", verbose=False, testing=False):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        if verbose: print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = ""
        for i in doc:
            if '<authorref id=' in i:
                doc_changed = True
                ndoc += string.replace(i,"id='", "id='auth:")
                continue
            ndoc += i
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Update AuthorRef ID %s." % p
            shutil.copy(xmlfname, xmlfname + ".replace.authrefAUTH.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            if verbose: os.system("cat " + xmlfname)
            if testing: sys.exit(0)
            
def new_doctype(packages, path = "./entries", verbose=False, testing=False):
    progress = ""
    for p in packages:
        #
        # Progress meter!
        #
        if p[0] <> progress:
            print p[0],
            sys.stdout.flush()
            progress = p[0]
        xmlfname = path + "/" + p[0] + "/" + p + ".xml"
        if verbose: print p
        doc = open(xmlfname).readlines()
        doc_changed = False
        #
        # Modifications - USE STRINGS
        #------------------------------------------------------------
        ndoc = ""
        for i in doc:
            if '<!DOCTYPE entry' in i:
                doc_changed = True
                ndoc += string.replace(i,"entries/catalogue.dtd",
                                       "catalogue.dtd")
                continue
            ndoc += i
        # continue # Testing
        #------------------------------------------------------------
        # Write file out
        #
        if doc_changed:
            print "Update AuthorRef ID %s." % p
            shutil.copy(xmlfname, xmlfname + ".replace.authrefAUTH.bak")
            xmlfile = open(xmlfname, "w")
            xmlfile.write(ndoc)
            xmlfile.close()
            if verbose: os.system("cat " + xmlfname)
            if testing: sys.exit(0)
            
###################################################################
# MAIN PROGRAM
#
def _usage():
    """Print documentation."""
    print __doc__

def _main():
    """Process command line options then perform the action."""
    packages = list_packages()
    print "The catalogue contains %s entries." % commify(len(packages))
    # packages = ['a2ac', 'a0poster', 'a4', 'a2ping']
    # packages=['akletter']
#    fix_documentation(packages)
#    fix_version(packages)
#    fix_home(packages)
#    fix_distr(packages)
#    remove_description(packages)
#    abstract_to_description(packages)
#    remove_about(packages)
#    xref_to_also(packages)
#    remove_empty_email(packages)
#    fix_author(packages)
#    remove_end_auth(packages)
#    auth_to_ref(packages)
#    update_authid(packages, verbose=False, testing=False)
#    add_auth(packages)
    new_doctype(packages, verbose=False, testing=False)
    
########################################################################
#
# INTERACTIVE
#
# Test to see if we are running as a main program, rather than being
# imported as a library. If it's a main program, then let's do some
# work. Otherwise let's quielty proceed.
#
if __name__ == "__main__":
    _main()
