/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef TXLIST_H
#define TXLIST_H


#include "rtlist.h"
#include "transaction.h"
#include "refpointer.h"


class TransactionListView2;
class TransactionListView2Item;
class KBanking;


class TransactionListView2Item: public RichTextListViewItem {
private:
  RefPointer<Transaction> _transaction;
  void _populate();

protected:
  virtual void setupColumn(int col);
  void setup();

public:
  TransactionListView2Item(TransactionListView2 *parent,
                           RefPointer<Transaction> t);
  TransactionListView2Item(TransactionListView2 *parent,
                           TransactionListView2Item *after,
                           RefPointer<Transaction> t);
  TransactionListView2Item(const TransactionListView2Item &item);

  ~TransactionListView2Item();

  void redrawItem();

  RefPointer<Transaction> getTransaction();

  virtual QString key(int column, bool ascending) const;

};





class TransactionListView2: public RichTextListView {
private:
  KBanking *_app;
  bool _shortList;
  uint32_t _lastSessionId;

  void _init();

public:
  TransactionListView2(KBanking *app,
                       bool shortList,
                       QWidget *parent=0, const char *name=0);
  TransactionListView2(KBanking *app, QWidget *parent=0, const char *name=0);
  TransactionListView2(QWidget *parent=0, const char *name=0);

  virtual ~TransactionListView2();

  KBanking *app();
  void setApp(KBanking *app);

  void addTransaction(RefPointer<Transaction> t);
  void addTransactions(const std::list<RefPointer<Transaction> > &ts);

  RefPointer<Transaction> getCurrentTransaction();
  std::list<RefPointer<Transaction> > getSelectedTransactions();

  void redrawSelected();

  bool isShortList() const;
  void setShortList(bool b);

  uint32_t getLastSessionId() const;
  void setLastSessionId(uint32_t sess);
};


#endif

