/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Apr 05 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef AQHBCIBANK_XASTORAGE_P_H
#define AQHBCIBANK_XASTORAGE_P_H

#include "xastorage.h"
#include <gwenhywfar/misc.h>
#include <gwenhywfar/idlist.h>


typedef struct AH_STORAGE_DAY AH_STORAGE_DAY;
typedef struct AH_STORAGE_HANDLE AH_STORAGE_HANDLE;
#define TMP_DUMMY
GWEN_LIST_FUNCTION_LIB_DEFS(AH_STORAGE_DAY, AH_Storage_Day, TMP_DUMMY);
GWEN_LIST_FUNCTION_LIB_DEFS(AH_STORAGE_HANDLE, AH_StorageHandle, TMP_DUMMY);


struct AH_STORAGE_HANDLE {
  GWEN_LIST_ELEMENT(AH_STORAGE_HANDLE)
  AH_STORAGE_DAY *day;
  GWEN_DB_NODE *current;
  uint32_t id;
};

AH_STORAGE_HANDLE *AH_StorageHandle_new(AH_STORAGE_DAY *day,
                                        uint32_t id);
void AH_StorageHandle_free(AH_STORAGE_HANDLE *sh);



struct AH_STORAGE_DAY {
  GWEN_LIST_ELEMENT(AH_STORAGE_DAY)
  int year;
  int month;
  int day;
  uint32_t id;
  char *file;
  int readOnly;
  int changed;
  int fixed;
  GWEN_DB_NODE *transactions;
  uint32_t usage;
};



AH_STORAGE_DAY *AH_Storage_Day_new(int year,
                                   int month,
                                   int day,
                                   const char *file,
                                   int readOnly,
                                   GWEN_DB_NODE *transactions);
void AH_Storage_Day_free(AH_STORAGE_DAY *dy);
void AH_Storage_Day_Attach(AH_STORAGE_DAY *dy);

int AH_Storage_Day_GetYear(const AH_STORAGE_DAY *dy);
int AH_Storage_Day_GetMonth(const AH_STORAGE_DAY *dy);
int AH_Storage_Day_GetDay(const AH_STORAGE_DAY *dy);
uint32_t AH_Storage_Day_GetId(const AH_STORAGE_DAY *dy);
const char *AH_Storage_Day_GetFileName(const AH_STORAGE_DAY *dy);
int AH_Storage_Day_GetReadOnly(const AH_STORAGE_DAY *dy);
int AH_Storage_Day_GetChanged(const AH_STORAGE_DAY *dy);
void AH_Storage_Day_SetChanged(AH_STORAGE_DAY *dy, int chg);

GWEN_DB_NODE *AH_Storage_Day_GetTransactions(AH_STORAGE_DAY *dy);
int AH_Storage_Day_AddTransaction(AH_STORAGE_DAY *dy, GWEN_DB_NODE *t);
void AH_Storage_Day_FixDay(AH_STORAGE_DAY *dy);
int AH_Storage_Day_IsDayFixed(const AH_STORAGE_DAY *dy);



struct AH_STORAGE {
  AH_STORAGE_DAY_LIST *days;
  AH_STORAGE_HANDLE_LIST *handles;
  char *path;

  uint32_t lastHandleId;
};


uint32_t AH_Storage__MakeId(int year,
                                    int month,
                                    int day);

AH_STORAGE_DAY *AH_Storage_FindDay(const AH_STORAGE *st, uint32_t id);

AH_STORAGE_HANDLE *AH_Storage_FindHandle(AH_STORAGE *st,
                                         uint32_t id);


AH_STORAGE_DAY *AH_Storage_GetDay(AH_STORAGE *st,
                                  int year,
                                  int month,
                                  int day,
                                  int ro);
int AH_Storage_SaveDay(AH_STORAGE *st, AH_STORAGE_DAY *dy);


GWEN_IDLIST *AH_Storage_BuildIndex(AH_STORAGE *st);




#endif /* AQHBCIBANK_XASTORAGE_P_H */






