/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: edittransaction.cpp 406 2007-04-30 18:13:29Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "loadcellphone.h"
#include "kbanking.h"
#include "refpointer.h"

#include <qcombobox.h>
#include <qlineedit.h>
#include <qregexp.h>
#include <qvalidator.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qpushbutton.h>

#include <list>
#include <string>

#include <gwenhywfar/debug.h>
#include <gwenhywfar/text.h>

#include <aqbanking/jobloadcellphone.h>


#ifdef WIN32
# define strcasecmp stricmp
#endif

LoadCellPhone::LoadCellPhone(KBanking *app,
			     QWidget* parent,
			     const char* name,
			     bool modal,
			     WFlags fl)
:LoadCellPhoneUi(parent, name, modal, fl)
,_app(app)
,_productList(NULL)
,_account(NULL)
,_product(NULL)
,_value(NULL)
{
  int found;
  std::list<Account*>::const_iterator ait;
  int i;
  QString s, cs;

  QLayout *lo=layout();
  if (lo) {
    QSize csi;
    QSize nsi;

    csi=size();
    nsi=lo->sizeHint();
    if (csi.width()>nsi.width())
      nsi.setWidth(csi.width());
    if (csi.height()>nsi.height())
      nsi.setWidth(csi.height());
    resize(nsi);
  }

  // setup account combo
  found=0;
  i=0;
  localAccountCombo->insertItem(_tr("Select Account"), -1);
  for (ait=app->getAppAccounts().begin();
       ait!=app->getAppAccounts().end();
       ait++) {
    i++;
    cs="";

    s=QString::fromUtf8((*ait)->getBankName().c_str());
    if (s.isEmpty())
      s=QString::fromUtf8((*ait)->getBankCode().c_str());
    cs+=s;
    cs+=" / ";
    s=QString::fromUtf8((*ait)->getAccountNumber().c_str());
    cs+=s;
    cs+=" - ";
    s=QString::fromUtf8((*ait)->getAccountName().c_str());
    cs+=s;
    cs+=" (";
    cs+=QString::number((*ait)->getBankingId());
    cs+=")";

    localAccountCombo->insertItem(cs, -1);
  } // for

  // select currency
  _setComboTextNoDup(currencyCombo, "EUR");

  // connect buttons
  QObject::connect(localAccountCombo, SIGNAL(activated(int)),
                   this, SLOT(slotAccountChanged(int)));

  QTimer::singleShot(0, this, SLOT(adjustSize()));
}



LoadCellPhone::~LoadCellPhone(){
  AB_CellPhoneProduct_List_free(_productList);
  AB_CellPhoneProduct_free(_product);
  AB_Value_free(_value);
}



void LoadCellPhone::_setComboTextNoDup(QComboBox *qb, const QString &s){
  int i;

  for (i=0; i<qb->count(); i++) {
    if (qb->text(i)==s)
      return;
  }
  qb->insertItem(s, -1);
}



void LoadCellPhone::_setComboTextIfPossible(QComboBox *qb,
					    const QString &s){
  int i;

  for (i=0; i<qb->count(); i++) {
    if (qb->text(i)==s) {
      qb->setCurrentItem(i);
      break;
    }
  }
}



void LoadCellPhone::accept(){
  int pos;
  QString qs;
  std::list<Account*>::const_iterator ait;
  int i;
  Account *a;
  AB_VALUE *value;
  QRegExp valueRx(QString("^[0-9]{1,12}.[0-9]{1,2}$"));
  QRegExpValidator qv(valueRx, this);
  QRegExp numberRx(QString("^[0-9]{1,16}$"));
  QRegExpValidator qn(numberRx, this);
  AB_CELLPHONE_PRODUCT *cp;

  /* check number */
  qs=KBanking::sanitizedNumber(numberEdit->text());
  if (qs.isEmpty()) {
    QMessageBox::critical(this,
			  _tr("Incomplete Input"),
			  _tr("<qt>"
			      "<p>"
			      "Please fill out all fields."
			      "</p>"
			      "</qt>"
			     ),
			  _tr("Dismiss"), QString::null);
    return;
  }

  if (qs!=KBanking::sanitizedNumber(number2Edit->text())) {
    QMessageBox::critical(this,
			  _tr("Bad Input"),
			  _tr("<qt>"
			      "<p>"
                              "Please enter the same number in both fields."
			      "</p>"
			      "</qt>"
			     ),
			  _tr("Dismiss"), QString::null);
    return;
  }

  pos=0;
  if (qn.validate(qs, pos)!=
      QValidator::Acceptable) {
    QMessageBox::critical(this,
			  _tr("Bad Input"),
			  _tr("<qt>"
			      "<p>"
			      "Only digits are allowed for the phone number."
			      "Please correct the number."
			      "</p>"
			      "</qt>"
			     ),
			  _tr("Dismiss"), QString::null);
    return;
  }
  _number=qs;

  /* check value */
  qs=valueEdit->text().stripWhiteSpace();
  if (qs.isEmpty()) {
    QMessageBox::critical(this,
			  _tr("Incomplete Input"),
			  _tr("<qt>"
			      "<p>"
			      "Please fill out all fields."
			      "</p>"
			      "</qt>"
			     ),
			  _tr("Dismiss"), QString::null);
    return;
  }
  pos=0;
  if (qv.validate(qs, pos)!=
      QValidator::Acceptable) {
    QMessageBox::critical(this,
			  _tr("Bad Input"),
			  _tr("<qt>"
			      "<p>"
			      "The amount is invalid."
			      "Please correct it."
			      "</p>"
			      "</qt>"
			     ),
			  _tr("Dismiss"), QString::null);
    return;
  }
  qs+=":";
  qs+=currencyCombo->currentText();
  value=AB_Value_fromString(qs.latin1());
  if (_value)
    AB_Value_free(_value);
  _value=value;

  /* local account */
  if (localAccountCombo->currentItem()==0) {
    QMessageBox::critical(this,
                          _tr("No Source Account"),
                          _tr("<qt>"
                             "<p>"
                             "Please select the source account."
                             "</p>"
                             "</qt>"
                            ),
                          _tr("Dismiss"), QString::null);
    return;
  }

  /* product */
  if (productCombo->currentItem()==0) {
    QMessageBox::critical(this,
			  _tr("Incomplete Input"),
                          _tr("<qt>"
                             "<p>"
			      "Please select the card product."
			      "</p>"
			      "</qt>"
			     ),
			  _tr("Dismiss"), QString::null);
    return;
  }

  assert(_productList);

  i=1;
  cp=AB_CellPhoneProduct_List_First(_productList);
  while(cp) {
    if ((i++)==productCombo->currentItem())
      break;
    cp=AB_CellPhoneProduct_List_Next(cp);
  }
  assert(cp);
  if (_product)
    AB_CellPhoneProduct_free(_product);
  _product=AB_CellPhoneProduct_dup(cp);

  // find account
  i=localAccountCombo->currentItem();
  a=0;
  for (ait=_app->getAppAccounts().begin();
       ait!=_app->getAppAccounts().end();
       ait++) {
    if (!--i) {
      a=*ait;
      break;
    }
  } // for
  assert(a);
  _account=a;

  return QDialog::accept();
}



void LoadCellPhone::reject(){
  return QDialog::reject();
}



void LoadCellPhone::slotAccountChanged(int i){
  std::list<Account*>::const_iterator ait;
  Account *a;
  QString pp;
  QString qs;

  pp=productCombo->currentText();
  productCombo->clear();
  if (_productList) {
    AB_CellPhoneProduct_List_free(_productList);
    _productList=NULL;
  }

  a=0;
  for (ait=_app->getAppAccounts().begin();
       ait!=_app->getAppAccounts().end();
       ait++) {
    if (!--i) {
      a=*ait;
      break;
    }
  } // for
  if (a) {
    AB_ACCOUNT *ba;

    ba=AB_Banking_GetAccount(_app->getCInterface(),
			     a->getBankingId());
    if (ba) {
      AB_JOB *j=0;

      j=AB_JobLoadCellPhone_new(ba);
      if (AB_Job_CheckAvailability(j)==0) {
	const AB_CELLPHONE_PRODUCT_LIST *cl;

	productCombo->insertItem(_tr("Select Prepaid Card Type"), -1);
	cl=AB_JobLoadCellPhone_GetCellPhoneProductList(j);
	if (cl) {
	  AB_CELLPHONE_PRODUCT *cp;

	  _productList=AB_CellPhoneProduct_List_dup(cl);

	  cp=AB_CellPhoneProduct_List_First(_productList);
	  while(cp) {
            QString qs;
	    const char *s;

	    s=AB_CellPhoneProduct_GetProviderName(cp);
	    if (s && *s) {
	      qs+=QString::fromUtf8(s);
	    }
	    s=AB_CellPhoneProduct_GetProductName(cp);
	    if (s && *s) {
	      if (!qs.isEmpty())
		qs+="/";
	      qs+=QString::fromUtf8(s);
	    }
	    productCombo->insertItem(qs, -1);

	    cp=AB_CellPhoneProduct_List_Next(cp);
	  }
	  _setComboTextIfPossible(productCombo, pp);
	}
	else {
	  DBG_ERROR(0, "No products supported");
	  QMessageBox::critical(this,
				_tr("Empty List"),
				_tr("<qt>"
				    "<p>"
				    "Your bank did not report any supported "
				    "prepaid card product."
				    "</p>"
				    "</qt>"
				   ),
				_tr("Dismiss"), QString::null);
	  return;
	}
      }
      else {
	DBG_ERROR(0, "Job not supported with this account");
	QMessageBox::critical(this,
			      _tr("Job not Supported"),
			      _tr("<qt>"
				  "<p>"
				  "This account does not support this job."
				  "</p>"
				  "</qt>"
				 ),
			      _tr("Dismiss"), QString::null);
	return;
      }
    } // if account
  } // if account
}



AB_JOB *LoadCellPhone::createJob(KBanking *app,
				 const QString &title,
				 QWidget* parent,
				 bool modal,
				 WFlags fl) {
  LoadCellPhone w(app, parent, 0, modal, fl);

  if (!title.isEmpty())
    w.setCaption(title);
  if (w.exec()!=QDialog::Accepted)
    return NULL;
  else {
    AB_JOB *j=NULL;
    AB_ACCOUNT *ba;

    ba=AB_Banking_GetAccount(app->getCInterface(),
			     w._account->getBankingId());
    if (ba==NULL) {
      QMessageBox::critical(parent,
			    _tr("Account not Supported"),
			    _tr("<qt>"
				"<p>"
				"This account is not supported by "
				"any backend."
				"</p>"
				"</qt>"
			       ),
			    _tr("Dismiss"), QString::null);
      return NULL;
    }

    j=AB_JobLoadCellPhone_new(ba);
    if (AB_Job_CheckAvailability(j)==0) {
      AB_JobLoadCellPhone_SetCellPhoneProduct(j, w._product);
      AB_JobLoadCellPhone_SetPhoneNumber(j, w._number.latin1());
      AB_JobLoadCellPhone_SetValue(j, w._value);
      return j;
    }
    AB_Job_free(j);
    return NULL;
  }
}



QString LoadCellPhone::_tr(const char * sourceText){
  QString qs;
  int i;

  qs=tr(sourceText);
  i=qs.find('|');
  if (i) {
    qs=qs.mid(i+1);
  }
  return qs;
}






