/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_embeddedobj.hxx"

#include <osl/diagnose.h>

#include "olewrapclient.hxx"
#include "olecomponent.hxx"

// TODO: May be a mutex must be introduced

OleWrapperClientSite::OleWrapperClientSite( OleComponent* pOleComp )
: m_nRefCount( 0 )
, m_pOleComp( pOleComp )
{
	OSL_ENSURE( m_pOleComp, "No ole component is provided!\n" );
}

OleWrapperClientSite::~OleWrapperClientSite()
{
}

STDMETHODIMP OleWrapperClientSite::QueryInterface( REFIID riid , void** ppv )
{
	*ppv=NULL;

	if ( riid == IID_IUnknown )
		*ppv = (IUnknown*)this;

	if ( riid == IID_IOleClientSite )
		*ppv = (IOleClientSite*)this;

	if ( *ppv != NULL )
	{
		((IUnknown*)*ppv)->AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(ULONG) OleWrapperClientSite::AddRef()
{
	return osl_incrementInterlockedCount( &m_nRefCount);
}

STDMETHODIMP_(ULONG) OleWrapperClientSite::Release()
{
	ULONG nReturn = --m_nRefCount;
	if ( m_nRefCount == 0 )
		delete this;

    return nReturn;
}

void OleWrapperClientSite::disconnectOleComponent()
{
	// must not be called from the descructor of OleComponent!!!
	osl::MutexGuard aGuard( m_aMutex );
	m_pOleComp = NULL;
}

STDMETHODIMP OleWrapperClientSite::SaveObject()
{
	OleComponent* pLockComponent = NULL;
	HRESULT hResult = E_FAIL;

	{
		osl::MutexGuard aGuard( m_aMutex );
		if ( m_pOleComp )
		{
			pLockComponent = m_pOleComp;
			pLockComponent->acquire();
		}
	}

	if ( pLockComponent )
	{
		if ( pLockComponent->SaveObject_Impl() )
			hResult = S_OK;

		pLockComponent->release();
	}

	return hResult;
}

STDMETHODIMP OleWrapperClientSite::GetMoniker( DWORD, DWORD, LPMONIKER *ppmk )
{
	*ppmk = NULL;
	return E_NOTIMPL;
}

STDMETHODIMP OleWrapperClientSite::GetContainer( LPOLECONTAINER* ppContainer )
{
	*ppContainer = NULL;
	return E_NOTIMPL;
}

STDMETHODIMP OleWrapperClientSite::ShowObject(void)
{
	return S_OK;
}

STDMETHODIMP OleWrapperClientSite::OnShowWindow( BOOL bShow )
{
	OleComponent* pLockComponent = NULL;

	// TODO/LATER: redirect the notification to the main thread so that SolarMutex can be locked
	{
		osl::MutexGuard aGuard( m_aMutex );
		if ( m_pOleComp )
		{
			pLockComponent = m_pOleComp;
			pLockComponent->acquire();
		}
	}

	if ( pLockComponent )
	{
		pLockComponent->OnShowWindow_Impl( bShow ); // the result is not interesting
		pLockComponent->release();
	}

	return S_OK;
}

STDMETHODIMP OleWrapperClientSite::RequestNewObjectLayout(void)
{
	return E_NOTIMPL;
}

