/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#define UNICODE

#ifdef _MSC_VER
#pragma warning(push,1) // disable warnings within system headers
#endif
#include <windows.h>
#include <msiquery.h>
#ifdef _MSC_VER
#pragma warning(pop)
#endif

#include <string.h>
#include <malloc.h>
#include <stdio.h>

//----------------------------------------------------------
BOOL UnicodeEquals( wchar_t* pStr1, wchar_t* pStr2 )
{
	if ( pStr1 == NULL && pStr2 == NULL )
		return TRUE;
	else if ( pStr1 == NULL || pStr2 == NULL )
		return FALSE;

	while( *pStr1 == *pStr2 && *pStr1 && *pStr2 )
		pStr1++, pStr2++;

	return ( *pStr1 == 0 && *pStr2 == 0 );
}		

//----------------------------------------------------------
BOOL GetMsiProp( MSIHANDLE hMSI, const wchar_t* pPropName, wchar_t** ppValue )
{
    DWORD sz = 0;
   	if ( MsiGetProperty( hMSI, pPropName, L"", &sz ) == ERROR_MORE_DATA )
   	{
       	sz++;
       	DWORD nbytes = sz * sizeof( wchar_t );
       	wchar_t* buff = reinterpret_cast<wchar_t*>( malloc( nbytes ) );
       	ZeroMemory( buff, nbytes );
       	MsiGetProperty( hMSI, pPropName, buff, &sz );
   		*ppValue = buff;

		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------
BOOL MakeInstallForAllUsers( MSIHANDLE hMSI )
{
	BOOL bResult = FALSE;
	wchar_t* pVal = NULL;
	if ( GetMsiProp( hMSI, L"ALLUSERS", &pVal ) && pVal )
	{
		bResult = UnicodeEquals( pVal , L"1" );
		free( pVal );
	}

	return bResult;
}

//----------------------------------------------------------
extern "C" UINT __stdcall PatchActiveXControl( MSIHANDLE hMSI )
{
	// MessageBox(NULL, L"PatchActiveXControl", L"Information", MB_OK | MB_ICONINFORMATION);

	INSTALLSTATE current_state;
	INSTALLSTATE future_state;

	if ( ERROR_SUCCESS == MsiGetFeatureState( hMSI, L"gm_o_Activexcontrol", &current_state, &future_state ) )
	{
		BOOL bInstallForAllUsers = MakeInstallForAllUsers( hMSI );

		if ( future_state == INSTALLSTATE_LOCAL
		  || ( current_state == INSTALLSTATE_LOCAL && future_state == INSTALLSTATE_UNKNOWN ) )
		{
			HKEY hkey = NULL;
			char* aSubKey = "Software\\Classes\\MIME\\DataBase\\Content Type\\application/vnd.sun.xml.base";
	   		if ( ERROR_SUCCESS == RegCreateKeyA(bInstallForAllUsers ? HKEY_LOCAL_MACHINE : HKEY_CURRENT_USER, aSubKey, &hkey) )
			{
	   			RegDeleteValueA( hkey, "CLSID" );
				RegCloseKey( hkey ), hkey = NULL;
			}
		}
	}
	else
	{
		// assert( FALSE );
	}

	return ERROR_SUCCESS;
}


