/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef DBAUI_RTFREADER_HXX
#define DBAUI_RTFREADER_HXX

#ifndef _VECTOR_
#include <vector>
#endif
#ifndef _PARRTF_HXX //autogen
#include <svtools/parrtf.hxx>
#endif
#ifndef DBAUI_DATABASEEXPORT_HXX
#include "DExport.hxx"
#endif
#ifndef _STREAM_HXX 
#include <tools/stream.hxx>
#endif

namespace dbaui
{
	class ORTFReader : public SvRTFParser , public ODatabaseExport
	{
		::std::vector<sal_Int32>	m_vecColor;

		//	void insertValueIntoColumn();
	protected:
		virtual sal_Bool		CreateTable(int nToken);
		virtual void			NextToken( int nToken ); // Basisklasse
        virtual TypeSelectionPageFactory
                                getTypeSelectionPageFactory();

		~ORTFReader();
	public:
		ORTFReader(	SvStream& rIn,
					const SharedConnection& _rxConnection,
					const ::com::sun::star::uno::Reference< ::com::sun::star::util::XNumberFormatter >& _rxNumberF,
					const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rM,
					const TColumnVector* rList = 0,
					const OTypeInfoMap* _pInfoMap = 0);
		// wird f"ur auto. Typ-Erkennung gebraucht
		ORTFReader(	SvStream& rIn,
					sal_Int32 nRows,
					const TPositions &_rColumnPositions,
					const ::com::sun::star::uno::Reference< ::com::sun::star::util::XNumberFormatter >& _rxNumberF,
					const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rM,
					const TColumnVector* rList,
					const OTypeInfoMap* _pInfoMap,
                    sal_Bool _bAutoIncrementEnabled);

		virtual	SvParserState	CallParser();// Basisklasse
		virtual void			release();
		// birgt nur korrekte Daten, wenn der 2. CTOR benutzt wurde
		// ansonsten wird die SbaColumnList ohne "Anderung zur"uckgegeben
	};

	SV_DECL_IMPL_REF( ORTFReader );
}
#endif // DBAUI_RTFREADER_HXX


