/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef DBA_UCPRESULTSET_HXX
#define DBA_UCPRESULTSET_HXX

#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif
#ifndef _UCBHELPER_RESULTSETHELPER_HXX
#include <ucbhelper/resultsethelper.hxx>
#endif
#ifndef _DBA_COREDATAACCESS_DOCUMENTCONTAINER_HXX_
#include "documentcontainer.hxx"
#endif


// @@@ Adjust namespace name.
namespace dbaccess {

class DynamicResultSet : public ::ucbhelper::ResultSetImplHelper
{
  	rtl::Reference< ODocumentContainer > m_xContent;
	com::sun::star::uno::Reference<
		com::sun::star::ucb::XCommandEnvironment > m_xEnv;

private:
	virtual void initStatic();
	virtual void initDynamic();

public:
	DynamicResultSet(
			const com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory >& rxSMgr,
		  	const rtl::Reference< ODocumentContainer >& rxContent,
			const com::sun::star::ucb::OpenCommandArgument2& rCommand,
		  	const com::sun::star::uno::Reference<
				com::sun::star::ucb::XCommandEnvironment >& rxEnv );
};

}

#endif // DBA_UCPRESULTSET_HXX
