/*
 * Copyright (c) 2003-2011
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 */

/*****************************************************************************
 * COPYRIGHT AND PERMISSION NOTICE
 * 
 * Copyright (c) 2001-2003 The Queen in Right of Canada
 * 
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, provided that the above copyright notice(s) and this
 * permission notice appear in all copies of the Software and that both the
 * above copyright notice(s) and this permission notice appear in supporting
 * documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE 
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, 
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 * 
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in this Software without prior written authorization of the
 * copyright holder.
 ***************************************************************************/

/*
 * Assign a user's roles based on his/her Unix group membership.
 */

#ifndef lint
static const char copyright[] =
"Copyright (c) 2003-2011\n\
Distributed Systems Software.  All rights reserved.";
static const char revid[] =
  "$Id: local_unix_roles.c 2528 2011-09-23 21:54:05Z brachman $";
#endif

#include "dacs.h"

static const char *log_module_name = "local_unix_roles";

/*
 * Return 0 if no error occurs, -1 otherwise.
 * An empty string is returned if there are no roles.
 */
int
local_unix_roles(char *username, char **role_str)
{

  if (username == NULL) {
	log_msg((LOG_ERROR_LEVEL, "username argument is missing"));
	return(-1);
  }

  if (get_unix_roles(username, role_str) == -1 || *role_str == NULL) {
	log_msg((LOG_ERROR_LEVEL, "Can't get Unix roles for \"%s\"", username));
	return(-1);
  }

  return(0);
}

#ifdef PROG
int
main(int argc, char **argv)
{
  int i;
  char *errmsg, *jurisdiction, *role_str, *username;
  Kwv *kwv;

  errmsg = "Internal error";

  if (dacs_init(DACS_LOCAL_SERVICE, &argc, &argv, &kwv, &errmsg) == -1) {
  fail:
	emit_roles_reply_failed(stdout, errmsg);
	if (errmsg != NULL)
	  log_msg((LOG_ERROR_LEVEL, "%s", errmsg));

	exit(1);
  }

  if (argc > 1) {
	errmsg = "Usage: unrecognized parameter";
	goto fail;
  }

  username = jurisdiction = NULL;
  for (i = 0; i < kwv->nused; i++) {
	if (streq(kwv->pairs[i]->name, "DACS_USERNAME") && username == NULL)
	  username = kwv->pairs[i]->val;
	else if (streq(kwv->pairs[i]->name, "DACS_JURISDICTION")
			 && jurisdiction == NULL)
	  jurisdiction = kwv->pairs[i]->val;
	else if (streq(kwv->pairs[i]->name, "DACS_VERSION"))
	  ;
	else
	  log_msg((LOG_TRACE_LEVEL, "Parameter: '%s'", kwv->pairs[i]->name));
  }

  if (local_unix_roles(username, &role_str) == -1) {
	errmsg = "Could not get roles";
	goto fail;
  }

  log_msg((LOG_TRACE_LEVEL, "Returning role string: \"%s\"", role_str));

  emit_roles_reply_ok(stdout, role_str);

  exit(0);
}
#endif
