DACSTOKEN(1)                 DACS Commands Manual                 DACSTOKEN(1)



[1mNAME[0m
       dacstoken - administer hash-based one-time passwords

[1mSYNOPSIS[0m
       [1mdacstoken [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-all[22m] [[1m-base [4m[22mnum[24m] [[1m-counter [4m[22mnum[24m]
                 [[1m-digits [4m[22mnum[24m]
                 [[1m-disable [22m| [1m-enable[22m] [[1m-hotp-window [4m[22mnum[24m] [[1m-inkeys [4m[22mitem_type[24m]
                 [[[1m-key [4m[22mkeyval[24m] | [[1m-key-file [4m[22mfilename[24m] | [[1m-key-prompt[22m]]
                 [[1m-mode [4m[22motp-mode[24m] [[1m-outkeys [4m[22mitem_type[24m]
                 [[[1m-pin [4m[22mpinval[24m] | [[1m-pin-file [4m[22mfilename[24m] | [[1m-pin-prompt[22m]]
                 [[1m-pin-constraints [4m[22mstr[24m]
                 [[1m-rnd[22m] [[1m-seed [4m[22mstr[24m] [[1m-serial [4m[22mstr[24m] [[1m-totp-delta [4m[22mnum[24m]
                 [[1m-totp-drift [4m[22mnwindows[24m] [[1m-totp-hash [4m[22malg[24m]
                 [[1m-totp-timestep [4m[22msecs[24m] [[1m-vfs [4m[22mvfs_uri[24m] [[4mop-spec[24m] [[4musername[24m]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacstoken [22mutility administers [1mDACS [22maccounts associated with
       one-time password (OTP) generating devices ([4mtokens[24m) or software-based
       clients. Using command line options, it also computes OTP values; token
       account parameters can be overridden, but accounts are not even
       required.

       Strong, two-factor authentication can be provided when
       [34m[1mdacs_authenticate[0m[1m[22m[2] is configured to use the
       [34m[1mlocal_token_authenticate[0m[1m[22m[3] authentication module or when [1mdacstoken [22mis
       used as a standalone program to validate passwords. Both the HMAC-based
       one-time password mode (HOTP), based on an event counter and specified
       by [34m[1mRFC 4226[0m[1m[22m[4], and the time-based one-time password mode (TOTP), as
       specified by the [34m[1mlatest IETF Internet-Draft[0m[1m[22m[5] proposal, are supported.
       [34m[1mAdditional operational modes[0m[1m[22m[6] called OCRA ([4mOATH[24m [4mChallenge-Response[0m
       [4mAlgorithms[24m), described in an IETF Internet-Draft, are not yet fully
       supported.

           [1mNote[0m
           This version of [1mdacstoken [22mincorporates many changes that are not
           backward compatible with release 1.4.24a and earlier. Some command
           line flags function differently, and the format of the account file
           has changed. If you have used this command in earlier releases,
           please make a backup copy of your token account file and review
           this manual page carefully before proceeding (note the [34m[1m-convert[0m
           [34mflag[0m[7] in particular).

           [1mImportant[0m
           No vendor-supplied software is required by [1mdacstoken [22mto supply its
           functionality. The devices currently supported do not need any
           registration or configuration interaction with vendors and
           [1mdacstoken [4m[22mdoes[24m [4mnot[24m [4minteract[24m [4mwith[24m [4mvendors'[24m [4mservers[24m [4mor[24m [4muse[24m [4many[0m
           [4mproprietary[24m [4msoftware[24m. Vendor-supplied software may be required to
           perform initialization or configuration for other token devices,
           however, and [1mdacstoken [22mdoes not provide such support for them.

       Each token device generally corresponds to exactly one account that is
       managed by [1mdacstoken[22m, although some vendors produce tokens that can
       support multiple accounts.

       To summarize, this utility:

       +o   creates and administers [1mDACS [22maccounts associated with counter-based
           and time-based one-time passwords

       +o   provides validation and testing functionality

       +o   provides a command line authentication capability


           [1mSecurity[0m
           Only the [1mDACS [22madministrator should be able to successfully run this
           program from the command line. Because [1mDACS [22mkeys and configuration
           files, including the file used to store accounts, must be
           restricted to the administrator, this will normally be the case,
           but a careful administrator will set file permissions to deny
           access to all other users.

           [1mNote[0m
           The [34m[1mdacs_token(8)[0m[1m[22m[8] web service provides users with limited
           self-service functionality to set or reset their account PIN and
           synchronize their token. It also has a demonstration mode to
           simplify testing and evaluation.

   [1mPINs (Account Passwords)[0m
       A [1mdacstoken [22maccount can optionally have a PIN (i.e., a password)
       associated with it. To authenticate against such an account, a user
       must provide the one-time password produced by the token [4mand[24m the PIN.
       The [34m[1mTOKEN_REQUIRES_PIN[0m[1m[22m[9] configuration directive determines whether a
       PIN must be provided when creating or importing an account; it does not
       apply in conjunction with the [1m-delpin [22mflag, since only an administrator
       should be able to perform that function.

       A hash of the PIN is stored in the account record rather than the PIN
       itself. The same method used by [34m[1mdacspasswd(1)[0m[1m[22m[10] and
       [34m[1mdacs_passwd(8)[0m[1m[22m[11] is applied, and depends on the [34m[1mPASSWORD_DIGEST[0m[1m[22m[12]
       and [34m[1mPASSWORD_SALT_PREFIX[0m[1m[22m[13] directives in effect. If
       [34m[1mPASSWORD_DIGEST[0m[1m[22m[12] is configured, that algorithm is used, otherwise a
       compile-time default (SHA1) is used. If a user forgets the PIN, the old
       one cannot be recovered so it must either be deleted or a new one must
       be set.

       Some token devices have a PIN capability built into them. The user must
       enter a PIN into the device before the device will emit a one-time
       password. This "device PIN" is completely distinct from the account PIN
       that is managed by [1mdacstoken[22m, and this manual is only concerned with
       the [1mdacstoken [22mPIN. The device PIN should always be used when possible;
       the [1mdacstoken [22mPIN is strongly recommended and is required for
       two-factor authentication (unless an additional authentication factor
       is applied in some other way).

       Since only the administrator is allowed to run this command, no
       restrictions are imposed on the length or quality of the PINs that the
       administrator supplies; a warning message will be emitted, however, if
       the password is considered to be weak as determined by the
       [34m[1mPASSWORD_CONSTRAINTS[0m[1m[22m[14] directive.

   [1mOne-Time Passwords[0m
       Both kinds of one-time password device compute a password value by
       employing a secure keyed hash algorithm ([34m[1mRFC 2104[0m[1m[22m[15], [34m[1mFIPS 198[0m[1m[22m[16]).
       In the counter-based method, the device and server share a secret key
       and a counter value which are hashed to yield a numerical value
       displayed in a certain radix with a certain number of digits.
       Successful authentication requires the device and server to compute
       matching passwords. Each time the device produces a password, it
       increments its counter. When the server receives a matching password,
       it increments its counter. Because it is possible for the two counters
       to become unsynchronized, the server's matching algorithm will
       typically allow a client's password to fall within a "window" of
       counter values. The time-based method is similar, the main difference
       being that the current Unix time (as returned by [34m[1mtime(3)[0m[1m[22m[17], for
       instance) is used to establish a "time-step window" that serves as a
       counter value in the computation of the secure hash. Because the
       real-time clocks on the device and server may not be sufficiently
       synchronized, the server's matching algorithm must also allow a
       client's password to fall within some number of time-step windows for
       these devices.

           [1mSecurity[0m
           A token may be assigned a permanent secret key (sometimes called an
           OTP seed) by its manufacturer or the key may be programmable. This
           secret key is used by the token's password generation procedure and
           it is critical that it be kept private. If the token is not
           programmable, the key is obtained from the vendor (for a HOTP
           token, typically by providing the device's serial number and any
           three consecutive passwords). A record of each mapping from serial
           number to secret key should be kept in a secure location.

           If the secret key is programmable, as it is likely to be with a
           software client, it is required to be at least [1m128 [22mbits in length;
           a minimum of [1m160 bits [22mis recommended. The key is represented by a
           16 (or more) character long hexadecimal string. The key should be
           obtained from a cryptographic-quality source of random bits. Some
           clients may be capable of generating a suitable key, but you may
           use [34m[1mdacsexpr(1)[0m[1m[22m[18]:

               % dacsexpr -e "random(string, 20)"
               "bb2504780e8075a49bd88891b228fc7216ac18d9"

           [1mTip[0m
           Tokens can be used for authentication purposes other than computer
           sign on. For example, by providing an account number, PIN, and
           token value, customers can quickly be authenticated over the phone,
           reducing or eliminating the need for expensive and time-consuming
           security questions.

       One-time password devices and applications have the following
       operational parameters. These parameters determine the password
       sequence that is generated. Some operational parameters may be fixed
       (by the relevant standard or due to the implementation), while others
       may be partially or completely configurable by the user. Please refer
       to the references and manufacturers' documentation for details.

       base
           The radix in which passwords are displayed.

       counter
           For HOTP mode only, the current counter value.

       digits
           The number of digits in each one-time password.

       key
           The secret key (OTP seed).

       serial number
           A unique identifier or name for the device.

       time step size
           For TOTP mode only, the width of each time interval, in seconds.
           The same password will be generated within a given interval; i.e.,
           this is the "lifetime" or validity period of each TOTP password.

       In addition to these parameters, [1mdacstoken [22memploys several per-account
       (i.e., per-device) parameters:

       accept-window
           When validating a HOTP password, the maximum number of passwords to
           consider after the expected password.

       drift
           For TOTP mode only, the number of seconds by which to adjust the
           server's clock forward or backward to better synchronize it with
           the device. This is used to compensate for tokens or client
           software whose clocks are not well synchronized with the server's.

       drift-window
           For TOTP mode only, but analogous to the accept-window, the maximum
           number of intervals (each of the time step size) to search forward
           and backward when validating against a given password.

       sync-otps
           For HOTP mode only, the number of consecutive one-time passwords
           required to synchronize the account with the device.

       username
           The name of the [1mDACS [22maccount bound to the device.

       Authentication based on one-time password devices has the following
       advantages:

       +o   Each time a user authenticates, a different password will be
           generated (with high probability); users cannot therefore jot down
           "the password" because the password is always changing; users
           cannot forget their password;

       +o   Once used, a HOTP mode password is immediately "consumed" and is
           unlikely to be used again for a long time; with suitable
           configuration parameters, a TOTP mode password automatically
           "expires" within a relatively short time interval and is unlikely
           to be used again for a long time;

       +o   If no correction for clock drift is required, a TOTP mode account
           can have read-only operation;

       +o   Because the password is unlikely to be an easily-guessed number or
           string, it should be stronger than most user-selected passwords;

       +o   A HOTP token can be the basis of a mutual ("bidirectional")
           authentication method; the server shows the user his token's next
           password to confirm its identity (with both parties advancing their
           counters), then the client shows the server the next password to
           confirm his identity;

       +o   Should a key sniffer be installed on the user's computer, a sniffed
           password does not do an attacker any good unless a
           [34m[1mman-in-the-middle attack[0m[1m[22m[19] is possible; given [4mN[24m consecutive
           passwords it is still very difficult to compute password [4mN[24m [4m+[24m [4m1[0m
           without knowing the secret key;

       +o   It is more difficult for users to share an account (although users
           might sometimes view this as an inconvenience);

       +o   If a [1mdacstoken [22mPIN is assigned to an account and an attacker
           obtains the account's token, it is still difficult for the attacker
           to authenticate without knowing the PIN;

       +o   A quick and immediately effective way to disable an account is by
           simply seizing a hardware token (e.g., if an employee is fired),
           although an account can be disabled by this program or using the
           [34m[1mrevocation list[0m[1m[22m[20];

       +o   In the case of a software client that runs on a mobile device, such
           as a phone or PDA, users are already carrying the device with them;
           free clients are available, so there may be no additional cost
           (note that mobile devices may not offer the same tamper-resistance,
           durability, key secrecy, clock accuracy, etc. of a hardware token).


       One-time password devices have the following potential disadvantages:

       +o   There is a one-time expense for a hardware token (depending on the
           purchase volume, you can expect to pay $10-$100 USD each), and
           there is the possibility of having to replace a lost or broken
           token, or a token's battery (some units have a non-replaceable
           battery, making them disposable after a few years);

       +o   Initial configuration is somewhat more difficult than with other
           authentication methods, and users unfamiliar with the devices will
           have to be instructed on their use;

       +o   Although they are typically quite small (e.g., 5cm x 2cm x 1cm) and
           can be attached to a keychain or lanyard, or kept in a wallet,
           users may wince at having to carry a token around with them;

       +o   Users can forget to have their token with them or lose the token;

       +o   A mobile device (with a software client) is probably a likely
           target for theft, more so than a hardware token (hence the extra
           importance of a PIN for this device);

       +o   Unlike a hardware token where the key is burned into inaccessible,
           tamper-proof memory, the key configured into a software client is
           likely to be readable by its owner, making sharing of the account
           possible;

       +o   Entering a 40 character or longer seed value into a mobile device
           can be frustrating and prone to error;

       +o   Once a TOTP device generates a password, a new password cannot be
           generated until the next time-step window, requiring the user to
           wait 30 (or possibly 60) seconds (e.g., if an entry error is made);

       +o   Some devices are difficult to read in low-light conditions;
           presbyopic users and those with impaired vision may have difficulty
           reading the display.


   [1mAccounts[0m
       The accounts managed by [1mdacstoken [22mare completely separate from the
       accounts used by [34m[1mlocal_passwd_authenticate[0m[1m[22m[21] or any other [1mDACS[0m
       authentication module.

       Accounts for HOTP and TOTP devices may either be combined or kept
       separate. If the virtual filestore item type auth_hotp_token is
       defined, it is only used for accounts associated with HOTP tokens.
       Similarly, if the virtual filestore item type auth_totp_token is
       defined, it is only used for accounts associated with TOTP tokens. If
       either item type is not defined, accounts are accessed through [1mDACS's[0m
       virtual filestore using item type auth_token. It is assumed that file
       permissions on the account databases are such that all access is
       limited to the administrator and [1mlocal_token_authenticate[22m.

       If accounts for the two device types are [4mcombined[24m, because each
       username for an authentication method must be unique, if an individual
       has both types of token they must be assigned different usernames. So,
       for example, if Auggie has one HOTP token and one TOTP token, the
       former might correspond to the username auggie-hotp and the latter to
       auggie-totp; the sign-on form might include a device-mode input which
       would allow Auggie to simply type "auggie" in the username field and
       JavaScript to automatically append the appropriate suffix based on the
       select device mode. An obvious disadvantage of this configuration is
       that it results in two different [1mDACS [22midentities for the same
       individual; this would have to be remembered if an access control rule
       needed to identify Auggie explicitly. If both tokens should map to the
       same [1mDACS [22midentity, the Auth clause could strip the suffix off after
       successful authentication, but the administrator would then need to
       beware of the case of two different Auggies, each using a different
       device type.

       Configuring both the auth_hotp_token and auth_totp_token item types (or
       just one of them and auth_token) keeps the accounts separate and allows
       the same username to be used for both types of devices. Auggie could
       therefore have an account record with the same username for both device
       types. This approach requires the device mode to be specified when an
       operation is requested so that the correct item type can be used; this
       means that users must know which type of device they are using (perhaps
       by afixing a label to it). Refer to important details regarding [34m[1mDACS[0m
       [34midentities[0m[22].

       The [1m-vfs [22mis used to configure or reconfigure the auth_token item type.

       Only keys that meet the minimum key length requirement ([1m16 [22mbytes) may
       be stored with account information (e.g., with [1m-set [22mor [1m-import[22m). In
       other contexts, the requirement is not enforced.

       The secret key is encrypted by [1mdacstoken [22mwhen it is written to the
       account file. The virtual filestore item type auth_token_keys
       identifies the encryption keys for [1mdacstoken [22mto use; the [1m-inkeys [22mand
       [1m-outkeys [22mflags specify alternatives (see [34m[1mdacskey(1)[0m[1m[22m[23]). If the
       encryption keys are lost, the secret keys are practically
       unrecoverable.

           [1mImportant[0m
           If an attacker discovers a secret key, generating usable passwords
           without possessing the token will not be difficult. For at least
           some hardware tokens, the key is burned in to the device and cannot
           be changed; in this case, if the key is leaked the device should be
           destroyed. If a token is lost, the corresponding account should be
           disabled. In the event an attacker finds a lost token or discovers
           a secret key, having a strong PIN associated with the account will
           make it difficult for the attacker to gain access.

           [1mImportant[0m
           +o   This authentication method has been tested against the
               following OTP products:

               +o   [34m[1mAuthenex A-Key(R) 3600[0m[1m[22m[24] one-time password (HOTP)
                   hardware token;

               +o   [34m[1mFeitian Technologies[0m[1m[22m[25] OTP C100 and OTP C200 one-time
                   password hardware tokens, provided by [34m[1mHyperSecu Information[0m
                   [1m[34mSystems[0m[1m[22m[26]; and

               +o   [34m[1mOATH Token[0m[1m[22m[27] software application by Archie Cobbs, which
                   implements both HOTP and TOTP on the [34m[1miPod Touch, iPhone,[0m
                   [1m[34mand iPad[0m[1m[22m[28].

               +o   Feitian Technologies [34m[1miOATH Lite[0m[1m[22m[29] HOTP software
                   application for the iPod Touch, iPhone, and iPad.
                   Other manufacturers interested in having their products
                   supported by [1mDACS [22mare welcome to contact Dss.

               +o    [34m[1mPhoto[0m[1m[22m[30]: Feitian OTP C200, iPod Touch with the OATH
                   Token app, Authenex A-Key(R) 3600 (clockwise from top left)

               +o   Although this implementation should work with similar,
                   conformant products, only these products are officially
                   supported by [1mDACS[22m.

               +o   Hardware tokens can be purchased directly from the vendors.

               +o   Any problems with using tokens to authenticate through [1mDACS[0m
                   are not the responsibility of the token vendor.

   [1mImporting and Exporting OTP Accounts[0m
       Descriptions of accounts and their tokens can be loaded or dumped
       (refer to the [1m-import [22mand [1m-export [22mflags). This simplifies bulk
       provisioning, backup, and portability. The account information is
       written in a simple, application-specific (almost) XML format.

       The format understood by [1mdacstoken [22mconsists of a root element
       ("otp_tokens"), followed by zero or more "otp_token" elements, one per
       line, each with required and optional attributes (described below). The
       XML declaration must be omitted. Leading whitespace and blank lines are
       ignored, as are single line XML comments. Additionally, lines having a
       "#" as the first non-whitespace character are ignored. Optional
       attributes that are not present are assigned default values. The
       default digest algorithm is SHA1. Short attribute names are used to
       save space. Unrecognized attributes, and attributes irrelevant to the
       device mode, are ignored. Single or double quote characters (or both)
       within XML attribute values must be replaced by the corresponding
       entity reference ("&apos;" and "&quot;", respectively), as must the "<"
       (less than) and "&" (ampersand) characters. A ">" (greater than)
       character may optionally be replaced by a "&gt;" sequence, but no other
       entity references are recognized.

       Recognized attributes are:

       +o   b:
             [4mbase[0m
             -- radix for OTP value
             [Optional:
             [1m10 [22m(default),
             [1m16[22m, or [1m32[22m]

       +o   c:
             [4mcounter[0m
             -- current counter value for HOTP, in hex if preceded
             by "0x" (or "0X"), decimal otherwise
             [Optional:
             default is [1m0[22m]

       +o   d:
             [4mOTP[24m [4mdevice[24m [4mmode[0m
             -- "c" (for HOTP)
             or "t" (for TOTP)
             [Required]

       +o   dn:
             [4mdigest-name[0m
             -- one of the Secure Hash Algorithms
             [Optional:
             SHA1 (default),
             SHA224, SHA256,
             SHA384, SHA512]

       +o   dr:
             [4mclock-drift[0m
             -- clock adjustment, in seconds, for TOTP
             [Optional]

       +o   ek:
             [4mencrypted-key[0m
             -- encrypted secret key, base-64 encoded
             [Required:
             OTP account records only]

       +o   en:
             [4menabled-status[0m
             -- [1m1 [22mfor enabled,
             [1m0 [22mfor disabled
             [Required]

       +o   k:
             [4mplaintext-key[0m
             -- unencrypted secret key
             [Required]

       +o   lu:
             [4mlast-update[0m
             -- Unix time of last record update
             [Optional: default is current time]

       +o   nd:
             [4mndigits[0m
             -- number of digits for OTP value
             [Optional:
             default is [1m6 [22mfor HOTP,
             [1m8 [22mfor TOTP]

       +o   p:
             [4mplaintext-PIN[0m
             -- plaintext PIN value for the account
             [Required:
             unless ph is present,
             for import only]

       +o   ph:
             [4mhashed-PIN[0m
             -- hashed PIN value for the account
             [Optional:
             generated by [1mdacstoken[0m
             for export and OTP account files only]

       +o   s:
             [4mserial-number[0m
             -- unique identifier string for the device
             [Required]

       +o   ts:
             [4mtime-step[0m
             -- time-step value, in seconds, for TOTP
             [Optional:
             default is [1m30[22m]

       +o   u:
             [4musername[0m
             -- a valid [1mDACS [22musername associated with this account
             [Required]


       The following example describes two accounts that might be created
       using the [1m-import [22mflag:

           <otp_tokens>
           <!-- Staff OTP tokens for DACS authentication -->
           <otp_token u="ietf" d="t" en="1" s="totp-ietf &quot;draft&quot;" k="3132333435363738393031323334353637383930" dn="SHA1" ts="30"/>
           <otp_token u="ipod-c" d="c" en="1" s="ipodc-9C841SD4203" k="19c0a3519a89b4a8034c5b9306db" dn="SHA1" c="0" nd="6" b="10"/>
           </otp_tokens>


           [1mSecurity[0m
           Because imported records include the unencrypted secret keys for
           the OTP devices, the exported file should be kept encrypted (e.g.,
           using [1mopenssl[22m) or at least have appropriate file permissions.

           [1mNote[0m
           A standard format for OTP device provisioning is being developed.
           This format may be understood by a future version of [1mdacstoken[22m, or
           a conversion utility may be written. The standard format is likely
           to be considerably more complex than the [1mDACS [22mformat.

[1mOPTIONS[0m
       In addition to the standard [34m[4mdacsoptions[0m[4m[24m[1], a lengthy list of command
       line flags are recognized. When a [4musername[24m is given, default values
       associated with that account are used, otherwise recommended or
       implementation-specific defaults are used. These default values can
       usually be overridden on the command line. Some flags are only allowed
       with a particular token mode (e.g., [1m-counter[22m, [1m-totp-show[22m) and their
       appearance implies that mode, making the [1m-mode [22mflag unnecessary; other
       flags are mode independent (e.g., [1m-delete[22m, [1m-enable[22m). It is an error to
       use a mutually incompatible flag combination. Flags that are
       meaningless with the selected operation are ignored, although they
       still imply a mode. Hexadecimal values are case insensitive. If a
       counter value is required but unspecified (e.g., when creating an
       account), an initial counter value of zero is used.

       The [4mop-spec[24m specifies the operation to be performed, together with zero
       or more [4mmodifier[24m flags. If [4mop-spec[24m is missing, the [1m-list [22moperation is
       performed. An [4mop-spec[24m is one of the following:


       [1m-auth [4m[22motp-value[0m
           This flag is like [34m[1m-validate[0m[1m[22m[31], except:

           +o   a [4musername[24m is required, from which all parameters are obtained
               (such as the key);

           +o   if the account has a PIN, it must be provided;

           +o   if the account is for a HOTP token, the counter will be updated
               if authentication is successful.
               An exit status of zero indicates successful authentication,
               while any other value means authentication failed.

           [1m-convert [4m[22mfilename[0m
               Load an older format (prior to release 1.4.25) token account
               file from [4mfilename[24m ("-" means to read from stdin), convert it
               to the newer format, and write it to stdout (as by [1m-export[22m).
               This flag is deprecated and this capability will be removed in
               a future release of [1mDACS[22m.

           [1m-create[0m
               Create an account for [4musername[24m, which must not already exist.
               In other respects it works like [34m[1m-set[0m[1m[22m[32]. When creating a new
               account, [1m-serial [22mis required and [1m-key [22mis implied. If no [1m-enable[0m
               flag is provided when creating an account, [1m-disable [22mis implied.
               If no [1m-counter [22mflag is provided, a default of zero is used. If
               one of the PIN flags is present, the given PIN will be assigned
               to the account, otherwise the account will not have a PIN (or
               the existing PIN will not be changed).

           [1m-current[0m
               Display the current moving factor (i.e., the counter value for
               HOTP or the interval value for TOTP) and expected OTP for
               [4musername[24m. For HOTP, the counter is advanced. All parameters are
               taken from the account.

           [1m-delete[0m
               Delete the account for [4musername[24m. The device's secret key and
               other operational parameters will be lost.

           [1m-delpin[0m
               Delete the PIN, if present, on the account for [4musername[24m,
               leaving the account without a PIN.

           [1m-export[0m
               Write information about all accounts, or only one account if
               [4musername[24m is given, to stdout. If a mode is selected, however,
               only accounts having that mode will be written. This
               information may be reloaded using [1m-import [22mor [1m-import-replace[22m.
               The output should be stored in an encrypted form, or at the
               very least have its file permissions set appropriately. For
               example:

                   % dacstoken -uj EXAMPLE -export | openssl enc -aes-256-cbc > dacstoken-exported.enc

               Later, you might do something like:

                   % openssl enc -d -aes-256-cbc < dacstoken-exported.enc | dacstoken -uj EXAMPLE -import -


           [1m-h[0m
           [1m-help[0m
               Display a help message and exit.

           [1m-hotp-show [4m[22mnum[0m
               Display [4mnum[24m consecutive HOTP passwords from a given counter
               value and key. The [1m-counter [22mflag can be used to specify an
               initial counter value. The key can be specified using [1m-key[22m,
               [1m-key-file[22m, or [1m-key-prompt[22m. If a [4musername[24m is provided, the
               initial counter value and key are obtained from the user's HOTP
               account, unless either value is overridden on the command line;
               the account's stored counter value is not modified. This is
               mainly intended for debugging purposes.

           [1m-import [4m[22mfilename[0m
           [1m-import-replace [4m[22mfilename[0m
               Load account and token information from [4mfilename[24m; if [4mfilename[0m
               is "-", stdin is read. If a mode is selected, only accounts
               having that mode will be read. With [1m-import [22mit is an error if
               an imported account already exists, and processing stops;
               [1m-import-replace [22mwill replace an existing account with imported
               data.

           [1m-l[0m
           [1m-list[0m
           [1m-long[0m
               If [4musername[24m is provided, display information about the
               corresponding account; if the [1m-serial [22mflag is given, display
               information about the account with the specified serial number;
               otherwise list all accounts. If the [1m-mode [22mflag is given in any
               of these cases, however, list only those accounts that have the
               operational mode specified. If this flag is repeated, or with
               the [1m-long [22mflag, more detail is displayed: device type, account
               status, device serial number, counter value (for HOTP), clock
               drift value (for TOTP), whether or not the account has a PIN
               (indicated by a "+" or "-" symbol), and the time and date of
               the account's last modification.

           [1m-rename [4m[22mnew-username[0m
               Rename the existing account for [4musername[24m to be [4mnew-username[24m,
               and modify the new account using command line arguments (as
               with [34m[1m-set[0m[1m[22m[32]). As this requires two steps that are not done
               atomically, if an error occurs it is possible for the new
               account to be created and the old account to still exist.

           [1m-set[0m
               The [1m-set [22mflag is used to modify the existing account for
               [4musername[24m based on one or more modifier arguments ([1m-base[22m,
               [1m-counter[22m, [1m-digits[22m, [1m-disable [22mor [1m-enable[22m, [1m-key [22m(or [1m-key-file [22mor
               [1m-key-prompt[22m), [1m-pin [22m(or [1m-pin-file [22mor [1m-pin-prompt[22m), or [1m-serial[22m).
               The mode can also be changed by specifying [1m-mode[22m, but
               mode-specific parameters associated with the account will be
               lost (e.g., the current counter value will be deleted if a HOTP
               account is changed to a TOTP account) and general parameters
               (such as the serial number) will be retained unless overridden
               on the command line.

           [1m-sync [4m[22mpassword-list[0m
               In HOTP mode, this attempts to synchronize the server with the
               token for [4musername[24m. The [4mpassword-list[24m is a comma-separated list
               of three successive passwords produced by the user's token
               (this "auto-synchronize" function is also available through
               [34m[1mlocal_token_authenticate[0m[1m[22m[3]). The given sequence must match the
               computed sequence [4mexactly[24m, given the operational parameters in
               effect; e.g., leading zeroes are significant, as is the display
               radix and number of OTP digits in effect. If synchronization is
               successful, the user should be able to authenticate using the
               next password produced by the device. An exhaustive search
               algorithm using increasing counter values is employed, with a
               compile-time limit on the maximum number of computations. The
               search begins at the server's currently stored counter value,
               unless one is provided using [1m-counter[22m. If unsuccessful, this
               operation could take a long time before it terminates; the user
               must contact an administrator for assistance.

               In TOTP mode, attempt to determine how closely synchronized the
               system clock is with the token's clock and display the result.
               This information can be used to update the user's token record
               to compensate for poorly synchronized clocks, or to adjust
               validation parameters. The token's key and the name of the
               digest algorithm are obtained for the token record belonging to
               [4musername[24m, if it is given; otherwise the key is prompted for and
               the digest algorithm to use is either obtained from the command
               line or the default. Only the first password in [4mpassword-list[0m
               is used. The [1m-totp-timestep[22m, [1m-digits[22m, and [1m-totp-base [22moptions
               are effective during this operation.

           [1m-test[0m
               Perform some self-tests, then exit. A non-zero exit status
               means an error occurred.

           [1m-totp-show [4m[22mnum[0m
               Display a sequence of TOTP passwords using the parameters
               currently in effect: interval size ([1m-totp-timestep[22m), number of
               digits ([1m-digits[22m), and base ([1m-base[22m). The account's stored
               parameters are not modified. This is mainly intended for
               debugging purposes.

               If a [4musername[24m is provided (it must be associated with a TOTP
               device), the key and other stored parameters from the account
               are used unless overridden by command line flags. The sequence
               of passwords for [4mnum[24m intervals before and after the current
               time, together with the password for the current time are
               printed.

               If no [4musername[24m is given, the program prompts for the key (which
               is echoed) and uses command line flags or default values for
               parameters. It then emits the TOTP password for the current
               time each time Return/Enter is pressed. Typing EOF causes
               immediate termination.

           [1m-validate [4m[22motp-value[0m
               If [4motp-value[24m is the next expected one-time password, return an
               exit status of zero to indicate success; any other value
               indicates failure. If [4musername[24m is given, parameters for
               validation, including the key, are obtained from that account
               unless overridden on the command line. The server's state is
               not changed; e.g., a HOTP counter is not advanced. If no
               [4musername[24m is given, the [1m-mode [22mflag must be used and the
               parameters required for that mode must be given, including a
               key. For HOTP mode, a counter value must be provided. For TOTP
               mode, command line parameters are effective during this
               validation.  [1mdacstoken [22mwill test whether [4motp-value[24m validates
               against the parameters in effect.

           The following [4mmodifier[24m flags are understood:


           [1m-all[0m
               With [1m-set [22mand no [4musername[24m, apply the changes to [4mall[24m accounts.
               This can be used to enable or disable all accounts, for
               example. The [1m-inkeys [22mand [1m-outkeys [22mflags are honoured. If an
               error occurs processing stops immediately, in which case only
               some accounts may have been modified.

           [1m-base [4m[22mnum[0m
               Use [4mnum[24m as the base (radix) when displaying an OTP. The value
               of [4mnum[24m is restricted to [1m10 [22m(the default), [1m16[22m, or [1m32[22m.

           [1m-counter [4m[22mnum[0m
               This is the 8-byte HOTP counter value to set, expressed as a
               hex value if preceded by by "0x" (or "0X"), decimal otherwise.
               Leading zeroes may be elided. This implies HOTP mode. For token
               devices, it should not be possible to reset a counter (modulo
               counter overflow) because that will result in the password
               sequence being repeated, assuming that the key is not changed;
               software implementations might not have this restriction,
               however, so beware of the security implications.

           [1m-digits [4m[22mnum[0m
               Use [4mnum[24m digits when displaying an OTP. The value of [4mnum[24m is
               restricted to [1m6[22m, [1m7[22m, [1m8 [22m(the default), or [1m9 [22mwith base [1m10[22m. It is
               restricted to [1m6 [22mwith base [1m32 [22mand is ignored with base [1m16 [22m(hex
               output).

           [1m-disable[0m
               Disable the account for [4musername[24m. The [1mlocal_token_authenticate[0m
               module, and [1m-auth [22mand [1m-validate [22mflags, will not allow the user
               to authenticate until the account has been enabled, although
               other operations may still be performed on the account. If
               [1m-enable [22mis subsequently used, the account will become usable
               for authentication and is restored to its state at the time it
               was disabled. It is not an error to disable an already disabled
               account.

           [1m-enable[0m
               Enable the account for [4musername[24m. The [1mlocal_token_authenticate[0m
               module will allow the user to authenticate. It is not an error
               to enable an already enabled account.

           [1m-hotp-window [4m[22mnum[0m
               If the expected HOTP password does not match the given
               password, try to match up to [4mnum[24m passwords after the expected
               password in the sequence. A value of zero for [4mnum[24m disables this
               search.

           [1m-inkeys [4m[22mitem_type[0m
               For decrypting secret keys, use the store identified by
               [4mitem_type[24m, presumably configured in dacs.conf.

           [1m-key [4m[22mkeyval[0m
               Use [4mkeyval[24m as the secret key, expressed as a hex digit string.

                   [1mSecurity[0m
                   Supplying a key on the command line is not secure because
                   it may be visible to other processes.

           [1m-key-file [4m[22mfilename[0m
               Read the secret key, expressed as a hex digit string, from
               [4mfilename[24m. If [4mfilename[24m is "-", the key is read from stdin.

           [1m-key-prompt[0m
               Prompt for the secret key, expressed as a hex digit string. The
               input is not echoed.

           [1m-mode [4m[22motp-mode[0m
               This specifies (case insensitively) the type of token (the OTP
               device mode) for use with [1m-set[22m, [1m-create[22m, and validation and
               synchronization operations. The [4motp-mode[24m may be either counter
               or hotp for counter mode, or time or totp for time-based mode.
               This flag is required when creating a new account.

           [1m-outkeys [4m[22mitem_type[0m
               For encrypting secret keys, use the store identified by
               [4mitem_type[24m, presumably defined in dacs.conf.

           [1m-pin [4m[22mpinval[0m
               Use [4mpinval[24m as the secret PIN for the account.

                   [1mSecurity[0m
                   Supplying a PIN on the command line is not secure because
                   it may be visible to other processes.

           [1m-pin-constraints [4m[22mstr[0m
               Instead of using [34m[1mPASSWORD_CONSTRAINTS[0m[1m[22m[14], use [4mstr[24m (having the
               same syntax and semantics) to describe the requirements for a
               PIN.

                   [1mNote[0m
                   Requirements for a PIN apply to PINs obtained via a command
                   line flag and to those obtained through importing (using
                   the "p" attribute). Requirements are not "retroactive",
                   however, so changing the requirements does not affect the
                   PINs of existing accounts or importing accounts that were
                   previously exported (having a "ph" attribute).

           [1m-pin-file [4m[22mfilename[0m
               Read the secret PIN from [4mfilename[24m. If [4mfilename[24m is "-", the PIN
               is read from stdin.

           [1m-pin-prompt[0m
               Prompt for the secret PIN. The input is not echoed.

           [1m-rnd[0m
               Reserved for future use.

           [1m-seed [4m[22mstr[0m
               Reserved for future use.

           [1m-serial [4m[22mstr[0m
               The serial number, [4mstr[24m, is a (purportedly) unique identifier
               assigned to the token. This option is used with the [1m-set[22m,
               [1m-create[22m, and [1m-list [22mflags. A serial number identifies a specific
               OTP device and need not be kept secret. The uniqueness property
               is enforced within an item type storage unit; that is, serial
               numbers of all HOTP devices must be unique, serial numbers of
               all TOTP devices must be unique, and if accounts for the two
               device types are combined, all device serial numbers must be
               unique. Any printable string is accepted. If a software client
               is generating passwords, you may use the device's serial
               number, or choose any suitably descriptive string not already
               assigned to a device.

                   [1mNote[0m
                   A jurisdiction that allows (or may eventually allow) both
                   hardware tokens and software-generating client applications
                   should consider adopting a formalized naming scheme for its
                   tokens. For example, the administrator might append "-hw"
                   to the vendor's serial number to form the [1mdacstoken [22mserial
                   number. For software tokens, the administrator might create
                   a [1mdacstoken [22mserial number by appending "-sw" to the
                   vendor's serial number for the device.

           [1m-totp-delta [4m[22mnum[0m
               Adjust the base time by [4mnum[24m intervals (each of the step size
               number of seconds) when computing a TOTP. The [4mnum[24m may be
               negative, zero, or positive. This is used to correct for
               inadequately synchronized clocks.

           [1m-totp-drift [4m[22mnwindows[0m
               For TOTP, use a window size of [4mnwindows[24m (in terms of the
               interval size) for validation. If [4mnwindows[24m is [1m0[22m, the computed
               TOTP value must match the given one exactly. If [4mnwindows[24m is [1m1[22m,
               for example, [1mdacstoken [22mwill try to match the given TOTP value
               in the previous, current, and next intervals. This allows the
               clocks in the system running [1mdacstoken [22m(or
               [1mlocal_token_authenticate[22m) and token producing device to be less
               well synchronized.

                   [1mSecurity[0m
                   Although it compensates for poorly synchronized clocks,
                   increasing the value of [4mnwindows[24m weakens the system by
                   extending the lifetime of a one-time password.

           [1m-totp-hash [4m[22malg[0m
               Use [4malg[24m as the digest algorithm with TOTP. The value of [4malg[24m is
               restricted to (case insensitively) SHA1 (the default), SHA256,
               or SHA512.

           [1m-totp-timestep [4m[22msecs[0m
               Use [4msecs[24m as the interval size when computing a TOTP. It must be
               greater than zero. The default is [1m30 [22mseconds.

                   [1mSecurity[0m
                   Although it compensates for poorly synchronized clocks,
                   increasing the value of [4msecs[24m weakens the system by
                   extending the lifetime of a one-time password.

           [1m-vfs [4m[22mvfs_uri[0m
               Use [4mvfs_uri[24m to override the [34m[1mVFS[0m[1m[22m[33] configuration directive in
               effect. This can be used to configure or reconfigure
               auth_token, auth_hotp_token, or auth_totp_token to specify the
               storage method for the accounts being acted upon.

           Apart from error messages, which are printed to the standard error,
           all output goes to the standard output.

           Ordinarily, a [4mdacsoption[24m will be specified to select the
           jurisdiction on behalf of which accounts are being managed.

[1mEXAMPLES[0m
       These examples assume that the jurisdiction name to use is EXAMPLE and
       its federation domain is example.com.

       To use this authentication method, a [1mDACS [22madministrator might perform
       the following steps for each OTP device assigned to a user:

        1. Obtain a supported token, review how it is used for authentication,
           and select values for the various parameters. Obtain the secret key
           for the device from the vendor; for a programmable device, select a
           suitable random key and program it into the device. The current
           counter values might also be obtained from the vendor, although it
           is likely to initialized to zero; for a programmable device, set
           the counter value to zero. Decide whether a PIN will be required
           (see [34m[1mTOKEN_REQUIRES_PIN[0m[1m[22m[9]). If a software client is being used,
           install the software on the user's device (or have the user do so),
           and configure the software.

        2. Decide where the account information will be stored and, if
           necessary, add a suitable [34m[1mVFS[0m[1m[22m[33] directive to dacs.conf. The
           default (found in site.conf) maintains the account information in a
           file named auth_tokens within each jurisdiction's default private
           area:

               VFS "[auth_token]dacs-kwv-fs:${Conf::FEDERATIONS_ROOT}/\
               ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/auth_tokens"


        3. Generate keys to encrypt the account information (see [34m[1mTokens and[0m
           [1m[34msecret keys[0m[1m[22m[34]) and decide where they will be stored; for example
           (your user ID, group ID, path, jurisdiction name, and federation
           domain may vary):

               % cd /usr/local/dacs/federations_root/example.com/EXAMPLE
               % dacskey -uj EXAMPLE -q auth_token_keys
               % chgrp www auth_token_keys
               % chmod 0640 auth_token_keys

           If necessary, add a suitable [34m[1mVFS[0m[1m[22m[33] directive to dacs.conf; the
           default, which is used above, maintains the account information in
           a file named auth_token_keys within each jurisdiction's default
           private area:

               VFS "[auth_token_keys]dacs-fs:${Conf::FEDERATIONS_ROOT}/\
               ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/auth_token_keys"


        4. If you need users to sign on through [34m[1mdacs_authenticate(8)[0m[1m[22m[2], you
           must configure a suitable Auth clause in dacs.conf, for example:

               <Auth id="token">
                 URL "token"
                 STYLE "pass"
                 CONTROL "sufficient"
               </Auth>


        5. There are several ways that an administrator might proceed,
           depending on how much of the effort can be done by users (e.g.,
           whether they can be trusted, their technical ability), how many
           users there are (a few, or thousands), and the level of security
           required.

            1. prepare a file containing an [34m[1mXML record[0m[1m[22m[35] for each account to
               be created; if PINs are to be used, assign a random PIN to each
               account;

            2. use the [34m[1m-import[0m[1m[22m[36] flag to create the accounts;

            3. give the token device, username, and (if necessary) initial PIN
               to the user (perhaps verifying identity), providing any
               necessary demonstration and instructions;

            4. have the user set or reset the PIN for the account, and ask the
               user to sign on using the token to confirm correct operation.


       To create a disabled account for user bobo for a HOTP device:

           % dacstoken -uj EXAMPLE -mode hotp -serial 37000752 -key-file bobo.key -create bobo

       The secret key for the account (which must not already exist) is read
       from the file bobo.key. New accounts are disabled by default; use
       [1m-enable [22mto create an enabled account.

       Once an account has been created, it can be synchronized with the
       token. To synchronize the HOTP token for user bobo:

           % dacstoken -uj EXAMPLE -sync 433268,894121,615120 bobo

       In this example, the particular token produced the three consecutive
       passwords 433268, 894121, and 615120. Note that the password sequence
       string that follows the [1m-sync [22mflag is a single argument that cannot
       have any embedded spaces. If the key for this token is
       19c0a3519a89b4a8034c5b9306db, the next password generated by this token
       should be 544323 (with counter value [1m13[22m). This can be verified using
       [1m-hotp-show[22m:

           % dacstoken -hotp-show 5 -counter 10 -key 19c0a3519a89b4a8034c5b9306db
           000000000000000a: 433268
           000000000000000b: 894121
           000000000000000c: 615120
           000000000000000d: 544323
           000000000000000e: 002442

       To enable the account for user bobo:

           % dacstoken -uj EXAMPLE -enable -set bobo

       To both set the PIN and enable the account for user bobo:

           % dacstoken -uj EXAMPLE -enable -pin "CzAy" -set bobo

       To list all accounts in detail:

           % dacstoken -uj EXAMPLE -long

       The [1m-list [22mflag is redundant because it is the default operation. The
       [1m-mode[22m, [1m-counter[22m, etc. modifiers have no effect when listing.

       To list only the account for bobo:


           % dacstoken -uj EXAMPLE -list bobo

       The exit status will be non-zero if this user does not have an account.

       To display the account for the device with serial number 37000752:

           % dacstoken -uj EXAMPLE -serial 37000752

       The serial number, which should uniquely identify a token, is often
       printed on the token or can be displayed by the token.

       To set the counter value for the existing account of bobo:

           % dacstoken -uj EXAMPLE -counter 9 -set bobo

       This operation might be used for testing or with a software token. The
       [1m-sync [22moperation is more appropriate for a hardware token.

       To change the PIN for username bobo:

           % dacstoken -uj EXAMPLE -pin-prompt -set bobo

       The program will prompt for the new PIN.

       To use an alternate account file, /secure/auth_tokens:

           % dacstoken -uj EXAMPLE -vfs "dacs-kwv-fs:/secure/auth_tokens" -list

       To use new keys (making the same assumptions as earlier), add a
       suitable VFS directive to dacs.conf; the default defines the item type
       auth_token_keys_prev as follows:

           VFS "[auth_token_keys_prev]dacs-fs:${Conf::FEDERATIONS_ROOT}/\
           ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/auth_token_keys.prev"



           % cd /usr/local/dacs/federations_root/example.com/EXAMPLE
           % mv auth_token_keys auth_token_keys.prev
           % dacskey -uj EXAMPLE -q auth_token_keys
           % chgrp www auth_token_keys
           % chmod 0640 auth_token_keys
           % dacstoken -uj EXAMPLE -inkeys auth_token_keys.prev -set


[1mDIAGNOSTICS[0m
       The program exits 0, or 1 if an error occurred.

[1mBUGS[0m
       HOTP should probably be called COTP, but HOTP came before TOTP.  WOTP?

       Listings may only be sorted by username.

       The drift adjustment for TOTP accounts is tied to the real time clocks
       of a particular client/server pair. If either clock is effectively
       changed "too much" (e.g., by resetting a very fast server clock or
       replacing an old token that had a relatively slower clock), then a user
       will observe the token to suddenly stop working. Resynchronization is
       required in these cases. Sharing an account file amongst two or more
       servers should be avoided in general (because locks are unlikely to be
       visible across hosts), but also if their clocks are not always well
       synchronized. It is recommended that the Network Time Protocol ([34m[1mRFC[0m
       [1m[34m1305[0m[1m[22m[37]) or equivalent be used on any host that runs [1mDACS [22mcommands or
       web services.

       The implementation of time-based tokens is based on the latest
       available Internet-Draft, which is considered by the IETF to be a "work
       in progress". Hence the algorithm, its implementation (including [1mDACS[0m
       accounts based on this operational mode), and documentation are all
       subject to change.

       TOTP password matching windows are symmetrical.

       This functionality should probably be available through
       [34m[1mdacs_admin(8)[0m[1m[22m[38] and [34m[1mdacsauth(1)[0m[1m[22m[39], but it's not.

       Mutual authentication using tokens should be implemented.

       Although release 1.4.25 introduced many improvements, some cause
       incompatibilities with earlier versions of [1mdacstoken[22m.

[1mSEE ALSO[0m
       [34m[1mRFC 4226[0m[1m[22m[4], [34m[1mdraft-mraihi-totp-timebased-05.txt[0m[1m[22m[5],
       [34m[1mdacs_authenticate(8)[0m[1m[22m[2], [34m[1mdacs_token(8)[0m[1m[22m[8], [34m[1mdacsgrid(1)[0m[1m[22m[40],
       [34m[1mdacspasswd(1)[0m[1m[22m[10], [34m[1mopie(4)[0m[1m[22m[41], [34m[1mMobile One Time Passwords[0m[1m[22m[42],
       [34m[1mmod_authn_otp[0m[1m[22m[43]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[44])

[1mACKNOWLEDGEMENTS[0m
       Our sincere thanks to [34m[1mAuthenex, Inc.[0m[1m[22m[24] and [34m[1mHyperSecu Information[0m
       [1m[34mSystems, Inc.[0m[1m[22m[26] for generously providing samples of their products
       and technical support.

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[45] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        3. local_token_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#token

        4. RFC 4226
           http://www.rfc-editor.org/rfc/rfc4226.txt

        5. latest IETF Internet-Draft
           http://www.ietf.org/id/draft-mraihi-totp-timebased-05.txt

        6. Additional operational modes
           http://www.ietf.org/id/draft-mraihi-mutual-oath-hotp-variants-11.txt

        7. [1m-convert [22mflag
           http://dacs.dss.ca/man/#convert_flag

        8. dacs_token(8)
           http://dacs.dss.ca/man/dacs_token.8.html

        9. TOKEN_REQUIRES_PIN
           http://dacs.dss.ca/man/dacs.conf.5.html#TOKEN_REQUIRES_PIN

       10. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

       11. dacs_passwd(8)
           http://dacs.dss.ca/man/dacs_passwd.8.html

       12. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       13. PASSWORD_SALT_PREFIX
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_SALT_PREFIX

       14. PASSWORD_CONSTRAINTS
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_CONSTRAINTS

       15. RFC 2104
           http://www.rfc-editor.org/rfc/rfc2104.txt

       16. FIPS 198
           http://csrc.nist.gov/publications/fips/fips198/fips-198a.pdf

       17. time(3)
           http://www.freebsd.org/cgi/man.cgi?query=time&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       18. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

       19. man-in-the-middle attack
           http://en.wikipedia.org/wiki/Man-in-the-middle_attack

       20. revocation list
           http://dacs.dss.ca/man/dacs.acls.5.html#revocation_list

       21. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#passwd

       22. [1mDACS [22midentities
           http://dacs.dss.ca/man/dacs.1.html#gloss_identity

       23. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

       24. Authenex A-Key(R) 3600
           http://www.authenex.com

       25. Feitian Technologies
           http://www.ftSafe.com

       26. HyperSecu Information Systems
           http://www.hypersecu.com

       27. OATH Token
           http://oathtoken.googlecode.com

       28. iPod Touch, iPhone, and iPad
           http://itunes.apple.com/us/app/oath-token/id364017137?mt=8

       29. iOATH Lite
           http://itunes.apple.com/ca/app/ioath-lite/id327109243?mt=8

       30. Photo
           http://dacs.dss.ca/otp-tokens2.jpg

       31. [1m-validate[0m
           http://dacs.dss.ca/man/#validate_flag

       32. [1m-set[0m
           http://dacs.dss.ca/man/#set_flag

       33. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       34. Tokens and secret keys
           http://dacs.dss.ca/man/#security1

       35. XML record
           http://dacs.dss.ca/man/#user_provisioning

       36. -import
           http://dacs.dss.ca/man/import_flag

       37. RFC 1305
           http://www.rfc-editor.org/rfc/rfc1305.txt

       38. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       39. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       40. dacsgrid(1)
           http://dacs.dss.ca/man/dacsgrid.1.html

       41. opie(4)
           http://www.freebsd.org/cgi/man.cgi?query=opie&apropos=0&sektion=4&manpath=FreeBSD+9.0-RELEASE&format=html

       42. Mobile One Time Passwords
           http://motp.sourceforge.net

       43. mod_authn_otp
           http://code.google.com/p/mod-authn-otp

       44. www.dss.ca
           http://www.dss.ca

       45. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                      DACSTOKEN(1)
