DACS_SIGNOUT(8)            DACS Web Services Manual            DACS_SIGNOUT(8)



[1mNAME[0m
       dacs_signout - [1mDACS [22msignout service

[1mSYNOPSIS[0m
       [1mdacs_signout [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This web service is part of the [1mDACS [22msuite.

       The [1mdacs_signout [22mweb service is invoked from a web browser to cause one
       or more sets of [1mDACS [22mcredentials [4mfor[24m [4mthe[24m [34m[1mcurrent federation[0m[1m[22m[2], stored
       as HTTP cookies, to be removed from the browser. This is done by
       replacing one or more existing cookies with cookies that have expired.
       The effect is that the user agent signs out (logs off) identities
       previously obtained through [34m[1mdacs_authenticate(8)[0m[1m[22m[3] or any other [1mDACS[0m
       authentication method. A [1mDACS[22m-enabled portal will typically provide
       users with a link or web page form to invoke this service.

       By default, all credentials are removed, but credentials can be
       selected for deletion based on a particular username (who the user was
       authenticated as) or a particular jurisdiction (the jurisdiction that
       performed that authentication).

       Should copies of the selected credentials exist outside of the browser,
       they may still be valid; only the browser's copies are destroyed.

       The [34m[1mSIGNOUT_HANDLER[0m[1m[22m[4] directive can optionally be used to specify
       where the user should be redirected before this service terminates,
       provided [4mFORMAT[24m does not select a variety of XML output (see
       [34m[1mdacs.conf(5)[0m[1m[22m[5]). If XML output is selected, a document conforming to
       [34m[1mdacs_current_credentials.dtd[0m[1m[22m[6] is returned.

       Explicitly signing off using this web service is generally unnecessary
       because [1mDACS [22mcredentials will either become invalid when their lifetime
       is reached (see [34m[1mAUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS[0m[1m[22m[7]) or will be
       automatically deleted when the user's browser session terminates (or a
       session with a trusted servlet ends). A user can also sign off by
       deleting his browser's [1mDACS [22mcookies. Middleware can simply discard
       cookies.

       As [1mDACS [22mcredentials are relative to a particular federation of [1mDACS[0m
       servers, only those credentials that are associated with the federation
       of the [1mDACS [22mserver that receives the service request will be affected
       by this service. This implies that a user who wants to explicitly sign
       out must do so for each federation in which he or she is currently
       authenticated.

   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[8], [1mdacs_signout [22munderstands
       the following CGI arguments:

       [4mDACS_USERNAME[0m
           If present, all credentials associated with this username will be
           deleted. If not provided, the username in the credentials is
           immaterial.

       [4mDACS_JURISDICTION[0m
           If present, all credentials associated with this jurisdiction
           (given as its [34m[1mJURISDICTION_NAME[0m[1m[22m[9]) will be deleted. If not
           provided, the jurisdiction in the credentials is immaterial.

       [4mCOOKIE_SYNTAX[0m
           This optional parameter is as described for the
           [34m[1mdacs_authenticate(8)[0m[1m[22m[3] service.

       The optional parameters are used to delete only those credentials that
       match a particular username or jurisdiction (or both). If neither
       parameter is specified in the service request, all [1mDACS [22mcookies
       associated with the federation that receives the service request will
       be deleted.

       The name matching method can be configured through the [34m[1mNAME_COMPARE[0m[1m[22m[10]
       directive.

           [1mNote[0m
           [1mDACS [22mdoes not currently provide an inactivity timeout feature, but
           it may appear in a future release. One way to add it would be to
           take advantage of the [34m[1muser tracking[0m[1m[22m[11] capability, which can
           record all of a user's requests for [1mDACS[22m-wrapped services within a
           federation. By simply comparing the current time with the time
           stamp of the user's last service request, the user's idle time can
           be determined. If the idle time exceeds a configured maximum,
           [34m[1mdacs_acs(8)[0m[1m[22m[12] would consider the user's credentials to be invalid
           (effectively expired) and take appropriate action. A
           straightforward implementation would be a relatively simple
           enhancement to [1mDACS[22m; its main drawback, for those that enable it,
           is the extra performance hit incurred from user tracking and having
           to compute idle time during access control processing - whether
           this hit is significant will depend on your platforms, the
           configuration of your federation, and user activity patterns.

[1mEXAMPLES[0m
       To signout from [4mall[24m identities in the EXAMPLE federation, a user would
       simply invoke a URL like:

           https://dss.example.com/cgi-bin/dacs/dacs_signout

       To signout only from the identity EXAMPLE::FEDROOT:bobo, a URL like the
       following might be invoked:

           https://fedroot.example.com/cgi-bin/dacs/dacs_signout?\
           DACS_USERNAME=bobo&DACS_JURISDICTION=FEDROOT

       To signout from only those identities in the EXAMPLE federation having
       a username component bobo, invoke a URL like:

           https://fedroot.example.com/cgi-bin/dacs/dacs_signout?DACS_USERNAME=bobo

       This would signoff from EXAMPLE::FEDROOT:bobo and EXAMPLE::DSS:bobo,
       for instance.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs_authenticate(8)[0m[1m[22m[3], [34m[1mdacs_current_credentials(8)[0m[1m[22m[13],
       [34m[1mdacs_auth_agent(8)[0m[1m[22m[14], [34m[1mdacs_auth_transfer(8)[0m[1m[22m[15],
       [34m[1mdacs_select_credentials(8)[0m[1m[22m[16], [34m[1mdacsauth(1)[0m[1m[22m[17], [34m[1mdacscred(1)[0m[1m[22m[18]

       The [1mDACS [22mdistribution includes an example of a "log off" web page:
       [34m[1mhtml/examples/signout.html[0m[1m[22m[19].

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[20])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[21] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. current federation
           http://dacs.dss.ca/man/dacs.1.html#current_federation

        3. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        4. SIGNOUT_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#SIGNOUT_HANDLER

        5. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        6. dacs_current_credentials.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_current_credentials.dtd

        7. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS

        8. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        9. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

       10. NAME_COMPARE
           http://dacs.dss.ca/man/dacs.conf.5.html#NAME_COMPARE

       11. user tracking
           http://dacs.dss.ca/man/dacs.1.html#tracking_user_activity

       12. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       13. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       14. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       15. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

       16. dacs_select_credentials(8)
           http://dacs.dss.ca/man/dacs_select_credentials.8.html

       17. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       18. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

       19. html/examples/signout.html
           http://dacs.dss.ca/man//examples/signout.html

       20. www.dss.ca
           http://www.dss.ca

       21. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                   DACS_SIGNOUT(8)
