#include "eidviewerTypes.h"

#define BACK_RCOLOR 135
#define BACK_GCOLOR 207
#define BACK_BCOLOR 163

#include <wx/datetime.h>
#include <wx/bitmap.h>


void ASN1_TIME_Print(ASN1_TIME *tm, wxString & strTime)
{
    strTime.Empty();
	if(tm->type == V_ASN1_UTCTIME)
        ASN1_UTCTIME_Print(tm, strTime);
	if(tm->type == V_ASN1_GENERALIZEDTIME)
		ASN1_GENERALIZEDTIME_Print(tm, strTime);
}

void ASN1_GENERALIZEDTIME_Print(ASN1_GENERALIZEDTIME *tm, wxString & strTime)
{
	char *v;
	int gmt=0;
	int i;
	int y=0,M=0,d=0,h=0,m=0,s=0;

	i=tm->length;
	v=(char *)tm->data;

	if (i < 12) return;
	if (v[i-1] == 'Z') gmt=1;
	for (i=0; i<12; i++)
		if ((v[i] > '9') || (v[i] < '0')) return;
	y= (v[0]-'0')*1000+(v[1]-'0')*100 + (v[2]-'0')*10+(v[3]-'0');
	M= (v[4]-'0')*10+(v[5]-'0');
	if ((M > 12) || (M < 1)) return;
	d= (v[6]-'0')*10+(v[7]-'0');
	h= (v[8]-'0')*10+(v[9]-'0');
	m=  (v[10]-'0')*10+(v[11]-'0');
	if (	(v[12] >= '0') && (v[12] <= '9') &&
		(v[13] >= '0') && (v[13] <= '9'))
		s=  (v[12]-'0')*10+(v[13]-'0');

    wxDateTime oDateTime(d, (wxDateTime::Month)(M -1), y+1900, h, m, s);

    if(gmt == 1)
    {
        oDateTime.MakeGMT();
    }

    strTime = oDateTime.Format(wxT("%d/%m/%Y"));
}

void ASN1_UTCTIME_Print(ASN1_UTCTIME *tm, wxString & strTime)
{
	char *v;
	int gmt=0;
	int i;
	int y=0,M=0,d=0,h=0,m=0,s=0;

	i=tm->length;
	v=(char *)tm->data;

	if (i < 10) return;
	if (v[i-1] == 'Z') gmt=1;
	for (i=0; i<10; i++)
		if ((v[i] > '9') || (v[i] < '0')) return;
	y= (v[0]-'0')*10+(v[1]-'0');
	if (y < 50) y+=100;
	M= (v[2]-'0')*10+(v[3]-'0');
	if ((M > 12) || (M < 1)) return;
	d= (v[4]-'0')*10+(v[5]-'0');
	h= (v[6]-'0')*10+(v[7]-'0');
	m=  (v[8]-'0')*10+(v[9]-'0');
	if (	(v[10] >= '0') && (v[10] <= '9') &&
		(v[11] >= '0') && (v[11] <= '9'))
		s=  (v[10]-'0')*10+(v[11]-'0');

    wxDateTime oDateTime(d, (wxDateTime::Month)(M -1), y+1900, h, m, s);
    if(gmt == 1)
    {
        oDateTime.MakeGMT();
    }

    strTime = oDateTime.Format(wxT("%d/%m/%Y"));
}

wxBitmap eidBitmapsFunc( size_t index )
{
    if (index == 0)
    {
        static const unsigned char data[] = 
        {
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,132,223,116,173,0,13,169,0,22,171,0,16,144,143,86,145,135,83,158,48,51,171,
            0,16,160,32,45,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,172,0,18,165,0,35,165,0,35,165,0,35,167,0,29,167,0,
            29,166,0,32,165,0,35,170,0,23,134,215,113,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,146,127,82,173,0,18,169,0,27,165,0,36,165,0,36,165,0,36,165,0,36,
            165,0,36,165,0,36,165,0,36,165,0,36,167,0,33,155,72,62,171,0,21,170,0,24,159,
            40,50,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,149,111,78,147,127,83,149,111,78,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,148,128,84,171,0,28,167,0,39,167,0,39,167,0,39,167,0,39,167,
            0,39,167,0,39,167,0,39,167,0,39,167,0,39,167,0,39,167,0,39,168,0,36,167,0,
            39,167,0,39,169,0,34,162,32,51,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,134,215,114,161,40,54,171,0,32,169,0,
            34,174,0,23,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,174,0,23,167,0,40,167,0,40,167,0,40,167,0,
            40,167,0,40,167,0,40,167,0,40,167,0,40,167,0,40,167,0,40,167,0,40,167,0,40,
            167,0,40,167,0,40,167,0,40,167,0,40,169,0,34,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,132,223,117,175,0,26,169,0,40,
            167,0,42,167,0,42,172,0,32,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,147,128,85,170,0,37,167,0,42,167,0,42,
            167,0,42,167,0,42,167,0,42,167,0,42,167,0,42,167,0,42,167,0,42,167,0,42,167,
            0,42,167,0,42,167,0,42,167,0,42,167,0,42,167,0,42,167,0,42,169,0,40,174,0,
            29,161,40,56,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,148,127,87,175,0,32,169,
            0,46,169,0,46,169,0,46,169,0,46,170,0,43,162,48,61,147,135,89,148,127,87,147,135,
            89,162,48,61,175,0,32,174,0,35,178,0,27,133,223,118,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,175,0,32,169,0,46,169,
            0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,
            46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,
            169,0,46,169,0,46,170,0,43,173,0,38,174,0,35,174,0,35,175,0,32,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,148,127,86,179,0,34,173,0,
            43,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,172,0,46,173,0,43,
            173,0,43,173,0,43,172,0,46,171,0,49,171,0,49,171,0,49,178,0,33,133,223,118,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,164,40,61,176,0,38,171,0,
            49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,
            171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,
            0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,49,171,0,
            49,173,0,43,165,32,58,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,147,127,84,176,0,28,172,0,40,
            171,0,49,172,0,51,172,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,
            0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,
            52,178,0,39,147,143,95,149,127,90,151,119,87,135,207,163,164,40,64,177,0,42,173,0,49,
            171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,
            0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,
            52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,171,0,52,
            171,0,52,171,0,52,171,0,52,174,0,47,164,40,64,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,133,223,117,176,0,21,170,0,36,169,
            0,44,170,0,45,171,0,49,172,0,51,171,0,53,174,0,55,174,0,55,174,0,55,174,0,
            55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,
            174,0,55,174,0,55,174,0,55,176,0,50,176,0,50,176,0,50,178,0,47,175,0,52,174,
            0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,
            55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,
            174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,
            0,55,174,0,55,174,0,55,174,0,55,174,0,55,174,0,55,175,0,52,179,0,45,165,48,
            68,150,127,91,136,207,114,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,161,32,48,171,0,27,168,0,
            41,167,0,41,169,0,44,170,0,45,171,0,49,172,0,51,171,0,52,175,0,56,175,0,57,
            175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,
            0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,
            58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,
            175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,
            0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,
            58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,175,0,58,
            175,0,58,177,0,55,178,0,53,184,0,44,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,132,223,116,174,0,15,167,0,34,
            167,0,39,168,0,41,167,0,41,169,0,44,170,0,45,171,0,49,172,0,51,171,0,52,175,
            0,56,176,0,58,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,
            60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,
            176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,
            0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,
            60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,
            176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,
            0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,184,0,45,134,223,119,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,146,127,80,170,0,20,166,
            0,36,165,0,36,167,0,39,168,0,41,167,0,41,169,0,44,170,0,45,171,0,49,172,0,
            51,171,0,52,175,0,56,176,0,57,177,0,61,178,0,64,179,0,65,179,0,65,179,0,65,
            179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,
            0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,
            65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,
            179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,
            0,65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,175,0,58,179,0,65,179,0,
            65,179,0,65,179,0,65,179,0,65,179,0,65,179,0,65,178,0,65,177,0,62,176,0,58,
            186,0,38,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,171,0,
            16,164,0,35,166,0,36,165,0,36,167,0,39,168,0,41,167,0,41,169,0,44,170,0,45,
            171,0,49,172,0,51,171,0,52,175,0,56,176,0,57,177,0,61,177,0,64,180,0,66,180,
            0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,
            67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,
            180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,
            0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,
            67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,
            180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,179,0,65,176,
            0,62,177,0,56,169,32,66,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,169,0,22,164,0,35,166,0,36,165,0,36,167,0,39,168,0,41,167,0,41,169,
            0,44,170,0,45,171,0,49,172,0,51,171,0,52,175,0,56,176,0,57,177,0,61,177,0,
            64,180,0,65,181,0,69,182,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,
            181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,
            0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,
            71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,
            181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,
            0,71,181,0,71,181,0,71,181,0,71,181,0,71,181,0,71,182,0,71,182,0,70,181,0,
            68,179,0,65,176,0,62,184,0,45,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,169,0,22,164,0,35,166,0,36,165,0,36,167,0,39,168,0,
            41,167,0,41,169,0,44,170,0,45,171,0,49,172,0,51,171,0,52,175,0,56,176,0,57,
            177,0,61,177,0,64,180,0,65,180,0,69,183,0,72,184,0,74,184,0,74,184,0,74,184,
            0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,
            74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,
            184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,
            0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,
            74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,74,184,0,75,183,0,72,
            182,0,70,181,0,68,179,0,65,179,0,57,148,144,98,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,169,0,22,164,0,35,166,0,36,165,0,36,
            167,0,39,168,0,41,167,0,41,169,0,44,170,0,45,171,0,49,172,0,51,171,0,52,175,
            0,56,176,0,57,177,0,61,177,0,64,180,0,65,180,0,69,183,0,72,185,0,75,186,0,
            77,186,0,77,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,
            185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,
            0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,
            76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,
            185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,77,186,0,77,185,
            0,76,182,0,71,182,0,70,181,0,68,179,0,65,179,0,57,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,134,215,113,168,0,25,164,0,35,166,
            0,36,165,0,36,167,0,39,168,0,41,167,0,41,169,0,44,170,0,45,171,0,49,172,0,
            51,171,0,52,175,0,56,176,0,57,177,0,61,177,0,64,180,0,65,180,0,69,183,0,72,
            185,0,75,186,0,77,187,0,77,188,0,81,188,0,80,188,0,80,188,0,80,188,0,80,188,
            0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,
            80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,
            188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,
            0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,80,188,0,
            79,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,185,0,49,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,167,0,
            28,164,0,35,166,0,36,165,0,36,167,0,39,168,0,41,167,0,41,169,0,44,170,0,45,
            171,0,49,172,0,51,171,0,52,175,0,56,176,0,57,177,0,61,177,0,64,180,0,65,180,
            0,69,183,0,72,185,0,75,186,0,77,186,0,77,189,0,82,189,0,82,189,0,82,189,0,
            82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,
            189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,
            0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,
            82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,
            189,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,182,0,60,149,
            144,98,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,167,0,28,164,0,35,166,0,36,165,0,36,167,0,39,168,0,41,167,0,41,169,
            0,44,170,0,45,171,0,49,172,0,51,171,0,52,175,0,56,176,0,57,177,0,61,177,0,
            64,180,0,65,180,0,69,183,0,72,185,0,75,186,0,77,186,0,77,189,0,82,190,0,82,
            191,0,85,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,
            0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,
            86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,
            192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,192,0,86,191,
            0,85,191,0,84,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,
            68,182,0,60,152,128,94,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,134,215,113,169,0,22,164,0,35,166,0,36,165,0,36,167,0,39,168,0,
            41,167,0,41,169,0,44,170,0,45,171,0,49,172,0,51,171,0,52,175,0,56,176,0,57,
            177,0,61,177,0,64,180,0,65,180,0,69,183,0,72,185,0,75,186,0,77,186,0,77,189,
            0,82,190,0,82,190,0,84,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,
            87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,
            193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,
            0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,
            87,193,0,87,192,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,
            182,0,70,181,0,68,182,0,60,152,128,94,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,160,32,45,167,0,29,166,0,36,165,0,36,
            167,0,39,168,0,41,167,0,41,169,0,44,170,0,45,171,0,49,172,0,51,171,0,52,175,
            0,56,176,0,57,177,0,61,177,0,64,180,0,65,180,0,69,183,0,72,185,0,75,186,0,
            77,186,0,77,189,0,82,190,0,82,190,0,84,194,0,88,195,0,89,195,0,91,195,0,90,
            195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,
            0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,
            90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,195,0,90,
            195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,
            0,76,182,0,71,182,0,70,181,0,68,182,0,60,149,144,98,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,160,32,46,168,
            0,30,165,0,36,167,0,39,168,0,41,167,0,41,169,0,44,170,0,45,171,0,49,172,0,
            51,171,0,52,175,0,56,176,0,57,177,0,61,177,0,64,180,0,65,180,0,69,183,0,72,
            185,0,75,186,0,77,186,0,77,189,0,82,190,0,82,190,0,84,194,0,88,195,0,88,196,
            0,91,196,0,92,196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,196,0,
            91,196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,
            196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,196,0,91,196,
            0,91,196,0,92,196,0,91,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,
            78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,181,0,55,169,32,67,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,161,32,47,167,0,34,167,0,39,168,0,41,167,0,41,169,0,44,170,0,45,
            171,0,49,176,0,43,177,0,43,179,0,49,176,0,57,177,0,61,177,0,64,180,0,65,180,
            0,69,183,0,72,185,0,75,186,0,77,186,0,77,189,0,82,190,0,82,190,0,84,194,0,
            88,195,0,88,196,0,91,197,0,93,198,0,94,198,0,94,198,0,94,198,0,94,198,0,94,
            198,0,94,198,0,94,198,0,94,198,0,94,198,0,94,198,0,94,198,0,94,198,0,94,198,
            0,94,198,0,94,198,0,94,198,0,94,198,0,94,198,0,94,198,0,94,198,0,94,198,0,
            94,198,0,94,198,0,94,198,0,94,195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,
            190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,
            0,62,178,0,54,167,40,68,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,174,0,16,167,0,39,168,0,41,167,0,41,169,
            0,44,172,0,40,180,0,32,133,223,119,135,207,163,134,223,119,183,0,46,177,0,61,177,0,
            64,180,0,65,180,0,69,183,0,72,185,0,75,186,0,77,186,0,77,189,0,82,190,0,82,
            190,0,84,194,0,88,195,0,88,196,0,91,197,0,93,198,0,94,199,0,95,199,0,95,199,
            0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,
            95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,
            199,0,95,199,0,95,199,0,95,199,0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,
            0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,
            68,179,0,65,176,0,62,176,0,58,176,0,54,179,0,42,147,143,94,150,127,89,150,119,84,
            136,207,112,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,132,223,116,175,0,19,170,0,
            35,169,0,39,175,0,31,149,127,87,135,207,163,135,207,163,135,207,163,135,207,163,151,128,94,
            180,0,56,177,0,64,180,0,65,180,0,69,183,0,72,185,0,75,186,0,77,186,0,77,189,
            0,82,190,0,82,190,0,84,194,0,88,195,0,88,196,0,91,197,0,93,198,0,94,199,0,
            94,200,0,97,200,0,97,200,0,97,200,0,97,200,0,97,200,0,97,200,0,97,200,0,97,
            200,0,97,200,0,97,200,0,97,200,0,97,200,0,97,200,0,97,200,0,97,200,0,97,200,
            0,97,200,0,97,200,0,97,200,0,97,198,0,96,199,0,95,198,0,94,195,0,90,195,0,
            90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,
            182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,53,174,0,47,175,
            0,45,172,0,41,176,0,29,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,149,119,81,164,24,50,134,215,115,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,183,0,52,177,0,64,180,0,65,180,0,69,183,0,72,185,0,75,186,0,
            77,186,0,77,189,0,82,190,0,82,190,0,84,194,0,88,195,0,88,196,0,91,197,0,93,
            198,0,94,199,0,94,200,0,97,199,0,98,200,0,98,200,0,98,200,0,98,200,0,98,200,
            0,98,200,0,98,200,0,98,200,0,98,200,0,98,200,0,98,200,0,98,200,0,98,200,0,
            98,200,0,98,200,0,98,200,0,98,199,0,98,200,0,97,198,0,96,199,0,95,198,0,94,
            195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,
            0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,
            53,171,0,52,172,0,50,169,0,46,169,0,45,175,0,26,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,184,0,50,177,0,64,180,0,65,180,0,69,183,0,72,
            185,0,75,186,0,77,186,0,77,189,0,82,190,0,82,190,0,84,194,0,88,195,0,88,196,
            0,91,197,0,93,198,0,94,199,0,94,200,0,97,199,0,98,201,0,97,201,0,98,200,0,
            98,200,0,98,200,0,98,200,0,98,200,0,98,200,0,98,200,0,98,200,0,98,200,0,98,
            200,0,98,200,0,98,200,0,98,200,0,98,201,0,97,199,0,98,200,0,97,198,0,96,199,
            0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,
            78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,
            175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,43,173,0,29,161,
            40,53,138,191,106,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,168,48,73,179,0,62,180,0,65,180,
            0,69,183,0,72,185,0,75,186,0,77,186,0,77,189,0,82,190,0,82,190,0,84,194,0,
            88,195,0,88,196,0,91,197,0,93,198,0,94,199,0,94,200,0,97,199,0,98,201,0,97,
            200,0,99,202,0,99,202,0,99,202,0,99,202,0,99,202,0,99,202,0,99,202,0,99,202,
            0,99,202,0,99,202,0,99,202,0,99,202,0,99,202,0,99,201,0,97,199,0,98,200,0,
            97,198,0,96,199,0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,
            190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,
            0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,
            43,168,0,40,171,0,28,136,199,108,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,151,136,96,180,0,
            59,180,0,65,180,0,69,183,0,72,185,0,75,186,0,77,186,0,77,189,0,82,190,0,82,
            190,0,84,194,0,88,195,0,88,196,0,91,197,0,93,198,0,94,199,0,94,200,0,97,199,
            0,98,201,0,97,200,0,99,202,0,98,201,0,100,202,0,99,202,0,99,202,0,99,202,0,
            99,202,0,99,202,0,99,202,0,99,202,0,99,202,0,100,201,0,100,202,0,99,201,0,97,
            199,0,98,200,0,97,198,0,96,199,0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,
            0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,
            68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,
            169,0,45,167,0,43,168,0,40,171,0,28,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            153,128,94,180,0,59,180,0,65,180,0,69,183,0,72,185,0,75,186,0,77,186,0,77,189,
            0,82,190,0,82,190,0,84,194,0,88,195,0,88,196,0,91,197,0,93,198,0,94,199,0,
            94,200,0,97,199,0,98,201,0,97,200,0,99,202,0,98,201,0,100,203,0,101,203,0,101,
            203,0,101,203,0,101,203,0,101,203,0,101,203,0,101,203,0,101,203,0,99,201,0,100,202,
            0,99,201,0,97,199,0,98,200,0,97,198,0,96,199,0,95,198,0,94,195,0,90,195,0,
            90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,
            182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,
            0,50,169,0,46,169,0,45,167,0,43,168,0,40,174,0,23,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,156,112,90,184,0,55,180,0,65,184,0,65,186,0,68,188,0,71,186,0,
            77,186,0,77,189,0,82,190,0,82,190,0,84,194,0,88,195,0,88,196,0,91,197,0,93,
            198,0,94,199,0,94,200,0,97,199,0,98,201,0,97,200,0,99,202,0,98,201,0,100,203,
            0,101,203,0,101,203,0,101,202,0,100,202,0,100,203,0,101,203,0,101,203,0,101,203,0,
            99,201,0,100,202,0,99,201,0,97,199,0,98,200,0,97,198,0,96,199,0,95,198,0,94,
            195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,
            0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,
            53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,43,170,0,35,143,160,94,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,152,127,95,193,0,50,151,143,102,155,127,100,
            152,143,104,195,0,69,186,0,77,189,0,82,190,0,82,190,0,84,194,0,88,195,0,88,196,
            0,91,197,0,93,198,0,94,199,0,94,200,0,97,199,0,98,201,0,97,200,0,99,202,0,
            98,201,0,100,203,0,101,203,0,101,202,0,100,204,0,102,204,0,102,202,0,100,203,0,101,
            203,0,101,203,0,99,201,0,100,202,0,99,201,0,97,199,0,98,200,0,97,198,0,96,199,
            0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,
            78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,
            175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,43,168,0,40,170,
            0,31,162,32,49,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,197,0,68,189,0,82,190,0,82,190,0,84,194,0,
            88,195,0,88,196,0,91,197,0,93,198,0,94,199,0,94,200,0,97,199,0,98,201,0,97,
            200,0,99,202,0,98,201,0,100,203,0,101,203,0,101,202,0,100,203,0,101,203,0,101,202,
            0,100,203,0,101,203,0,101,203,0,99,201,0,100,202,0,99,201,0,97,199,0,98,200,0,
            97,198,0,96,199,0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,
            190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,
            0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,
            43,168,0,40,166,0,40,168,0,35,174,0,17,132,223,116,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,223,122,196,0,76,190,0,82,
            190,0,84,194,0,88,195,0,88,196,0,91,197,0,93,198,0,94,199,0,94,200,0,97,199,
            0,98,201,0,97,200,0,99,202,0,98,201,0,100,203,0,101,203,0,101,203,0,101,202,0,
            101,202,0,101,203,0,101,203,0,101,203,0,101,203,0,99,201,0,100,202,0,99,201,0,97,
            199,0,98,200,0,97,198,0,96,199,0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,
            0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,
            68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,
            169,0,45,167,0,43,168,0,40,166,0,40,167,0,37,166,0,37,169,0,23,160,32,45,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,177,
            48,90,191,0,81,190,0,84,194,0,88,195,0,88,196,0,91,197,0,93,198,0,94,199,0,
            94,200,0,97,199,0,98,201,0,97,200,0,99,202,0,98,201,0,100,203,0,100,203,0,100,
            203,0,100,203,0,100,203,0,100,203,0,100,203,0,100,203,0,100,203,0,99,201,0,100,202,
            0,99,201,0,97,199,0,98,200,0,97,198,0,96,199,0,95,198,0,94,195,0,90,195,0,
            90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,
            182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,
            0,50,169,0,46,169,0,45,167,0,43,168,0,40,166,0,40,167,0,37,166,0,37,164,0,
            34,168,0,25,149,112,75,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,159,128,104,193,0,80,190,0,84,194,0,88,199,0,86,200,0,88,201,0,90,
            198,0,94,199,0,94,200,0,97,199,0,98,201,0,97,200,0,99,202,0,98,202,0,100,202,
            0,100,202,0,100,202,0,100,202,0,100,202,0,100,202,0,100,202,0,100,202,0,100,202,0,
            100,202,0,100,202,0,99,201,0,97,199,0,98,200,0,97,198,0,96,199,0,95,198,0,94,
            195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,
            0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,
            53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,43,168,0,40,166,0,40,167,0,37,
            166,0,37,164,0,34,167,0,28,148,120,78,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,139,207,119,203,0,72,198,0,79,206,0,80,157,143,110,162,
            127,109,158,143,112,135,207,163,201,0,93,200,0,97,199,0,98,201,0,97,200,0,99,201,0,
            99,201,0,98,201,0,98,201,0,98,201,0,98,201,0,98,201,0,98,201,0,98,201,0,98,
            201,0,98,201,0,98,201,0,98,201,0,99,201,0,97,199,0,98,200,0,97,198,0,96,199,
            0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,
            78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,
            175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,43,168,0,40,166,
            0,40,167,0,37,166,0,37,166,0,31,171,0,16,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,190,32,99,209,0,93,202,0,97,201,0,97,
            201,0,98,201,0,98,201,0,98,201,0,98,201,0,98,201,0,98,201,0,98,201,0,98,201,
            0,98,201,0,98,201,0,98,201,0,98,201,0,98,201,0,98,201,0,97,199,0,98,200,0,
            97,198,0,96,199,0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,
            190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,
            0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,
            43,168,0,40,166,0,40,167,0,37,168,0,31,159,40,49,134,215,113,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,139,215,123,188,
            40,102,204,0,96,199,0,98,199,0,98,199,0,98,199,0,98,199,0,98,199,0,98,199,0,
            98,199,0,98,199,0,98,199,0,98,199,0,98,199,0,98,199,0,98,199,0,98,199,0,98,
            200,0,98,200,0,97,198,0,96,199,0,95,198,0,94,195,0,90,195,0,90,194,0,88,191,
            0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,
            68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,
            169,0,45,167,0,43,168,0,40,166,0,40,169,0,32,161,32,48,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,188,40,101,201,0,95,199,0,96,199,0,96,199,0,96,199,0,96,
            199,0,96,199,0,96,199,0,96,199,0,96,199,0,96,199,0,96,199,0,96,199,0,96,199,
            0,96,199,0,96,199,0,96,199,0,96,198,0,96,199,0,95,198,0,94,195,0,90,195,0,
            90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,
            182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,
            0,50,169,0,46,169,0,45,167,0,43,168,0,40,168,0,37,161,40,52,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,139,215,123,205,0,91,199,0,95,199,0,95,199,
            0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,
            95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,199,0,95,198,0,94,
            195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,
            0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,
            53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,43,168,0,40,174,0,23,134,215,114,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,208,0,88,197,0,
            93,197,0,93,197,0,93,197,0,93,197,0,93,197,0,93,197,0,93,197,0,93,197,0,93,
            197,0,93,197,0,93,197,0,93,197,0,93,197,0,93,197,0,93,197,0,93,197,0,93,197,
            0,93,197,0,93,195,0,90,195,0,90,194,0,88,191,0,86,191,0,83,190,0,83,188,0,
            78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,
            175,0,57,172,0,53,171,0,52,172,0,50,169,0,46,169,0,45,167,0,43,175,0,24,133,
            223,116,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            179,64,101,198,0,91,196,0,92,196,0,92,196,0,92,196,0,92,196,0,92,196,0,92,196,
            0,92,196,0,92,196,0,92,196,0,92,196,0,92,196,0,92,196,0,92,196,0,92,196,0,
            92,196,0,92,196,0,92,196,0,92,196,0,91,195,0,90,194,0,88,191,0,86,191,0,83,
            190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,
            0,62,176,0,58,175,0,57,172,0,53,171,0,52,172,0,50,171,0,44,172,0,37,176,0,
            24,133,223,117,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,204,0,82,194,0,88,194,0,88,194,0,88,194,0,88,194,0,88,194,0,
            88,194,0,88,194,0,88,194,0,88,194,0,88,194,0,88,196,0,87,194,0,88,194,0,88,
            194,0,88,194,0,88,194,0,88,194,0,88,194,0,88,194,0,88,194,0,89,194,0,88,191,
            0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,
            68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,53,171,0,52,176,0,42,163,40,59,
            134,215,115,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,201,0,82,193,0,87,193,0,87,193,0,87,193,0,87,
            193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,197,0,84,177,64,98,203,
            0,80,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,87,193,0,
            87,193,0,87,192,0,86,191,0,83,190,0,83,188,0,78,185,0,76,185,0,76,182,0,71,
            182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,53,174,0,47,150,
            128,90,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,198,0,79,190,0,85,190,0,85,190,
            0,85,190,0,85,190,0,85,190,0,85,190,0,85,190,0,85,190,0,85,192,0,83,181,40,
            91,135,207,163,135,207,163,198,0,79,190,0,85,190,0,85,190,0,85,190,0,85,190,0,85,
            190,0,85,190,0,85,190,0,85,191,0,85,191,0,84,190,0,83,188,0,78,185,0,76,185,
            0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,172,0,
            53,177,0,42,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,161,120,104,193,0,79,189,0,
            82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,
            199,0,75,135,207,163,135,207,163,135,207,163,197,0,76,189,0,82,189,0,82,189,0,82,189,
            0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,82,189,0,83,188,0,
            78,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,
            175,0,57,172,0,53,180,0,37,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,176,48,88,
            190,0,77,188,0,78,188,0,78,188,0,78,188,0,78,188,0,78,188,0,78,188,0,78,188,
            0,78,197,0,70,157,128,103,135,207,163,135,207,163,139,207,119,193,0,74,188,0,78,188,0,
            78,188,0,78,188,0,78,188,0,78,175,0,58,188,0,78,188,0,78,188,0,78,188,0,78,
            188,0,78,188,0,79,185,0,76,185,0,76,182,0,71,182,0,70,181,0,68,179,0,65,176,
            0,62,176,0,58,175,0,57,175,0,49,147,144,95,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,197,0,65,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,
            76,185,0,76,196,0,66,135,223,121,135,207,163,135,207,163,135,207,163,160,112,99,188,0,73,
            185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,
            0,76,185,0,76,185,0,76,185,0,76,185,0,76,185,0,76,182,0,71,182,0,70,181,0,
            68,179,0,65,176,0,62,176,0,58,175,0,57,175,0,49,152,112,86,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,190,0,65,187,0,69,187,0,69,187,0,69,184,0,72,
            185,0,71,187,0,69,196,0,60,134,223,121,135,207,163,135,207,163,135,207,163,135,207,163,138,
            207,117,189,0,67,184,0,72,184,0,72,184,0,72,184,0,72,184,0,72,184,0,72,184,0,
            72,184,0,72,184,0,72,184,0,72,184,0,72,184,0,72,184,0,72,184,0,73,183,0,72,
            182,0,70,181,0,68,179,0,65,176,0,62,176,0,58,175,0,57,181,0,39,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,158,111,95,154,127,99,154,127,99,151,
            143,102,192,0,56,171,48,81,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,188,0,62,181,0,69,181,0,69,181,0,69,181,0,69,181,0,69,
            181,0,69,181,0,69,181,0,69,181,0,69,181,0,69,181,0,69,181,0,69,181,0,69,181,
            0,69,181,0,70,181,0,69,181,0,68,179,0,65,176,0,62,176,0,58,179,0,50,151,128,
            92,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,187,0,60,180,0,67,180,0,67,180,0,67,180,
            0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,67,180,0,
            67,180,0,67,180,0,67,180,0,67,180,0,67,181,0,67,179,0,65,176,0,62,177,0,56,
            169,32,66,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,183,0,54,177,0,62,177,0,
            62,177,0,62,177,0,62,177,0,62,177,0,62,177,0,62,177,0,62,177,0,62,177,0,62,
            177,0,62,177,0,62,177,0,62,177,0,62,177,0,62,177,0,62,177,0,62,177,0,63,177,
            0,62,183,0,47,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,182,0,52,
            176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,
            0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,60,176,0,
            60,176,0,60,178,0,58,164,64,76,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,180,0,48,175,0,56,175,0,56,175,0,56,175,0,56,175,0,56,175,0,56,175,0,
            56,175,0,56,175,0,56,175,0,56,175,0,56,175,0,56,175,0,56,175,0,56,175,0,56,
            175,0,56,175,0,56,175,0,56,175,0,56,182,0,46,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,184,0,35,178,0,44,178,0,44,175,0,49,172,0,54,172,0,54,
            172,0,54,172,0,54,172,0,54,172,0,54,172,0,54,172,0,54,172,0,54,172,0,54,172,
            0,54,172,0,54,172,0,54,172,0,54,172,0,54,172,0,54,175,0,49,150,128,92,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,180,
            0,36,176,0,43,172,0,51,172,0,51,172,0,51,172,0,51,172,0,51,172,0,51,172,0,
            51,172,0,51,172,0,51,172,0,51,172,0,51,172,0,51,172,0,51,172,0,51,172,0,51,
            180,0,36,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,133,223,118,179,0,30,171,0,45,170,0,47,170,0,47,170,0,47,
            170,0,47,170,0,47,170,0,47,170,0,47,170,0,47,170,0,47,170,0,47,170,0,47,170,
            0,47,170,0,47,173,0,42,153,104,81,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,174,0,35,169,
            0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,46,169,0,
            46,169,0,46,169,0,46,169,0,46,173,0,38,132,231,121,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,176,0,22,170,0,36,167,0,41,167,0,41,167,0,41,167,0,41,167,0,41,
            167,0,41,167,0,41,167,0,41,167,0,41,167,0,41,169,0,39,161,40,55,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,148,127,84,173,0,26,167,0,40,167,0,40,167,
            0,40,167,0,40,167,0,40,167,0,40,167,0,40,167,0,40,167,0,40,167,0,40,171,0,
            32,150,112,79,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,171,0,
            27,167,0,39,167,0,39,167,0,39,167,0,39,167,0,39,167,0,39,167,0,39,167,0,39,
            167,0,39,169,0,33,149,120,81,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,159,40,50,168,0,30,166,0,36,166,0,36,166,0,36,166,0,36,166,0,36,166,
            0,36,166,0,36,166,0,36,169,0,27,135,207,111,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,110,159,40,49,167,0,29,164,0,35,164,0,35,164,0,
            35,164,0,35,164,0,35,164,0,35,166,0,32,172,0,14,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,160,32,45,170,0,18,
            169,0,21,169,0,21,169,0,21,169,0,21,170,0,18,159,40,48,134,215,113,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163
        };
        wxImage image( 85, 68, (unsigned char*)data, TRUE );
#ifndef _WIN32	
        wxBitmap bitmap( image.Scale(90,90) );
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#else	
        wxBitmap bitmap( image.Scale(90,90) );
#endif	
        return bitmap;
    }
    if (index == 1)
    {
        static const unsigned char data[] = 
        {
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,249,242,
            217,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,249,242,217,242,242,230,242,
            242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,236,236,230,236,236,230,249,242,204,249,242,204,249,236,204,249,242,230,249,242,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,249,242,217,249,242,217,249,242,204,249,242,230,249,242,230,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,
            249,242,217,249,242,204,249,242,230,249,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,
            217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,217,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,217,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,236,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,242,217,236,242,217,230,236,217,
            230,236,217,230,236,217,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,217,236,230,217,236,230,217,236,
            242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,217,236,230,217,236,230,217,236,242,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,236,236,230,236,236,230,236,236,230,242,242,217,242,242,217,242,236,
            217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,217,
            236,236,217,242,242,230,242,242,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,236,236,230,236,236,230,236,236,230,242,242,217,242,242,217,242,236,217,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,217,236,236,217,242,242,
            230,242,242,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,255,255,
            255,255,255,255,255,255,255,236,236,230,236,236,230,242,242,230,236,236,230,236,236,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,242,236,230,242,236,230,135,
            207,163,135,207,163,135,207,163,242,242,217,242,242,217,249,242,230,135,207,163,135,207,163,135,207,
            163,135,207,163,242,236,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,230,236,236,230,236,236,230,135,207,163,
            135,207,163,135,207,163,236,236,230,236,236,230,249,236,217,249,236,217,236,236,230,236,236,230,236,
            236,230,242,236,230,242,236,230,242,242,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,
            163,236,230,230,236,230,230,249,242,217,249,242,217,242,236,242,242,236,242,135,207,163,236,236,230,
            236,236,230,242,236,217,242,236,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,236,242,217,236,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,242,236,230,236,236,230,236,236,230,135,207,163,135,207,163,135,207,
            163,236,236,230,236,236,230,249,236,217,249,236,217,236,236,230,236,236,230,236,236,230,242,236,230,
            242,236,230,242,242,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,236,230,230,236,
            230,230,249,242,217,249,242,217,242,236,242,242,236,242,135,207,163,236,236,230,236,236,230,242,236,
            217,242,236,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,242,217,
            236,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,249,242,217,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,242,236,230,242,
            236,230,249,242,217,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,
            230,249,242,217,249,242,217,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,236,236,217,
            236,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,
            242,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,242,242,217,242,242,217,242,242,
            230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,
            217,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,242,236,230,242,236,230,249,242,217,
            249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,249,242,217,249,
            242,217,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,236,236,217,236,236,217,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,236,236,230,
            236,236,230,135,207,163,135,207,163,135,207,163,242,242,217,242,242,217,242,242,230,242,242,230,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,236,236,230,236,236,230,230,236,217,236,242,217,236,
            242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,255,255,
            255,255,255,255,255,255,255,236,223,230,236,223,230,242,217,217,249,230,217,249,230,217,236,236,230,
            236,236,230,236,236,230,242,242,217,242,242,217,249,223,217,249,223,217,242,223,217,242,223,217,236,
            230,230,236,230,230,236,230,230,242,236,230,242,236,230,242,236,217,135,207,163,135,207,163,135,207,
            163,135,207,163,242,236,242,242,236,217,242,236,217,135,207,163,135,207,163,135,207,163,236,236,230,
            236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,242,236,230,
            242,236,230,135,207,163,135,207,163,135,207,163,249,236,217,249,236,217,249,217,217,242,217,217,242,
            217,217,242,217,217,242,217,217,249,210,217,249,223,204,249,223,204,249,242,204,249,242,204,249,242,
            217,249,236,217,249,236,217,242,210,217,242,210,217,249,217,204,249,217,204,249,217,217,242,210,217,
            242,210,217,249,230,204,249,230,204,249,242,217,236,236,230,236,236,230,135,207,163,135,207,163,242,
            242,217,236,236,217,236,236,217,135,207,163,135,207,163,135,207,163,236,242,217,236,242,217,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,242,236,230,242,236,230,135,207,
            163,135,207,163,135,207,163,249,236,217,249,236,217,249,217,217,242,217,217,242,217,217,242,217,217,
            242,217,217,249,210,217,249,223,204,249,223,204,249,242,204,249,242,204,249,242,217,249,236,217,249,
            236,217,242,210,217,242,210,217,249,217,204,249,217,204,249,217,217,242,210,217,242,210,217,249,230,
            204,249,230,204,249,242,217,236,236,230,236,236,230,135,207,163,135,207,163,242,242,217,236,236,217,
            236,236,217,135,207,163,135,207,163,135,207,163,236,242,217,236,242,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,217,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,249,236,217,249,236,217,242,236,230,242,236,230,135,207,163,242,242,217,242,
            242,217,249,230,204,249,230,204,249,210,217,242,210,204,242,210,204,242,217,217,242,217,217,249,210,
            217,249,217,204,249,217,204,249,242,204,249,242,204,249,242,204,249,236,217,249,236,217,242,210,217,
            242,210,217,242,210,217,242,210,217,249,210,217,242,210,217,242,210,217,249,230,204,249,230,204,249,
            242,204,242,242,217,242,242,217,236,236,230,236,236,230,249,230,217,242,230,217,242,230,217,135,207,
            163,135,207,163,135,207,163,236,242,217,236,242,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,236,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,249,236,217,249,236,217,242,236,230,242,236,230,135,207,163,242,242,217,242,242,217,249,230,204,
            249,230,204,249,210,217,242,210,204,242,210,204,242,217,217,242,217,217,249,210,217,249,217,204,249,
            217,204,249,242,204,249,242,204,249,242,204,249,236,217,249,236,217,242,210,217,242,210,217,242,210,
            217,242,210,217,249,210,217,242,210,217,242,210,217,249,230,204,249,230,204,249,242,204,242,242,217,
            242,242,217,236,236,230,236,236,230,249,230,217,242,230,217,242,230,217,135,207,163,135,207,163,135,
            207,163,236,242,217,236,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,242,242,249,242,230,249,242,230,242,242,230,242,242,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,242,236,230,242,236,230,242,223,217,242,217,204,242,
            217,204,249,236,217,249,236,217,249,242,217,249,242,204,249,242,204,249,242,217,249,242,217,242,223,
            217,242,217,217,242,217,217,249,210,217,249,210,217,249,210,217,249,223,217,249,223,217,249,242,204,
            249,242,204,249,242,204,249,242,217,249,242,217,249,223,204,249,223,204,242,217,217,242,217,217,242,
            210,217,242,217,217,242,217,217,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,
            217,249,242,217,249,217,217,242,210,204,242,210,204,242,217,217,242,217,217,242,223,217,249,242,230,
            249,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,242,242,242,242,242,242,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,236,217,249,242,204,249,242,204,249,242,204,249,242,204,249,236,217,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,249,230,217,249,230,217,249,217,217,249,217,217,249,210,204,242,210,217,242,210,217,249,223,204,
            249,223,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,217,242,223,217,242,
            223,217,242,223,230,242,223,230,242,230,217,249,236,217,249,236,217,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,217,249,242,217,255,255,255,255,255,255,242,230,230,242,236,204,
            242,236,204,249,242,217,249,242,217,249,242,217,249,242,204,249,242,204,249,236,217,249,236,217,242,
            217,217,249,210,217,249,210,217,249,210,217,249,210,217,242,217,204,242,236,217,242,236,217,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,255,255,
            255,255,255,255,242,236,230,242,236,230,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,217,
            249,242,204,249,242,204,249,242,204,249,242,204,249,236,217,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,230,217,249,
            230,217,249,217,217,249,217,217,249,210,204,242,210,217,242,210,217,249,223,204,249,223,204,249,236,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,217,242,223,217,242,223,217,242,223,230,
            242,223,230,242,230,217,249,236,217,249,236,217,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,242,217,249,242,217,255,255,255,255,255,255,242,230,230,242,236,204,242,236,204,249,242,
            217,249,242,217,249,242,217,249,242,204,249,242,204,249,236,217,249,236,217,242,217,217,249,210,217,
            249,210,217,249,210,217,249,210,217,242,217,204,242,236,217,242,236,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,255,255,255,255,255,255,242,
            236,230,242,236,230,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,
            217,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,249,242,204,249,242,204,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,249,236,217,249,236,217,242,217,204,
            242,217,204,242,210,217,242,217,230,242,217,230,249,230,217,249,230,217,249,242,204,249,249,204,249,
            249,204,249,242,204,249,242,204,249,242,204,249,236,230,249,236,230,255,255,255,255,255,255,236,223,
            230,249,223,204,249,223,204,249,236,217,249,236,217,249,236,217,249,236,204,249,236,204,242,236,230,
            242,236,230,255,255,255,255,255,255,242,230,230,249,230,217,249,230,217,249,242,217,249,242,217,249,
            242,204,249,236,204,249,236,204,255,255,255,255,255,255,255,255,255,242,223,217,242,223,217,249,223,
            204,249,223,204,249,236,204,249,242,217,249,242,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,204,249,242,204,249,236,204,249,236,204,
            249,242,204,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,249,242,204,249,
            242,204,249,242,204,249,242,217,249,242,217,249,242,204,249,242,204,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,236,236,230,249,236,217,249,236,217,242,217,204,242,217,204,242,210,
            217,242,217,230,242,217,230,249,230,217,249,230,217,249,242,204,249,249,204,249,249,204,249,242,204,
            249,242,204,249,242,204,249,236,230,249,236,230,255,255,255,255,255,255,236,223,230,249,223,204,249,
            223,204,249,236,217,249,236,217,249,236,217,249,236,204,249,236,204,242,236,230,242,236,230,255,255,
            255,255,255,255,242,230,230,249,230,217,249,230,217,249,242,217,249,242,217,249,242,204,249,236,204,
            249,236,204,255,255,255,255,255,255,255,255,255,242,223,217,242,223,217,249,223,204,249,223,204,249,
            236,204,249,242,217,249,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,249,242,217,249,242,204,249,242,204,249,236,204,249,236,204,249,242,204,242,242,
            217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,249,236,217,249,236,217,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,242,236,217,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,249,242,204,249,242,204,249,236,204,249,236,204,242,236,230,255,255,255,255,
            255,255,242,236,230,242,236,230,249,236,204,249,236,217,249,236,217,249,242,204,249,242,204,249,236,
            204,242,223,217,242,223,217,242,236,230,242,236,230,249,230,217,242,217,204,242,217,204,249,230,204,
            249,230,204,249,236,217,249,223,217,249,223,217,242,223,217,242,223,217,242,230,217,242,230,217,242,
            230,217,242,217,204,242,217,204,249,230,204,249,230,204,249,236,204,249,236,217,249,236,217,236,236,
            230,236,236,230,242,230,230,242,223,204,242,223,204,249,236,204,249,236,204,249,242,217,242,236,230,
            242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            242,236,217,249,242,217,249,242,217,249,242,217,249,242,217,242,242,217,236,236,230,236,236,230,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,217,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,242,242,230,242,242,230,249,242,204,249,242,204,242,242,217,255,255,255,255,255,255,242,223,230,
            242,223,230,249,217,204,249,223,204,249,223,204,249,242,217,249,242,217,249,236,204,249,236,204,249,
            236,204,249,242,204,249,242,204,249,236,204,249,236,204,249,236,204,249,242,204,249,242,204,249,242,
            204,249,236,204,249,236,204,249,236,217,249,236,217,249,242,204,249,242,204,249,242,204,249,236,204,
            249,236,204,249,242,204,249,242,204,249,236,204,249,236,204,249,236,204,242,236,217,242,236,217,249,
            223,204,249,223,204,249,223,204,249,236,217,249,236,217,242,242,230,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,242,242,242,242,242,230,242,242,230,242,242,217,242,242,217,249,242,217,249,242,
            217,249,242,217,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,242,217,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,
            242,230,249,242,204,249,242,204,242,242,217,255,255,255,255,255,255,242,223,230,242,223,230,249,217,
            204,249,223,204,249,223,204,249,242,217,249,242,217,249,236,204,249,236,204,249,236,204,249,242,204,
            249,242,204,249,236,204,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,236,204,249,
            236,204,249,236,217,249,236,217,249,242,204,249,242,204,249,242,204,249,236,204,249,236,204,249,242,
            204,249,242,204,249,236,204,249,236,204,249,236,204,242,236,217,242,236,217,249,223,204,249,223,204,
            249,223,204,249,236,217,249,236,217,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            242,242,242,242,242,230,242,242,230,242,242,217,242,242,217,249,242,217,249,242,217,249,242,217,242,
            242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,236,236,230,236,236,230,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,217,249,242,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,210,230,230,210,230,230,135,207,163,
            135,207,163,242,236,217,242,223,217,242,223,217,249,230,217,249,230,217,249,242,204,249,242,204,249,
            242,204,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,217,249,242,217,249,242,217,249,242,217,249,242,204,249,249,204,249,249,204,249,242,217,
            249,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,204,242,236,217,242,236,217,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,
            204,249,242,204,249,242,217,249,242,217,249,242,217,242,242,217,242,242,217,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,
            236,230,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,242,
            217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,210,230,230,210,230,230,135,207,163,135,207,163,242,236,
            217,242,223,217,242,223,217,249,230,217,249,230,217,249,242,204,249,242,204,249,242,204,249,236,204,
            249,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,
            242,217,249,242,217,249,242,217,249,242,204,249,249,204,249,249,204,249,242,217,249,242,217,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,236,204,242,236,217,242,236,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,204,249,242,204,249,
            242,217,249,242,217,249,242,217,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,
            249,242,217,249,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,
            242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,217,242,
            236,217,249,242,204,249,242,204,249,249,204,249,242,204,249,242,204,249,236,217,249,236,217,242,242,
            217,242,236,217,242,236,217,242,242,217,242,242,217,249,242,204,249,236,204,249,236,204,249,217,217,
            249,217,217,249,217,217,249,230,204,249,230,204,249,242,204,249,242,204,249,242,204,249,242,204,242,
            242,217,236,236,217,236,236,217,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,242,242,230,242,242,230,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,
            249,242,217,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,230,242,236,
            230,242,242,217,242,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,242,217,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,217,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,236,217,249,236,217,210,230,217,204,223,217,204,
            223,217,223,236,217,223,236,217,242,249,204,249,236,204,249,236,204,242,210,217,242,210,217,242,210,
            217,249,217,217,249,217,217,249,242,204,249,242,204,242,236,217,242,236,217,210,230,217,204,230,217,
            204,230,217,223,236,217,223,236,217,242,242,204,249,242,204,249,242,204,249,236,217,249,236,217,249,
            242,204,249,242,217,249,242,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,
            242,217,242,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,236,217,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,230,242,236,230,242,242,217,242,
            242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,242,217,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,242,236,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,236,217,249,236,217,210,230,217,204,223,217,204,223,217,223,236,217,
            223,236,217,242,249,204,249,236,204,249,236,204,242,210,217,242,210,217,242,210,217,249,217,217,249,
            217,217,249,242,204,249,242,204,242,236,217,242,236,217,210,230,217,204,230,217,204,230,217,223,236,
            217,223,236,217,242,242,204,249,242,204,249,242,204,249,236,217,249,236,217,249,242,204,249,242,217,
            249,242,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,217,242,242,217,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,236,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,242,242,217,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,242,230,242,242,230,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,
            236,236,230,249,242,217,249,223,204,249,223,204,249,217,204,249,217,204,242,223,217,249,236,204,249,
            236,204,249,242,217,249,242,217,217,236,217,210,230,217,210,230,217,230,236,217,230,236,217,249,249,
            204,249,242,204,249,242,204,249,230,217,249,230,217,249,230,204,249,236,217,249,236,217,249,242,204,
            249,242,204,249,242,217,249,242,217,223,236,217,210,230,217,210,230,217,230,236,204,230,236,204,249,
            242,204,249,230,204,249,230,204,249,217,204,249,217,204,249,217,217,242,230,217,242,230,217,242,242,
            230,242,242,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,242,242,217,242,242,217,249,242,204,249,242,204,249,242,204,249,242,
            217,249,242,217,249,242,230,249,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,242,242,217,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,204,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,249,242,
            217,249,223,204,249,223,204,249,217,204,249,217,204,242,223,217,249,236,204,249,236,204,249,242,217,
            249,242,217,217,236,217,210,230,217,210,230,217,230,236,217,230,236,217,249,249,204,249,242,204,249,
            242,204,249,230,217,249,230,217,249,230,204,249,236,217,249,236,217,249,242,204,249,242,204,249,242,
            217,249,242,217,223,236,217,210,230,217,210,230,217,230,236,204,230,236,204,249,242,204,249,230,204,
            249,230,204,249,217,204,249,217,204,249,217,217,242,230,217,242,230,217,242,242,230,242,242,230,236,
            236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,242,242,217,242,242,217,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,249,
            242,230,249,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,249,242,217,249,242,217,249,236,204,249,
            236,204,249,242,204,242,242,204,242,242,204,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,236,217,242,236,217,255,255,255,255,255,255,236,230,230,242,210,217,242,
            210,217,242,210,217,242,210,217,249,230,217,249,242,217,249,242,217,249,242,204,249,242,204,249,242,
            204,242,242,204,242,242,204,249,236,217,249,236,217,249,230,217,249,230,204,249,230,204,249,230,204,
            249,230,204,249,230,204,249,230,204,249,230,204,249,230,217,249,230,217,249,230,217,249,230,217,249,
            236,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,217,249,236,217,249,230,
            204,249,230,204,249,217,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,
            236,236,230,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,249,242,
            217,249,242,217,249,236,204,249,236,204,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,249,242,217,
            249,242,204,249,242,204,249,242,217,249,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,236,
            217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,249,236,204,
            249,236,204,249,236,204,249,230,217,249,230,217,242,223,217,242,223,217,249,217,217,249,217,217,249,
            217,217,249,217,217,249,217,217,242,210,217,249,210,217,249,210,217,249,210,217,249,210,217,242,210,
            204,249,210,217,249,210,217,242,210,217,242,210,217,242,210,217,242,210,217,249,210,217,249,217,217,
            249,217,217,249,223,217,249,223,217,249,217,217,249,230,204,249,230,204,249,236,204,249,236,204,249,
            242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,
            217,242,242,217,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,242,242,230,242,242,230,249,242,204,249,242,204,249,242,204,242,242,217,242,242,217,242,
            242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,249,242,217,249,242,204,249,242,
            204,249,242,217,249,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,236,217,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,249,236,204,249,236,204,249,236,
            204,249,230,217,249,230,217,242,223,217,242,223,217,249,217,217,249,217,217,249,217,217,249,217,217,
            249,217,217,242,210,217,249,210,217,249,210,217,249,210,217,249,210,217,242,210,204,249,210,217,249,
            210,217,242,210,217,242,210,217,242,210,217,242,210,217,249,210,217,249,217,217,249,217,217,249,223,
            217,249,223,217,249,217,217,249,230,204,249,230,204,249,236,204,249,236,204,249,242,217,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,217,242,242,217,242,
            242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,
            230,242,242,230,249,242,204,249,242,204,249,242,204,242,242,217,242,242,217,242,242,230,242,242,230,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,217,242,236,217,249,242,204,249,
            242,204,242,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,236,217,242,236,217,249,242,217,249,242,217,249,242,217,242,236,230,
            242,236,230,242,236,217,249,242,217,249,242,217,249,242,204,249,242,204,249,230,204,249,223,204,249,
            223,204,249,223,217,249,223,217,249,230,217,249,230,217,249,230,217,249,230,217,249,230,217,249,230,
            217,242,230,217,242,230,217,249,230,217,249,230,217,249,230,217,242,230,217,242,230,217,249,230,204,
            249,230,204,249,230,217,249,230,217,249,230,204,242,223,204,242,223,204,242,223,217,242,223,217,242,
            230,217,249,230,217,249,230,217,249,236,204,249,236,204,249,242,217,249,242,217,249,242,217,249,242,
            217,249,242,217,249,236,217,242,242,217,242,242,217,249,242,204,249,242,204,249,242,204,242,242,230,
            242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,249,
            242,204,249,242,204,249,242,204,236,236,217,236,236,217,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,242,236,217,242,236,217,249,242,204,249,242,204,242,236,217,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,236,217,242,236,217,249,242,217,249,242,217,249,242,217,242,236,230,242,236,230,242,236,
            217,249,242,217,249,242,217,249,242,204,249,242,204,249,230,204,249,223,204,249,223,204,249,223,217,
            249,223,217,249,230,217,249,230,217,249,230,217,249,230,217,249,230,217,249,230,217,242,230,217,242,
            230,217,249,230,217,249,230,217,249,230,217,242,230,217,242,230,217,249,230,204,249,230,204,249,230,
            217,249,230,217,249,230,204,242,223,204,242,223,204,242,223,217,242,223,217,242,230,217,249,230,217,
            249,230,217,249,236,204,249,236,204,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,
            236,217,242,242,217,242,242,217,249,242,204,249,242,204,249,242,204,242,242,230,242,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,249,242,204,249,242,204,
            249,242,204,236,236,217,236,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,236,236,230,236,236,230,242,242,230,242,242,230,249,242,204,249,242,204,249,242,
            204,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,236,236,230,
            236,236,230,249,242,217,223,217,204,223,217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,
            217,204,217,217,204,217,217,204,223,217,204,217,223,204,217,223,204,217,217,204,217,217,204,210,217,
            204,217,217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,217,204,
            217,217,204,217,210,204,217,223,204,217,223,204,242,236,204,242,236,204,249,242,204,249,242,204,242,
            242,204,223,223,204,223,223,204,217,210,204,217,210,204,217,217,204,217,210,204,217,210,204,217,217,
            204,217,217,204,217,210,204,217,210,204,217,210,204,217,210,204,217,210,204,217,210,204,217,217,204,
            217,217,204,223,223,204,223,223,204,242,236,217,242,236,230,242,236,230,242,242,230,242,242,230,135,
            207,163,242,242,230,242,242,230,249,242,204,249,242,204,249,242,217,242,242,230,242,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            236,236,230,236,236,230,242,242,230,242,242,230,249,242,204,249,242,204,249,242,204,242,242,230,242,
            242,230,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,236,236,230,236,236,230,249,242,
            217,223,217,204,223,217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,217,204,
            217,217,204,223,217,204,217,223,204,217,223,204,217,217,204,217,217,204,210,217,204,217,217,204,217,
            217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,217,204,217,210,
            204,217,223,204,217,223,204,242,236,204,242,236,204,249,242,204,249,242,204,242,242,204,223,223,204,
            223,223,204,217,210,204,217,210,204,217,217,204,217,210,204,217,210,204,217,217,204,217,217,204,217,
            210,204,217,210,204,217,210,204,217,210,204,217,210,204,217,210,204,217,217,204,217,217,204,223,223,
            204,223,223,204,242,236,217,242,236,230,242,236,230,242,242,230,242,242,230,135,207,163,242,242,230,
            242,242,230,249,242,204,249,242,204,249,242,217,242,242,230,242,242,230,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,242,204,249,242,204,249,242,204,249,242,217,249,242,217,242,242,217,
            242,242,217,236,236,217,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,217,210,204,217,
            210,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,217,210,204,217,210,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,210,204,217,
            210,204,217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,204,242,230,217,242,
            230,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,242,236,204,242,236,204,230,223,
            204,230,223,204,204,204,204,204,204,204,204,204,204,230,230,217,230,230,217,242,236,204,230,230,204,
            230,230,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,217,217,210,217,242,
            236,230,223,223,217,223,223,217,242,236,230,242,236,230,249,242,204,249,242,204,249,242,204,236,236,
            230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,236,230,242,236,230,242,236,230,249,242,204,249,242,204,249,242,204,249,242,204,242,236,
            230,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,223,210,204,223,210,204,230,210,217,
            230,210,217,230,210,217,236,217,204,236,217,204,242,223,217,242,223,217,217,210,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,223,204,217,223,204,217,230,204,
            217,204,204,204,204,204,204,210,217,204,210,217,204,242,236,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,236,204,249,236,204,249,242,204,249,249,204,249,249,204,236,236,217,236,236,217,204,
            204,204,230,223,204,230,223,204,242,236,204,242,236,204,217,217,204,230,236,217,230,236,217,230,230,
            204,230,230,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,236,236,230,255,255,255,
            255,255,255,242,242,217,242,242,217,249,242,204,249,242,217,249,242,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,230,
            242,236,230,242,236,230,249,242,204,249,242,204,249,242,204,249,242,204,242,236,230,255,255,255,255,
            255,255,255,255,255,255,255,255,242,236,217,223,210,204,223,210,204,230,210,217,230,210,217,230,210,
            217,236,217,204,236,217,204,242,223,217,242,223,217,217,210,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,223,204,217,223,204,217,230,204,217,204,204,204,204,
            204,204,210,217,204,210,217,204,242,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,
            204,249,236,204,249,242,204,249,249,204,249,249,204,236,236,217,236,236,217,204,204,204,230,223,204,
            230,223,204,242,236,204,242,236,204,217,217,204,230,236,217,230,236,217,230,230,204,230,230,204,204,
            204,204,204,204,204,204,204,204,217,210,204,217,210,204,236,236,230,255,255,255,255,255,255,242,242,
            217,242,242,217,249,242,204,249,242,217,249,242,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,242,242,217,242,242,217,249,242,217,249,242,217,242,236,217,255,255,255,255,255,255,255,255,255,
            255,255,255,242,236,217,204,204,204,204,204,204,223,223,204,223,223,204,249,236,217,249,242,204,249,
            242,204,249,242,217,249,242,217,255,255,255,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,230,210,204,223,204,217,223,204,217,223,210,204,
            223,210,204,249,242,204,249,242,204,249,242,204,249,236,217,249,236,217,249,242,204,249,242,204,249,
            242,217,249,242,204,249,242,204,236,230,217,236,230,217,217,210,204,242,242,217,242,242,217,230,223,
            204,230,223,204,217,210,204,223,217,204,223,217,204,236,230,217,236,230,217,204,204,204,204,204,204,
            204,204,204,217,217,204,217,217,204,242,242,230,242,242,230,242,242,230,242,242,217,242,242,217,236,
            236,230,255,255,255,255,255,255,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,217,242,
            242,217,249,242,217,249,242,217,242,236,217,255,255,255,255,255,255,255,255,255,255,255,255,242,236,
            217,204,204,204,204,204,204,223,223,204,223,223,204,249,236,217,249,242,204,249,242,204,249,242,217,
            249,242,217,255,255,255,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,230,210,204,223,204,217,223,204,217,223,210,204,223,210,204,249,242,
            204,249,242,204,249,242,204,249,236,217,249,236,217,249,242,204,249,242,204,249,242,217,249,242,204,
            249,242,204,236,230,217,236,230,217,217,210,204,242,242,217,242,242,217,230,223,204,230,223,204,217,
            210,204,223,217,204,223,217,204,236,230,217,236,230,217,204,204,204,204,204,204,204,204,204,217,217,
            204,217,217,204,242,242,230,242,242,230,242,242,230,242,242,217,242,242,217,236,236,230,255,255,255,
            255,255,255,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,255,255,255,255,255,255,236,236,230,
            236,236,230,249,242,217,242,242,217,242,242,217,236,236,230,236,236,230,249,236,217,217,210,204,217,
            210,204,223,217,204,223,217,204,249,242,204,249,242,204,249,242,204,242,236,204,242,236,204,217,210,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,217,210,204,217,210,204,217,210,204,
            217,210,204,217,210,204,230,204,204,230,204,204,230,204,204,230,204,204,223,217,204,236,223,217,236,
            223,217,249,242,204,249,242,204,249,242,204,249,242,204,249,236,217,249,242,204,249,242,204,236,230,
            204,236,230,204,217,210,204,242,236,217,242,236,217,249,236,204,249,236,204,249,242,204,236,230,204,
            236,230,204,236,230,204,236,230,204,217,210,204,204,204,204,204,204,204,217,217,204,217,217,204,249,
            242,217,249,242,204,249,242,204,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,242,242,
            230,242,242,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,236,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,230,
            217,249,242,217,249,242,217,249,242,204,249,242,204,242,236,204,217,210,204,217,210,204,230,217,204,
            230,217,204,249,242,217,249,242,204,249,242,204,249,242,204,249,242,204,223,223,204,217,210,204,217,
            210,204,204,204,204,204,204,204,204,204,204,236,230,204,236,230,204,249,249,217,249,249,217,236,230,
            204,230,230,204,230,230,204,236,230,217,236,230,217,204,204,204,210,217,204,210,217,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,217,249,242,204,249,242,204,242,242,204,242,242,204,217,
            217,204,230,223,204,230,223,204,249,242,217,249,242,217,255,255,255,223,217,204,223,217,204,217,217,
            204,217,217,204,204,204,204,204,204,204,204,204,204,217,217,204,217,217,204,249,242,217,236,236,230,
            236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,
            236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,217,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,230,217,249,242,217,249,
            242,217,249,242,204,249,242,204,242,236,204,217,210,204,217,210,204,230,217,204,230,217,204,249,242,
            217,249,242,204,249,242,204,249,242,204,249,242,204,223,223,204,217,210,204,217,210,204,204,204,204,
            204,204,204,204,204,204,236,230,204,236,230,204,249,249,217,249,249,217,236,230,204,230,230,204,230,
            230,204,236,230,217,236,230,217,204,204,204,210,217,204,210,217,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,217,249,242,204,249,242,204,242,242,204,242,242,204,217,217,204,230,223,204,
            230,223,204,249,242,217,249,242,217,255,255,255,223,217,204,223,217,204,217,217,204,217,217,204,204,
            204,204,204,204,204,204,204,204,217,217,204,217,217,204,249,242,217,236,236,230,236,236,230,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,217,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,230,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,242,217,
            249,242,217,249,236,217,230,210,204,230,210,204,242,223,217,242,223,217,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,242,236,217,242,236,217,230,223,204,230,223,204,217,210,
            204,223,223,217,223,223,217,230,230,204,230,230,204,249,249,217,249,242,204,249,242,204,249,242,217,
            249,242,217,236,230,204,230,223,204,230,223,204,249,242,217,249,242,217,249,242,204,249,242,204,249,
            242,204,249,242,217,249,242,217,242,236,204,242,236,204,217,210,204,217,217,204,217,217,204,242,236,
            204,242,236,204,204,204,204,217,217,217,217,217,217,217,210,204,217,210,204,204,204,204,210,204,217,
            210,204,217,217,210,204,217,210,204,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,242,242,242,242,242,242,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,249,242,230,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,242,217,249,242,217,249,236,
            217,230,210,204,230,210,204,242,223,217,242,223,217,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,242,236,217,242,236,217,230,223,204,230,223,204,217,210,204,223,223,217,223,
            223,217,230,230,204,230,230,204,249,249,217,249,242,204,249,242,204,249,242,217,249,242,217,236,230,
            204,230,223,204,230,223,204,249,242,217,249,242,217,249,242,204,249,242,204,249,242,204,249,242,217,
            249,242,217,242,236,204,242,236,204,217,210,204,217,217,204,217,217,204,242,236,204,242,236,204,204,
            204,204,217,217,217,217,217,217,217,210,204,217,210,204,204,204,204,210,204,217,210,204,217,217,210,
            204,217,210,204,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,242,242,230,242,242,242,242,242,242,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,236,236,230,236,236,230,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,242,236,230,242,236,230,249,242,217,249,242,217,249,236,204,217,210,204,217,
            210,204,217,210,204,217,210,204,230,223,204,249,242,217,249,242,217,249,242,204,249,242,204,249,242,
            204,249,242,217,249,242,217,249,249,217,249,249,217,242,242,204,230,223,204,230,223,204,223,210,204,
            223,210,204,242,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,
            242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,236,
            204,242,236,204,204,204,204,217,210,204,217,210,204,236,230,217,236,230,217,217,210,204,223,223,204,
            223,223,204,217,210,204,217,210,204,223,223,217,217,217,204,217,217,204,223,217,204,223,217,204,242,
            236,217,255,255,255,255,255,255,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,236,236,230,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,
            242,230,236,236,230,242,242,217,242,242,217,255,255,255,255,255,255,255,255,255,255,255,255,242,236,
            230,249,249,217,249,249,217,242,242,217,242,242,217,249,236,217,210,210,217,210,210,217,204,204,204,
            204,204,204,255,255,255,236,230,204,236,230,204,236,230,204,236,230,204,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,242,236,204,242,236,204,242,236,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,204,249,236,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,236,217,242,236,217,217,
            210,204,217,210,204,217,210,204,255,255,255,255,255,255,223,223,204,217,210,204,217,210,204,223,223,
            204,223,223,204,217,217,204,204,204,204,204,204,204,217,217,204,217,217,204,242,236,217,255,255,255,
            255,255,255,249,249,230,249,249,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,
            242,230,249,249,230,249,249,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,236,236,230,
            242,242,217,242,242,217,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,249,249,217,249,
            249,217,242,242,217,242,242,217,249,236,217,210,210,217,210,210,217,204,204,204,204,204,204,255,255,
            255,236,230,204,236,230,204,236,230,204,236,230,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,217,249,242,217,242,236,204,242,236,204,242,236,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,236,204,249,236,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,242,236,217,242,236,217,217,210,204,217,210,204,
            217,210,204,255,255,255,255,255,255,223,223,204,217,210,204,217,210,204,223,223,204,223,223,204,217,
            217,204,204,204,204,204,204,204,217,217,204,217,217,204,242,236,217,255,255,255,255,255,255,249,249,
            230,249,249,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,242,230,249,249,230,
            249,249,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,242,236,217,249,242,217,249,242,
            217,236,236,230,236,236,230,255,255,255,255,255,255,236,242,217,236,236,230,236,236,230,255,255,255,
            255,255,255,242,236,217,204,204,204,204,204,204,204,204,204,204,204,204,223,217,204,223,217,204,223,
            217,204,236,230,204,236,230,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,204,249,236,204,249,
            242,204,242,236,204,242,236,204,223,223,204,223,223,204,217,210,204,204,204,204,204,204,204,255,255,
            255,255,255,255,223,223,217,217,210,204,217,210,204,236,230,217,236,230,217,204,204,204,204,204,204,
            204,204,204,217,217,204,217,217,204,242,236,230,255,255,255,255,255,255,242,242,230,242,242,230,242,
            236,230,255,255,255,255,255,255,255,255,255,255,255,255,249,242,217,249,249,217,249,249,217,242,242,
            217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,242,236,217,249,242,217,249,242,217,236,236,230,236,
            236,230,255,255,255,255,255,255,236,242,217,236,236,230,236,236,230,255,255,255,255,255,255,242,236,
            217,204,204,204,204,204,204,204,204,204,204,204,204,223,217,204,223,217,204,223,217,204,236,230,204,
            236,230,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,204,249,236,204,249,242,204,242,236,204,
            242,236,204,223,223,204,223,223,204,217,210,204,204,204,204,204,204,204,255,255,255,255,255,255,223,
            223,217,217,210,204,217,210,204,236,230,217,236,230,217,204,204,204,204,204,204,204,204,204,217,217,
            204,217,217,204,242,236,230,255,255,255,255,255,255,242,242,230,242,242,230,242,236,230,255,255,255,
            255,255,255,255,255,255,255,255,255,249,242,217,249,249,217,249,249,217,242,242,217,242,242,217,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,249,230,249,249,
            230,249,249,230,249,249,230,249,242,230,249,242,217,249,242,217,242,236,217,242,236,217,242,242,230,
            242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,223,223,217,223,223,217,236,230,204,236,230,204,236,230,
            204,249,242,217,249,242,217,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,249,242,217,
            249,242,217,249,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,223,217,204,223,217,204,204,204,
            204,204,204,204,204,204,204,217,210,204,217,210,204,236,236,217,236,236,217,217,210,204,230,230,217,
            230,230,217,217,210,204,217,210,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,242,
            242,230,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,236,236,230,236,236,230,242,236,
            230,242,236,230,249,242,217,242,242,230,242,242,230,242,242,230,242,242,230,242,242,230,242,242,230,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,236,236,217,236,236,217,249,242,204,249,242,204,249,242,230,249,242,230,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,255,255,255,217,217,204,217,
            217,204,230,223,204,230,223,204,236,223,204,242,230,217,242,230,217,242,230,204,242,230,204,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,217,249,242,217,249,242,204,223,217,204,223,217,204,255,255,255,255,255,255,230,
            223,204,230,230,217,230,230,217,230,230,204,230,230,204,217,210,204,230,223,204,230,223,204,217,210,
            204,217,210,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,236,236,217,255,255,255,
            255,255,255,255,255,255,255,255,255,236,236,230,242,242,230,242,242,230,242,242,204,242,242,204,242,
            242,217,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            236,236,217,236,236,217,249,242,204,249,242,204,249,242,230,249,242,230,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,242,236,230,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,255,255,255,217,217,204,217,217,204,230,223,204,
            230,223,204,236,223,204,242,230,217,242,230,217,242,230,204,242,230,204,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            217,249,242,217,249,242,204,223,217,204,223,217,204,255,255,255,255,255,255,230,223,204,230,230,217,
            230,230,217,230,230,204,230,230,204,217,210,204,230,223,204,230,223,204,217,210,204,217,210,204,204,
            204,204,204,204,204,204,204,204,217,210,204,217,210,204,236,236,217,255,255,255,255,255,255,255,255,
            255,255,255,255,236,236,230,242,242,230,242,242,230,242,242,204,242,242,204,242,242,217,255,255,255,
            255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,242,242,230,242,242,230,249,242,230,249,242,230,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,242,236,217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,210,217,204,217,210,204,217,210,204,217,210,204,217,210,204,236,223,
            217,242,236,204,242,236,204,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,236,230,204,236,230,204,242,242,217,242,242,217,236,236,204,249,242,217,249,242,217,217,217,
            204,217,217,204,230,223,204,217,217,204,217,217,204,230,230,217,230,230,217,217,217,204,204,204,204,
            204,204,204,217,217,204,217,217,204,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,236,
            236,230,242,242,217,242,242,217,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,
            242,230,249,242,230,249,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,
            217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,210,217,204,217,210,204,217,210,204,217,210,204,217,210,204,236,223,217,242,236,204,242,
            236,204,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,236,230,204,
            236,230,204,242,242,217,242,242,217,236,236,204,249,242,217,249,242,217,217,217,204,217,217,204,230,
            223,204,217,217,204,217,217,204,230,230,217,230,230,217,217,217,204,204,204,204,204,204,204,217,217,
            204,217,217,204,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,242,242,217,
            242,242,217,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,
            242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,236,236,230,236,236,
            230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,236,236,230,
            236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,255,255,255,255,255,255,249,249,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,217,249,242,217,249,242,217,249,242,217,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,236,236,204,236,236,204,223,217,
            204,223,217,204,217,210,204,249,236,204,249,236,204,223,217,204,223,217,204,230,230,217,223,217,204,
            223,217,204,255,255,255,255,255,255,217,210,204,204,204,204,204,204,204,217,217,204,217,217,204,236,
            236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,242,242,230,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,242,236,230,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,242,249,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,217,204,217,217,204,217,217,210,204,
            217,210,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,223,223,204,223,
            223,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,217,249,242,217,249,242,217,249,242,217,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,217,249,242,217,249,242,204,242,236,204,242,236,204,204,204,204,204,204,204,217,
            217,204,242,242,217,242,242,217,223,217,204,223,217,204,217,217,217,223,210,204,223,210,204,242,236,
            204,242,236,204,217,210,204,204,204,204,204,204,204,217,217,204,217,217,204,242,236,217,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,242,242,230,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,242,242,230,242,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,249,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,242,236,217,217,204,217,217,204,217,217,210,204,217,210,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,223,223,204,223,223,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,
            242,217,249,242,217,249,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            217,249,242,217,249,242,204,242,236,204,242,236,204,204,204,204,204,204,204,217,217,204,242,242,217,
            242,242,217,223,217,204,223,217,204,217,217,217,223,210,204,223,210,204,242,236,204,242,236,204,217,
            210,204,204,204,204,204,204,204,217,217,204,217,217,204,242,236,217,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,242,242,230,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,242,242,230,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,242,236,217,223,210,204,223,210,204,255,255,255,255,255,255,242,230,217,210,217,204,210,
            217,204,204,204,204,204,204,204,236,223,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,249,
            242,204,236,230,217,236,230,217,204,204,204,204,204,204,217,217,204,249,249,217,249,249,217,242,230,
            204,242,230,204,255,255,255,217,210,204,217,210,204,242,242,204,242,242,204,217,217,204,204,204,204,
            204,204,204,223,217,204,223,217,204,242,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,242,236,230,242,236,230,242,236,217,242,236,217,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,230,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,
            242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,
            217,223,210,204,223,210,204,255,255,255,255,255,255,242,230,217,210,217,204,210,217,204,204,204,204,
            204,204,204,236,223,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,249,242,204,236,230,217,
            236,230,217,204,204,204,204,204,204,217,217,204,249,249,217,249,249,217,242,230,204,242,230,204,255,
            255,255,217,210,204,217,210,204,242,242,204,242,242,204,217,217,204,204,204,204,204,204,204,223,217,
            204,223,217,204,242,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,
            242,236,230,242,236,217,242,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,236,236,230,236,236,
            230,242,249,230,242,249,230,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,217,210,204,217,
            210,204,230,217,204,230,217,204,249,249,217,230,223,204,230,223,204,223,217,204,223,217,204,249,242,
            217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,230,223,204,
            230,223,204,236,230,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,204,249,
            236,204,249,242,204,249,242,204,249,236,204,249,236,204,249,242,204,230,223,204,230,223,204,204,204,
            204,204,204,204,204,204,204,236,236,204,236,236,204,249,249,217,249,249,217,249,242,217,236,230,204,
            236,230,204,230,230,217,230,230,217,210,217,204,204,204,204,204,204,204,223,210,204,223,210,204,249,
            242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,
            230,242,242,230,255,255,255,242,242,230,242,242,230,236,236,230,236,236,230,242,242,230,242,242,230,
            249,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,242,242,217,242,242,217,242,242,217,242,242,217,242,
            242,217,236,242,217,236,236,230,236,236,230,242,236,230,242,236,230,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,236,210,204,236,210,204,249,236,217,
            249,236,217,249,242,204,249,236,204,249,236,204,249,236,217,249,236,217,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,223,223,204,223,223,204,204,204,204,204,204,204,204,204,
            204,230,223,204,230,223,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,204,
            249,236,204,249,242,217,249,242,217,249,242,204,242,242,217,242,242,217,217,217,204,217,217,204,204,
            204,204,204,204,204,204,204,204,255,255,255,255,255,255,249,242,204,249,236,217,249,236,217,217,210,
            204,217,210,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,249,242,217,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,236,
            236,230,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,249,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,242,217,242,242,217,242,242,217,242,242,217,242,242,217,236,242,217,
            236,236,230,236,236,230,242,236,230,242,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,242,236,217,236,210,204,236,210,204,249,236,217,249,236,217,249,242,
            204,249,236,204,249,236,204,249,236,217,249,236,217,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,223,223,204,223,223,204,204,204,204,204,204,204,204,204,204,230,223,204,230,
            223,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,204,249,236,204,249,242,
            217,249,242,217,249,242,204,242,242,217,242,242,217,217,217,204,217,217,204,204,204,204,204,204,204,
            204,204,204,255,255,255,255,255,255,249,242,204,249,236,217,249,236,217,217,210,204,217,210,204,204,
            204,204,204,204,204,204,204,204,217,210,204,217,210,204,249,242,217,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,236,236,230,249,242,217,
            249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,249,230,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,249,242,217,249,242,204,249,242,204,242,242,230,242,242,230,242,242,230,249,242,217,249,242,
            217,249,242,217,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,242,236,217,223,217,204,223,217,204,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,249,217,249,249,217,249,242,204,249,242,204,249,242,204,242,230,204,242,230,204,217,217,
            204,204,204,204,204,204,204,204,204,204,204,204,204,223,223,204,236,230,204,236,230,204,242,236,204,
            242,236,204,249,242,217,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,217,249,242,204,249,242,204,242,242,204,242,242,204,217,217,204,204,204,204,204,204,204,204,204,
            204,204,204,204,217,210,204,249,236,217,249,236,217,242,236,217,242,236,217,230,223,204,204,204,204,
            204,204,204,223,217,204,223,217,204,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,242,242,230,242,242,230,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,
            217,249,242,217,249,242,230,249,242,230,249,242,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,
            249,242,204,249,242,204,242,242,230,242,242,230,242,242,230,249,242,217,249,242,217,249,242,217,249,
            242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,
            217,223,217,204,223,217,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,249,217,
            249,249,217,249,242,204,249,242,204,249,242,204,242,230,204,242,230,204,217,217,204,204,204,204,204,
            204,204,204,204,204,204,204,204,223,223,204,236,230,204,236,230,204,242,236,204,242,236,204,249,242,
            217,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,242,204,
            249,242,204,242,242,204,242,242,204,217,217,204,204,204,204,204,204,204,204,204,204,204,204,204,217,
            210,204,249,236,217,249,236,217,242,236,217,242,236,217,230,223,204,204,204,204,204,204,204,223,217,
            204,223,217,204,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,
            242,242,230,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,
            242,230,249,242,230,249,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,249,230,249,249,217,249,249,
            217,242,242,217,242,242,217,242,242,217,249,242,217,249,242,217,249,242,217,249,242,217,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,217,210,204,217,
            210,204,230,217,204,230,217,204,242,223,204,249,242,204,249,242,204,242,230,204,242,230,204,236,230,
            217,236,230,204,236,230,204,217,217,204,217,217,204,230,223,204,217,210,204,217,210,204,236,230,217,
            236,230,217,249,249,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,
            242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,242,242,204,223,217,204,223,217,204,217,210,204,217,210,204,217,210,204,242,236,204,
            242,236,204,249,242,204,249,242,204,236,230,217,204,204,204,204,204,204,217,217,204,217,217,204,242,
            242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,242,236,217,242,249,
            217,242,249,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,
            242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,249,249,230,249,249,217,249,249,217,242,242,217,242,
            242,217,242,242,217,249,242,217,249,242,217,249,242,217,249,242,217,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,217,210,204,217,210,204,230,217,204,
            230,217,204,242,223,204,249,242,204,249,242,204,242,230,204,242,230,204,236,230,217,236,230,204,236,
            230,204,217,217,204,217,217,204,230,223,204,217,210,204,217,210,204,236,230,217,236,230,217,249,249,
            217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,
            242,204,223,217,204,223,217,204,217,210,204,217,210,204,217,210,204,242,236,204,242,236,204,249,242,
            204,249,242,204,236,230,217,204,204,204,204,204,204,217,217,204,217,217,204,242,242,217,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,242,236,217,242,249,217,242,249,217,249,
            242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,242,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,249,249,217,242,242,217,242,242,217,242,249,217,242,249,217,242,242,230,
            242,236,230,242,236,230,249,242,230,249,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,242,236,217,217,210,204,217,210,204,204,204,204,204,204,204,204,204,
            204,217,217,204,217,217,204,204,204,204,204,204,204,204,204,204,236,230,204,236,230,204,236,230,217,
            236,230,217,249,242,204,242,236,204,242,236,204,242,236,217,242,236,217,249,242,217,249,242,204,249,
            242,204,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,236,204,249,236,204,249,242,204,249,242,204,249,242,204,249,242,217,
            249,242,217,242,236,217,242,236,217,236,230,204,249,242,217,249,242,217,249,236,204,249,236,204,223,
            223,217,204,204,204,204,204,204,217,210,204,217,210,204,249,242,217,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,236,236,230,236,236,230,242,242,230,242,242,230,255,255,255,249,249,217,
            249,249,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,230,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,230,242,242,230,242,242,230,242,242,230,
            242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,
            242,230,249,249,230,236,230,230,236,230,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,242,242,230,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,249,242,217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,217,210,204,236,230,204,236,230,204,242,236,204,242,236,204,249,242,
            204,249,249,204,249,249,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,
            249,242,217,249,236,217,249,242,204,249,242,204,249,242,217,249,242,217,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,242,236,204,242,236,204,249,236,
            204,249,236,204,249,242,204,242,230,204,242,230,204,230,223,204,230,223,204,204,204,204,204,204,204,
            204,204,204,223,210,204,223,210,204,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,242,236,230,242,236,230,255,255,255,236,230,230,236,230,230,255,255,
            255,255,255,255,236,236,230,236,236,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,249,249,230,
            236,230,230,236,230,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,242,
            242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,242,
            217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,217,210,204,236,230,204,236,230,204,242,236,204,242,236,204,249,242,204,249,249,204,249,
            249,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,249,236,
            217,249,242,204,249,242,204,249,242,217,249,242,217,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,217,242,236,204,242,236,204,249,236,204,249,236,204,249,
            242,204,242,230,204,242,230,204,230,223,204,230,223,204,204,204,204,204,204,204,204,204,204,223,210,
            204,223,210,204,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,242,236,230,242,236,230,255,255,255,236,230,230,236,230,230,255,255,255,255,255,255,236,
            236,230,236,236,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,236,249,230,242,242,230,242,242,230,242,242,230,242,242,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,217,242,242,217,242,242,230,
            242,242,230,255,255,255,217,236,242,217,236,242,255,255,255,255,255,255,242,242,217,217,210,204,217,
            210,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,230,223,204,230,223,204,249,242,204,249,236,217,249,236,217,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,230,223,204,236,236,217,236,
            236,217,249,249,217,249,249,217,242,236,204,242,236,204,249,236,204,249,242,204,249,242,204,249,242,
            217,249,242,217,249,242,204,242,236,204,242,236,204,223,210,204,223,210,204,242,236,217,230,223,204,
            230,223,204,255,255,255,255,255,255,204,204,204,204,204,204,204,204,204,217,217,204,217,217,204,242,
            242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,242,242,230,249,242,
            217,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,249,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,236,249,230,242,242,230,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,242,242,217,242,242,217,242,242,230,242,242,230,255,255,
            255,217,236,242,217,236,242,255,255,255,255,255,255,242,242,217,217,210,204,217,210,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,230,223,204,230,223,204,249,242,204,249,236,217,249,236,217,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,230,223,204,236,236,217,236,236,217,249,249,217,
            249,249,217,242,236,204,242,236,204,249,236,204,249,242,204,249,242,204,249,242,217,249,242,217,249,
            242,204,242,236,204,242,236,204,223,210,204,223,210,204,242,236,217,230,223,204,230,223,204,255,255,
            255,255,255,255,204,204,204,204,204,204,204,204,204,217,217,204,217,217,204,242,242,230,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,242,242,230,249,242,217,249,242,217,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,249,242,230,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,236,236,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,236,217,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,236,236,230,236,236,230,236,236,230,236,236,230,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,242,236,217,217,217,204,217,217,204,204,204,204,204,204,204,204,204,
            204,217,210,204,217,210,204,230,204,204,230,204,204,230,210,204,217,210,204,217,210,204,223,230,217,
            223,230,217,223,223,204,223,217,204,223,217,204,249,242,217,249,242,217,249,242,204,249,242,204,249,
            242,204,249,242,217,249,242,217,223,217,204,217,210,204,217,210,204,255,255,255,255,255,255,223,210,
            217,223,210,217,242,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,223,217,204,223,217,204,230,223,204,230,223,204,230,223,204,236,230,204,236,230,204,255,
            255,255,204,204,204,204,204,204,217,217,204,217,217,204,236,236,217,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,249,249,230,249,249,230,242,242,217,242,242,217,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,236,236,230,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,242,236,217,242,236,217,249,236,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,236,217,242,236,217,242,236,217,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,242,230,242,242,230,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,242,236,230,223,217,204,223,217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,230,204,204,230,204,204,249,236,204,242,236,217,242,236,217,217,217,204,217,217,204,210,217,
            204,204,204,204,204,204,204,236,230,204,236,230,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,230,230,204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,204,249,249,204,249,249,204,236,230,
            204,236,230,204,223,217,204,242,236,204,242,236,204,249,242,204,249,242,204,230,223,204,204,204,204,
            204,204,204,217,217,204,217,217,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,242,242,230,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,
            230,217,249,230,217,249,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,236,217,242,236,217,242,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,
            242,242,230,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,
            230,223,217,204,223,217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,230,204,204,
            230,204,204,249,236,204,242,236,217,242,236,217,217,217,204,217,217,204,210,217,204,204,204,204,204,
            204,204,236,230,204,236,230,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,230,230,
            204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,236,204,249,249,204,249,249,204,236,230,204,236,230,204,223,
            217,204,242,236,204,242,236,204,249,242,204,249,242,204,230,223,204,204,204,204,204,204,204,217,217,
            204,217,217,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,
            242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,
            242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,230,217,249,230,217,
            249,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,223,217,
            242,230,217,242,230,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,
            230,255,255,255,255,255,255,255,255,255,236,236,217,236,236,217,236,236,217,236,236,217,242,242,217,
            242,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,223,223,204,223,
            223,204,204,204,204,204,204,204,204,204,204,223,210,204,223,210,204,236,230,204,236,230,204,249,249,
            204,249,236,204,249,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,204,
            217,210,204,242,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,217,210,204,217,
            210,204,204,204,204,204,204,204,230,223,204,230,223,204,249,249,217,249,242,217,249,242,217,249,242,
            217,249,242,217,249,242,204,249,242,204,249,242,204,242,236,204,242,236,204,236,223,204,249,242,204,
            249,242,204,249,249,217,249,249,217,242,236,204,217,210,204,217,210,204,217,217,204,217,217,204,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,230,236,217,230,236,217,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,242,236,230,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,217,217,249,217,217,249,223,217,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,223,217,242,230,217,242,230,
            217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,255,255,255,255,
            255,255,255,255,255,236,236,217,236,236,217,236,236,217,236,236,217,242,242,217,242,242,217,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,223,223,204,223,223,204,204,204,204,
            204,204,204,204,204,204,223,210,204,223,210,204,236,230,204,236,230,204,249,249,204,249,236,204,249,
            236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,242,236,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,217,210,204,217,210,204,204,204,204,
            204,204,204,230,223,204,230,223,204,249,249,217,249,242,217,249,242,217,249,242,217,249,242,217,249,
            242,204,249,242,204,249,242,204,242,236,204,242,236,204,236,223,204,249,242,204,249,242,204,249,249,
            217,249,249,217,242,236,204,217,210,204,217,210,204,217,217,204,217,217,204,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,230,236,217,230,236,217,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,242,236,230,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,249,217,217,249,217,217,249,223,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,242,217,217,249,223,217,249,223,217,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,236,236,230,236,236,230,249,242,204,
            242,242,217,242,242,217,242,242,217,242,242,217,242,242,230,242,242,230,236,236,230,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,236,230,217,236,230,217,204,204,204,204,204,204,223,210,
            217,242,223,217,242,223,217,249,249,204,249,249,204,249,242,204,249,236,204,249,236,204,223,217,204,
            223,217,204,217,210,204,230,223,204,230,223,204,242,236,217,242,236,217,249,249,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,249,204,236,230,204,236,230,204,236,230,204,236,230,204,242,236,
            204,242,236,204,249,242,204,236,230,204,236,230,204,230,223,204,230,223,204,242,236,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,236,204,242,236,204,242,
            236,204,217,210,204,217,210,204,230,230,217,230,230,217,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,249,242,230,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,236,236,230,
            236,236,230,255,255,255,255,255,255,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,
            230,242,242,230,249,217,204,249,217,204,249,223,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,249,217,217,249,217,217,249,217,217,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,249,242,217,242,236,230,242,236,
            230,236,236,230,236,236,230,242,236,230,242,236,230,242,242,217,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,236,236,217,236,236,217,223,210,204,223,210,204,204,204,204,217,210,204,217,
            210,204,236,230,204,236,230,204,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,236,
            204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,236,204,249,236,204,249,242,217,
            249,242,217,249,242,204,230,217,204,230,217,204,242,236,217,242,236,217,236,236,204,236,236,204,217,
            217,204,217,217,204,217,217,204,204,204,204,204,204,204,217,217,204,223,217,204,223,217,204,249,242,
            217,249,242,217,249,242,204,249,242,204,249,242,204,236,230,204,236,230,204,217,217,204,217,210,204,
            217,210,204,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,
            242,230,236,236,230,236,236,230,236,230,230,236,230,230,242,242,217,242,236,230,242,236,230,236,236,
            230,236,236,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,230,217,242,230,217,249,
            210,217,249,210,217,242,217,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,249,217,217,249,217,217,249,217,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,249,242,217,242,236,230,242,236,230,236,236,230,236,
            236,230,242,236,230,242,236,230,242,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,236,236,217,236,236,217,223,210,204,223,210,204,204,204,204,217,210,204,217,210,204,236,230,204,
            236,230,204,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,236,204,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,204,249,236,204,249,236,204,249,242,217,249,242,217,249,242,
            204,230,217,204,230,217,204,242,236,217,242,236,217,236,236,204,236,236,204,217,217,204,217,217,204,
            217,217,204,204,204,204,204,204,204,217,217,204,223,217,204,223,217,204,249,242,217,249,242,217,249,
            242,204,249,242,204,249,242,204,236,230,204,236,230,204,217,217,204,217,210,204,217,210,204,236,236,
            230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,236,236,230,
            236,236,230,236,230,230,236,230,230,242,242,217,242,236,230,242,236,230,236,236,230,236,236,230,242,
            242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,242,230,217,242,230,217,249,210,217,249,210,217,
            242,217,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,242,217,217,
            249,217,217,249,217,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,
            230,249,242,217,249,242,217,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,242,242,230,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,230,230,204,230,230,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,249,236,
            217,249,242,217,249,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,236,204,204,204,204,204,
            204,204,217,210,204,217,210,204,223,217,204,223,217,204,204,204,204,217,210,204,217,210,204,242,236,
            217,242,236,217,249,242,217,236,230,217,236,230,217,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,236,230,217,236,230,217,204,204,204,223,223,217,223,223,217,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,242,242,
            230,242,242,230,242,236,217,249,242,217,249,242,217,249,249,217,249,249,217,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,242,230,217,249,217,217,249,217,217,242,210,217,242,210,217,249,223,217,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,242,217,217,249,217,217,249,217,
            217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,249,242,217,249,
            242,217,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,
            230,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,230,230,204,
            230,230,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,249,236,217,249,242,217,249,
            242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,204,249,242,204,249,242,204,242,236,204,204,204,204,204,204,204,217,210,204,
            217,210,204,223,217,204,223,217,204,204,204,204,217,210,204,217,210,204,242,236,217,242,236,217,249,
            242,217,236,230,217,236,230,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,236,230,
            217,236,230,217,204,204,204,223,223,217,223,223,217,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,242,
            236,217,249,242,217,249,242,217,249,249,217,249,249,217,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            242,230,217,249,217,217,249,217,217,242,210,217,242,210,217,249,223,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,236,236,230,236,236,230,242,217,217,242,217,217,242,217,217,236,230,217,236,
            230,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,242,242,217,242,242,217,236,236,230,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,242,242,217,242,
            242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,223,217,
            204,204,204,204,204,204,204,223,210,204,223,210,204,242,217,217,249,236,204,249,236,204,249,242,204,
            249,242,204,249,236,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,230,230,217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,217,210,204,230,217,204,230,217,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,217,236,230,204,236,230,204,217,210,204,217,210,204,217,
            210,204,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,249,242,
            217,249,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,217,
            242,242,217,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,242,223,204,249,204,
            217,249,204,217,249,210,217,249,210,217,249,223,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,223,204,249,210,217,249,210,217,242,217,217,242,217,217,249,230,230,
            242,236,230,242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,242,242,230,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,242,217,217,217,204,217,
            217,204,204,204,204,204,204,204,217,210,204,255,255,255,255,255,255,236,236,204,236,236,204,230,223,
            204,242,242,204,242,242,204,242,236,204,242,236,204,249,249,217,242,236,204,242,236,204,236,230,204,
            236,230,204,236,236,217,217,210,204,217,210,204,204,204,204,204,204,204,204,204,204,204,204,204,210,
            204,217,223,210,204,223,210,204,236,217,204,236,217,204,249,236,217,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,217,230,223,204,230,223,204,204,204,204,204,204,204,230,230,217,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,236,236,217,236,236,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,249,236,217,249,236,217,242,217,217,242,217,217,242,210,217,242,210,217,242,210,217,249,
            210,217,249,210,217,249,230,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,223,204,249,210,217,249,210,217,242,217,217,242,217,217,249,230,230,242,236,230,242,236,
            230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,242,242,230,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,236,242,217,217,217,204,217,217,204,204,204,204,
            204,204,204,217,210,204,255,255,255,255,255,255,236,236,204,236,236,204,230,223,204,242,242,204,242,
            242,204,242,236,204,242,236,204,249,249,217,242,236,204,242,236,204,236,230,204,236,230,204,236,236,
            217,217,210,204,217,210,204,204,204,204,204,204,204,204,204,204,204,204,204,210,204,217,223,210,204,
            223,210,204,236,217,204,236,217,204,249,236,217,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,217,230,223,204,230,223,204,204,204,204,204,204,204,230,230,217,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,236,236,217,236,236,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,236,
            217,249,236,217,242,217,217,242,217,217,242,210,217,242,210,217,242,210,217,249,210,217,249,210,217,
            249,230,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,236,230,
            249,217,204,249,217,204,249,210,217,249,210,217,242,210,217,242,223,217,242,223,217,242,236,217,242,
            236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,236,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,242,236,230,242,236,230,242,242,217,242,242,217,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,249,236,230,242,236,204,242,236,204,223,217,204,223,217,204,204,204,
            204,210,217,204,210,217,204,217,217,204,217,217,204,223,223,204,255,255,255,255,255,255,217,210,204,
            217,210,204,236,230,204,230,223,204,230,223,204,204,204,204,204,204,204,217,210,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,223,210,
            204,223,210,204,242,217,217,249,236,217,249,236,217,242,242,204,242,242,204,236,230,204,217,217,204,
            217,217,204,230,223,204,230,223,204,236,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,249,242,230,249,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,236,236,230,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,230,230,242,217,217,242,217,217,249,
            210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,217,217,242,230,
            217,242,230,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,236,230,249,217,204,249,217,
            204,249,210,217,249,210,217,242,210,217,242,223,217,242,223,217,242,236,217,242,236,217,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,236,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,242,236,230,242,236,230,242,242,217,242,242,217,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,249,236,230,242,236,204,242,236,204,223,217,204,223,217,204,204,204,204,210,217,204,210,
            217,204,217,217,204,217,217,204,223,223,204,255,255,255,255,255,255,217,210,204,217,210,204,236,230,
            204,230,223,204,230,223,204,204,204,204,204,204,204,217,210,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,223,210,204,223,210,204,242,
            217,217,249,236,217,249,236,217,242,242,204,242,242,204,236,230,204,217,217,204,217,217,204,230,223,
            204,230,223,204,236,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,242,230,
            249,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,
            236,230,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,242,230,230,242,217,217,242,217,217,249,210,217,249,210,217,
            249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,217,217,242,230,217,242,230,217,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,249,236,230,249,223,204,249,223,204,249,210,217,249,
            210,217,249,210,217,242,210,204,242,210,204,242,217,217,242,217,217,242,236,217,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            242,242,230,242,242,230,249,242,230,249,242,230,249,249,230,249,249,230,242,242,230,249,242,230,249,
            242,230,249,242,217,249,242,217,249,242,204,236,236,230,236,236,230,236,236,230,236,236,230,242,242,
            217,249,242,217,249,242,217,242,236,217,242,236,217,223,217,204,204,204,204,204,204,204,204,204,204,
            204,204,204,217,210,204,230,230,217,230,230,217,217,210,204,217,210,204,204,204,204,217,210,204,217,
            210,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,223,210,204,217,210,204,
            217,210,204,217,210,204,217,210,204,223,217,204,242,236,217,242,236,217,242,236,230,242,236,230,242,
            242,217,242,242,230,242,242,230,242,242,217,242,242,217,242,242,204,249,249,230,249,249,230,242,242,
            230,242,242,230,242,242,230,242,242,230,242,242,230,249,242,230,249,242,230,242,242,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,
            236,230,242,236,230,249,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,
            217,249,210,217,249,210,217,249,210,217,249,210,217,242,217,217,242,217,217,242,236,230,242,236,230,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,236,236,230,236,236,230,242,223,217,249,217,217,249,217,217,249,210,217,249,210,217,249,210,217,
            249,210,217,249,210,217,249,210,217,249,210,217,249,217,204,242,236,230,242,236,230,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,217,242,242,
            217,249,236,230,249,236,230,242,242,217,242,242,217,249,249,204,249,242,217,249,242,217,249,242,217,
            249,242,217,249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,242,242,217,230,223,204,230,223,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,
            204,204,217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,
            204,217,210,204,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,249,242,204,
            249,242,204,249,242,204,249,242,204,249,242,217,249,242,217,249,242,217,249,249,230,249,249,230,249,
            242,217,242,242,217,242,242,217,242,242,217,242,242,217,236,236,230,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,223,217,242,223,217,
            249,210,217,249,210,217,249,210,217,249,217,217,249,217,217,242,210,217,249,217,217,249,217,217,249,
            210,217,249,210,217,249,210,217,242,210,217,242,210,217,242,230,230,242,230,230,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,
            236,230,242,223,217,249,217,217,249,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,
            217,249,210,217,249,210,217,249,217,204,242,236,230,242,236,230,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,217,242,242,217,249,236,230,249,
            236,230,242,242,217,242,242,217,249,249,204,249,242,217,249,242,217,249,242,217,249,242,217,249,242,
            204,249,242,204,249,242,204,249,242,217,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,242,242,217,230,223,204,230,223,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,204,204,217,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,210,204,217,210,204,236,
            236,230,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,249,242,204,249,242,204,249,242,
            204,249,242,204,249,242,217,249,242,217,249,242,217,249,249,230,249,249,230,249,242,217,242,242,217,
            242,242,217,242,242,217,242,242,217,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,223,217,242,223,217,249,210,217,249,210,
            217,249,210,217,249,217,217,249,217,217,242,210,217,249,217,217,249,217,217,249,210,217,249,210,217,
            249,210,217,242,210,217,242,210,217,242,230,230,242,230,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,242,236,242,242,236,242,242,223,217,242,223,217,242,210,217,
            249,210,217,249,210,217,249,210,217,249,210,217,242,217,217,249,217,217,249,217,217,249,210,217,249,
            210,217,249,210,217,249,230,217,249,230,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,217,
            242,242,217,242,236,230,255,255,255,255,255,255,249,249,230,249,249,230,249,242,217,249,242,204,249,
            242,204,249,242,204,249,242,204,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,242,236,230,242,236,230,236,236,217,236,236,217,217,217,204,204,204,204,204,204,204,204,204,217,
            204,204,217,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,217,210,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,230,217,
            223,230,217,255,255,255,255,255,255,242,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,249,217,249,249,217,255,255,255,255,255,255,242,242,217,249,242,217,249,242,217,242,242,
            230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,242,242,230,242,242,230,242,223,204,242,223,204,249,210,217,249,210,217,249,210,217,242,
            217,217,242,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,
            204,249,210,204,249,223,217,249,223,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,242,236,242,242,236,242,242,223,217,242,223,217,242,210,217,249,210,217,249,210,
            217,249,210,217,249,210,217,242,217,217,249,217,217,249,217,217,249,210,217,249,210,217,249,210,217,
            249,230,217,249,230,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,217,242,242,217,242,236,
            230,255,255,255,255,255,255,249,249,230,249,249,230,249,242,217,249,242,204,249,242,204,249,242,204,
            249,242,204,249,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,236,230,242,
            236,230,236,236,217,236,236,217,217,217,204,204,204,204,204,204,204,204,204,217,204,204,217,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,217,
            210,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,223,230,217,223,230,217,255,255,
            255,255,255,255,242,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,249,249,217,
            249,249,217,255,255,255,255,255,255,242,242,217,249,242,217,249,242,217,242,242,230,242,242,230,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,
            230,242,242,230,242,223,204,242,223,204,249,210,217,249,210,217,249,210,217,242,217,217,242,217,217,
            249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,204,249,210,204,249,
            223,217,249,223,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            242,236,217,242,236,217,242,210,217,242,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,
            210,217,242,210,217,242,217,217,242,217,217,249,210,217,249,210,217,249,210,217,242,223,217,242,223,
            217,242,236,230,242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,242,242,217,242,242,217,236,230,230,236,236,230,236,
            236,230,249,249,217,249,249,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,
            217,249,242,217,249,242,217,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,236,236,217,230,230,204,230,230,204,217,210,204,217,210,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,223,223,217,223,223,217,236,230,230,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,217,242,242,217,249,
            242,217,249,242,204,249,242,204,249,242,217,249,242,217,249,242,217,249,242,204,249,242,204,236,230,
            230,236,230,230,236,236,230,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,217,242,236,217,242,
            217,217,242,217,217,242,210,217,249,217,217,249,217,217,242,210,217,242,210,217,249,210,217,249,210,
            204,249,210,204,242,210,217,242,210,217,249,210,217,249,210,204,249,210,204,249,217,217,249,217,217,
            242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,217,242,236,
            217,249,210,217,249,210,217,249,210,217,242,217,217,242,217,217,242,210,217,242,210,217,249,210,217,
            242,217,217,242,217,217,242,210,217,242,210,217,249,210,217,249,217,217,249,217,217,242,230,217,242,
            230,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,236,230,242,236,230,242,242,217,249,242,217,249,242,217,249,242,204,
            249,242,204,242,242,217,242,236,230,242,236,230,249,242,217,249,242,217,249,242,217,242,242,217,242,
            242,217,242,242,217,242,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,236,236,217,236,236,217,223,223,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,223,
            217,204,236,236,230,236,236,230,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,236,236,230,236,236,230,236,236,230,242,242,230,242,242,230,249,242,217,249,242,217,
            249,242,217,249,242,217,249,242,217,249,242,217,249,236,204,249,236,204,249,242,217,249,242,217,236,
            236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,249,236,217,249,236,217,242,210,204,242,210,204,
            249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,242,217,217,249,223,217,249,223,217,249,
            236,217,249,236,217,249,230,217,249,230,217,249,230,217,242,223,217,242,223,217,242,230,217,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,217,242,236,217,249,210,217,249,
            210,217,249,210,217,242,217,217,242,217,217,242,210,217,242,210,217,249,210,217,242,217,217,242,217,
            217,242,210,217,242,210,217,249,210,217,249,217,217,249,217,217,242,230,217,242,230,217,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,236,230,242,236,230,242,242,217,249,242,217,249,242,217,249,242,204,249,242,204,242,242,
            217,242,236,230,242,236,230,249,242,217,249,242,217,249,242,217,242,242,217,242,242,217,242,242,217,
            242,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,236,236,217,236,236,217,223,223,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
            204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,223,217,204,236,236,230,
            236,236,230,236,236,230,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,
            236,230,236,236,230,236,236,230,242,242,230,242,242,230,249,242,217,249,242,217,249,242,217,249,242,
            217,249,242,217,249,242,217,249,236,204,249,236,204,249,242,217,249,242,217,236,236,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,249,236,217,249,236,217,242,210,204,242,210,204,249,210,217,249,210,
            217,249,210,217,249,210,217,249,210,217,242,217,217,249,223,217,249,223,217,249,236,217,249,236,217,
            249,230,217,249,230,217,249,230,217,242,223,217,242,223,217,242,230,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,242,236,230,242,236,230,249,210,217,249,210,217,242,210,217,
            242,217,217,242,217,217,242,217,217,242,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,
            210,217,249,210,217,249,210,204,249,210,204,249,223,217,249,223,217,236,230,230,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,249,236,217,249,242,204,249,242,204,249,242,217,249,242,217,255,255,255,236,236,230,236,
            236,230,249,242,217,249,242,217,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,242,236,
            217,249,236,217,249,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,236,236,217,236,236,217,223,223,204,223,223,204,204,204,204,204,204,204,204,
            204,204,223,217,204,223,217,204,236,230,230,236,230,230,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,236,236,230,236,236,230,255,255,255,255,255,255,236,236,230,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,249,249,217,249,249,217,249,249,230,249,249,230,249,
            242,230,249,242,217,249,242,217,249,242,204,249,242,204,242,242,217,135,207,163,135,207,163,236,236,
            230,236,236,230,249,236,217,242,230,204,242,230,204,242,236,230,242,236,230,135,207,163,135,207,163,
            135,207,163,249,230,217,249,230,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,242,
            217,217,242,217,217,242,236,217,236,230,230,236,230,230,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,242,236,230,242,236,230,249,230,204,242,236,217,242,236,217,135,207,163,135,207,163,
            242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,242,236,230,242,236,230,249,210,217,249,210,217,242,210,217,242,217,217,242,217,
            217,242,217,217,242,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,
            249,210,204,249,210,204,249,223,217,249,223,217,236,230,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,236,
            217,249,242,204,249,242,204,249,242,217,249,242,217,255,255,255,236,236,230,236,236,230,249,242,217,
            249,242,217,236,236,230,255,255,255,255,255,255,255,255,255,255,255,255,242,236,217,249,236,217,249,
            236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,236,236,217,236,236,217,223,223,204,223,223,204,204,204,204,204,204,204,204,204,204,223,217,204,
            223,217,204,236,230,230,236,230,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,236,236,230,236,236,230,255,255,255,255,255,255,236,236,230,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,249,249,217,249,249,217,249,249,230,249,249,230,249,242,230,249,242,217,
            249,242,217,249,242,204,249,242,204,242,242,217,135,207,163,135,207,163,236,236,230,236,236,230,249,
            236,217,242,230,204,242,230,204,242,236,230,242,236,230,135,207,163,135,207,163,135,207,163,249,230,
            217,249,230,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,242,217,217,242,217,217,
            242,236,217,236,230,230,236,230,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,
            236,230,242,236,230,249,230,204,242,236,217,242,236,217,135,207,163,135,207,163,242,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            249,223,217,249,223,217,242,217,204,242,217,204,242,223,217,249,236,217,249,236,217,249,236,217,249,
            236,217,242,230,217,249,210,217,249,210,217,242,210,217,242,210,217,249,210,217,249,210,217,249,210,
            217,242,210,217,242,210,217,242,230,230,135,207,163,135,207,163,135,207,163,135,207,163,249,230,217,
            242,223,204,242,223,204,249,223,217,249,223,217,249,242,217,249,242,217,249,242,217,249,242,217,249,
            242,217,249,242,217,249,242,217,255,255,255,242,242,217,242,242,217,249,242,217,249,242,217,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,242,242,217,
            242,242,217,249,242,217,242,242,217,242,242,217,255,255,255,255,255,255,255,255,255,242,242,217,242,
            242,217,249,242,217,249,242,217,249,242,217,249,236,217,249,236,217,249,242,217,249,242,217,236,236,
            230,236,236,230,255,255,255,236,236,230,236,236,230,255,255,255,255,255,255,242,242,230,249,249,217,
            249,249,217,242,242,217,242,242,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,
            236,230,249,242,204,249,242,204,249,242,217,249,242,217,242,242,230,242,242,217,242,242,217,242,242,
            230,242,242,230,249,242,204,249,230,204,249,230,204,249,223,204,249,223,204,249,210,217,249,210,217,
            249,210,217,249,230,217,249,230,217,135,207,163,135,207,163,135,207,163,249,230,217,249,230,217,249,
            210,217,249,210,217,249,210,217,249,210,217,249,210,217,242,236,217,242,236,217,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,242,242,230,242,242,230,242,242,230,242,242,230,249,242,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,230,230,242,230,217,242,230,
            217,242,230,217,242,230,217,242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,236,230,230,
            249,217,217,249,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,
            210,217,249,230,217,242,242,217,242,242,217,242,230,217,242,230,217,242,210,217,242,210,217,242,210,
            217,249,210,217,249,210,217,249,223,204,249,223,204,249,230,217,236,236,230,236,236,230,255,255,255,
            255,255,255,236,236,230,249,242,204,249,242,204,249,242,217,249,242,217,249,242,217,236,236,230,236,
            236,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,249,242,217,249,242,217,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,230,249,242,230,249,242,230,249,249,217,
            249,249,217,249,242,217,249,249,217,249,249,217,249,242,217,249,242,217,249,249,230,249,249,230,255,
            255,255,236,236,230,236,236,230,236,236,230,236,236,230,255,255,255,242,242,217,242,242,217,242,236,
            217,242,236,217,236,230,230,255,255,255,255,255,255,255,255,255,255,255,255,242,242,217,249,242,217,
            249,242,217,249,236,230,249,236,230,242,242,230,255,255,255,255,255,255,242,236,230,242,236,230,242,
            230,217,249,223,217,249,223,217,249,223,217,249,223,217,249,217,217,249,210,217,249,210,217,242,217,
            204,242,217,204,236,236,217,236,236,217,135,207,163,242,230,217,242,230,217,249,210,217,249,210,217,
            242,210,217,249,210,217,249,210,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,236,230,230,242,230,217,242,230,217,242,230,217,242,
            230,217,242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,236,230,230,249,217,217,249,217,
            217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,230,217,
            242,242,217,242,242,217,242,230,217,242,230,217,242,210,217,242,210,217,242,210,217,249,210,217,249,
            210,217,249,223,204,249,223,204,249,230,217,236,236,230,236,236,230,255,255,255,255,255,255,236,236,
            230,249,242,204,249,242,204,249,242,217,249,242,217,249,242,217,236,236,230,236,236,230,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,249,242,217,249,242,217,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,242,242,230,249,242,230,249,242,230,249,249,217,249,249,217,249,242,
            217,249,249,217,249,249,217,249,242,217,249,242,217,249,249,230,249,249,230,255,255,255,236,236,230,
            236,236,230,236,236,230,236,236,230,255,255,255,242,242,217,242,242,217,242,236,217,242,236,217,236,
            230,230,255,255,255,255,255,255,255,255,255,255,255,255,242,242,217,249,242,217,249,242,217,249,236,
            230,249,236,230,242,242,230,255,255,255,255,255,255,242,236,230,242,236,230,242,230,217,249,223,217,
            249,223,217,249,223,217,249,223,217,249,217,217,249,210,217,249,210,217,242,217,204,242,217,204,236,
            236,217,236,236,217,135,207,163,242,230,217,242,230,217,249,210,217,249,210,217,242,210,217,249,210,
            217,249,210,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,248,242,242,248,
            242,242,242,217,242,242,217,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,230,230,249,230,230,249,210,217,249,
            210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,242,223,217,249,236,204,249,236,
            204,249,217,217,249,217,217,249,210,217,242,210,217,242,210,217,249,223,217,249,223,217,249,217,217,
            249,217,217,249,217,204,249,230,204,249,230,204,236,236,230,236,236,230,255,255,255,249,242,230,249,
            242,230,249,242,217,249,242,217,242,242,230,255,255,255,255,255,255,236,242,217,236,242,217,249,242,
            217,249,242,204,249,242,204,249,242,204,249,242,204,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,249,242,230,249,242,230,249,242,217,249,242,217,249,
            242,217,249,249,230,249,249,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,242,236,217,242,236,217,249,242,217,249,242,217,249,242,217,242,242,217,
            242,242,217,236,236,230,236,236,230,242,242,230,242,242,217,242,242,217,249,236,230,249,236,230,249,
            242,230,249,236,217,249,236,217,242,223,217,242,223,217,242,217,204,242,217,217,242,217,217,249,223,
            217,249,223,217,249,223,217,249,210,217,249,210,217,242,210,217,242,210,217,242,230,217,242,230,217,
            236,236,230,249,230,217,249,230,217,249,210,217,249,210,217,242,210,217,242,217,204,242,217,204,242,
            236,230,242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,248,242,242,248,242,242,242,217,242,
            242,217,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,249,230,230,249,230,230,249,210,217,249,210,217,249,210,217,
            249,210,217,249,210,217,249,210,217,249,210,217,242,223,217,249,236,204,249,236,204,249,217,217,249,
            217,217,249,210,217,242,210,217,242,210,217,249,223,217,249,223,217,249,217,217,249,217,217,249,217,
            204,249,230,204,249,230,204,236,236,230,236,236,230,255,255,255,249,242,230,249,242,230,249,242,217,
            249,242,217,242,242,230,255,255,255,255,255,255,236,242,217,236,242,217,249,242,217,249,242,204,249,
            242,204,249,242,204,249,242,204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,249,242,230,249,242,230,249,242,217,249,242,217,249,242,217,249,249,230,
            249,249,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,242,236,217,242,236,217,249,242,217,249,242,217,249,242,217,242,242,217,242,242,217,236,236,
            230,236,236,230,242,242,230,242,242,217,242,242,217,249,236,230,249,236,230,249,242,230,249,236,217,
            249,236,217,242,223,217,242,223,217,242,217,204,242,217,217,242,217,217,249,223,217,249,223,217,249,
            223,217,249,210,217,249,210,217,242,210,217,242,210,217,242,230,217,242,230,217,236,236,230,249,230,
            217,249,230,217,249,210,217,249,210,217,242,210,217,242,217,204,242,217,204,242,236,230,242,236,230,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,236,236,230,236,236,230,242,210,217,242,210,217,242,210,204,249,210,217,249,210,
            217,249,210,217,249,210,217,249,223,217,249,230,204,249,230,204,249,210,217,249,210,217,242,210,217,
            249,217,217,249,217,217,249,223,204,249,223,204,249,217,204,249,217,204,249,223,217,249,223,204,249,
            223,204,242,217,204,242,217,204,249,230,230,255,255,255,255,255,255,255,255,255,255,255,255,242,242,
            217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,242,236,230,242,236,230,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,
            236,230,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,236,236,230,236,236,230,249,242,217,242,242,217,242,242,217,236,236,217,236,236,217,249,
            249,217,249,249,217,249,249,217,249,236,217,249,236,217,249,230,217,249,217,204,249,217,204,249,217,
            217,249,217,217,249,223,217,249,223,204,249,223,204,249,217,217,249,217,217,249,217,217,242,210,217,
            242,210,217,242,210,217,242,210,217,249,210,217,249,210,217,242,236,217,249,230,217,249,230,217,249,
            210,217,249,210,217,249,210,217,242,217,204,242,217,204,236,236,230,236,236,230,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            236,236,230,236,236,230,242,210,217,242,210,217,242,210,204,249,210,217,249,210,217,249,210,217,249,
            210,217,249,223,217,249,230,204,249,230,204,249,210,217,249,210,217,242,210,217,249,217,217,249,217,
            217,249,223,204,249,223,204,249,217,204,249,217,204,249,223,217,249,223,204,249,223,204,242,217,204,
            242,217,204,249,230,230,255,255,255,255,255,255,255,255,255,255,255,255,242,242,217,249,242,217,249,
            242,217,249,242,217,249,242,217,249,242,217,242,236,230,242,236,230,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,249,242,217,
            249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,236,236,
            230,236,236,230,249,242,217,242,242,217,242,242,217,236,236,217,236,236,217,249,249,217,249,249,217,
            249,249,217,249,236,217,249,236,217,249,230,217,249,217,204,249,217,204,249,217,217,249,217,217,249,
            223,217,249,223,204,249,223,204,249,217,217,249,217,217,249,217,217,242,210,217,242,210,217,242,210,
            217,242,210,217,249,210,217,249,210,217,242,236,217,249,230,217,249,230,217,249,210,217,249,210,217,
            249,210,217,242,217,204,242,217,204,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,249,217,217,249,217,217,249,217,217,242,210,217,242,210,217,242,217,217,242,217,217,249,230,217,
            249,223,217,249,223,217,249,210,217,249,210,217,249,223,217,249,217,204,249,217,204,249,217,217,249,
            217,217,249,217,204,249,217,204,249,223,217,242,223,217,242,223,217,249,223,204,249,223,204,249,223,
            204,249,223,217,249,223,217,242,230,230,242,230,230,236,236,230,242,242,230,242,242,230,249,249,217,
            249,249,217,242,236,230,236,230,230,236,230,230,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,236,230,230,236,230,230,249,242,217,249,242,217,249,242,
            204,249,242,204,249,242,204,242,242,217,242,242,217,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,242,242,230,242,242,230,249,
            242,217,249,242,230,249,242,230,249,242,230,249,242,230,249,242,230,249,230,217,249,230,217,249,217,
            204,249,217,204,242,217,217,249,230,204,249,230,204,249,217,217,249,217,217,249,223,217,249,223,204,
            249,223,204,249,217,217,249,217,217,242,210,217,242,210,217,242,210,217,249,210,217,249,210,217,249,
            210,217,249,210,217,249,230,217,249,230,217,249,230,217,242,210,217,242,210,217,249,210,217,249,217,
            217,249,217,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,223,217,242,
            223,217,242,210,217,242,210,217,242,210,217,249,217,217,249,217,217,249,230,217,242,210,217,242,210,
            217,249,217,217,249,217,217,249,230,204,249,230,204,249,230,204,249,217,217,249,217,217,249,217,217,
            249,217,217,249,223,217,249,217,204,249,217,204,249,230,204,249,230,204,249,223,204,249,223,204,249,
            223,204,249,223,204,249,223,204,249,230,217,242,236,230,242,236,230,255,255,255,255,255,255,255,255,
            255,236,236,217,236,236,217,255,255,255,255,255,255,236,242,217,236,242,217,236,242,217,255,255,255,
            255,255,255,255,255,255,236,236,230,236,236,230,242,236,230,242,236,230,249,242,204,249,242,204,249,
            242,204,236,236,217,236,236,217,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,255,255,
            255,255,255,255,255,255,255,242,236,230,242,236,230,249,236,230,249,236,230,236,236,230,249,242,230,
            249,242,230,249,230,217,249,230,217,242,217,217,249,217,204,249,217,204,249,223,204,249,223,204,242,
            210,217,249,223,217,249,223,217,249,217,217,249,217,217,242,217,217,249,223,217,249,223,217,249,223,
            217,249,223,217,242,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,
            242,217,204,249,230,217,249,230,217,249,217,217,249,217,217,242,210,217,249,217,217,249,217,217,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,223,217,242,223,217,242,210,217,
            242,210,217,242,210,217,249,217,217,249,217,217,249,230,217,242,210,217,242,210,217,249,217,217,249,
            217,217,249,230,204,249,230,204,249,230,204,249,217,217,249,217,217,249,217,217,249,217,217,249,223,
            217,249,217,204,249,217,204,249,230,204,249,230,204,249,223,204,249,223,204,249,223,204,249,223,204,
            249,223,204,249,230,217,242,236,230,242,236,230,255,255,255,255,255,255,255,255,255,236,236,217,236,
            236,217,255,255,255,255,255,255,236,242,217,236,242,217,236,242,217,255,255,255,255,255,255,255,255,
            255,236,236,230,236,236,230,242,236,230,242,236,230,249,242,204,249,242,204,249,242,204,236,236,217,
            236,236,217,255,255,255,255,255,255,255,255,255,236,236,230,236,236,230,255,255,255,255,255,255,255,
            255,255,242,236,230,242,236,230,249,236,230,249,236,230,236,236,230,249,242,230,249,242,230,249,230,
            217,249,230,217,242,217,217,249,217,204,249,217,204,249,223,204,249,223,204,242,210,217,249,223,217,
            249,223,217,249,217,217,249,217,217,242,217,217,249,223,217,249,223,217,249,223,217,249,223,217,242,
            210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,242,217,204,249,230,
            217,249,230,217,249,217,217,249,217,217,242,210,217,249,217,217,249,217,217,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,230,217,242,230,217,249,210,217,249,210,217,249,210,
            217,249,223,217,249,223,217,249,223,217,242,210,217,242,210,217,249,217,217,249,217,217,249,230,217,
            249,223,204,249,223,204,249,223,204,249,223,204,249,223,204,249,223,204,249,217,204,242,217,204,242,
            217,204,249,223,204,249,223,204,249,230,204,249,217,217,249,217,217,249,223,217,249,223,217,249,217,
            204,249,223,204,249,223,204,249,230,217,249,230,217,242,236,217,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,236,236,230,236,236,230,242,242,230,242,242,230,249,249,217,242,236,230,242,
            236,230,242,242,230,242,242,230,242,242,217,236,236,230,236,236,230,242,236,230,242,236,230,242,242,
            230,242,242,230,249,242,230,249,242,217,249,242,217,249,242,230,249,242,230,249,242,230,249,242,230,
            249,242,230,249,236,217,249,236,217,242,230,217,242,223,217,242,223,217,249,223,204,249,223,204,249,
            223,204,249,230,204,249,230,204,249,223,217,249,223,217,249,217,217,242,210,217,242,210,217,249,217,
            217,249,217,217,249,223,217,249,223,217,249,223,217,249,230,217,249,230,217,249,217,204,249,210,217,
            249,210,217,242,217,217,242,217,217,242,217,217,242,217,217,249,217,217,249,230,217,249,230,217,249,
            223,217,249,223,217,242,210,217,249,223,217,249,223,217,236,236,230,236,236,230,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,230,217,242,230,217,249,210,217,249,210,217,249,210,217,249,223,217,249,
            223,217,249,223,217,242,210,217,242,210,217,249,217,217,249,217,217,249,230,217,249,223,204,249,223,
            204,249,223,204,249,223,204,249,223,204,249,223,204,249,217,204,242,217,204,242,217,204,249,223,204,
            249,223,204,249,230,204,249,217,217,249,217,217,249,223,217,249,223,217,249,217,204,249,223,204,249,
            223,204,249,230,217,249,230,217,242,236,217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,236,236,230,236,236,230,242,242,230,242,242,230,249,249,217,242,236,230,242,236,230,242,242,230,
            242,242,230,242,242,217,236,236,230,236,236,230,242,236,230,242,236,230,242,242,230,242,242,230,249,
            242,230,249,242,217,249,242,217,249,242,230,249,242,230,249,242,230,249,242,230,249,242,230,249,236,
            217,249,236,217,242,230,217,242,223,217,242,223,217,249,223,204,249,223,204,249,223,204,249,230,204,
            249,230,204,249,223,217,249,223,217,249,217,217,242,210,217,242,210,217,249,217,217,249,217,217,249,
            223,217,249,223,217,249,223,217,249,230,217,249,230,217,249,217,204,249,210,217,249,210,217,242,217,
            217,242,217,217,242,217,217,242,217,217,249,217,217,249,230,217,249,230,217,249,223,217,249,223,217,
            242,210,217,249,223,217,249,223,217,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,242,236,230,242,236,230,242,210,217,242,210,217,242,210,217,249,230,204,249,230,204,249,223,204,
            249,230,217,249,230,217,249,230,204,249,230,204,249,217,217,242,217,217,242,217,217,249,230,217,249,
            230,217,249,223,217,249,223,217,242,217,204,249,230,217,249,230,217,242,217,217,242,217,217,249,217,
            217,249,230,204,249,230,204,249,223,204,249,223,204,249,223,217,249,223,204,249,223,204,242,217,217,
            242,217,217,242,217,217,249,217,217,249,217,217,249,223,217,249,223,217,242,236,217,242,236,230,242,
            236,230,242,242,230,242,242,230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,242,242,
            230,249,242,230,249,242,230,255,255,255,255,255,255,242,242,242,242,242,242,249,242,230,249,242,204,
            249,242,204,249,230,217,249,230,217,242,223,217,242,217,204,242,217,204,242,217,204,242,217,204,249,
            217,204,249,223,204,249,223,204,249,223,204,249,223,204,249,223,217,242,223,217,242,223,217,249,217,
            217,249,217,217,249,217,217,249,223,217,249,223,217,249,217,217,249,217,217,249,223,204,242,217,217,
            242,217,217,249,230,217,249,230,217,249,223,204,249,217,217,249,217,217,249,230,204,249,230,204,249,
            242,217,249,242,217,249,217,217,242,223,204,242,223,204,249,230,204,249,230,204,242,210,217,242,217,
            204,242,217,204,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,230,242,
            236,230,249,217,217,249,210,217,249,210,217,249,217,217,249,217,217,249,223,204,249,242,204,249,242,
            204,249,236,204,249,236,204,249,223,217,242,217,217,242,217,217,249,210,217,249,210,217,249,217,204,
            249,217,204,249,230,204,242,230,204,242,230,204,249,223,217,249,223,217,249,223,217,249,217,204,249,
            217,204,249,217,217,249,217,217,249,217,204,249,223,204,249,223,204,249,223,217,249,223,217,249,223,
            217,242,217,204,242,217,204,249,230,217,249,230,217,249,217,217,249,217,204,249,217,204,242,217,217,
            242,217,217,249,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,
            223,217,242,223,217,242,223,217,249,217,204,249,217,204,242,217,217,249,217,217,249,217,217,249,210,
            217,249,210,217,249,217,204,249,223,204,249,223,204,249,223,217,249,223,217,249,223,204,249,223,217,
            249,223,217,249,223,204,249,223,204,249,223,217,242,217,204,242,217,204,249,217,217,249,217,217,249,
            223,217,249,223,217,249,223,217,249,223,204,249,223,204,249,223,204,249,230,217,249,230,217,242,217,
            204,242,217,204,249,223,217,249,223,217,249,223,217,242,217,217,242,217,217,249,230,217,249,230,217,
            249,236,217,242,230,204,242,230,204,249,236,217,249,236,217,249,223,204,242,230,217,242,230,217,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,230,242,236,230,249,217,217,
            249,210,217,249,210,217,249,217,217,249,217,217,249,223,204,249,242,204,249,242,204,249,236,204,249,
            236,204,249,223,217,242,217,217,242,217,217,249,210,217,249,210,217,249,217,204,249,217,204,249,230,
            204,242,230,204,242,230,204,249,223,217,249,223,217,249,223,217,249,217,204,249,217,204,249,217,217,
            249,217,217,249,217,204,249,223,204,249,223,204,249,223,217,249,223,217,249,223,217,242,217,204,242,
            217,204,249,230,217,249,230,217,249,217,217,249,217,204,249,217,204,242,217,217,242,217,217,249,223,
            217,249,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,223,217,242,223,217,
            242,223,217,249,217,204,249,217,204,242,217,217,249,217,217,249,217,217,249,210,217,249,210,217,249,
            217,204,249,223,204,249,223,204,249,223,217,249,223,217,249,223,204,249,223,217,249,223,217,249,223,
            204,249,223,204,249,223,217,242,217,204,242,217,204,249,217,217,249,217,217,249,223,217,249,223,217,
            249,223,217,249,223,204,249,223,204,249,223,204,249,230,217,249,230,217,242,217,204,242,217,204,249,
            223,217,249,223,217,249,223,217,242,217,217,242,217,217,249,230,217,249,230,217,249,236,217,242,230,
            204,242,230,204,249,236,217,249,236,217,249,223,204,242,230,217,242,230,217,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,230,217,249,236,204,249,236,
            204,249,236,204,249,236,204,249,236,204,249,242,217,249,242,217,249,223,217,249,223,217,249,210,217,
            249,217,204,249,217,204,249,230,217,249,230,217,242,217,204,242,217,204,242,210,204,249,223,217,249,
            223,217,249,223,217,249,223,217,249,223,217,242,223,217,242,223,217,249,223,217,249,223,217,249,217,
            204,249,217,217,249,217,217,249,223,217,249,223,217,249,223,204,249,217,217,249,217,217,249,217,217,
            249,217,217,249,217,217,249,223,217,249,223,217,249,217,217,249,217,217,249,223,217,249,223,217,249,
            223,217,242,217,217,242,217,217,242,210,217,242,210,217,242,210,217,249,210,217,249,210,217,249,210,
            217,249,210,217,249,217,217,249,217,217,249,217,217,249,217,217,249,217,217,249,223,217,249,223,204,
            249,223,204,249,223,217,249,223,217,249,223,204,249,217,217,249,217,217,242,217,217,242,217,217,249,
            223,217,242,223,217,242,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,210,
            204,249,210,204,242,217,204,249,230,217,249,230,217,249,223,217,249,223,217,242,210,217,242,210,217,
            242,210,217,242,210,217,242,210,217,249,217,204,249,217,204,249,242,204,249,242,204,249,242,204,249,
            242,204,249,242,204,249,242,204,242,236,217,242,236,217,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,242,230,217,249,236,204,249,236,204,249,236,204,249,
            236,204,249,236,204,249,242,217,249,242,217,249,223,217,249,223,217,249,210,217,249,217,204,249,217,
            204,249,230,217,249,230,217,242,217,204,242,217,204,242,210,204,249,223,217,249,223,217,249,223,217,
            249,223,217,249,223,217,242,223,217,242,223,217,249,223,217,249,223,217,249,217,204,249,217,217,249,
            217,217,249,223,217,249,223,217,249,223,204,249,217,217,249,217,217,249,217,217,249,217,217,249,217,
            217,249,223,217,249,223,217,249,217,217,249,217,217,249,223,217,249,223,217,249,223,217,242,217,217,
            242,217,217,242,210,217,242,210,217,242,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,
            217,217,249,217,217,249,217,217,249,217,217,249,217,217,249,223,217,249,223,204,249,223,204,249,223,
            217,249,223,217,249,223,204,249,217,217,249,217,217,242,217,217,242,217,217,249,223,217,242,223,217,
            242,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,210,204,249,210,204,242,
            217,204,249,230,217,249,230,217,249,223,217,249,223,217,242,210,217,242,210,217,242,210,217,242,210,
            217,242,210,217,249,217,204,249,217,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,
            249,242,204,242,236,217,242,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,249,236,230,249,236,204,249,236,204,249,242,217,249,242,217,249,236,217,
            242,223,204,242,223,204,249,217,217,249,217,217,249,217,204,242,217,217,242,217,217,242,236,230,242,
            236,230,236,236,230,236,236,230,242,223,217,249,217,204,249,217,204,249,217,217,249,217,217,249,217,
            217,249,217,217,249,217,217,249,223,217,249,223,217,249,217,204,249,217,217,249,217,217,249,217,217,
            249,217,217,242,217,217,249,223,217,249,223,217,249,223,217,249,223,217,249,217,204,249,223,217,249,
            223,217,249,223,217,249,223,217,249,223,217,249,217,217,249,217,217,242,210,217,242,210,217,249,210,
            217,249,210,217,249,210,217,242,210,217,242,210,217,249,217,217,249,217,217,249,217,217,242,217,217,
            242,217,217,249,217,217,249,217,217,249,230,217,249,223,217,249,223,217,242,217,204,242,217,204,249,
            210,204,242,210,217,242,210,217,249,217,217,249,217,217,249,223,217,249,223,204,249,223,204,249,223,
            204,249,223,204,249,223,204,249,210,217,249,210,217,249,223,217,249,223,217,249,236,230,249,242,217,
            249,242,217,249,223,217,249,223,217,249,210,217,249,210,217,249,210,217,249,217,204,249,217,204,249,
            223,217,249,223,217,242,236,204,249,242,204,249,242,204,249,242,204,249,242,204,249,242,204,242,242,
            230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,249,242,217,249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,242,217,217,242,217,
            217,249,210,217,249,210,217,242,223,204,249,230,217,249,230,217,230,230,217,230,230,217,135,207,163,
            135,207,163,135,207,163,242,230,217,242,230,217,249,223,217,249,223,217,242,210,217,249,217,217,249,
            217,217,249,210,204,249,210,204,242,210,217,249,230,217,249,230,217,249,230,217,249,230,217,242,217,
            217,249,217,204,249,217,204,249,217,217,249,217,217,242,217,204,249,217,217,249,217,217,249,217,217,
            249,217,217,249,217,217,249,217,217,249,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,
            210,217,242,217,217,242,217,217,242,217,217,242,217,217,249,223,217,249,217,217,249,217,217,242,217,
            217,242,217,217,249,217,204,242,217,217,242,217,217,249,217,217,249,217,217,249,217,217,242,210,217,
            242,210,217,249,217,217,249,217,217,249,223,217,249,217,204,249,217,204,249,217,204,249,217,204,249,
            223,217,242,236,217,242,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,
            217,242,236,217,242,217,217,249,217,204,249,217,204,249,223,217,249,223,217,255,255,255,255,255,255,
            249,230,217,249,236,217,249,236,217,249,242,204,249,242,204,249,242,204,242,236,230,242,236,230,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,
            249,242,204,249,242,204,249,242,204,249,242,204,249,242,217,242,217,217,242,217,217,249,210,217,249,
            210,217,242,223,204,249,230,217,249,230,217,230,230,217,230,230,217,135,207,163,135,207,163,135,207,
            163,242,230,217,242,230,217,249,223,217,249,223,217,242,210,217,249,217,217,249,217,217,249,210,204,
            249,210,204,242,210,217,249,230,217,249,230,217,249,230,217,249,230,217,242,217,217,249,217,204,249,
            217,204,249,217,217,249,217,217,242,217,204,249,217,217,249,217,217,249,217,217,249,217,217,249,217,
            217,249,217,217,249,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,242,217,217,
            242,217,217,242,217,217,242,217,217,249,223,217,249,217,217,249,217,217,242,217,217,242,217,217,249,
            217,204,242,217,217,242,217,217,249,217,217,249,217,217,249,217,217,242,210,217,242,210,217,249,217,
            217,249,217,217,249,223,217,249,217,204,249,217,204,249,217,204,249,217,204,249,223,217,242,236,217,
            242,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,236,217,242,236,217,242,
            217,217,249,217,204,249,217,204,249,223,217,249,223,217,255,255,255,255,255,255,249,230,217,249,236,
            217,249,236,217,249,242,204,249,242,204,249,242,204,242,236,230,242,236,230,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,217,242,242,217,242,242,204,249,242,217,249,242,
            217,249,242,217,249,242,217,249,230,204,242,210,204,242,210,204,242,210,217,242,210,217,242,217,217,
            242,236,230,242,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,242,230,217,242,217,217,242,217,217,242,217,217,242,217,217,249,217,
            217,249,230,217,249,230,217,249,230,204,249,230,204,249,223,217,249,223,217,249,223,217,249,223,217,
            249,223,217,249,223,217,249,217,217,249,217,217,249,217,217,249,217,217,249,217,217,242,217,217,242,
            217,217,249,217,217,249,217,217,242,217,217,242,210,217,242,210,217,249,210,204,249,210,204,242,210,
            204,242,210,204,249,217,217,249,217,217,249,217,217,242,217,217,242,217,217,242,217,217,242,217,217,
            242,217,217,249,217,217,249,217,217,249,230,204,242,217,217,242,217,217,242,210,217,242,210,217,249,
            210,217,249,217,217,249,217,217,242,236,217,242,236,217,236,236,230,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,236,217,249,223,217,
            249,223,217,249,210,217,249,210,217,242,210,217,242,210,217,249,210,217,242,217,217,242,217,217,242,
            236,217,242,236,217,249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,236,236,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,217,242,242,217,242,242,204,249,242,217,249,242,217,249,242,217,249,
            242,217,249,230,204,242,210,204,242,210,204,242,210,217,242,210,217,242,217,217,242,236,230,242,236,
            230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,242,230,217,242,217,217,242,217,217,242,217,217,242,217,217,249,217,217,249,230,217,249,
            230,217,249,230,204,249,230,204,249,223,217,249,223,217,249,223,217,249,223,217,249,223,217,249,223,
            217,249,217,217,249,217,217,249,217,217,249,217,217,249,217,217,242,217,217,242,217,217,249,217,217,
            249,217,217,242,217,217,242,210,217,242,210,217,249,210,204,249,210,204,242,210,204,242,210,204,249,
            217,217,249,217,217,249,217,217,242,217,217,242,217,217,242,217,217,242,217,217,242,217,217,249,217,
            217,249,217,217,249,230,204,242,217,217,242,217,217,242,210,217,242,210,217,249,210,217,249,217,217,
            249,217,217,242,236,217,242,236,217,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,236,217,249,223,217,249,223,217,249,210,
            217,249,210,217,242,210,217,242,210,217,249,210,217,242,217,217,242,217,217,242,236,217,242,236,217,
            249,242,217,249,242,217,249,242,217,249,242,217,249,242,217,236,236,230,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,
            217,249,242,204,249,242,204,242,242,217,236,236,230,236,236,230,135,207,163,135,207,163,242,236,230,
            249,236,230,249,236,230,242,230,217,242,230,217,242,230,230,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,236,230,230,236,230,230,242,230,217,242,230,217,242,217,204,242,217,204,242,217,204,249,217,217,
            249,217,217,249,217,204,249,230,217,249,230,217,249,223,204,249,223,204,249,223,217,242,217,217,242,
            217,217,249,223,217,249,223,217,249,230,217,249,223,217,249,223,217,249,223,217,249,223,217,242,217,
            217,242,217,217,242,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,217,217,242,210,217,
            242,210,217,242,210,217,242,210,217,249,217,217,249,217,217,249,217,217,249,217,204,249,217,204,249,
            223,204,249,217,217,249,217,217,249,217,217,249,217,217,242,230,217,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,249,230,217,249,230,217,242,210,217,242,210,217,242,
            210,204,242,210,204,242,223,217,236,230,230,236,230,230,135,207,163,135,207,163,135,207,163,242,242,
            217,242,242,217,249,242,204,249,242,204,249,242,217,236,236,230,236,236,230,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,242,242,217,249,242,204,249,242,204,249,242,204,249,
            242,204,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,236,236,230,236,236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,242,236,230,242,230,230,242,230,230,242,223,217,242,223,217,242,217,
            204,249,217,217,249,217,217,249,210,217,249,210,217,249,223,217,242,217,217,242,217,217,249,223,204,
            249,223,204,249,223,204,249,217,204,249,217,204,249,217,217,249,217,217,242,210,217,249,210,217,249,
            210,217,249,210,217,249,210,217,242,210,217,242,210,217,242,210,217,249,210,217,249,210,217,242,210,
            217,242,210,217,242,217,217,249,217,204,249,217,204,249,217,217,249,217,217,249,223,217,242,230,230,
            242,230,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,242,230,217,242,230,217,242,236,230,242,236,230,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,249,
            242,217,249,242,217,249,242,204,249,242,204,249,242,204,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,242,242,230,242,242,230,242,242,217,249,242,204,249,242,204,249,242,204,249,242,204,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,
            236,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,242,236,230,242,230,230,242,230,230,242,223,217,242,223,217,242,217,204,249,217,217,249,
            217,217,249,210,217,249,210,217,249,223,217,242,217,217,242,217,217,249,223,204,249,223,204,249,223,
            204,249,217,204,249,217,204,249,217,217,249,217,217,242,210,217,249,210,217,249,210,217,249,210,217,
            249,210,217,242,210,217,242,210,217,242,210,217,249,210,217,249,210,217,242,210,217,242,210,217,242,
            217,217,249,217,204,249,217,204,249,217,217,249,217,217,249,223,217,242,230,230,242,230,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,242,230,217,242,230,217,242,236,230,242,236,230,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,249,242,217,249,242,217,
            249,242,204,249,242,204,249,242,204,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,223,217,236,223,217,249,236,217,249,
            236,217,249,236,204,249,242,204,249,242,204,249,236,217,249,236,217,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,223,223,217,223,223,217,135,207,163,135,207,163,236,230,230,236,223,230,236,223,230,242,230,217,
            242,230,217,249,223,217,242,217,217,242,217,217,242,217,204,242,217,204,242,217,217,242,217,217,242,
            217,217,249,217,217,249,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,
            204,249,210,204,249,210,217,249,217,217,249,217,217,249,217,217,249,217,217,249,223,217,249,230,217,
            249,230,217,236,223,217,236,223,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,223,223,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,230,217,242,230,217,249,242,217,249,242,
            204,249,242,204,249,236,217,249,236,217,242,230,217,236,223,217,236,223,217,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,236,223,217,236,223,217,249,236,217,249,236,217,249,236,204,
            249,242,204,249,242,204,249,236,217,249,236,217,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,223,223,217,223,
            223,217,135,207,163,135,207,163,236,230,230,236,223,230,236,223,230,242,230,217,242,230,217,249,223,
            217,242,217,217,242,217,217,242,217,204,242,217,204,242,217,217,242,217,217,242,217,217,249,217,217,
            249,217,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,217,249,210,204,249,210,204,249,
            210,217,249,217,217,249,217,217,249,217,217,249,217,217,249,223,217,249,230,217,249,230,217,236,223,
            217,236,223,217,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,223,223,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,242,230,217,242,230,217,249,242,217,249,242,204,249,242,204,249,
            236,217,249,236,217,242,230,217,236,223,217,236,223,217,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,
            242,242,242,242,242,249,242,217,249,242,217,249,242,204,249,242,204,249,242,204,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,236,230,242,236,230,249,236,217,249,236,217,249,236,
            204,249,230,204,249,230,204,249,236,217,249,236,217,242,236,230,242,236,230,236,236,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,249,242,204,249,242,204,
            249,242,217,242,242,230,242,242,230,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,242,242,230,
            249,242,217,249,242,217,249,242,217,249,242,217,242,242,242,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,236,236,230,236,236,230,249,249,230,249,249,230,249,242,230,249,242,230,249,
            242,230,249,242,217,249,242,217,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,242,242,230,242,242,
            242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,242,242,230,249,242,217,249,242,
            217,249,242,217,249,242,217,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,236,236,230,236,236,230,249,249,230,249,249,230,249,242,230,249,242,230,249,242,230,249,242,217,
            249,242,217,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,249,242,217,249,242,217,242,242,230,242,242,242,242,242,242,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,242,242,230,242,242,230,242,
            242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,
            236,230,249,249,217,249,249,217,249,242,230,242,236,230,242,236,230,249,242,217,249,242,217,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,242,242,242,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,242,230,242,242,230,242,242,230,242,242,230,242,242,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,249,249,217,
            249,249,217,249,242,230,242,236,230,242,236,230,249,242,217,249,242,217,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,
            242,242,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,242,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,242,242,
            217,242,242,217,242,242,217,242,242,217,242,242,217,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,249,242,230,249,242,230,249,242,217,249,242,230,249,
            242,230,242,242,230,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,249,242,230,249,242,230,249,242,217,249,242,230,249,242,230,242,242,230,
            242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,
            236,230,249,242,217,249,242,217,249,242,217,242,242,230,242,242,230,242,242,230,242,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,236,236,230,236,236,230,249,242,217,
            249,242,217,249,242,217,242,242,230,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,
            242,242,242,242,242,242,242,242,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,230,242,242,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,
            242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,242,242,242,242,242,230,242,242,230,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,
            242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,242,242,242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,249,242,230,249,242,230,242,242,230,242,242,230,242,242,230,135,207,163,135,
            207,163,135,207,163,135,207,163,236,242,217,230,242,217,230,242,217,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,249,242,230,249,242,230,242,242,230,242,242,230,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,249,242,230,249,242,230,242,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,
            135,207,163,236,242,217,230,242,217,230,242,217,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,249,242,230,249,242,230,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,249,242,230,249,242,230,135,207,163,135,207,163,135,207,163,236,242,217,236,242,217,217,236,
            230,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,135,207,163,249,242,230,
            249,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,230,
            249,242,230,135,207,163,135,207,163,135,207,163,236,242,217,236,242,217,217,236,230,135,207,163,135,
            207,163,135,207,163,135,207,163,242,242,230,242,242,230,135,207,163,249,242,230,249,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,210,236,230,135,207,163,135,207,163,135,207,163,
            135,207,163,242,242,217,242,242,217,135,207,163,249,242,230,249,242,230,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,242,242,217,242,242,217,135,207,163,242,242,230,242,
            242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,
            230,242,242,230,135,207,163,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,242,242,230,242,242,230,242,242,217,242,242,217,135,207,163,242,242,230,242,242,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,135,
            207,163,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,230,242,
            242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,
            230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,242,242,230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,230,242,242,230,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,230,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,
            230,242,242,230,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,236,242,217,236,242,217,242,242,230,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,217,236,230,135,207,163,135,207,163,242,242,230,242,242,230,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,249,242,230,249,242,230,242,242,230,242,242,242,242,242,242,242,242,242,242,242,242,242,242,
            242,242,242,242,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,249,242,230,
            249,242,230,242,242,230,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,242,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,242,242,230,242,242,230,249,242,217,249,242,217,242,242,
            230,249,242,230,249,242,230,242,242,230,242,242,230,249,242,230,249,242,230,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,242,242,230,242,242,230,249,242,217,249,242,217,242,242,230,249,242,230,249,
            242,230,242,242,230,242,242,230,249,242,230,249,242,230,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,242,242,242,242,242,242,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163
        };

        wxImage image( 140, 175, (unsigned char*)data, TRUE );
#ifndef _WIN32	
        wxBitmap bitmap( image.Scale(80,90) );
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#else
        wxBitmap bitmap( image.Scale(80,90) );	
#endif		
        return bitmap;
    }
    if (index == 2)
    {
        static const unsigned char data[] = 
        {
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,0,0,0,0,0,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,0,0,0,0,0,0,0,
            0,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,0,0,0,0,0,0,0,0,0,255,255,0,255,255,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,0,
            0,0,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,255,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,0,0,0,0,0,0,255,255,0,255,255,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,0,0,0,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,255,255,0,
            0,0,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,0,0,0,0,0,0,255,255,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,
            253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,
            0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,
            255,253,0,255,253,0,255,253,0,255,253,0,0,0,0,0,0,0,255,253,0,255,253,0,255,
            253,0,255,253,0,255,253,0,255,253,0,0,0,0,0,0,0,0,0,0,255,253,0,255,253,
            0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,
            255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,
            253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,
            0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,255,0,255,255,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,0,0,0,0,0,0,255,255,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,
            255,253,0,255,253,0,255,253,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,
            252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,
            0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,
            255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,0,0,0,0,0,0,255,
            252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,0,0,0,0,0,0,0,0,
            0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,
            255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,
            252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,
            0,255,252,0,255,252,0,255,252,0,255,253,0,255,253,0,255,253,0,255,253,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,255,255,0,0,0,0,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,0,0,0,0,0,
            0,0,0,0,255,255,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,253,0,
            255,253,0,255,253,0,255,253,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,
            252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,
            0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,
            255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,0,
            0,0,0,0,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,0,0,
            0,0,0,0,0,0,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,
            255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,
            252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,
            0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,253,0,
            255,253,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,255,
            255,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,0,0,0,0,0,0,255,255,0,255,254,0,255,254,0,255,254,0,255,254,0,255,253,0,
            255,253,0,255,253,0,255,252,0,255,252,0,255,252,0,255,251,0,255,251,0,255,251,0,255,
            251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,
            0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,
            255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,
            251,0,255,251,0,0,0,0,0,0,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,
            0,255,251,0,0,0,0,0,0,0,0,0,0,255,251,0,255,251,0,255,251,0,255,251,0,
            255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,
            251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,
            0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,
            255,252,0,255,252,0,255,252,0,255,252,0,255,253,0,255,253,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,255,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,0,0,0,255,255,0,255,255,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,252,0,255,251,0,255,251,0,255,
            251,0,255,251,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,
            0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,
            255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,
            250,0,255,250,0,255,250,0,255,250,0,0,0,0,0,0,0,255,250,0,255,250,0,255,250,
            0,255,250,0,255,250,0,255,250,0,0,0,0,0,0,0,0,0,0,255,250,0,255,250,0,
            255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,
            250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,
            0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,251,0,
            255,251,0,255,251,0,255,251,0,255,252,0,255,252,0,255,252,0,255,253,0,255,253,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,0,0,0,135,207,
            163,135,207,163,135,207,163,135,207,163,0,0,0,255,255,0,255,255,0,255,254,0,255,254,0,
            255,254,0,255,253,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,251,0,255,
            251,0,255,250,0,255,250,0,255,250,0,255,250,0,255,249,0,255,249,0,255,249,0,255,249,
            0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,
            255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,
            249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,0,0,0,0,0,0,255,249,
            0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,0,0,0,0,0,0,0,0,0,
            255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,
            249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,
            0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,
            255,250,0,255,250,0,255,250,0,255,250,0,255,251,0,255,251,0,255,251,0,255,252,0,255,
            252,0,255,252,0,255,253,0,255,253,0,255,254,0,255,254,0,255,254,0,255,255,0,255,255,
            0,0,0,0,135,207,163,135,207,163,135,207,163,135,207,163,0,0,0,255,255,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,252,0,255,
            251,0,255,251,0,255,250,0,255,250,0,255,250,0,255,249,0,255,249,0,255,249,0,255,249,
            0,255,249,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,
            255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,
            248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,0,0,
            0,0,0,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,0,0,0,
            0,0,0,0,0,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,
            248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,
            0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,
            255,249,0,255,249,0,255,249,0,255,249,0,255,250,0,255,250,0,255,250,0,255,251,0,255,
            251,0,255,251,0,255,252,0,255,252,0,255,253,0,255,253,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,255,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,163,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,255,246,0,255,246,0,255,246,0,255,246,0,255,246,0,
            255,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,207,163,135,207,163,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,255,246,0,255,246,0,255,246,0,255,246,0,
            255,246,0,255,246,0,255,246,0,255,246,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            253,0,255,252,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,249,
            0,255,248,0,255,248,0,255,248,0,255,246,0,255,246,0,255,246,0,255,244,0,255,244,0,
            255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,
            244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,244,0,255,244,0,255,244,0,
            255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,
            244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,
            0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,
            255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,246,0,255,246,0,255,
            246,0,255,248,0,255,248,0,255,248,0,255,249,0,255,249,0,255,250,0,255,250,0,255,251,
            0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,253,0,255,252,0,255,252,0,255,251,0,255,251,0,255,250,0,255,250,
            0,255,249,0,255,249,0,255,248,0,255,248,0,255,246,0,255,246,0,255,246,0,255,244,0,
            255,244,0,255,244,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,
            242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,
            0,255,242,0,0,0,0,0,0,0,0,0,0,0,0,0,255,242,0,255,242,0,255,242,0,
            255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,
            242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,
            0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,
            255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,255,244,0,255,244,0,255,244,0,255,
            244,0,255,246,0,255,246,0,255,246,0,255,248,0,255,248,0,255,249,0,255,249,0,255,250,
            0,255,250,0,255,251,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,
            254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,
            0,255,250,0,255,249,0,255,249,0,255,248,0,255,248,0,255,246,0,255,246,0,255,246,0,
            255,244,0,255,244,0,255,242,0,255,242,0,255,242,0,255,242,0,255,240,0,255,240,0,255,
            240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,
            0,255,240,0,0,0,0,0,0,0,0,0,0,255,240,0,255,240,0,255,240,0,255,240,0,
            255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,
            240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,
            0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,
            255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,242,0,255,
            242,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,246,0,255,248,0,255,248,
            0,255,249,0,255,249,0,255,250,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,
            0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,
            0,255,251,0,255,250,0,255,250,0,255,249,0,255,249,0,255,248,0,255,248,0,255,246,0,
            255,246,0,255,244,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,240,0,255,
            240,0,255,240,0,255,240,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,
            0,255,238,0,255,238,0,0,0,0,0,0,0,0,0,0,255,238,0,255,238,0,255,238,0,
            255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,
            238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,
            0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,
            255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,240,0,255,240,0,255,
            240,0,255,240,0,255,242,0,255,242,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,
            0,255,248,0,255,248,0,255,249,0,255,249,0,255,250,0,255,250,0,255,251,0,255,252,0,
            255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,
            207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,
            0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,
            255,246,0,255,246,0,255,244,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,
            240,0,255,238,0,255,238,0,255,238,0,255,238,0,255,235,0,255,235,0,255,235,0,255,235,
            0,255,235,0,255,235,0,255,235,0,0,0,0,0,0,0,0,0,0,255,235,0,255,235,0,
            255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,
            235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,
            0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,
            255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,
            238,0,255,238,0,255,238,0,255,240,0,255,240,0,255,240,0,255,242,0,255,242,0,255,244,
            0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,249,0,255,250,0,
            255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,
            0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,
            255,248,0,255,248,0,255,246,0,255,246,0,255,244,0,255,244,0,255,242,0,255,242,0,255,
            240,0,255,240,0,255,238,0,255,238,0,255,238,0,255,238,0,255,235,0,255,235,0,255,235,
            0,255,235,0,255,235,0,255,235,0,255,235,0,0,0,0,0,0,0,0,0,0,255,235,0,
            255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,
            235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,
            0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,
            255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,
            235,0,255,235,0,255,235,0,255,238,0,255,238,0,255,238,0,255,240,0,255,240,0,255,242,
            0,255,242,0,255,244,0,255,244,0,255,244,0,255,246,0,255,248,0,255,248,0,255,249,0,
            255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,
            0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,
            255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,246,0,255,244,0,255,242,0,255,
            242,0,255,240,0,255,240,0,255,238,0,255,238,0,255,238,0,255,235,0,255,235,0,255,235,
            0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,0,0,0,0,0,0,255,230,0,
            255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,
            230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,
            0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,
            255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,233,0,255,
            233,0,255,233,0,255,233,0,255,233,0,255,235,0,255,235,0,255,235,0,255,238,0,255,238,
            0,255,240,0,255,240,0,255,242,0,255,242,0,255,244,0,255,244,0,255,246,0,255,248,0,
            255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,
            0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,
            255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,
            244,0,255,242,0,255,242,0,255,240,0,255,240,0,255,238,0,255,235,0,255,235,0,255,235,
            0,255,233,0,255,233,0,255,230,0,255,230,0,255,230,0,255,230,0,0,0,0,0,0,0,
            255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,
            228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,
            0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,
            255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,
            228,0,255,230,0,255,230,0,255,230,0,255,230,0,255,233,0,255,233,0,255,235,0,255,235,
            0,255,238,0,255,238,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,
            255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,
            252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,
            163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,
            255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,
            246,0,255,244,0,255,244,0,255,242,0,255,242,0,255,240,0,255,238,0,255,238,0,255,235,
            0,255,235,0,255,233,0,255,233,0,255,233,0,255,230,0,255,230,0,255,228,0,255,228,0,
            0,0,0,0,0,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,
            228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,
            0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,
            255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,
            228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,230,0,255,230,0,255,230,0,255,233,
            0,255,233,0,255,235,0,255,235,0,255,238,0,255,238,0,255,240,0,255,240,0,255,242,0,
            255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,
            251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,
            0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,
            255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,
            248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,
            0,255,235,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,230,0,255,228,0,
            255,228,0,0,0,0,0,0,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,
            225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,
            0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,
            255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,
            225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,228,0,255,228,0,255,228,
            0,255,230,0,255,233,0,255,233,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,
            255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,
            249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,
            255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,
            250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,
            0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,233,0,255,230,0,255,230,0,
            255,228,0,255,228,0,255,225,0,0,0,0,0,0,0,255,222,0,255,222,0,255,222,0,255,
            222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,
            0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,
            255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,
            222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,222,0,255,225,0,255,225,0,255,225,
            0,255,228,0,255,228,0,255,230,0,255,230,0,255,233,0,255,233,0,255,235,0,255,235,0,
            255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,
            248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,
            0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,
            251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,
            0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,
            255,230,0,255,230,0,255,228,0,255,228,0,0,0,0,0,0,0,0,0,0,255,222,0,255,
            222,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,
            0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,
            255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,
            220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,222,0,255,222,
            0,255,222,0,255,225,0,255,225,0,255,228,0,255,228,0,255,230,0,255,230,0,255,233,0,
            255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,
            246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,
            0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,
            135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,
            252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,
            0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,
            255,233,0,255,230,0,255,230,0,255,228,0,255,228,0,255,225,0,0,0,0,0,0,0,0,
            0,0,255,222,0,255,220,0,255,220,0,255,220,0,255,220,0,255,217,0,255,217,0,255,217,
            0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,
            255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,
            217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,220,0,255,220,0,255,220,
            0,255,220,0,255,222,0,255,222,0,255,225,0,255,225,0,255,228,0,255,228,0,255,230,0,
            255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,
            244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,
            0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,
            0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,
            253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,
            0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,
            255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,228,0,255,225,0,0,
            0,0,0,0,0,0,0,0,255,220,0,255,220,0,255,217,0,255,217,0,255,217,0,255,215,
            0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,
            255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,
            215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,217,
            0,255,217,0,255,217,0,255,220,0,255,220,0,255,222,0,255,222,0,255,225,0,255,225,0,
            255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,
            240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,
            0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,
            254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,
            0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,
            255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,
            228,0,255,225,0,0,0,0,0,0,0,0,0,0,255,220,0,255,217,0,255,217,0,255,217,
            0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,
            255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,
            215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,
            0,255,215,0,255,215,0,255,217,0,255,217,0,255,220,0,255,220,0,255,222,0,255,222,0,
            255,225,0,255,225,0,255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,
            238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,
            0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,217,0,255,217,
            0,255,215,0,255,215,0,255,215,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,
            255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,
            213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,
            0,255,213,0,255,213,0,255,213,0,255,215,0,255,215,0,255,217,0,255,217,0,255,220,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,207,163,135,
            207,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,255,217,0,255,217,0,255,215,0,255,215,0,255,213,0,255,213,0,255,213,0,255,211,0,
            255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,
            211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,
            0,255,211,0,255,211,0,255,211,0,255,213,0,255,213,0,255,215,0,255,215,0,255,215,0,
            255,217,0,255,220,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,
            0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,
            255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,
            235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,225,0,255,225,0,255,222,
            0,255,222,0,0,0,0,0,0,0,255,217,0,255,215,0,255,213,0,255,213,0,255,211,0,
            255,211,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,
            210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,
            0,255,210,0,255,210,0,255,210,0,255,210,0,255,211,0,255,211,0,255,213,0,255,213,0,
            255,215,0,255,215,0,255,217,0,255,220,0,0,0,0,0,0,0,255,222,0,255,225,0,255,
            228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,
            0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,
            255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,
            0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,
            255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,
            240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,225,
            0,255,225,0,255,222,0,255,222,0,0,0,0,0,0,0,255,217,0,255,215,0,255,213,0,
            255,213,0,255,211,0,255,211,0,255,210,0,255,210,0,255,210,0,255,208,0,255,208,0,255,
            208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,
            0,255,208,0,255,208,0,255,208,0,255,208,0,255,210,0,255,210,0,255,210,0,255,211,0,
            255,211,0,255,213,0,255,215,0,255,215,0,255,217,0,0,0,0,0,0,0,255,222,0,255,
            222,0,255,225,0,255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,
            0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,
            255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,
            0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,
            255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,
            242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,
            0,255,228,0,255,225,0,255,225,0,255,222,0,255,222,0,255,220,0,0,0,0,0,0,0,
            255,215,0,255,213,0,255,213,0,255,211,0,255,210,0,255,210,0,255,208,0,255,208,0,255,
            207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,
            0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,208,0,255,208,0,255,210,0,
            255,210,0,255,211,0,255,211,0,255,213,0,255,215,0,255,215,0,0,0,0,0,0,0,255,
            222,0,255,222,0,255,222,0,255,225,0,255,228,0,255,230,0,255,230,0,255,233,0,255,235,
            0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,
            255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,
            253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,
            163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,
            255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,
            244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,
            0,255,230,0,255,230,0,255,228,0,255,225,0,255,225,0,255,222,0,255,222,0,255,220,0,
            0,0,0,0,0,0,0,0,0,255,213,0,255,213,0,255,211,0,255,210,0,255,210,0,255,
            208,0,255,208,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,
            0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,
            255,208,0,255,208,0,255,210,0,255,211,0,255,211,0,255,213,0,255,215,0,255,215,0,0,
            0,0,0,0,0,255,222,0,255,222,0,255,222,0,255,225,0,255,228,0,255,230,0,255,230,
            0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,
            255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,
            252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,
            0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,
            255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,
            248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,
            0,255,235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,225,0,255,225,0,255,222,0,
            255,222,0,255,220,0,255,217,0,255,217,0,0,0,0,0,0,0,255,213,0,255,211,0,255,
            210,0,255,210,0,255,208,0,255,208,0,255,207,0,255,206,0,255,206,0,255,206,0,255,206,
            0,255,206,0,255,206,0,255,206,0,255,206,0,255,206,0,255,206,0,255,206,0,255,206,0,
            255,207,0,255,207,0,255,208,0,255,208,0,255,210,0,255,211,0,255,211,0,255,213,0,0,
            0,0,0,0,0,0,0,0,255,220,0,255,222,0,255,222,0,255,222,0,255,225,0,255,228,
            0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,
            255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,
            250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,
            255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,
            249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,
            0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,225,0,
            255,225,0,255,222,0,255,222,0,255,220,0,255,217,0,255,217,0,0,0,0,0,0,0,0,
            0,0,255,211,0,255,210,0,255,210,0,255,208,0,255,208,0,255,207,0,255,206,0,255,206,
            0,255,205,0,255,205,0,255,205,0,255,205,0,255,205,0,255,205,0,255,205,0,255,205,0,
            255,205,0,255,206,0,255,207,0,255,207,0,255,208,0,255,208,0,255,210,0,255,211,0,255,
            211,0,255,213,0,0,0,0,0,0,0,255,217,0,255,220,0,255,222,0,255,222,0,255,222,
            0,255,225,0,255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,
            255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,
            249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,
            255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,
            250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,
            0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,
            255,228,0,255,225,0,255,225,0,255,222,0,255,222,0,255,220,0,255,217,0,255,217,0,255,
            215,0,0,0,0,0,0,0,255,211,0,255,210,0,255,210,0,255,208,0,255,208,0,255,207,
            0,255,206,0,255,205,0,255,205,0,255,204,0,255,204,0,255,204,0,255,204,0,255,204,0,
            255,204,0,255,205,0,255,205,0,255,206,0,255,207,0,255,207,0,255,208,0,255,208,0,255,
            210,0,255,211,0,255,211,0,0,0,0,0,0,0,0,0,0,255,217,0,255,220,0,255,222,
            0,255,222,0,255,222,0,255,225,0,255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,
            255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,
            246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,
            0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,
            252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,
            0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,
            255,230,0,255,230,0,255,228,0,255,225,0,255,225,0,255,222,0,255,222,0,255,220,0,255,
            217,0,255,217,0,255,215,0,0,0,0,0,0,0,255,211,0,255,210,0,255,210,0,255,208,
            0,255,208,0,255,207,0,255,206,0,255,205,0,255,205,0,255,204,0,255,204,0,255,204,0,
            255,204,0,255,204,0,255,204,0,255,205,0,255,205,0,255,206,0,255,207,0,255,207,0,255,
            208,0,255,208,0,255,210,0,255,211,0,255,211,0,0,0,0,0,0,0,0,0,0,255,217,
            0,255,220,0,255,222,0,255,222,0,255,222,0,255,225,0,255,228,0,255,230,0,255,230,0,
            255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,
            244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,
            0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,
            135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,
            253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,
            0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,
            255,235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,225,0,255,225,0,255,222,0,255,
            222,0,255,220,0,255,217,0,255,217,0,255,215,0,0,0,0,0,0,0,255,211,0,255,210,
            0,255,210,0,255,208,0,255,208,0,255,207,0,255,206,0,255,205,0,255,205,0,255,204,0,
            255,204,0,255,204,0,255,204,0,255,204,0,255,204,0,255,205,0,255,205,0,255,206,0,255,
            207,0,255,207,0,255,208,0,255,208,0,255,210,0,255,211,0,255,211,0,0,0,0,0,0,
            0,255,215,0,255,217,0,255,220,0,255,222,0,255,222,0,255,222,0,255,225,0,255,228,0,
            255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,
            242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,
            0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,
            254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,
            0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,
            255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,225,0,255,
            225,0,255,222,0,255,222,0,255,220,0,255,217,0,255,217,0,255,215,0,0,0,0,0,0,
            0,255,211,0,255,210,0,255,210,0,255,208,0,255,208,0,255,207,0,255,206,0,255,205,0,
            255,205,0,255,204,0,255,204,0,255,204,0,255,204,0,255,204,0,255,204,0,255,205,0,255,
            205,0,255,206,0,255,207,0,255,207,0,255,208,0,255,208,0,255,210,0,255,211,0,255,211,
            0,0,0,0,0,0,0,0,0,0,255,217,0,255,220,0,255,222,0,255,222,0,255,222,0,
            255,225,0,255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,
            240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,
            0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,
            254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,
            0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,
            255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,
            228,0,255,225,0,255,225,0,255,222,0,255,222,0,255,220,0,255,217,0,255,217,0,0,0,
            0,0,0,0,0,0,0,255,211,0,255,210,0,255,210,0,255,208,0,255,208,0,255,207,0,
            255,206,0,255,205,0,255,205,0,255,204,0,255,204,0,255,204,0,255,204,0,255,204,0,255,
            204,0,255,205,0,255,205,0,255,206,0,255,207,0,255,207,0,255,208,0,255,208,0,255,210,
            0,255,211,0,255,211,0,0,0,0,0,0,0,0,0,0,255,217,0,255,220,0,255,222,0,
            255,222,0,255,222,0,255,225,0,255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,
            235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,
            0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,
            0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,
            0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,
            255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,
            230,0,255,230,0,255,228,0,255,225,0,255,225,0,255,222,0,255,222,0,255,220,0,255,217,
            0,255,217,0,0,0,0,0,0,0,0,0,0,255,211,0,255,210,0,255,210,0,255,208,0,
            255,208,0,255,207,0,255,206,0,255,206,0,255,206,0,255,205,0,255,205,0,255,205,0,255,
            205,0,255,205,0,255,205,0,255,205,0,255,206,0,255,206,0,255,207,0,255,207,0,255,208,
            0,255,208,0,255,210,0,255,211,0,255,211,0,255,213,0,0,0,0,0,0,0,255,217,0,
            255,220,0,255,222,0,255,222,0,255,222,0,255,225,0,255,228,0,255,230,0,255,230,0,255,
            233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,
            0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,
            255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,
            207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,
            0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,
            255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,
            235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,225,0,255,225,0,255,222,0,255,222,
            0,255,220,0,255,217,0,0,0,0,0,0,0,0,0,0,255,213,0,255,211,0,255,210,0,
            255,210,0,255,208,0,255,208,0,255,207,0,255,207,0,255,206,0,255,206,0,255,206,0,255,
            206,0,255,206,0,255,206,0,255,206,0,255,206,0,255,206,0,255,206,0,255,206,0,255,207,
            0,255,207,0,255,208,0,255,208,0,255,210,0,255,211,0,255,211,0,255,213,0,0,0,0,
            0,0,0,0,0,0,255,220,0,255,222,0,255,222,0,255,222,0,255,225,0,255,228,0,255,
            230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,
            0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,
            255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,
            0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,
            255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,
            238,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,228,0,255,225,0,255,225,
            0,255,222,0,255,222,0,255,220,0,0,0,0,0,0,0,255,215,0,255,213,0,255,213,0,
            255,211,0,255,210,0,255,210,0,255,208,0,255,208,0,255,207,0,255,207,0,255,207,0,255,
            207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,0,255,207,
            0,255,207,0,255,207,0,255,208,0,255,208,0,255,210,0,255,210,0,255,211,0,255,211,0,
            255,213,0,255,215,0,255,215,0,0,0,0,0,0,0,255,222,0,255,222,0,255,222,0,255,
            225,0,255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,
            0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,
            255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,
            0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,
            255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,
            242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,228,
            0,255,225,0,255,225,0,255,222,0,255,222,0,255,220,0,0,0,0,0,0,0,255,215,0,
            255,213,0,255,213,0,255,211,0,255,211,0,255,210,0,255,208,0,255,208,0,255,208,0,255,
            208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,
            0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,208,0,255,210,0,255,210,0,
            255,211,0,255,211,0,255,213,0,255,215,0,255,215,0,0,0,0,0,0,0,255,222,0,255,
            222,0,255,222,0,255,225,0,255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,
            0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,
            255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,
            0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,
            255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,
            242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,
            0,255,230,0,255,228,0,255,225,0,255,225,0,255,222,0,255,222,0,0,0,0,0,0,0,
            255,217,0,255,215,0,255,213,0,255,213,0,255,211,0,255,211,0,255,210,0,255,210,0,255,
            210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,
            0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,
            255,210,0,255,210,0,255,211,0,255,211,0,255,213,0,255,215,0,255,215,0,255,217,0,0,
            0,0,0,0,0,0,0,0,255,222,0,255,225,0,255,228,0,255,230,0,255,230,0,255,233,
            0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,
            255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,
            252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,
            163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,
            255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,
            246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,
            0,255,233,0,255,230,0,255,230,0,255,228,0,255,225,0,255,225,0,255,222,0,0,0,0,
            0,0,0,0,0,0,255,217,0,255,215,0,255,215,0,255,213,0,255,211,0,255,211,0,255,
            211,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,
            0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,255,210,0,
            255,210,0,255,210,0,255,211,0,255,211,0,255,211,0,255,213,0,255,213,0,255,215,0,255,
            215,0,255,217,0,255,220,0,0,0,0,0,0,0,255,222,0,255,225,0,255,228,0,255,230,
            0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,
            255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,
            251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,
            0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,255,217,0,255,217,0,255,215,0,255,215,0,255,215,0,255,
            213,0,255,213,0,255,213,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,
            0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,
            255,211,0,255,211,0,255,211,0,255,211,0,255,211,0,255,213,0,255,213,0,255,213,0,255,
            215,0,255,215,0,255,215,0,255,217,0,255,220,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,217,0,255,217,0,255,215,0,255,
            215,0,255,215,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,
            0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,
            255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,213,0,255,
            213,0,255,215,0,255,215,0,255,215,0,255,217,0,255,217,0,255,220,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,135,207,163,135,207,163,0,0,0,
            0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,
            251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,
            0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,230,0,
            255,230,0,255,228,0,255,228,0,255,225,0,0,0,0,0,0,0,0,0,0,255,220,0,255,
            220,0,255,217,0,255,217,0,255,217,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,
            0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,
            255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,215,0,255,
            215,0,255,215,0,255,215,0,255,215,0,255,217,0,255,217,0,255,217,0,255,220,0,255,220,
            0,255,222,0,0,0,0,0,0,0,255,225,0,255,228,0,255,230,0,255,230,0,255,233,0,
            255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,
            246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,
            0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,
            135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,
            252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,
            0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,
            255,233,0,255,230,0,255,230,0,255,228,0,255,228,0,255,225,0,0,0,0,0,0,0,0,
            0,0,255,220,0,255,220,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,
            0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,
            255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,
            217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,0,255,217,
            0,255,220,0,255,220,0,255,222,0,0,0,0,0,0,0,255,228,0,255,228,0,255,230,0,
            255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,
            244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,
            0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,
            0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,
            253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,
            0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,
            255,235,0,255,235,0,255,233,0,255,230,0,255,230,0,255,230,0,255,228,0,255,228,0,0,
            0,0,0,0,0,0,0,0,255,222,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,
            0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,
            255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,
            220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,
            0,255,220,0,255,220,0,255,222,0,255,222,0,255,222,0,0,0,0,0,0,0,255,228,0,
            255,228,0,255,230,0,255,230,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,
            240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,
            0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,
            254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,
            0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,255,242,0,255,242,0,
            255,240,0,255,238,0,255,235,0,255,235,0,255,233,0,255,233,0,255,230,0,255,230,0,255,
            228,0,255,228,0,0,0,0,0,0,0,0,0,0,255,222,0,255,222,0,255,222,0,255,220,
            0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,
            255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,
            220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,0,255,220,
            0,255,220,0,255,220,0,255,222,0,255,222,0,255,222,0,255,222,0,255,225,0,0,0,0,
            0,0,0,255,228,0,255,228,0,255,230,0,255,233,0,255,233,0,255,235,0,255,235,0,255,
            238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,
            0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,
            0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,
            0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,242,0,
            255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,235,0,255,233,0,255,
            230,0,255,230,0,255,228,0,255,228,0,255,228,0,0,0,0,0,0,0,255,225,0,255,225,
            0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,
            255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,
            225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,
            0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,
            0,0,0,0,0,0,0,0,0,255,228,0,255,230,0,255,233,0,255,233,0,255,233,0,255,
            235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,
            0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,
            255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,
            207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,
            0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,
            255,244,0,255,242,0,255,242,0,255,242,0,255,240,0,255,238,0,255,235,0,255,235,0,255,
            235,0,255,233,0,255,233,0,255,230,0,255,230,0,255,228,0,255,228,0,0,0,0,0,0,
            0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,
            255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,
            225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,
            0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,255,225,0,
            255,225,0,255,225,0,0,0,0,0,0,0,0,0,0,255,230,0,255,230,0,255,233,0,255,
            233,0,255,233,0,255,235,0,255,235,0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,
            0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,
            255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,
            0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,
            0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,
            255,248,0,255,246,0,255,244,0,255,244,0,255,242,0,255,242,0,255,240,0,255,240,0,255,
            238,0,255,235,0,255,235,0,255,233,0,255,233,0,255,233,0,255,230,0,255,230,0,255,230,
            0,255,228,0,0,0,0,0,0,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,
            255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,
            228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,
            0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,255,228,0,
            255,228,0,255,228,0,255,228,0,255,228,0,0,0,0,0,0,0,255,230,0,255,230,0,255,
            233,0,255,233,0,255,233,0,255,235,0,255,235,0,255,238,0,255,238,0,255,240,0,255,240,
            0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,
            255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,
            0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,
            255,249,0,255,248,0,255,248,0,255,246,0,255,244,0,255,244,0,255,242,0,255,242,0,255,
            240,0,255,240,0,255,238,0,255,238,0,255,235,0,255,235,0,255,233,0,255,233,0,255,233,
            0,255,233,0,255,230,0,255,230,0,0,0,0,0,0,0,0,0,0,255,230,0,255,230,0,
            255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,
            230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,
            0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,
            255,230,0,255,230,0,255,230,0,255,230,0,255,230,0,0,0,0,0,0,0,0,0,0,255,
            230,0,255,233,0,255,233,0,255,233,0,255,235,0,255,235,0,255,238,0,255,238,0,255,238,
            0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,
            255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,
            0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,
            255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,246,0,255,244,0,255,
            242,0,255,242,0,255,240,0,255,240,0,255,238,0,255,238,0,255,238,0,255,235,0,255,235,
            0,255,235,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,0,0,0,0,0,0,
            255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,
            233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,
            0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,
            255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,255,233,0,0,0,0,0,0,0,255,
            233,0,255,233,0,255,233,0,255,233,0,255,235,0,255,235,0,255,235,0,255,238,0,255,238,
            0,255,238,0,255,240,0,255,240,0,255,242,0,255,244,0,255,244,0,255,244,0,255,246,0,
            255,248,0,255,248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,252,0,255,252,0,255,
            253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,
            163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,
            255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,248,0,255,248,0,255,246,0,255,
            246,0,255,244,0,255,244,0,255,244,0,255,242,0,255,242,0,255,240,0,255,240,0,255,238,
            0,255,238,0,255,238,0,255,238,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,
            255,235,0,0,0,0,0,0,0,0,0,0,255,235,0,255,235,0,255,235,0,255,235,0,255,
            235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,
            0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,
            255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,0,0,0,0,
            0,0,0,0,0,255,235,0,255,235,0,255,235,0,255,235,0,255,235,0,255,238,0,255,238,
            0,255,238,0,255,240,0,255,240,0,255,240,0,255,242,0,255,242,0,255,244,0,255,244,0,
            255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,249,0,255,250,0,255,251,0,255,
            252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,
            0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,253,0,
            255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,249,0,255,
            248,0,255,246,0,255,246,0,255,244,0,255,244,0,255,244,0,255,242,0,255,242,0,255,240,
            0,255,240,0,255,240,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,
            255,238,0,255,238,0,255,238,0,255,238,0,0,0,0,0,0,0,0,0,0,255,238,0,255,
            238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,
            0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,
            255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,0,
            0,0,0,0,0,0,0,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,0,255,238,
            0,255,238,0,255,238,0,255,240,0,255,240,0,255,240,0,255,242,0,255,242,0,255,242,0,
            255,244,0,255,244,0,255,246,0,255,246,0,255,248,0,255,249,0,255,249,0,255,249,0,255,
            250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,
            255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,
            249,0,255,249,0,255,248,0,255,248,0,255,246,0,255,246,0,255,246,0,255,244,0,255,244,
            0,255,242,0,255,242,0,255,242,0,255,242,0,255,240,0,255,240,0,255,240,0,255,240,0,
            255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,0,0,0,0,
            0,0,0,0,0,0,0,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,
            0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,
            255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,
            240,0,0,0,0,0,0,0,0,0,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,
            0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,242,0,255,242,0,255,242,0,
            255,244,0,255,244,0,255,246,0,255,246,0,255,246,0,255,248,0,255,248,0,255,249,0,255,
            249,0,255,250,0,255,250,0,255,251,0,255,252,0,255,252,0,255,253,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,
            255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,251,0,255,
            251,0,255,250,0,255,249,0,255,249,0,255,249,0,255,248,0,255,248,0,255,246,0,255,246,
            0,255,244,0,255,244,0,255,244,0,255,242,0,255,242,0,255,242,0,255,242,0,255,242,0,
            255,242,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,
            240,0,255,240,0,0,0,0,0,0,0,0,0,0,255,240,0,255,240,0,255,240,0,255,240,
            0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,
            255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,240,0,255,
            240,0,0,0,0,0,0,0,0,0,0,0,0,0,255,240,0,255,240,0,255,240,0,255,240,
            0,255,240,0,255,240,0,255,240,0,255,240,0,255,242,0,255,242,0,255,242,0,255,242,0,
            255,242,0,255,244,0,255,244,0,255,244,0,255,246,0,255,246,0,255,246,0,255,248,0,255,
            248,0,255,249,0,255,249,0,255,250,0,255,251,0,255,251,0,255,252,0,255,252,0,255,253,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,135,207,163,135,207,163,
            0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,253,0,255,252,0,255,
            252,0,255,252,0,255,251,0,255,250,0,255,250,0,255,249,0,255,249,0,255,248,0,255,248,
            0,255,248,0,255,246,0,255,246,0,255,246,0,255,244,0,255,244,0,255,244,0,255,244,0,
            255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,
            244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,0,0,0,0,0,0,0,0,
            0,0,0,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,
            255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,
            244,0,0,0,0,0,0,0,0,0,0,0,0,0,255,244,0,255,244,0,255,244,0,255,244,
            0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,
            255,244,0,255,244,0,255,244,0,255,244,0,255,246,0,255,246,0,255,246,0,255,248,0,255,
            248,0,255,249,0,255,249,0,255,249,0,255,250,0,255,250,0,255,251,0,255,251,0,255,252,
            0,255,252,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,0,0,0,
            135,207,163,135,207,163,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            253,0,255,252,0,255,252,0,255,252,0,255,251,0,255,251,0,255,250,0,255,250,0,255,249,
            0,255,249,0,255,248,0,255,248,0,255,248,0,255,246,0,255,246,0,255,246,0,255,246,0,
            255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,
            244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,244,0,255,244,0,255,244,0,
            255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,
            244,0,0,0,0,0,0,0,0,0,0,0,0,0,255,244,0,255,244,0,255,244,0,255,244,
            0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,255,244,0,
            255,244,0,255,244,0,255,244,0,255,244,0,255,246,0,255,246,0,255,246,0,255,246,0,255,
            248,0,255,248,0,255,248,0,255,249,0,255,249,0,255,250,0,255,250,0,255,250,0,255,251,
            0,255,251,0,255,252,0,255,253,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,255,0,0,0,0,135,207,163,135,207,163,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,255,246,0,255,246,0,255,246,0,255,246,0,255,246,0,255,246,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,163,0,0,0,255,
            255,0,255,254,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,
            0,255,251,0,255,251,0,255,250,0,255,250,0,255,250,0,255,249,0,255,249,0,255,249,0,
            255,249,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,
            248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,
            0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,
            255,248,0,0,0,0,0,0,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,
            248,0,0,0,0,0,0,0,0,0,0,0,0,0,255,248,0,255,248,0,255,248,0,255,248,
            0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,
            255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,248,0,255,
            248,0,255,248,0,255,248,0,255,248,0,255,249,0,255,249,0,255,249,0,255,250,0,255,250,
            0,255,250,0,255,251,0,255,251,0,255,252,0,255,252,0,255,253,0,255,253,0,255,253,0,
            255,254,0,255,254,0,255,254,0,255,255,0,255,255,0,0,0,0,135,207,163,135,207,163,135,
            207,163,0,0,0,255,255,0,255,255,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,
            0,255,253,0,255,252,0,255,252,0,255,251,0,255,251,0,255,251,0,255,250,0,255,250,0,
            255,250,0,255,250,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,
            249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,
            0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,
            255,249,0,255,249,0,255,249,0,0,0,0,0,0,0,255,249,0,255,249,0,255,249,0,255,
            249,0,255,249,0,255,249,0,0,0,0,0,0,0,0,0,0,255,249,0,255,249,0,255,249,
            0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,
            255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,
            249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,249,0,255,250,0,255,250,0,255,250,
            0,255,250,0,255,251,0,255,251,0,255,251,0,255,252,0,255,252,0,255,252,0,255,253,0,
            255,253,0,255,254,0,255,254,0,255,254,0,255,255,0,255,255,0,0,0,0,0,0,0,135,
            207,163,135,207,163,135,207,163,0,0,0,0,0,0,255,255,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,253,0,255,253,0,255,252,0,255,252,0,255,252,0,255,251,0,255,251,0,
            255,251,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,
            250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,
            0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,
            255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,0,0,0,0,0,0,255,250,0,255,
            250,0,255,250,0,255,250,0,255,250,0,255,250,0,0,0,0,0,0,0,0,0,0,255,250,
            0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,
            255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,
            250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,0,255,250,
            0,255,250,0,255,250,0,255,251,0,255,251,0,255,251,0,255,252,0,255,252,0,255,252,0,
            255,253,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,255,0,255,255,0,0,
            0,0,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,0,0,0,255,255,0,255,255,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,253,0,255,252,0,
            255,252,0,255,252,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,
            251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,
            0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,
            255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,0,0,0,0,
            0,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,0,0,0,0,0,
            0,0,0,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,
            255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,
            251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,
            0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,252,0,255,252,0,255,252,0,
            255,252,0,255,253,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            255,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,0,0,
            0,0,0,0,255,255,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,253,0,
            255,253,0,255,253,0,255,252,0,255,252,0,255,252,0,255,252,0,255,251,0,255,251,0,255,
            251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,
            0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,
            255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,
            251,0,0,0,0,0,0,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,
            0,0,0,0,0,0,0,0,0,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,
            255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,
            251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,
            0,255,251,0,255,251,0,255,251,0,255,251,0,255,251,0,255,252,0,255,252,0,255,252,0,
            255,252,0,255,253,0,255,253,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,255,0,255,255,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,0,0,0,0,0,0,255,255,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,
            252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,
            0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,
            255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,
            252,0,255,252,0,255,252,0,0,0,0,0,0,0,255,252,0,255,252,0,255,252,0,255,252,
            0,255,252,0,255,252,0,0,0,0,0,0,0,0,0,0,255,252,0,255,252,0,255,252,0,
            255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,
            252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,
            0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,255,252,0,
            255,253,0,255,253,0,255,253,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,255,0,255,255,0,0,0,0,0,0,0,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,0,0,0,0,0,0,255,255,0,255,255,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,253,0,255,
            253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,
            0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,
            255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,
            253,0,255,253,0,255,253,0,255,253,0,255,253,0,0,0,0,0,0,0,255,253,0,255,253,
            0,255,253,0,255,253,0,255,253,0,255,253,0,0,0,0,0,0,0,0,0,0,255,253,0,
            255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,
            253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,
            0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,255,253,0,
            255,253,0,255,253,0,255,253,0,255,253,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,255,0,255,255,0,0,0,0,0,0,0,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            0,0,0,0,0,0,255,255,0,255,255,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,0,0,0,0,0,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,0,0,0,0,0,0,
            0,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,255,0,255,255,0,255,255,0,0,0,0,0,0,0,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,0,0,0,0,0,0,0,0,0,255,255,0,255,255,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            0,0,0,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,
            0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,
            255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,
            254,0,255,254,0,255,254,0,255,254,0,255,255,0,255,255,0,255,255,0,0,0,0,0,0,
            0,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,0,0,0,0,0,0,0,
            0,0,0,0,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,0,0,0,0,0,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,0,0,0,0,0,0,0,0,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163
        };
        wxImage image( 102, 78, (unsigned char*)data, TRUE );
        wxBitmap bitmap( image );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#endif		
        return bitmap;
    }
    if (index == 3)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "40 76 2 1",
        "a c #00CC99",
        "b c #87CFA3",
        /* pixels */
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbba",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "baaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "baaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaa",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbba",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#endif	        
	return bitmap;
    }
    if (index == 4)
    {
        static const unsigned char data[] = 
        {
            135,207,163,135,207,163,135,207,163,135,207,163,179,179,204,179,179,204,179,179,204,179,179,204,179,
            179,204,179,179,204,179,179,204,179,179,204,179,179,204,179,179,204,179,179,204,174,174,198,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,143,143,178,223,225,236,251,253,255,251,253,255,251,253,255,251,253,
            255,251,253,255,251,253,255,251,253,255,251,253,255,251,253,255,251,253,255,144,144,173,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,123,124,167,241,248,255,241,248,255,241,248,255,241,248,255,241,248,255,
            241,248,255,241,248,255,241,248,255,241,248,255,241,248,255,223,230,242,118,118,138,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,139,149,191,184,191,217,234,245,255,234,245,255,234,245,255,234,245,255,234,245,255,234,
            245,255,234,245,255,234,245,255,234,245,255,234,245,255,131,135,165,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,125,128,172,224,240,255,224,240,255,224,240,255,224,240,255,224,240,255,224,240,255,224,240,
            255,224,240,255,224,240,255,224,240,255,178,188,217,117,117,127,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,137,137,
            172,202,219,242,217,236,255,217,236,255,217,236,255,217,236,255,217,236,255,217,236,255,217,236,255,
            217,236,255,217,236,255,202,219,242,94,94,116,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,139,149,191,168,183,217,
            207,231,255,207,231,255,207,231,255,207,231,255,207,231,255,207,231,255,207,231,255,207,231,255,207,
            231,255,207,231,255,108,111,146,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,139,149,191,200,228,255,200,
            228,255,200,228,255,200,228,255,200,228,255,200,228,255,200,228,255,200,228,255,200,228,255,200,228,
            255,138,149,191,125,125,125,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,127,130,172,190,223,255,190,223,255,190,223,
            255,190,223,255,190,223,255,190,223,255,190,223,255,190,223,255,190,223,255,190,223,255,146,162,204,
            95,95,105,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,142,142,177,178,212,249,183,219,255,183,219,255,183,219,255,
            183,219,255,183,219,255,183,219,255,183,219,255,181,218,255,176,215,255,155,186,230,89,89,105,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,139,149,191,155,186,230,173,214,255,170,208,255,168,204,255,165,200,255,162,
            197,255,159,194,255,153,188,255,172,202,255,185,211,255,198,212,242,204,204,214,133,133,133,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,150,
            150,150,179,179,185,173,182,230,166,179,255,166,179,255,185,197,255,204,214,255,223,230,255,222,227,
            241,234,234,234,224,224,224,213,213,213,211,211,211,213,213,213,160,160,160,110,110,110,169,169,169,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,154,154,154,247,247,
            247,248,248,248,250,250,250,218,218,218,199,199,199,193,193,193,178,178,178,185,185,185,191,191,191,
            198,198,198,205,205,205,211,211,211,211,211,211,162,162,162,171,171,171,177,177,177,162,162,162,135,
            135,135,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,159,159,159,234,234,234,234,234,234,
            234,234,234,182,182,182,171,171,171,178,178,178,185,185,185,191,191,191,173,173,173,159,159,159,142,
            142,142,157,157,157,161,161,161,193,193,193,226,226,226,222,222,222,182,182,182,197,197,197,124,124,
            124,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,127,127,127,150,150,150,151,151,151,170,170,170,155,155,155,176,176,176,175,
            175,175,148,148,148,138,138,138,150,150,150,163,163,163,189,189,189,213,213,213,238,238,238,237,237,
            237,235,235,235,234,234,234,232,232,232,231,231,231,230,230,230,181,181,181,200,200,200,121,121,121,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,141,
            141,141,218,218,218,214,214,214,209,209,209,214,214,214,223,223,223,176,176,176,154,154,154,209,209,
            209,244,244,244,242,242,242,241,241,241,239,239,239,238,238,238,237,237,237,235,235,235,234,234,234,
            232,232,232,231,231,231,230,230,230,219,219,219,190,190,190,171,171,171,208,208,208,96,96,96,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,139,139,139,217,217,217,222,222,
            222,218,218,218,214,214,214,209,209,209,208,208,208,239,239,239,211,211,211,187,187,187,242,242,242,
            241,241,241,239,239,239,238,238,238,237,237,237,235,235,235,234,234,234,223,223,223,202,202,202,182,
            182,182,177,177,177,190,190,190,207,207,207,224,224,224,222,222,222,136,136,136,111,111,111,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,125,125,125,230,230,230,226,226,226,222,222,222,
            218,218,218,214,214,214,209,209,209,207,207,207,239,239,239,209,209,209,197,197,197,239,239,239,238,
            238,238,232,232,232,210,210,210,189,189,189,178,178,178,187,187,187,206,206,206,224,224,224,227,227,
            227,225,225,225,216,216,216,205,205,205,195,195,195,137,137,137,85,85,85,139,139,139,135,207,163,
            135,207,163,135,207,163,135,207,163,122,122,122,215,215,215,230,230,230,226,226,226,222,222,222,218,
            218,218,214,214,214,209,209,209,212,212,212,241,241,241,191,191,191,185,185,185,179,179,179,184,184,
            184,209,209,209,227,227,227,231,231,231,230,230,230,225,225,225,207,207,207,195,195,195,182,182,182,
            182,182,182,180,180,180,161,161,161,115,115,115,80,80,80,139,139,139,135,207,163,135,207,163,135,
            207,163,135,207,163,120,120,120,119,119,119,184,184,184,230,230,230,226,226,226,222,222,222,218,218,
            218,214,214,214,209,209,209,222,222,222,238,238,238,226,226,226,235,235,235,234,234,234,232,232,232,
            218,218,218,199,199,199,181,181,181,173,173,173,176,176,176,174,174,174,151,151,151,128,128,128,99,
            99,99,101,101,101,121,121,121,79,79,79,139,139,139,135,207,163,135,207,163,135,207,163,135,207,
            163,128,128,128,183,183,183,153,153,153,110,110,110,165,165,165,218,218,218,222,222,222,218,218,218,
            214,214,214,211,211,211,235,235,235,225,225,225,206,206,206,184,184,184,168,168,168,167,167,167,170,
            170,170,164,164,164,143,143,143,116,116,116,112,112,112,139,139,139,172,172,172,126,158,110,121,191,
            86,101,101,101,77,77,77,139,139,139,135,207,163,135,207,163,135,207,163,135,207,163,157,157,157,
            203,203,203,242,242,242,229,229,229,169,169,169,118,118,118,148,148,148,206,206,206,218,218,218,214,
            214,214,179,179,179,158,158,158,162,162,162,164,164,164,154,154,154,131,131,131,115,115,115,116,116,
            116,136,136,136,167,167,167,185,185,185,188,188,188,191,191,191,128,160,112,118,175,89,119,119,119,
            76,76,76,139,139,139,135,207,163,135,207,163,135,207,163,135,207,163,158,158,158,206,206,206,246,
            246,246,242,242,242,238,238,238,225,225,225,167,167,167,118,118,118,146,146,146,195,195,195,173,173,
            173,143,143,143,129,129,129,110,110,110,115,115,115,143,143,143,167,167,167,179,179,179,182,182,182,
            185,185,185,188,188,188,191,191,191,195,195,195,161,161,161,200,200,200,137,137,137,75,75,75,139,
            139,139,135,207,163,135,207,163,135,207,163,135,207,163,156,156,156,208,208,208,251,251,251,246,246,
            246,242,242,242,238,238,238,234,234,234,230,230,230,180,180,180,117,117,117,102,102,102,122,122,122,
            139,139,139,162,162,162,173,173,173,176,176,176,179,179,179,182,182,182,185,185,185,183,183,183,162,
            162,162,144,144,144,78,78,78,51,51,51,185,185,185,120,120,120,73,73,73,139,139,139,135,207,
            163,135,207,163,135,207,163,135,207,163,155,155,155,161,161,161,254,254,254,251,251,251,246,246,246,
            242,242,242,238,238,238,234,234,234,230,230,230,226,226,226,171,171,171,167,167,167,170,170,170,173,
            173,173,176,176,176,179,179,179,182,182,182,153,153,153,132,132,132,117,117,117,126,126,126,142,142,
            142,157,157,157,167,167,167,141,141,141,113,113,113,73,73,73,139,139,139,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,118,118,118,90,90,90,195,195,195,251,251,251,246,246,246,242,
            242,242,238,238,238,234,234,234,230,230,230,182,182,182,170,170,170,173,173,173,176,176,176,139,139,
            139,109,109,109,87,87,87,95,95,95,111,111,111,126,126,126,142,142,142,157,157,157,175,175,175,
            198,198,198,230,230,230,250,250,250,107,107,107,139,139,139,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,119,119,119,74,74,74,109,109,109,214,214,214,246,246,246,242,242,
            242,238,238,238,234,234,234,186,186,186,173,173,173,176,176,176,171,171,171,61,61,61,80,80,80,
            95,95,95,111,111,111,126,126,126,142,142,142,157,157,157,197,197,197,234,234,234,255,255,255,204,
            204,204,118,118,118,69,69,69,139,139,139,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,119,119,119,65,65,65,130,130,130,234,234,234,242,242,242,
            238,238,238,189,189,189,176,176,176,179,179,179,174,174,187,134,134,173,109,109,122,111,111,111,126,
            126,126,155,155,155,210,210,210,243,243,243,242,242,242,166,166,166,81,81,81,68,68,68,89,89,
            89,130,130,130,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,95,95,95,69,69,69,150,150,150,242,242,242,192,
            192,192,163,163,163,110,110,110,77,77,80,102,102,128,147,147,194,146,146,184,212,212,218,255,255,
            255,230,230,230,129,129,129,71,71,71,72,72,72,94,94,94,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,119,119,119,77,77,77,77,77,77,92,92,92,53,53,
            53,58,58,58,68,68,68,75,75,75,66,66,69,102,102,128,166,166,176,103,103,103,60,60,60,
            78,78,78,103,103,103,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,133,133,133,75,75,75,75,75,75,95,95,95,
            140,140,140,119,119,119,119,119,119,111,111,111,74,74,74,82,82,82,113,113,113,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,
            135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,
            207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,
            163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163,135,207,163
        };
        wxImage image( 32, 32, (unsigned char*)data, TRUE );
        wxBitmap bitmap( image );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#endif		
        return bitmap;
    }
    if (index == 5)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "48 48 1 1",
        "a c #87CFA3",
        /* pixels */
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#endif		
        return bitmap;
    }
    if (index == 6)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "16 16 6 1",
        "a c Black",
        "b c #80FF80",
        "c c #2F0000",
        "d c #FFFFFF",
        "e c #3F0000",
        "f c #7F7F7F",
        /* pixels */
        "bbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbb",
        "bbbbbbffffbbbbbb",
        "bbbbfceeeecfbbbb",
        "bbbfeeaaaaaefbbb",
        "bbbcefdaaaaacbbb",
        "bbfeadfaaaaaebbb",
        "bbfeaaaaaaaaebbb",
        "bbfeaaaaaafaecbb",
        "bbfeaaaaaffaecbb",
        "bbbcaaaaffaeccbb",
        "bbbfeaaaaaeeccbb",
        "bbbbfceeeeccccbb",
        "bbbbbbbbcccccbbb",
        "bbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#endif		
        return bitmap;
    }
    if (index == 7)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "16 16 7 1",
        "a c Black",
        "b c #80FF80",
        "c c #00BF00",
        "d c #3F3F3F",
        "e c #FFFFFF",
        "f c #7FFF7F",
        "g c #7F7F7F",
        /* pixels */
        "bbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbb",
        "bbbbbbggggbbbbbb",
        "bbbbgaaaaaagbbbb",
        "bbbgaacccccagbbb",
        "bbbaafecccccabbb",
        "bbgacefcccccabbb",
        "bbgaccccccccabbb",
        "bbgaccccccfcadbb",
        "bbgacccccffcadbb",
        "bbbaccccffcaddbb",
        "bbbgacccccaaddbb",
        "bbbbgaaaaaddddbb",
        "bbbbbbbbdddddbbb",
        "bbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#endif		
        return bitmap;
    }
    if (index == 8)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "16 16 7 1",
        "a c Black",
        "b c #FFF0A0",
        "c c #80FF80",
        "d c #FFFF00",
        "e c #3F3F3F",
        "f c #FFFFFF",
        "g c #7F7F7F",
        /* pixels */
        "cccccccccccccccc",
        "cccccccccccccccc",
        "ccccccggggcccccc",
        "ccccgaaaaaagcccc",
        "cccgaadddddagccc",
        "cccaabfdddddaccc",
        "ccgadfbdddddaccc",
        "ccgaddddddddaccc",
        "ccgaddddddbdaecc",
        "ccgadddddbbdaecc",
        "cccaddddbbdaeecc",
        "cccgadddddaaeecc",
        "ccccgaaaaaeeeecc",
        "cccccccceeeeeccc",
        "cccccccccccccccc",
        "cccccccccccccccc"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#endif		
        return bitmap;
    }
    if (index == 9)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "16 16 7 1",
        "a c #80FF80",
        "b c #2F0000",
        "c c #FFFFFF",
        "d c #3F0000",
        "e c #FF6F6F",
        "f c #7F7F7F",
        "g c #EF0000",
        /* pixels */
        "aaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaa",
        "aaaaaaffffaaaaaa",
        "aaaafbddddbfaaaa",
        "aaafddgggggdfaaa",
        "aaabdecgggggbaaa",
        "aafdgcegggggdaaa",
        "aafdggggggggdaaa",
        "aafdggggggegdbaa",
        "aafdgggggeegdbaa",
        "aaabggggeegdbbaa",
        "aaafdgggggddbbaa",
        "aaaafbddddbbbbaa",
        "aaaaaaaabbbbbaaa",
        "aaaaaaaaaaaaaaaa",
        "aaaaaaaaaaaaaaaa"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, wxColour(BACK_RCOLOR,BACK_GCOLOR,BACK_BCOLOR)));
#endif		
        return bitmap;
    }
    if (index == 10)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "32 32 5 1",
        "  c None",
        "a c Black",
        "b c #FF0000",
        "c c #FFFF00",
        "d c #800000",
        /* pixels */
        "                d               ",
        "               ddddd            ",
        "     dd       ddddddd           ",
        "   dddddddddddddddddddddd       ",
        "  dddddddddddddddddddddddd      ",
        "ddddddddddddddddddddddddddd     ",
        "ddddddddddddddddddddddddddd     ",
        "dddddddddddddddddddddddddd      ",
        "ddddddddddddddddacccacdddd      ",
        " ddddddddddddddcacccaaadddd     ",
        "  dd ddddddddddccaccaccddddd    ",
        "     ddddddddddcaaaaaacddddddd  ",
        "      dddddddddacaccacadddddd   ",
        "        ddddddddcaccacddddddddd ",
        "         dddddddddddddddddddddd ",
        "            ddddddddddddddddddd ",
        "             ddddddddddddddddd  ",
        "             dddddddddddddddd   ",
        "             ddddddddddddddd    ",
        "             dddd dddddddddd    ",
        "             ddd  dddddddddd    ",
        "                  dddddddddd    ",
        "                  ddddddddddd   ",
        "                   dddddddddd   ",
        "aaaaccccbbbb           dddddd   ",
        "aaaaccccbbbb           ddddd    ",
        "aaaaccccbbbb            ddd     ",
        "aaaaccccbbbb                    ",
        "aaaaccccbbbb                    ",
        "aaaaccccbbbb                    ",
        "aaaaccccbbbb                    ",
        "aaaaccccbbbb                    "
        };
        wxBitmap bitmap( xpm_data );
        return bitmap;
    }
    if (index == 11)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "11 11 3 1",
        "a c Black",
        "b c #FFFFFF",
        "c c #808080",
        /* pixels */
        "ccccccccccc",
        "cbbbbbbbbbc",
        "cbbbbbbbabc",
        "cbbbbbbaabc",
        "cbabbbaaabc",
        "cbaabaaabbc",
        "cbaaaaabbbc",
        "cbbaaabbbbc",
        "cbbbabbbbbc",
        "cbbbbbbbbbc",
        "ccccccccccc"
        };
        wxBitmap bitmap( xpm_data );
        return bitmap;
    }
    if (index == 12)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "11 11 2 1",
        "a c #FFFFFF",
        "b c #808080",
        /* pixels */
        "bbbbbbbbbbb",
        "baaaaaaaaab",
        "baaaaaaaaab",
        "baaaaaaaaab",
        "baaaaaaaaab",
        "baaaaaaaaab",
        "baaaaaaaaab",
        "baaaaaaaaab",
        "baaaaaaaaab",
        "baaaaaaaaab",
        "bbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
        return bitmap;
    }
    if (index == 13)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "284 314 2 1",
        "a c Black",
        "b c #FFFFFF",
        /* pixels */
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbabbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaabbbbaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabbbbaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabbbbabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaabbbbaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbabaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabaaaabaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbabbbabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabbbabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbabbbabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbabbbabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaaabbbaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbaabbbaaaaaaaaaaabbbbabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaabbbaabaaaabbbbbbbbbbbaaaaaaabbbbbbbaaaaaaabbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbaaaabaaabbbbbbbbbaaabbbbaaaaaabbbbbbaabbbbbbbbbaaaaaaaabbbbbaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaabbbbbbabbbbbaaaaabbbbbbabbbbbaabbbaabbbbbaabbbbbbbbbaabbbaaabbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbabbbbbbaabbbbaaaaaabbbbbabbbbbaaaaaaabbbbbabbbbbaaaaaabbbbbabbbbbbaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbbbbbbbabbbbbbabbbbbbabbbaaaaaaaabbbbabbbbaabbbbaabbbbaabbbabbbbbbabbbbbbabbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbaabbbbbbbabbbbbaabbbbbaabbbbabbbaaaabbaaaaaababbbaaaaaaaabbbbabbbbbbaabbbbbabbbbbbbaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbbbbaabbbbbbbaaaaaaaaaabbaaabbbbabbaabbaabaaaaaaaabaaabaabbbabbbbaabbbbbaaaabbaabbbbbbbaabbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabbbbaaaaabbbbaaaaabbbbaaaaaaabbbaabbabbbbaaaabbbbbaaabbbbabbbaabbbaaaaaaaaaaaaaaabbbbbbbabbbbbaaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaabaaabbbaaaaaabbbbbbbbbbbbbaaaaaaabbabbbbbaabaaaabaaabbbbabbbbabbbaaaaabbbbbbbbbaabbbaaaabbbbbabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbaaaaabbbbbbaaabbbaaaaaaaaaabbbbbbaaaaabbbbbaaaaaaaaaaabbbbabaaaaaaaaabbbbbbbbbbbbbaaaaaabaaabbbabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbaaaabbbbbbbaabbaaabbbbbbbaaaaaabbbbbbabbbbbaabbbbbbaaabbbbaaaabbbbbbbbaaaaaaaaabbbbaaabbbbbabbaabbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaabbbbaaaaabbbbbbbabbbaabbbbbbbbbbbbaaaaaaababbbbbaabbbbbbaaabbbbabbbbbbaaaaaaaabbbbbaabbbaabbbbbbaaaaabbbbbbaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaabaaabbabbbbbbbbabbaabaaaaaaaaaaabbbbbbaaaabbbbbaabbbbbbbaabbbbaaaaaaaaabbbbaaaaaabbaabbaabbbbbbbaaaaaabbbaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaabbbaaabbbbbbbabbabbabbbbbbbaaaaaaaabbbbabbbbbaabaaaabaaabbbbaaaaaaaaaaaaaaaaaaaaabaabaabbbbbbbaaabbaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaabbbaaaabaaabbaabbabbaaaaaaaaaaaaaaaaaaaaabbbbbaaaaabaaaaabbbbaaaaaaaaaaabbbbbbbbbaababaabbbbbbbabaabbbaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaabbbbaabaaaaaaaaabbabbabbbbbbbbaaaaaaaaaaaabbbbbaabbbbbbaaabbbbaaaaaaaaaaaaaaaaaaaabababbaabbbbbaabbabbbbbaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabbbbaabaabbbbbaaabbabbabbbbbbbbbbbbbbbbbbbabbbbbaabbbbbbaaabbbbabbbaaabbbbbbbbbbbbaaababaaaaaaaaabbbaaabbbbaabbbbaabbbbbbbbbbbbbbbbbbbbbaaabbbabaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbaabbbababbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaabbbbbaababbbbbbbbabbabbabbbbbbbbbbbbbbbbbbbabbbbbabbbbbbbbaabbbbabbbbbbbbbbbbbbbbbbbaababaaabbbbbaabbabaaabbbabbbbabbbbbbbbbbbbbbbbbbbbbbaaabbbabaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbaabaababbbbbbbbbbbbbbbbbbbbbbaaabbbaaaabbbbbbabaabbbbbbbbabbaababbbbbbbbaaaaaaaaaaaabbbbbaabbbbbbbaabbbbaaaaaaaaaaaabbbbbbbbaababaabbbbbbbaabaabbaabbaaaaaaaabbbbbbbbbbbbbbbbbbbaaaaaaaabaaaaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbbaaaabaabbbbbbbbbbbbbbbbbbbbbabbbbbbbaabbbbbbababbbbbbbbbaabbababbbaaaaaaaaabbbbbbbabbbbbaaaaaaabaaabbbbabbbbbbbaaaaaaaaabbbaabababbbbbbbbbabaaabbabbbaaabbbaabbbbbbbbbbbbbbbbbbbaabbaabbabaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbaaabbaabbbbbbbbbbbbbbbbbbbbabbbbbbbabbbbbbbababbbbbbbbbaabbabaaaaaabbbbbbbbbbbbbbabbbbbaaaaabaaaaabbbbabbbbbbbbbbbbbbaaaaaabaababbbbbbbbbababaabaabbaabbbbbabbbbbbbbbbbbbbbbbbbbaaabaaaaaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbaabbaabbbbbbbbbbbbbbbbbbbaabbbbbbbabbbbbbbaaaabbbbbbbbaabbabaabbbbbbbbbbbbbbbbbbabbbbbaabbbbbbaaabbbbabbbbbbbbbbbbbbbbbbbabaababbbbbbbbbababbaababbaabbbbbabbbbbbbbbbbbbbbbbbbbbbabbbbbaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaabbbabbbabbbbbbbbbbbbbbbbbbbaabbbbbbbabbbbbbbaabaabbbbbbaaaabaaaabbbbbbbbbbbbbbbbbbabbbbbaabbbbbbaaabbbbabbbbbbbbbbbbbbbbbbaababaaabbbbbbbbababbbababbaabbbbbabbbbbbbbbbbbbbbbbbbbbbaaabaabbabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbaabbaabbbbbbbbbbbbbbbbbbbabbbbbbbabbbbbbbbabbaabbbbaaaaabaababbbbbbbbbbbbbbbbbbabbbbbabbbbbbbbaabbbbabbbbbbbbbbbbbbbbbbabaabaaaabbbbbbaababbbaaabbaabbbbbabbbbbbbbbbbbbbbbbbbbbbbaaabaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaaaabbbaabbbbbbbbbbbbbbbbbbaaabbaaaabbbbbbbbaabaaaaaaaaaaabbabaabbbbbbbbbbbbbbbbbabbbbbabbbbbbbbaabbbbabbbbbbbbbbbbbbbbbbabaababbaaabbbaabbabbbbaabbaabbbbbabbbbbbbbbbbbbbbbbbbbbbbabaaaaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabaabbabbbaabbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbaabbbaabbbbaaabbabbabbbbbbbbbbbbbbbbbabbbbbaabaaaabaaabbbbabbbbbbbbbbbbbbbbbbababaabaaaaaaaabbaaaabbaabaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbabbbaaabaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabbbbbbbbabbbbbbbbbbbbbbbbbbbbaabbbbaabbbbbbbbabbaabbbbbbaaabaababbbbbbbbbbbbbbbbbabbbbbaaaaaaaaaaabbbbabbbbbbbbbbbbbbbbbaabababaabbbbaaabbaaaaaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbabbbbaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaabbbbbbbbaabbbbbbbbbbbbbbbbbbbabbbbbbabbbbbbbbabaabbbbbbbbaabbababbbbbbbbbbbbbbbbbabbbbbaaaabbbaaaabbbbabbbbbbbbbbbbbbbbbabaabaaabbbbbbbabbabbbbaabbaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbabbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaabaabbbbbbbaabbbbbbbbbbbbbbbbbbabbbbbbbaabbbbbbbaaaabbbbbbbbaabbabaabbbbbbbbbbbbbbbbabbbaaaaaaaaaaaaaabbbabbbbbbbbbbbbbbbbaababbaabbbbbbbbabaabbbbaabbabbbbbbabbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaababbbbbbbbabbbbbbbbbbbbbbbbbbabbbbbbbbabbbbbbbbaaabbbbbbbbaaabaaaabbbbbbbbaabbbbbbabbbabbbabbbbaabbabbbabbbbbbbbbbbbbbbbaababaaabbbbbbbbababbbbbabbaabbbbbbaabbbbbbbbbbbbbbbbbbbaabbbbabbabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaabbbbbbbbaabbbbbbbbbbbbbbbbbaabbbbbbaabbbbbbbbaaabbbbbbbbaaabaababbbbbaaaaaaaabbbabaaaabbabbbbabbaaaaaabbbbaaaaaaabbbbbabaababaabbbbbbbababbbbaabbaabbbbbbaabbbbbbbbbbbbbbbbbbbaabbbbabaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbaabbbbbbbbbbbbbbbbbaabbbbbbaaabbbbbbbbaaabbbbaaaaaabbabaabbbaabbbbbbabbbaaabaaabaabbbabaaaaaaabbbaabbbbbabbbbbababaabbabbbbbbbaaabbbbaabbaabbbbbbaabbbbbbbbbbbbbbbbaaabaaaaaababbbaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaabbbbbbbbbbaabbbbbbbbbbbbbbbbbbaaabaaaaaabbbbbbbbaaaaabaabbaaaabaababbaabbbbbbbabbbaaabaaabbaaaaabaaabbaabbaabbbbbbbaabbaaaabaabaaaabbbbaaabbbbbaabaaaabbbbaabbbbbbbbbbbbbbbbbaaaaaabbaabaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbaaaabbbbaabbbbbbbaabbaaabbbbabaabababbaabbbbbbbabbbababbbbbbabbbabbbbbbaaababbbbbbbbbabbaaaaaabaabbaaaaaaaabbbbaabbaaaaabbaabbbbbbbbbbbbbbbbbaabbaaabbabbbababaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbabbbbbbabbbbbbbbaabaaabaaaabaaaababbaabbbbbbbaabaabaaaaaaaabbbaaabaaaabababbbbbbbbbabbababaababaaaaaaababbbbbaabbabbbaaaabbbbbbbbbbbbbbbbbaabbbbaaababbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbaababbbbbbbbbbbbbbbbbbbaabbbbbbabbbbbbbbaababbbaaaabaabaaaabaabbbbbbbaabaababaaaaabbbbbaaaababbababbbbbbbbbabaaaabaabbbabbaaaababbbbbabbaabbbbbabbbbbbbbbbbbbbbbbaaaabbaabababbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaabbaaaaabbbbbbbbbbbbbbbaabbbbbbaabbbbbbbbabaabbbaaabaababaabbabbbbbbaaabaaaabaaababbbbbaaaabaababaaabbbbbbaabaaabbbabbbaaaaabaaabbbbaabaabbbbbbabbbbbbbbbbbbbbbbbaabaaaaaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabbbbbaabaabbbbbbbbbbbbbbaabbbbbbbabbbbbbbbabaaabbabaabbbabbabbaabaaaaaabbbaabbbbbbaabbbaabaaabaaabaaaaabbbbabbabababbbaaaabbbaaabbbbbabbaabbbbbbabbbbbbbbbbbbbbaaaaaaabbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbaaabbaabbbbbbbbbbbbbbbaabbbbbaaabbbbbbbaaaaabaabbaaaaabbaabbaaabbbbabbbaaabaaaabaabaaaaabaaaabbaabbaaaaabbbababaaaaaaabbbaaaaabbbaabbaabbbbbbabbbbbbbbbbbbbaabbaaaaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaabaaabbbbbbbbbbbbbbbaaabaaaaaabbbbbaaaabbbbaabbaaabaabaabbaabaaaaabbbbaaaaaabbaaaaababaaaabbbbaaabbbbabbbaaaaababbbabbbbbbaaabbabbaaaabbbbbabbbbbbbbbbbbbaaaababbaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaababbaabbbbbbbbbbbbbbbbbbaaaabbaaaabbbbabaaabbbbabbbabbaaaaabbbaaaaabaabbbaaabaabbbaaabbaabbbabbbbaaaaaaaabbaaaaaaaabbbabbbbbaabaaaaaaaaaaaaaaaabbbbbbbbbbbbbbaaabaaaaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbabbbabbbbbbbbbbbbbbbbbbbbabbaaaaabbbbababaabbbaabaabbaaababbbabbaabbaabbabaaabbbaaaabbbaaababbbaababbaabbbaaaabbaabbbabbbbbbabbaaaabaabbbaabbbbbbbbbbbbbbbbbaaaaaaaabaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbabbbaabbbbbbbbbbbbbbbbbbbaaabaaaaaaaaababbabbbbaaaaaaaaababbaabbaaaabaaaaaaabbbaabaaabbbbaaaaaaabaaabaaabbabaabaaaabaabbbbbbabbaaaabbaaabaabbbbbbbbbbbbbbbbbaabaaababbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbabbaabbbaabbbbbbbbbbbbbbbbbbbbaabbbaaaaaabaabbbbbaabbaaaaabbaaaabbaabaaaabbbbbaaaaaaaaaaabbbbbbbbbbaaaabbaabaabaabaabaaabbbbbbbabaaababbbaaaabbbbbbbbbbbbbbbbbaabaaaaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabaaabbaabbbbbbbbbbbbbbbbbbbbaabbabbbbaaaaaabbaaabbbaaaaaaaaabbbabbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbaaaabbaaaabbbaabbbbbaaaaabbabbaabaabbbbbbbbbbbbbbbbaabbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabaaaababbaabbbbbbbbbbbbbbbbbbbbaaabbbbbaaaabaaaaaabbabbbbaabbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbaaaaaaababbaabbbbaaaaabbbbbbaabbbbbbbbbbbbbbbbbbaabbbaaabaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaabbbbbaabbbbbbbbbbbbbbbbbbbaabaabbaaaabaaaaaaabaaaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbaaabaaaaaaabaaaabbaaaabbbbbbbbbbbbbbbbbbaabbaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabbbbaabbbbbbbbbbbbbbbbbbaabbabbbaaaaabbaaabbabaaaaaabbbbbbbbbbbbbbbbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbaaaaaaaabaabbaaaaaaabaaaaaabaabbbbbbbbbbbbbbbbbaabbbbaababaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaaaaabaabbbbbbbbbbbbbbbbbbaababbaaaaaabbbbbbaaaaaabbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbaaaaaaaaabbaaabbaaaaaaabbaabbbbbbbbbbbbbbbbaaabaaaaabaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbabbabbbbbbbbbbbbbbbbbbbaaabaaaaaabbbbbaaaabbbbbbbbbbbaaaaaabbaaaabbbaaaaaaaaaaabbbbbbaaaaaaaaabbbbbbbbbbaaaabbbbbbaabaabaabbabbbbbbbbbbbbbbbbbabbbaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaabbbbbbbbbbbbbbbbbbbbbaaaaaaaabbaaaaabbbbbbbaaaaaaabbaaabbabbaaaaaaaaaaaaaaaaaabbaababbaaaaaaaaabbbbbbbaaaaaaaababbaaaaaaabbbbbbbbbbbbbbbbaabbbaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababaaabbabbbbbbbbbbbbbbbbbbbbaaaaabbbbaaabbbbbbbbbaaaaabaaabaababbaaaaaaaaaabbaabbaaaaaabaababbabaabaaaaaaabbbbbbbaaaaabaaaaabbabbbbbbbbbbbbbbbbbbabbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaababaaabbbbbbbbbbbbbbaaaaaaaabaaabbbbbbbaaaaaaaaaaaaaaaaaaaaabaaaaaaaaaaaaaaaaabaaabaaaaaaaaaaaaaaaaaaaaabbbbbaaaabbbbbaabbbbbbbbbbbbbbbbbabaabbabaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabaaaababbbbbbbbbbbbbaaaaaaaaaaabbbbbbbaaabaaaabbbaaaaabaababaabbaaaaaaabaabbaaaaaaabbbabaaaaaaaabbbaabaaaaabbbbbbaabbbaaaabbbbbbbbbbbbbbbaaaaabbaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabbbaabbbbbbbbbbbbbaaaaaaaaabbbbbbaaaaaabaaaaabaabbaaabbbaaaaaaaaaaaaaaaaaaaaaaabbaabababbaaaaaaabbaaaabbaaabbbbbaaaaaaaaaabbbbbbbbbbbbbaaabaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbabbbbbbbbbbbaaaaaaaabbbabbbbaaabbabaaaabbaaaabbaabbaaabbbabaabbaaaaaaaaaabbbbaabaaaabaababbbaaaaaaaaaabaaabbbbbabaaaaababbbbbbbbbbbbbabbbbaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaabbbbbbbbaaaaaaaaabbbbaabaaabaaaaaaaaabbaabaaaaabaababbbaaaabbbaaaaaaabbbbbbaaaabbaaaaaaaaaaaabbabaaabaaaaaabbabbaaaaaabbbbbbbbbbbbaabbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaabbbbbbbaaaaaaaaabbbbbbaaaaaaabaaabaaabaabbaabaabaaaabaaaaaaaaaaaaaaaaaaaaaaaaabbbabaaaaabbbbaabaaabbbaaaabaaaabbbbaaaaaaabbbbbbbbbbaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbaabaabbbbaaaaaaaaaaaaabbbbbbaaaaaabaaabaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbaaaaaaaaaaaabaaaaaaaaaaaabaaaaaaaaaaabbbaaaaaaaaaaabbbbbbaaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbaabbbaaaaaaaaabaaabbbbbbabbaaabaaaaaaaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaabaabaabaaaaaaabbbaaaaabaaaaaaabbbbbabbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbabbbbbabbbaaaaaaaaaaaaaabbbbbabaaaabaaaaaaaaaaaaaabbbbbbbaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbaaaaaaaaaaaaaaaaaaaaababbbaaaaaaaaaaaaaabbbaabbbbaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaabaaaaabbaaaabbbaaaaaaaaaaaaaaaabbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbbaaaababababababbbabbbaaaaabbaaaaaaabbaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaaaaaaaaaaaaaaaabaaaaaaaaaaaaabbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbaaaaaaaaaababbaaaaaaaaaaaabaaaaaaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaaaaaaabaabbbbbbbaaaaabbaaaaaaaabbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbaaaaaabaaaaaabbbbbbbbaaabaaaaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaaabbbbbbbbbbaaaaaaaaaaabbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbaaaaaaaaaabbbbbbbbbbbbaaabbaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabababbbbbbbbbbbbbbaaaaaaabbbaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabbbbaaaaabbbbbbbbbbbbbbbaabbbabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbaaaaabbbbbbbbbbbbbbbaaaaaaaaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaaaabbbbbbbbbbbbbbbbbbaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbaababbbbbbbbbbbbbbbbbbbbaaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbaaabbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbaabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabbbaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbabbbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbbabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabaabbbbaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbbbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaabbaabbbbabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbbaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabaabbbbbabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbaababaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabaaaaaaabaaabbbbaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbaaaaaabbaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaabaaaabaabbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbaabaaaaaaabbabbbbbababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbaaaabaabbbaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababaabaabaaaabbbaabbbbaaabbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbabbbaabaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabaaaaaaaabbbbaabbbbaabbbbbbbbbbbbbaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbabbbbaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaabbbbbbaabbbbabbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbbbbabbbaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaababbbabaaaaabbbbbbbabbbbabbbbbbbbbbbbbbbbaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbbbaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaabbbbbbbbaabbbabbbbbbbaaaaaaaaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbaaaabbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbbbbbaaaabbbbbbbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaabaabaaaaabbbbbbbaaaabbabbbbbbaabbaabaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbaababbabbbbbaabbbbbbaaabbbbbbbbbbbbbbbbbaabbbbbbbbbaaabbbbbbabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbabaaaaaabbbbbbbbaaaaababbbbbaaaabaabbaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaaabbbbaaaaaabbbbaabbaaaaabbaabbbbbbbbbbbbbbbbaaabbbbbbbbaaabbbbbbabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaaabaaaabbbbbbbaaaaaababbbbbaabaaabbbbabbaababbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaaabbbbbbababbbbaabaaabbbaaabaabbbbbbbbbbbbbbbaababbbbbbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaabaaaaaabbababbbbbbbaaaaaaaaabbbbbbbbbabbbbbbbaabaabbbbbbbbbbbbbbbbaaaabbbbaaaaabbaaaaabbbbbaaaabababbaabbbbbbaabaabbbbbbbbbbbbbbaaaaabbbbbbbaaaaaabaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaaaaaaabbbbaaabbbbbbaaaaaabbaabbbbbbbbbaabbbbaaabbaabbbbbbbbbbbbbbbbbabaaabbaaaaabbbbaaabbbbbbaaaaaaabaabbbbbbbaabbabbbbbbbbbbbbbbaaaaaabbbbbbbaaaaaaaaaabaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaabbbbbbbaabbbbbbaaaaabbbbabbbbbbbbbbaaaabbaabbbabbbbbbbbbbbbbbbbbabbbabbaaabbbbbbaabaaaaaababaaaababbbbbbbbbaabaabbbbbbbbbbbbbaaaaaabbbbbbbaaaaabaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaabbbbbbbbbabbbbbbbaaaabbbbbabbbbbbbbbbbbbabbbabbbabbbbbbbbbbbbbbbbbabbbaabaabbbbbbbbbbbbbbbabaaababbabaaaabbbbbabbabbbbbbbbbbbbbabaababbbbbbbaabbbbaababaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbabbbbbbbaaaabbbbbabbbbbbbbbbbaaabbaabbbabbbbbbbbbbbbbbbbbabbbbabbabbbbbbbbbbbbbbbabbaababbabbababbbbbabbabbbbbbbbbbbbbabbaaabbbbbbbaabbbbaaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbabbbbaaaaabbbbbbbabbbbbbbbaaaabbbaabbbbaabbbbbbbbbbbbbbbbabbbbaababbbbbbbbbbbbbbbabbbababbabbabaabbbbabbabbbbbbbbbbbbbabbbaaaaabbbbaabbbbbaaaaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbabbbbaaaabbbbbbbbabbbbbbbaabbabbbbabbbbbaabbbbbbbbbbbbbbbabbbbbababbbbbbbbbbbbbbbabbbaaabbaababbabbbbabbabbbbbbbbbbbbbabbbbaaaabbbbbabbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbabbbaaaaabbbbbbaaabbbbbbbabbaabbbbaabbbbbaabbbbbbbbbbbbbbaabbbbbaaaaaaabbbbbbbbbbaabbaaabbbaaabbabbbbabbaabbbbbbbbbbbbabbbbaaaaabbbbabbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbabbbaaaaabbbbbbababbbbbbbabaaabbbbaabbbbbbaabbbbbbbbbbbabbaabbbbbaaabbaabbbbbbbbbaabaaaabbbbbbbaabbbbabbaaabbbabbbbbbbabbbbaaaaabbbbabbbbbbbbbbbbbbbaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaababbbbbbbbbbbbbbbabbaaaaabbbbbbaababbbbbbbaaabaabbbbbbbbbbbbaaaabbbbbbaaaaabaaabbbbbaaababbbbbbbbbbaaaababbbbbaaabbbbbabbaaaaaaaaabbbbbabbbbbaaaaabbbabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbaabaaaaabbbbbbaababbbbbbbaabbbaaaabbbbbbbbbbbbaabbbbbbaabaabbaaaaabbbababbbbbbbbbbbbaabaaabbbabbbbbbaabbabaabbbbbabbbbabbbbbbaaababbabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabaaabbbbbaaaaaaabbbbbbbabbabbbbbbbbbbbbbbbabbbbbbbbbbbbbaaabbbbbabbaabbabaaaaaaaabbbbbbbbbbbbaaaaaaabbaabbbbbaabaabaabaaaaabbbbabbbbbbaaaaabbabbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaababbaaaaaaaaabbbbbbabaaabbbbbbbbabbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaabbbabbbaababbbbbabaabbbbbbbbbbbbbaaabbabbaabbbbbabbabbaababbaabbbbabbbbbbbaaaabaabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababbbaabaaaaabbbbbbaaaaabbbbbbbbabbabbbbbbbbbbbbbbaabbabbbbbbbbbbbbbbaaaaababbaaaaabbbabaabbbbbbbbbbbbbaaabbbabbabbaaaabaabaabbabbbabbbbabbbbbbbbaaababbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbabbbabbbaaaabbbbbaaaabbbbbbbbbbabbabbbbbbbbbbbbbbaabbaabbbbbbbbbbbbbbbbbababbbaaaaabbaaaabbbbbbbbbbbbabbabbbabbaaaaaabbaabaabbababbbbbbabbbbbbbbbaaaabbbbbbbaabbaaaabaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaabbaabaaaaabbaaaaaaabbbbbbbbbbaababbbbbbbbbbbbbbabbbaabbbbbbbbbbbbbbbaaaaaabbbbaabbbbaabbbbbbbbbbbbbaaaabaaaabaaabaabaabbabbaaaaabbbbbabbbbbbbbbaaaabbbbbbaaabaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaabbaaaaaaaaaaaabaaabbbbbbbbbbbababbbbbbbbbbbbbbabbbbabbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabbaaababaaabbababbaabbaabaabbbbbabbbbbbbbbaaaaabbbbbabaaaabaabbabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabaabaaaabaabbaaaaaaabbbbbbbbbbbababbbbbbbbbbbbbbaabbbabbbbbbbabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabaabababaabbbaaabaabbaaaaabbbbbbabbbbbbbbbbaaaabbbbbaaaaabbabbbabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbabbaabbbaaaaaaaaaabbbbbbbbbbbababbbbbbbbbbbbbbaababbbbbbbbbaaaabbbbbbaaabbbbbbbbbbbbbbbbbbbbbabbbbbababbaaabaabbaaabaabbbaaaabbbbbbbabbbbbbbbbbaaaaabbbbaaaaababbbaabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaabbaabbbaaabbbaaaaaaaabbbbbbbbbbbaaabbbbbbbbbbbbbbbababbbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbabbbabbaabababbbaaaaabbaabaaabbaaaabbbbbbbbabbbbbbbbbbaaaaabbbbbbbabaabbaabbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaabbbbbaaabbaaabbaaaaaaababbbbbbbbbbbbaabbbbbbbbbbbbbbbaaabbbbbbbbbbbabaabbbaabbbbbbbbbbbbbbbbbbaabbbaabaabaaaabbbbaabbaaaaabbbaaaaabbbbbbbbabbbbbbbbbbaaaaabbbaaaaaaaaabaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaaaaabaaabaaaabbaaaaabaaaaaabaabbbbbbbbbbbaabbbbbbbbbbbbbbbaaabbbaabaabbbabbaaaaabbaaaaaaaaaaaaaaabaaabbaaaaaaabaaaaaaaabbbaaaabbaaaaaabbbbbbbbbabbbbbbbbbaaaaaaaaaaaaabaaaabababaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbabaaaaabaaababbaabaaababaabbbbabbbbbbbbbbbbabbbbbbbbbbbbbbbbbabbbabbaabbbabbaabbbaaaabbbbbbbbbbbbbbababbabaabbaaaabbbbbabbbaaabbbabaaabbbbbbbbbbabbbbbbbbbabbbaaababbaabaaaaaabaabbbaaabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaaabaabbbbbbabaaabaaabaaaaabbbaabbbbbbbbbbbabbbbbbbbbbbbbbbbaabbaabaaaabbaaaabbaaabbbbbbbbbbbbbbbaaabaaaabbaaaaabbbbbbbabbaaabbaaaaabbbbbbbbbbbbabbbbbbbbaabbbaaaaaaababaaaaaabbbaaaaaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaaaabbbbbbabaaaabbaaaaaaabbbaabbbbbbbbbbbabbbbbbbbbbbbbbbbbaaaaababaabbaaabbaaabbaaaaaaabbbbbaaabbbbaabbbaaaaabbbbbbbabbaabbaaaaaaabbbbbbbbbbbabbbbbbbbabbbbbaaaaaabbabaaaaaabaaaaaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaabbbbbbbaaaaaaaabaaaaaaaabbbabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbaaabbabbababaaaaaaaaaaaaaaaaaaabbbbabbbbbbaabbbbbbbbbbabbabbaaaabbbaabbbbbbbbbbabbbbbbbbabbbbaaaaaaaaaaaaaaaaaaabbaaaaaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbaaaabbbbbbbabaabababbbaaaababbbabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbaabbabbabababababbbbbbbbbbbbbbbbbbababbbbabbbbaaaabbbabbabbaabbbbbbaabbbbbbbbbabbbbbbbaabbbbaaaaaaaaaaaaaaabbbbbbaaaababbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbaaabbbbbbbbaaaababaabaaaaabaabbaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbaababaaaabaaaaabbbbbbbbbbbbbbbabbabaabbbaabaaaaaaaaaabaabbabaaaabbbaabbbbbbbbabbbbbbbabbbbbaaaaabaaaaaabaabbbbbbbabaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbaabbbbbbbbbbbabbaaabbaaababbabbaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabaaabbbbbbbbbbbbabbbabbaababbbaababbbbbbbaabbabbbbaaaaabbaabbbbbbbbabbbbbbbabbbbbaaaaaabaaabaababbbbbbbaaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaaabbaaaaaabbbbbbbbbbaaaaabbabbbabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaaabbbbbbbbbbbbabbaabbbabaabbaaaabaaabbbbbbbbbbbaaaaaabbbabbbbbbbbabbbbbbaabbbbaaaaababbabaaababbbbbbbaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbabaaaaaaabbbaaabbbbbbbbbaaabbbabbbaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbabbaaabbabaaaaaaabaabaabbbbbbbbbbaabbaabbbabbbbbbbbabbbbbbabbbbbabaaababbaaabaaaabbbbbbbaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbabaaaabbbbbaaaaaaaaabbbaaabbbbabbbaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbabbbbbabbaaabbaabaabbaababaaabbbbbbbbbbaaaaaabbbabbbbbbbbabbbbbbabbbbaabaaaaabaaabbaaaabbbbbbbaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaaaaaaaaaabbbbaaaaabbbbbaabbababbbbabbbbabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabbbbbbbabbbbbaabbaaabbaabaaaaaaabaaaabbbbbbbbbaaaaaaabbabbbbbbbbabbbbbbabbbbaabbaaabbaaabbbaaaaaaabbbbababbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaaaaaaabaaaaabbbaaaaaaabbbbbabaaaabbbbabbbbabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbaabbbbbaabbbbbbaabaaabbbabbaaabaaaaaaabbbbbbbbbbabaaaabbaabbbbbbbabbbbbbabbbbabbbbaabbbaaaaaaaaabbaaaaaaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbabbbbbbabaaaabbaaaaaaaaaabbbbaaaaaabbbaabbbbabbbbbbbbbabbbbbbbaaaaaabbbbbbbbbbbbbaabbbbbbbbabbbbbaabbbbbbbabaaaabbaabaaabbaaabbaabbbbbbbbbaaabaaabbabbbbbbbabbbbbbabbbbabbbbaabbbbaabbbbbbbbbbbaaaaaabbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaabbbbaabaaaaaaaaaabbaaaabbbbbaaaaabbbaabbbbabbbbbbbbbabbbbbbaabbaaaaabbbbbbbbaaaabbbbbbbbbaabbbbaabbbbbabaabaaaabbaabaabbbbbbbbabbbbbbbbbaaaaababbaabbbbbbabbbbbaabbbbabbbbaaaaaaabbbbbbbbbbbbbbaaaaaaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbabbbbaaaaaaabaaabbbbbaaabbbbbaaaaabbbabbbbbabbbbbbbbbabbbbbbaaaaabbbbabbbbbbaabbbbbbbbbbbbbabbbbaabbbbbabbaababaabbabaabbbbbbbbabbbbbbbbbaabaaaaabbaaabbbbabbbbbaabbbbaabbbaaaaabbbbbbaabbbbbbbbaaaaabaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbbaaabbaabaaaabbaaaabbaaaabbbbbaaaaabbbabbbaaabbbbbbbbbabbbbbbbbbabbbbbabbbbbaabbbbbbbbbbbbbbaabbbaabbbbbaabbabaaaaabaaaabbbbbbbbaabbbbbbbbaabaaaaaaaaaabbbbabbbbbaabbbbbabbbaaaabbbbbaaaaaaabbbbbaaaaabbbbbaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaaabbaaaabbaaaaaaaaaaabbbbaaababbbaaaaababbbbbbbbbabbbbbbbbbaabbbaabbbbaabbbbbbbbbbbbbbbbaabbbaabbbbaaabbbbaabaabaaabbbbbbbbbaabbbbbbbaabbbaabbbbbbbbbbabbbbbaabbbbbabbbaaaabbbbbabaaaaabbbbbaaababbbbbbbabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaabbbbbaaabbbbbbbbbbbbbaaaaaaaabbaaaaaaaaaaabbbbaaaaabbaabbbbbabbbbbbbbbabbbbbbbbbbabbbabbbbaabbbbbbbbbbbbbbbbbbabbbaaabbbabaaabbbaababaaabbbbbbbbbbaabbbbbbaabbbbbbbbbbbbbbbabbbbbaabbbbbabbbaaaabbbbbaaaaaaaaabbbaaaaabbbbbaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbbaaaaaaaabbaaaabbbaaaabbbaaaaabbabbbbbbabbbbbbbbaabbbbbbbaaaabbbaabbaabbbbbbbbbbbbbbbbbbbabbbababbaabbbaabbaabaaabaabbbbbbbbbaaabbbbbabbbbbbbbbbbbbbbbabbbbbaaaabbbabbbaaaabbbbaaaabaaaaaaaaaaaaabbbbaabbbbbbbbabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaaabbbaaabbbbbbbbbbbbbbbaaaaaaaabbaaaabbbaaaabbbbaaaabbabbbbbaabbbbbbbbaabbbbbbaabbbbbbbaaaabbbbbbbbbbbbbbbbbbbbabbaababbaabbbaaabbabaaabaabbbbbbbbbbaaabbbbabbbbbbbbbbbbbbbbabbbbbbabaaaaaabbaaaaabbbaaaabbbaaaaaaababbbbaabbbbbbbbbbaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbabaaaababbaaaabbbaaabbbbbaababbabbbbbaabbbbbbbababbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbabaabbbbbbaababaabbbaabbbbbbbbbbbaabbbabbbbbbbbbbbbbbbbabbbbbbabbbbbbabbaabaabbbaaaaaabaaaabbaaaaabaabbbbbbbbbbbabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaaaabaaaabbbbbaaaaaaaaaabaaaababbaaaaaaaaaaaaabbaababbabaaaaabbbbbbbaababbbaababbbbbbbbbbbbbbbbbbbbbbbbbaababaaabaabbababbbbbbbbababaabbbbaabbbbbbbbbbbaaabaabbbbbbbbbbbbbbbabbbbbbabbbbbbaabaababbbaaaaaaaaaaabbbaaaaababbbbbbbbbbbbaaaaaaabbbabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbaaabaaaaaabbaaaababbaaaaabbaabbaaaaaaaaabaaaaaaabbbbbbbabbabbbabaabbbbbbbbbbbbbbbbbbbbbbbbaabaaaabaaabbabaabbbbbbbbaaabbbbbbbbabbbbbbbbbbbbaabaabbbbbbbbbbbbbbbabbbbbbabbbbbbbabbababbbaaaaaaabaaabbaabaaababbbbbbbbbbbbabbbbbbbbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbaaabbbbbbbbbbaaaababbaaaaabbaabbabaaaaabaaaabbbabbbbbbbaabbabbbaaaaabbbbbbbbbbbbbbbbbaabbaaabbbbaaaaaaaaaaabbbbbbbbbaaabbbbbbbbaabbbbbbbbbbbaabaabbbbbbbbbbbbbbbabbbbbbaabbbbbbabbababbbaaaabbaaaaabbaabaaababbbbbbbbbbbbaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbaabbbbbbbbbbbbaaaababbaaaaaaabaaaaaaaaaabbaaaaaaabbbbbaaabbbabbbaabbaaaaabbbbbabbbbaabaaaaaabbbaaaabbbbbbaaabbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbbabbaaabbbbbbbbbbbbbabbbbbbbabbbbbbabaabaabbaaaabbbaaaabbaabaaababbbbbbbbbbbaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaaaabbbbbbaaabbbbbbbbbbbbbbaaababbaaaabaaaaaaaaaaaaabbbaaaabbbbbaaaabbbbabbbabbbbbbaabbbaaabbbaaabaaaabbbbaaabbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbaabbbbbbbbbbabbaaaabbbbbbbbbbbbaabbbbbbaabbbbbaaaaaaabbaaaabbaaaaabbaabaaabaaaaaaaaaabbbaaaaaaabbbabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaababbaaaaaabbbbbbbbbbbbbbbaaababbaaaabbbaaabbbaaaaabbbbaaaaaaaaabbbbbbbabbbbbbbbbbaaabbababbaabaaaabbbbbaabbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbaabbbbbbbbaabaaabbbbbbbbbbbbbbaabbbbbbbaabbbaaaaabaaaaaaaaaaaaababaaabaaabbbaaabbbbaabbabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbaaaaaabaaaaabbbaaabbbaaaaabbbbbbbaaabbbbbbbbbbabbbbbbbbbbaaaaaabaaaabbaaaaabbbaabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbaaabbbbbaabbaaaabbbbbbbbbbbbbabaabbbbbbaaaaaabaaaaaabbbaaaaabaaabaaaaaaabbbbbbbbbbbaabaaaaaaaabaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaaaabaaaabbbaaaaabbbbbbbbbbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbbbaababbaabbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbaaabbbaabbbaaaabbbbbbbbbbbbbabbaaabbbbbbaaabbaaaaaaabbaaaaaaaaabaabbaabbbbbbbbbbbbbaaabbbbbbaababbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaaaaaababbbbbaabbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbbbbabaaaabbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbaaaaaabbaaaabbbbbbbbbbbbbbabbbbaaaaaaaabbbbaaaaaaaaaaaaaaaaaabaabbaabbbbbbbbbbbbbbaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbaaaaaaaaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbabbbbbbbbbbbbbabbaabbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbabbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaaaabbbaaabbbaaaaabaaaaaabbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaabaaaaaabbbbbaaaabbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaaabbbbbbbaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaaaabbbaaabbbaaaaabaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaababaaabbbbbbaaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabaabbbbbaaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbaabbbbaaabbbaaaaabbaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaaaaaabbbbbbaaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbaabaaaaabaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaaabbbbaaaaaaabaaabbaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbaaaabaaabbbbbbaaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbaaababababbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaaabbbbaaaaaaaaaaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaaabbbbbbbaaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaabaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaaabbaabbaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaabaabbbaaaaaaaaaaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaabbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbaaabbaabbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbaabbabbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaababbbaaaaabbbabaabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaaaaabbbbbabaaaabbbbbbbbbbbbbbbbbbaababbabbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaababbbbaaaabaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaabbbaabbbbababaabbbbbbbbbbbbbbbbaaaaaabbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaaaaaabbbbaaaaaaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaaaaaabbbaaabbabbbbbbbbbbbbbbbaaaaaaabaabbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabaaabbbbbbaaaaaaaabbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabbbbbbbbaabbbbaabbaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbaaabbbabbbaaabaabbbbbbbbbbbbbbaaaabaababbbbbbbbbbbbbbbaaabaaaabbbaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabaaabbbbbbbaaaaabbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbaaaabbaaaabbaaabbbbbbbbbbbbbbbbbbabbbbbbbbbbaaaabbbaabbbbaabbaaabbaabbbbbbbbbbbaaabaabaababbbbbbbbbbbbbbbaaabaabaaaaaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbbaaaaabbbbbbbaabbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbaaaabaabaabaaaabbbbbbbbbbbbbbbbbbabbbbbbbbbaabbaaabbabbbbaabbbbbbbbabbbbbbbbbbbaaaaaabbababbbbbbbbbbbbbbbaaaaaaabaabbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbaaaaabaaabaaaaabbbbbbbbbbbbbbbbbabbbbbbbbbabaaaaaaaaabbbaabbbbbbbbabbbbbbbbbbbabaaaaabbbabbbbbbbbbbbbbbbaaabaabbabbaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbbbbbabaabaaaaaaaaaabbbbbbbbbbbbbbbbbabbbbbbbbbaaaaabbbaabbbbabbbbbbbbbaabbbbbbbbbbabbaabbbbbabbbbbbbbbbbbbbbaaababbbbbaabaabbbbbbbbbbbbbbabbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababbbbbbaababaaaaaaaaaabbbbbbbbbbbbbbbbbabbbbbbbbbaababbbbbbbbbbabbbbbbbbbbaabbbbbbbbbabbbbbbbbbaabbbbbbbbbbbbbbaaaaabbbbbabbbabbbbbbbbbbbbbbabbbbbbbbbbbbbaaaabaaabbbaabbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbaabaaaaaaaaaaaabbbbbbbbbbbbbbbbbabbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbabbbbbbbbbaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbaaaaaaaabbbaaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaababbaaaaaaaaaaaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbaabbbbbbbbbbaaaabbbbbbaabbbbbbbbbbaaaabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbabbbbbbbbbbbbaaaaaaaaaabaaaabbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbaaabaaaabbbaaaaaabbbbbbbbbbbbbbbbbabbbbbbbbbbbbbabbbbbbbbbbbbaaaabbaaabbbbbbbbbbbbbbabbbaaababbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbabbbbbbbbbbbbaaabaabababababbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabaaababbaabbbbaaaaaaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbaaaabbbbbbbbbbbaaaaaabbbbbbbbbbbbbbaabbbabababbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbabbbbbbbbbbbaaaaaaaaaaaaababbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabababbaaaaabbaababaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbabbbbbbbbbbbaaaaaaaaaaaabaabbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbababbaaaaaaaaaaabaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbabbbbbbbbbbbaaaaabaaaaaababbaaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaabaabaaababbbbaaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbbbbbbabaabbbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbabbbbbbbbbbbaaaaabaabbbbbabbabaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaabbabbaaaabbbbbaaaaaabbbbbbbbbbbbbabbbbbbbbbbbbaababbbbaabbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaaaaaaaaabbaabbbbbbbbbbbbbbaaaaabbbbbbbbbbbbabbbbbbbbbbbaabaaaaababaaaaaababbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaabbabaaaaabbbbbbabaaabbbbbbbbbbbbbabbbbbbbbbbbbabbabbbaaaabbbbbbbbbbbbbbbbbbbbbbbabbaabbbbaaabaababaaaaaaabbbbbbbbbbbbbaabbbbbbbbbbbbbbabbbbbbbbbaaaababbaaaaaaaaabbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbabaaaaaaaaabbbbbbaaaaabbbbbbbbbbbbbabbbbbbbbbbbbabaaaaaababbbbbbbbbbbbbbbbbbbbbaababaaaaaaabbabaaaaabbbbbbabbbbbbbbbbbaabaabbbbbbbbbbbbbabbbbbbbbbaaaaaaaaaaabaaabbbaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaaabaabbbbbbbbaaaaabbbbbbbbbbbbabbbbbbbbbbbbaaabbbbbbabbbbbabbbabbbbbbbbaabaaaaaaabaaaaabaabbaaabbbbbbaabbbbbbbbbbaaaabbbbbbbbbbbbbbabbbbbbbbaaaaaaaaaaaaaaabbbbabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbabbbbbbbbbbbbaabbbbbbbabbbbbaabaabbaabbbaaababaaaaabaaaabbbaaaaabbbbbbbbabbbbbbbbbbbaaaabbbbbbbbbbbbaabbbbbbbbaaaaabbbbbaaabaabbaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbabbbbbbbbbbbbbabbbbbbbaaabbbaaaabbaaabbbaaaaabbbabaaabbbbbbbaaaaaaaabbbaabbbbbbbbbaabbaabbbbbbbbbbbbaabbbbbbbaaaaabbbbbaaaabbabbbabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbabaaaabaaaaabbababababbaaabbbbbbbbbbbbbaaaaabbbabbbaabbbbbbbbbaaaaabbbbbbbbbbbbbaabbbbbbbaaaaabbbbbaaaaababbbabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaabbaaaaaaabaaaaaababbbaabbbbbbbbbbbbaaaaaabbbbabaabbbbbbbbbbbaabbbbbbbbbbbbbbbaabbbbbbbaaaabbbbbbaaaaaaaaababaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbaaaabbbabaaaababaaaabbbbbbbbbbbbbbbbbbbbbabbbbbaaabbbbbbbbabaabaabbbbbbbbbbbbbbaabbbbbbbaaaabbbbbbbbabaaaaababaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaabaaabbbbbbbbbbbbbbbbbbaaabbbbbabbbbbbbbaaaaaaaabbbbbbbbbbbbbbbaabbbbbaaaabbbbbbbbbbbbbaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabaaabbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbaabbbbaaaabbbbbbbbbbbbbbbbbbaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbaaaaaabbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbababbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbabbbbbabbbbbbbbbbbbbbbbbbbbbaabbaaaaaabbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbaaaaaaaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbbbbbbbaaaaabbabbbbbbbbbbbbbbbbbbbbbaabbabaaaabbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbbbbbbbbbbbbbbbb",
        "bbaabbbbbbbbbbabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaabbbbbbbbaaaabaabaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbaabbbbbabbaaaaabbbbbbbbbbbbbbbbbbbbbaabaaaaaabbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbabbbbbbbbbbbbbbbbb",
        "bbaaabbbbbbbbbabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbabaaaaaaaaaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaaaabbbabbaaabbbbbbbbbbbbbbbbbbbbbbbaabaaaaaabbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbabbbbbbbbbbbbbbbbb",
        "bbabaabbbbbbbbabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbaaaababbaabaaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabababbbabaaabbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaabbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbabbbbbbbbbbbabbbbb",
        "bbaabaaabbbbbbabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbaabaaabbaaaaaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaaaaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaaabbbbbbbbaaaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabbbbbbbbbbaabbbbb",
        "bbaabbbaaabbbbabbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaababbbbbaaaaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbabbbbbbbbbaaabbbbb",
        "bbbabbbbaaaabbaabbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabababaabbaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbabbbbbbbaaababbbbb",
        "bbbaabbbbbbaaababbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbaaaaabbbaaaaabaaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaaaaaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbabbbbbbaabbbabbbbb",
        "bbbbabbbbbbbbaaaabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaababaaaaaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbabbbaaaabbbaabbbbb",
        "bbbbaabbbbbbbbbaabbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbabbaaabaaaabaaabbaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaabaaaaaaaabbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbabaaaabbbbbabbbbbb",
        "bbbbbaabbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaababaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbaaaabbbbbbbaabbbbbb",
        "bbbbbbaabbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaaaaaaaaaaababaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaaaaaaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbabbbbbbb",
        "bbbbbbaaaabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbaabbbbbbb",
        "bbbbbbbbaaabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbaaaaaaaababbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaabbaaaabaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbb",
        "bbbbbbbbbbaaabbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbaababaaaaaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabaaaabaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbb",
        "bbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaabaaaabaabaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbaabaaaaabbabbaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbb",
        "bbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababaaaaaaaaaaaaaaaaaabaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbb",
        "bbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaababaaaaabaaaabaaaaaaaaaabbaaaaaabaabbbbaabbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbabbbbaabbbbbaaaaaaaabaaaaaaaababbaaabaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaabaaabbbaaaaaaabbbbaabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbaabbbbabbbbaaaaaaabaaaaaaaaaaaaaabababaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbbabaaaaaababbbbaaaaaaaabbbabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbaabbbaaaaaaaaaabaabaaaaaaaaaaabaaaaabbbabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaababbbbaaaaaabaaaabbbbbbaaaaaaabaabbbbbbbbbbbbbbbbbbbbbaaabbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbabbaaaaaaaababbaaaaaaaabaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbaaaaaaaaaabbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbabaaaaaaaaaaabaaaaabaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaaaaaaaaaaaaabbbbbbbbaabbabaaaaaaaabbbbbbbbbbbbbbbbbbbaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbaaaaaaaaaaabbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaabbbbbbbbbbbabbbbbabaaaaaaaabbbbbbbbbbbbbbbbbbaabbaabbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbabbaaaaaaabbaaaaaaababaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaabaaabbbbbbbbbbaabbbbaaaaaaaaaaabbabbbbbbbbbbbbbbbbaababbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbaabbbbbbaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbaaaaaaababaaabaabbbbbbbbabbbbbaabbaaaabaaaaaaaaaabbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaaaaaaaabbbaabbbbabbbbbbbbbbaaababaaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabaaabbbbbbaabbbbaabbbaaaaaaaaaaaaaaaaabbbbbbbbbbbaabbbbbbbbbbbbaaaaaaaaaaaaaaaabbbbabbbbaabbbbbbbbbaaaaabaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaabbbbbbaabbbbbbbbbbbbbbbbbbbaabaaabaaababaaaabbbbaabbbbbabbbbaaaaaaaabbaaaaaaaabbaaaaabbbbbbbbbbbbabbaaabaaaabaaaaaabaabbbbbabbbbabbbbbbbbbaaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbaaaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbaaaaaaaaaaabaaaabbbbabbbbbaabbbbabaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabaaaabaaaaabaabbbbaabbbaabbbbbbbaaaaaaaabaaaaaaaaabbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbaaabbbbbaaabbbbbaabbbbbbbbbbbbbbbbbbaaaaaaaababaaaabbbaabbbbaabbbbbaaabaaaaabbaabaaabbaaaaaaaaaaaaaabbbaaaaaaabaaaaabbbaaaaabaabaababbbbaabbbbbaaaaaaaaaaaabaaaaabbbbbbbbbbbbbbbbbbaaabbabbaaabbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbaaabbbbbbaaaaabbbbbaabbbbbbbbbbbbbbbbbbaaaaabaaabaaaaabaabbbbaabbbbabaaaaaaaaaaaaabbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaabbaaaaaaaabaaaaaaaaaabbbbaabbbbaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbaaabbbaaaabbaaabbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbaaabbbbbbbaaabbaabbbbbaabbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaabbbbbabbbaaaaaabbaaaaaabbabbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbaaaaabaaabaaaaaaaaaaabbbbabbbaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbaaabbbaabbabbbbaaabbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbaaabaabaabbbbbaabbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbbaabbbaaaaaaaabaaabaaaabbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbaaabaaaaabaaaaaaaaabaabbbaabaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbaabbbaaabbaabbbbbaaaabbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbaaabaaaabaabbbbbaabbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbaabbbbbbaaaaaababbaabbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbaabbaaababaaaaaabbbabbbbaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbaabbbbaabbbaabbbbbbbbaabbbbbbaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaaabbaaaabbbbbbbaabbaaaaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbaabbbbaaaaaaaaaaabaabbbbbbbbbbbbbbaaaaaaaaaaaabbbbbbbbbbbbbbaabaaaaaaaabbaaabbaabbbbaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbaaabbbaaaaaaabaabbbbbbbbaaaaabaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbaaabbbbbaabbaaabaaaabbbbbbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaabbbbaabbbbbaaaaabbbbbbbbabbbbbbbbbbbaaaaaaaaaaaaaaaaabbbbbbbbbbbbbaabbaaaaaabbbaabbbabbbbbaabaaaaaaaaaabbbbbbbbbbbbbbbbbbaabbbbaaaaabaabaabbbbbbbbbbaaaaaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbaabbbbbbbbbbbbbabbbbbbbbaaabbbbaabaaaaaaabbaaabbbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaaabbaabbbbbaaaabbaaaaaaaaaaabbbbbbaaaaaaaaaaaaaaaaaaaaaabbbbbbbbaaaababbbabaaaaaabbbbabbbbaaaaaaaaaaabbbbbbbbbbbbbbbbbbaaabbbbaabaabbaaabaabbbbbbbbaaaaaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbbbbaaabbbbaabaaaaabbaabaabbbbbaabbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbabbbbaaaaabbaaaaabbbbaaaaaaaaaaaaabaaaaabaaaaaabbbbbaaaaaaaaaabbbbaaaabbbbbabbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbabbbbbbbaabaabbbabbaabbbbbbaaabbbbbaabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbaabbbbbbbbbbbaabbbbbbbbbbaaabbbaaabaabbbaababaaabbbbaabbbbbbbbbbbbbbbbbbbbabaaaaaaaabbaaaaabbaabbaaabbbaaabbbbaaaaaaaabbbaabaaaaaaaaaaaaabbbbaaaabbbaaaaaabbbaaaabbbaabaaaaaaaabbbbbbbbbbbbbbbbbbbbaaabbbaaabbaabaaabaaaaabbbbaaaabbbbbbbabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbbbbbbaabbbbabaabbaabaaabaabbbbbaabbbbbbbbbbbbbbbbbbaabbaaaaaaaababbbaaaaaabbbabbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbaaabbbaabbbbaabbbbabaaaaaaabbbbbbbbbbbbbbbbbbbbaabbbbbaaaaaabbbaabbaabbbbbaaabbbbbbbbbaabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaaabbbbbbbbbbaaabbbaaabbaabbaaaaaaabbbbbaaabbbbbbbbbbbbbbbaabbbbaaaaaaaaaaaaabbbbaabbabbbbbbbbbbaaaaaaaaabbbaaabbbaaaaaaaaaabbbbbbbbbabbbaaaaaaaaaabaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbaabbbbbbaaaaabaaabaaabbbbbbaaabbbbbbbbbbbabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbaaabbbbbbbbbbbaabbbbbbaabbabaaaaabaabbbbaabbbbbbbbbbbbbbbabbbbbaaaaaaaaaaaabbbbbbabaabbbbbbbbbbabaabbaaaaaaabaaaaaaabbaaaaabbbbbbbbbaabaabbbbbbaaaaaaaaaabaababbbbbbbbbbbbbbbbbbbaabbbbaaaababbbabaabaabbbbbaabbbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaaaabbbbbbbbbbaabbbbbabbaaaaaabbaaaabbbbaaabbbbbbbbbaaaaabbbbaabbaabaaaaaaaaabbbababbbbbbbbbbbbaaaaaaaaaaaabaaaaaaaaaaaaabbbbbbbbbbbaaaaabbbbbaaaaaaaaaaabbbaabbbbbbbbbbbbbbbbbaabbbbaaabaaaaabaabaaaabbbaaabbbbbbbbbbbbbaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaaaabbbbbbbbbaabbbbaabaabaaabaaababbbbbaabbbbbbbbbabbbabbbbabbbbbbbbaaaaaaaabbabaabbbbbbbbbbbbaaaaaaaaaaabaaaaabaaabaabbbbbbbbbbbbbaababbbbbaaaaabaabbabbbbaabbbbbbbbbbbbbbbaabbbbaabaaaabbabbaababbbbbaabbbbbbbbbbbbbbabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbaaaaabbbbbbbaabbbbaabaaaabbaabbabbbbbbaaabbbbbbaabbbbaababbbbbbbbbaaaaaaaaaaaaaaaaabbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbbaabbaaaaaabbbbbbbbbbaaabbbbbaabaaabaaaaabaabbbbaaabbbbbbbbbbbbbaaabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbaaaabbbbbbaabbbbaaaaabbaabbbabaaabbbbaabbbbbbabbbbbbaabbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbaaaaaaabaaabaaabaaaabbbbbbbbbbbbbaaaabaaabaaaaabbbbbbbbaaaabbbbabbbbbbbbbaaabbbbbbaababbbaaaaaaabbbbaabbbbbbbbbbbbbbaabbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaaaabbbbbaabbbbaaaabaabaabaaaaaabbbbaabbbbbaabbbbbaabbbbbbbbbbbbbaaaaaaaaaaaaabbaabbbbbbbaabaaaabaaabaaaaaaabbbbbbbbbbaaabaaaaaaaaaabbbbbbbbbbbbaabbbbbbabbbbbbbbaaabbbaabbaabaabbabaaaabbbbaabbbbbbbbbbbbaaaabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbaaabbbbbaabbbbaabaabaaaaaabbaabbbbbaaabbaaaabbbbbabbbbbbbbbbbbbbbbbbaabaaabaaaaaaaaabbbaabaaaaaaaaaaaabbaabbbbbbaaaaabaaaaaaaaaaabbbbbbbbbbbbbaabbbbbbabbbbbbaaabbbbaaaabbabbaababaabbbbbaabbbbbbbbbbbaaaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbaaabbbbaabbbbbaabaaaaaabaaabaaabbbbaaaabbaaabbaabbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbaaaaaaaaaaaabaaaaaaaaabaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbaabbbbaaabbbbbaaabbbbaabbaaaaaabaaabaabbbbaaabbbbbbbaaaaaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbaaababaabaabaaaaabbbbaaabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaaaaaaaaaaaaaaaaaaaaaaabaaaaaaabaaaaababbbbbbbbbbbbbbbbbbbbbbabbbbaabbabbbaabbbbbbaababbaaaaabbbaabbbbaababbbbbbaaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbaababbbaabaabbbaabbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbaaabbbbbaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbaaaaaabbbaaaaabbbaaabaabaaabaaaaaaaabbbbaabbabbbbaaabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbbaabbaabbaabaabaabbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbaaabbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaabbbbbaaabbaaaaabbbaaabbbbbaaabbbabbbaabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbaabbbbbbaabbbbbaaaaabbaabaaaababbaabbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbaaaaaabaabbbbbbbbbbbbababbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbabaabaababaaabaabbbbaaabbbbabaaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbabbbbbbbaabbbbbbaabbaabaabaababaaaabbbbbbaaaaabbbbbbbbbbbbbbbbaaaaaabaaaaaabbbbbbbbbbbbaaabbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbaabbabbaababbaaaaaabbbbaaabbbbbaaabbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbabbbbbbbbaabbbbbabbaabbabaaabababaaaabbbbbbbbaaaaaaaaaaaaaaaaaaababaaaaabaaabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbbbbbbbbbbaaaaaaabbbbbbbaaaababbbabaaaabbbabbbbaabbbbbbbaaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbabbbbbbbbbaabbbbbbbabbaabaabaaaabaabaabbbbbbbbbbbbbbbbbbbbbbbbaaaabaaaabaaabbbbbbbbbbbbbaaabbbbbbbbbbbbbbbaabbbbbbbbbbaaaaaaaaaaaaaaaaaaabbbbbbaabbbabbaaabbbaaaababbbbbbbaabbbbbbbbabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbabbbbbbbbbbaaabbbbbaaabaaabaabaabaaabaabbaabbbbbbbbaaabbbaaaabaababaaaabaabbbbbbbbbbbaaaaaaaaaaabbbbbbbbbaaaabaaabbbbbbbbbbbbbbbbabbbbbbbbaaaaaaabbbaabbaaaaabaaaaaabbbbbaabbbbbbbbbabbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbabbbbbbbbbbbaaabbbbbbaabbbbabaabaababaabbaaaabbbbaaaaaabbabbabbababbbbabaabbbbbbbbbaaaaabaaaaabaaabbbbbbbaabaaaaaabbbbbbbbbbbbbbbbbaabaaaaaabbbaabbbbabbbabaaabaaaaabbbbaabbbbbbbbbbabbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbaaaaaababbbaaabaabbabbaabbaabbabaabaabaaaabaabbbaaaabbbbbbaaaabbbabaaaaabbbaaaabbbbaaaaaabaabaaaaabbbaaaaabaaaabaaaabbabaabbbbbabbaabaaabaaabbbbaaabbbbbbbbbbbabbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbaabbbbbbbbbbbbbbbaabbbbbbbbbbbaabaaabbbabbaabababbabbaaaaabaabaaabbaabbbaababbbbbaaabbbbbababaaabbbbbbaaabbaaaaaaaabbaaababbbabbbabaabaaaaaaaaabaabbbbbaabaabbaaaabbbbbaaabbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabbbbbbbbbbbbbbbbbaaabbbbbbbbbaabaaaaaaabaabaababbabaabaabbbabbbaabbabbbaaaabbbaaabbbbbbbaaabaaabbbbbbbaaaaaaaaaaaabaaaababbaabababaabaabababbaababbbbbbabaaaaababbbbbaaabbbbbbbbbbbbbaabbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbaaaaaaababbbaaaaababbabaabbbbbbabbaaaababbbaabbbaaabbbbbbbaaabaaaaaaabbbbbbbaaabbbaaabaaaaababbaabababaabaababbbbaababbbbbbaababaabbbbbaaabbbbbbbbbbbbbbbaaabbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbaaaaaababbbabaaabaababaabaaaabaababaabaabbbbbaaabbbbbbbaaaaaaaaaaaaaabbbbbbbbaaabaaaaabaaababaabaababaabaababbbbbabaabbbbbaababbbbbbbaaabbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbabaababbaabbbabaababbabaaaabaababbaaaabbbaaabbbbbbbbbaaaaabaaaaaaaaabbbbbbbbbaaabbaaaaaababaaaaaaaaaabbabaabbbbabaabbbbbbaaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbaaaabbaaaaaaababaabaaabaabbababbaaabbaaabbbbbbbbbbaaaaaabaaaaaaaaabbbbbbbbbbaaaaaaabbabababaaaaaaaabbaabaabbbaabaabbbbbaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbaaabbbbbbaabaabaabaababbaabbbaabbbaaabbbbbaaabbbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbbaaabbbbaaaaabaaabbababbaabbabbbaabaabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbbbaaaabbbbbbaaaaabaaaaabbaaaaaabbbbbbbbaaaaabbbbbbbbbbbbbbaaabaaaaaaabaaabbbbbbbbbbbbbbaaaabbaaaaaaaaabababbaaabaabbbaaaabbbbbbbaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbbaabaaaabbbbbbbbbbbaaaabbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbaaabaaaaaaabaaabbbbbbbbbbbbbbbbbaaabbbaaabaaaaaabbababaaabbbbbbbbbbbaaaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbaabbbbaaaaabbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbaaaaabbbbbaaaaaaaabaaaaabbbbbbbbbaaaabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaababbabbbbbbbbbaaaaabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbaaaabbaababbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaaaaabbbbbbbbbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbaaaaaabbbbbbabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaabbbbbbbbaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaababaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbabaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbabbbaabaaababbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabaabaaaabaabaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbaabaababaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaaabaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbaaaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaabaaabaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaababbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbababaaabaaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaabaabbaaababaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaabaababbaaaaababaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabaaaaaaaaaaaaaaaababaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaababaaaaaabaabbbbbbbbaaaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabaaababaabbbaaaabbbaaaaaaaabaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaaaabbaaaabbaaaaaaaabbbaabbaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaaaaabbaaabaaaaaaabaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbaababbaaaaaaababbabbaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaabbaabbaaaaaabaaaaaabbabaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabababaaaaabaaaaaaabaaaaaabbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaabbaabbaaaaaaaaabaaaabbabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaabbabbabaaaaabaaaababbabababbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaabbabbabbbaaaaaaaababbabababaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaababbbaabaabaaaaaababaabbabababaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababaaaaabbaaaaabbaaabaabbabaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabbaabbaaaaabbaaaaabbaaaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbabaaaaaabbaaabbbaaaaabaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaaabaaaabbbaaaaaaabbbaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaaaaaabaaaabbbbbbbbbbaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaababbbabaabaabbbbbbbbaaaaabaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaabaaabaaaaaaaaaaaaaaaaaabbaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaabaababbaaaaababaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbababaaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbababbaaaabaaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbaabbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaaaaaaaabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaaabababbaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaabaaaaaaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbaabaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
        return bitmap;
    }
    if (index == 14)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "284 314 2 1",
        "a c Black",
        "b c #FFFFFF",
        /* pixels */
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaabbbbaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabbbaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabbbabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaabbbaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbbbbbaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababbbabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbabbbabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabbbabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbabbbabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbabbbabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbaabbaaaaaaaaaaaabbbaabbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbaaaaaaaabbbbbbbbbaaaaaaabbbbbbbaaaaaaabbbbbbbbbbbabbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaabbbbbbaabbbbabbbbbbbbbaabbbbbaaaaaabbbbbbaabbbbbbbbbaaaaababbbbbaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaabbbbbaabbbbaaaaaabbbbaabbbbbaaaababbbbbbabbbbbaaaaaabbbaaabbbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbaabbbbbbabbbbbaabbaababbaabbbbaaaaaaabbbbaabbbbaabaaabbbbbabbbbbbaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaabbbbbbbbabbbbbaabbbbbabbbbaaaaaaabbbaabbbbaabbbbabaaaaabbbabbbbbbaabbbbbabbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbaabbbbbbbabbbbaaabbbbaabbbbabbbaaaabbabaaaaaabbaaaaaabaabbbaabbbbbbabbbbbabbbbbbbaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaabbbbbaaabbbbbaaaaaaaaaaaaaaabbbbabbaabbaaaaaaaaaaaaaabbaabbaabbbaaabbbbaaaaaaaabbbbbbbabbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbabbbbaaaaaabbaaabbbbbbbbbaaaaabbaabbaabbbbaabbbbbbaabbbbaabbbabbbbaaaaaaaaaaaaaabbbbbbaabbbbbaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaabaaabbbaaaaaabbbaaaaaabbbbbaaaaaaaaabbbbaaaaaaaaaabbbbaabbbaaaaaaaaabbbbbbbbbaaaaaaaaaabbbaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbaaaabbbbbbbaaabbaaaaaaaaaaaabbbbbbbaaabbbbaaabbbbaaabbbbaaaaaaaabbbbbbbbbbbbbbbbaaaabbbbaabbaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbaaaabbbbbbbaabbaaabbbbbbbaaaaaaaaabbaabbbbaabbbbbbaabbbbaabbbbbbaaaaaaaaaaaaaabbbaabbbbbbaaaaabbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaabbaaabaabbbbbbbabbaabbaaaaaabbbbbbbbaaaaaabbbbaabbbbbbbabbbbaaaaaaaaaabbbbbbbbbbbaabbabbbbbbbaaaaabbbbbaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbaaaaabaaabbbbbbbabbaabaabbbaaaaaaaaaabbbbaabbbbaabaaabbaabbbbaaaaaaaaaaaaaaaaaaaaabaababbbbbbbbaabaaaaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbaaabbbaaabbbbbbbabbabaaaaaaaaaaabbaaaaaaaaabbbbaaaaaaaaaabbbbaaaaaaaaaaaabbbbbbbbabaabaabbbbbbbaaabbbaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaabbbbaabaaaaaaaaabbabaaaabaaaaaaaaaaaabbbaabbbbaaabbbbaaabbbbaabbbbbbbbbbaaaaaaabaababaabbbbbbabbabbbbbaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaabbbbaabaaabbaaaabbabaabbbbbbbbbaaaaaaaaaabbbbbaabbbbbbaabbbbaaaaaaaaaaaaaaaaaaaaaababaaaaaaaaabbaaabbbbaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbabaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbaaaabbbabbbbbbabaabbbbbbaabbabaabbbbbbbbbbbbbbbbbbabbbbbaabbbbbbaabbbbaabbbbbbbbbbbbbbbbbbaababaaaabbaaabbbaaabbbbabbbbaabbbbbbbbbbbbbbbbbbbbbaaabbaabaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbaabbabaabbbbbbbbbbbbbbbbbbbbbaaabbaaaaabbbbbaaaabbbbbbbbabbaaaabbbbbbbbbbbbaaaaaaabbbbaaabbbbbbbabbbbaaaaaaaabbbbbbbbbbbbaababaabbbbbbaabbabaaabbaaaaaaaabbbbbbbbbbbbbbbbbbbaabaabaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbbaababaabbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbbabaabbbbbbbbabbaaaabbbbbbbaaaaaaaaaababbbbaaabaabbbaabbbbaaaaaaaaaaaaaabbbbbbaabababbbbbbbbaabaabbabbbaaaabaaabbbbbbbbbbbbbbbbbbaabbaaabaabaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbaaaabbabbbbbbbbbbbbbbbbbbbbaabbbbbbaabbbbbbaaaabbbbbbbbaabaabaaaaaaaaabbbbbbbbbbabbbbaaaaaaaaaaabbbbaabbbbbbbbbbaaaaaaaaabaababbbbbbbbaabaaabaabbaaabbbaabbbbbbbbbbbbbbbbbbaaaabaaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbaabbaabbbbbbbbbbbbbbbbbbbabbbbbbbaabbbbbbaaaabbbbbbbbaabbabaabbbbbbbbbbbbbbbbbabbbbaaaabbbbaaabbbbaabbbbbbbbbbbbbbbbaaabaababbbbbbbbbababaababbaabbbbbaabbbbbbbbbbbbbbbbbbbbaabbbaaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbaaabaaabbbbbbbbbbbbbbbbbbabbbbbbbaabbbbbbaababbbbbbbbaabbabaabbbbbbbbbbbbbbbbbabbbbaaabbbbbbaabbbbaabbbbbbbbbbbbbbbbbaababaaabbbbbbbaaaabbaaaabaabbbbbaabbbbbbbbbbbbbbbbbbbbbaabaaaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbaabbaabbbbbbbbbbbbbbbbbbaabbbbbbaabbbbbbbabaabbbbbaaaaababaabbbbbbbbbbbbbbbbbabbbbaabbbbbbbbabbbbaabbbbbbbbbbbbbbbbbabaabaaabbbbbbbabaabbbaaabaabbbbbbabbbbbbbbbbbbbbbbbbbbbbaabaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaaaaabbbabbbbbbbbbbbbbbbbbbaaabbbaaaabbbbbbbaabaaaaaaaaaaabaaaabbbbbbbbbbbbbbbbbabbbbaabbbbbbbbabbbbaabbbbbbbbbbbbbbbbbabaababaaabbbbaababbbbaabbaabbbbbaabbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaababbbaabbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbabbbaaabbaaaabaabaabbbbbbbbbbbbbbbbabbbbaaabbbbbbaabbbbaabbbbbbbbbbbbbbbbbababaabaaaaaaaabbaabbbaabbaaabbbaabbbbbbbbbbbbbbbbbbbbbbbabbaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaabbbbbbaaabbbbbbbbbbbbbbbbbbaaabbbaabbbbbbbbabbaabbbbbbaabbaaaabbbbbbbbbbbbbbbbabbbbaaaaaaaaaaabbbbaabbbbbbbbbbbbbbbbaabababaabbbbaabbaaaaaaaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbabbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbabbbbbbbbaabbbbbbbbbbbbbbbbbbabbbbbbaabbbbbbbaababbbbbbbbaabaababbbbbbbbbbbbbbbbabbbbaaaaabbbbaabbbbaabbbbbbbbbbbbbbbbabaabaaabbbbbbaabaabbbaaabaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbabbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabaabbbbbbbbabbbbbbbbbbbbbbbbbbabbbbbbbabbbbbbbaaaabbbbbbbbaabaababbbbbbbbbbbbbbbbabbbaaaaaaaaaaaaaabbaabbbbbbbbbbbbbbbaabaabaabbbbbbbbababbbbbabbaabbbbbabbbbbbbbbbbbbbbbbbbbaaaaaabbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaabaabbbbbbbabbbbbbbbbbbbbbbbbbabbbbbbbabbbbbbbbaaabbbbbbbbaabbabaabbbbbbbbbbbbbbbabbbabbabbbbbaabbabbaabbbbbbbbbbbbbbbaababaaabbbbbbbbababbbbaabbabbbbbbaabbbbbbbbbbbbbbbbbbbabbbbabbabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaaaabbbbbbbaabbbbbbbbbbbbbbbbbabbbbbbbaabbbbbbbaaabbbbbbbbaaabaaaabbbbaaaaaaaabbbabaaaabbabbbbabbaaaaaabbbaaaaaabbbbbbabaababaabbbbbbbaaabbbbaabaabbbbbbaabbbbbbbbbbbbbbbbbbbaabbbaababaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaabbbbbbbbaabbbbbbbbbbbbbbbbbabbbbbbaaabbbbbbbbaaabbbbaaaaaabaababbbaabbbbbaaabbaaaaaabbaabbbabaaaaaaabbaaabbbbaabbbbababaabaabbbbbbaaabbbbaabbaabbbbbbaabbbbbbbbbbbbbbbbaabaaaaaaababbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabbbbbbbbbaabbbbbbbbbbbbbbbbbaaabbaaaaaabbbbbbbaaaaabaabbaaaababaabbaabbbbbbaabbaaabaaabbaaaaabaaabaaabaaabbbbbbaabbbababaabaaabbbbaaaabbbbaabbaaabbbbbabbbbbbbbbbbbbbbbbaaaaaabbaababbaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaaaabbbaabbbbbbbaabaaaabbbaababaaaabbabbbbbbbbabbaaabbbbbbabbaabbbbbbaabaabbbbbbbbabbaaaaaaaaabaaaaaaaabbbbbabbbaaaabbaaabbbbbbbbbbbbbbbbaaaaababaabbabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbbbabbbbbbbbaabaaabaaaaaaaaababbabbbbbbbbabaabaaaaaaaabbbaaaaaaabaaaabbbbbbbbabbababaababaaaaaabbabbbbbabbaabbaaaaabbbbbbbbbbbbbbbaaabbbaaababbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbaaababbbbbbbbbbbbbbbbbbbabbbbbbaabbbbbbbaababbbabaaaaaaaaabbabbbbbbbbabaababbaaaabbbbabaaababaaaabbbbbbbbabaaaabaabbbabbaaaaaabbbbaabaabbbbbaabbbbbbbbbbbbbbbbaaaabbabaaabbaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaabbbaaaaabbbbbbbbbbbbbbbaabbbbbbabbbbbbbbabaabbaaaaaabbabaabaabbbbaaaabaaaabaabbabbbbaaaaababaabaabbbbbbaabaaaabbabbbaaaaabaabbbbbabbaabbbbbbabbbbbbbbbbbbbbbbaabaaaaaaaabaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaabbbbbaabaabbbbbbbbbbbbbbaabbbbbbaabbbbbbbabaaabaabaabbaabaabbaaaaaaababbaabbbbabaabbbaabaabaaabbaaaaaabbabbabababbbaaaabbaaaabbbbaabbabbbbbbbabbbbbbbbbbbbaaaaaaabbbbaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbaaabbaabbbbbbbbbbbbbbaabbbbaaaabbbbbbbaaaaababbbaaaaabbabbaaabbbbaabbaaabaaaababbaabaaabaaabbabbaaaaaabbababaaaabaabbbaaaabbbbabbaaabbbbbaabbbbbbbbbbbbabbbabaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaaabbaaabbbbbbbbbbbbbbbaaaaaaaaabbbbbaaaaabbbabbbaabbaaaaabbabaaaaabbbbaaaaaabbaaaabbabaaaabbbaaaabbbabbbaaaaaaabbbabbbbbbaaabaabbaaaabbbaabbbbbbbbbbbbbaaabaabaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaabbaabbbbbbbbbbbbbbbbbbaaabbbaaabbbbabaaaabbaabbaabbaaaaabbaaaaabaaabbaaabaabbbaaabbaabbbabbbaabaaaaabbaaaaaaaabbbabbbbbaabaaaaaaaabaaaaabbbbbbbbbbbbbbbbaabaaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabaabbaaabbbbbbbbbbbbbbbbbbaaaaaaaaaabbababaabbbaaaabbbaabbabbaabaaabaaababaaabbbaaaaabbaaababbaabbabbabbbaaaabaaabbbabbbbbaabaaaaaaaabbbabbbbbbbbbbbbbbbbbaaaaaababaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaaabbaaabbbbbbbbbbbbbbbbbaaaabaaaaaaaabaababbbabaaaaaaabbabaabbaaaaabaaaaabbbaaabaaabbbbaaaaaabaaabbaabbaaaabbbaaaaabbbbbbabaaaaabaaaababbbbbbbbbbbbbbbbaaabaaababaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabaaabbaabbbbbbbbbbbbbbbbbbbbaabbaabbaaaaabbbbaaabbaabbbbbaaabbbabaaaabbaaaaaaaaaaaaaaaaabbbbbbaaaaabbaaaabbaaaaaaabbbbbbbaabaaaaabbaaaaabbbbbbbbbbbbbbbbabbabaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabaaaabaaabbbbbbbbbbbbbbbbbbbabbbbbbbaaaaaabbaaabbbaaaaaaaabbaaaaaaaaaaaaabbbbbbbbbbaaaaaaaaaaaabaaabaaaabbaaaabbbaabbbbbaaaabbbabbabbbbbbbbbbbbbbbbbbaaabbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaabaabbabbbbbbbbbbbbbbbbbbbbaaabbbbaaabbaaaaaabaabbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbaaaaaabbabbaaabaaaaaabbbbbbbabbbbbbbbbbbbbbbbbbaabaaaaaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbaaabbbbbbbbbbbbbbbbbbabaabbaaaaaaaaaaaabaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbaaaabaaaaaaabaababaaaaabbbbbbbbbbbbbbbbbaabbaaaaabaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbababaaaabbbabbbbbbbbbbbbbbbbbbabbabbbaaaaabbbbbbbabaaaabbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbaaaaaabaabbaaaabaaaaaaaabbabbbbbbbbbbbbbbbbbaabbbbaaaabaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaababbbbbbbbbbbbbbbbbbaaaabaaaaaaabbbbbaaaaabbbbbbbbbbaaaaaaaaaaabbaaaaaaaaaabbaaaaaaaaaaabbbbbbbbbaaaaaaabbbabbaaaaaaaabaabbbbbbbbbbbbbbbbaabaaaaabbaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabaaaabbbbbbbbbbbbbbbbbbaaabaaaaaabbbbaaabbbbbbbbbbaaaaaabbbbbaaabaaaaaaaaaaaaaabbbbaaabbaaaaaabbbbbbbbbaaaabbbbbabbaaaaababbbbbbbbbbbbbbbbbaabaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabaaaaaabbbbbbbbbbbbbbbbbbbbaaaaaaabbaaaabbbbbbbaaaaaaaabbaaabbbaaaaaaaaaabaaaaaaaaabbababbaaaaaaaaaaabbbbbbaaaaaabaaabaaaaaabbbbbbbbbbbbbbbbaabbaaababaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabaaababbaabbbbbbbbbbbbbbbaaaaabbbaaabbbbbbbbaaaaaaaabaabababaaaaaaabaaaaaaaaaaaaaaaaaaabbabbaaaabaaaaaabbbbbbaaaabbaaabbabbbbbbbbbbbbbbbbbbaabbababbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaaaabbbbbbbbbbbbbaaaaaaaaaaabbbbbbaaaaaaaaabbaaaaaaaaaaaabaaaaaaabbaabbaaaaaaabbaaaaaaaaaaaaaaaaaaaabbbbbaaaabbbaaabbbbbbbbbbbbbbbaaaaabbaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaababaabbbbbbbbbbbbbaaaaaaaaabbbbbbaaabbbaaabbbaabaaabbbaababbbaaaaaaaaaaaaaaaabbbbabaaaaaaaaabbbaaaabaaabbbbbbaaaaaaaaabbbbbbbbbbbbbababaabaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbabbbbbbbbbbbaaaaaaaabaabbbbbaaabaaaaaaaaaaabbaaabaaaaaaaaaaaaaaaaaaaaaaabbbaaaaaaabbaaabaaabaaaaaaaaaaabbbbaaaaaaaaaabbbbbbbbbbbaabbbaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbabbbbbbbbbaaaaaaaabbbbaabbaaaaababaaabbbaaaaaaaaaababbbabbabbbaaaaaaabbbbbbababbbaaaaaaaaaaaaaabaaabbbaaabbbabaaaaaaabbbbbbbbbbbaabbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbbbaaaaaaaaabbbbbbaaaaaaaaaaaaaaabaabaaaaabaaaabbaaaaaaaaaaaaaaaaaaaabaaabbaabaaaabbbbaabaaaaabaaaaaaaaabbaaaaaaaabbbbbbbbbaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbaaaabbbbbbaaaaaaaaaaabbbbbaaaaaaabaaaaaaaaaaaaaaabbaaaaaaaaabbbbbbbbbbaaaaaaaaaaaabaaaaaaaabbbaaaabaaaabaaaaaabbbaaaaaaaaaabbbbbbbaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbaabbbaaaaaaaaaaaaabbbbbbaaaaaaaaaabaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaabaaaaaaaaaabbbaaaaaaaaaaaabbbbbaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbbaabbaaaaaaaaabaaabbbbbbabaaaabaaaaaaaaaaaaaabbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbbbaaaaaaaaaaaabaaaaaaaababbbaaabaaaaaaaaabbbbabbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaaaaaaaaaaaaaaaaaaabbbaaaaaaaaaaaaaaaaaabbbbbaaaaaaaaaaabbbbbbbaaaaaaaaaaaaaaabbbbbbaaaaaabaaaaaaaaaabbabbaaaaaaaaaaaaaaabbaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaaaaaaaaaabaaaaaaaaaabaaaaaaaaaaaaaabbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbaaaaaaaaaaaabbbabaaaaaaabbaaaaaaaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaaaaabbbbbaaaaaaaaaaaaaaaaabbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbaaaaaaaaaaaaaaaabbbbbaaaaaaaaaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaabaabbbbbbbbbbaaaaabaaaaabbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbaaabaaaaaabbbbbbbbbbbaaabbaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabaaaabbbbbbbbbbbbaaaaaaaabbbaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbaaaaaabbbbbbbbbbbbbbaabbaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbaaababbbbbbbbbbbbbbbaaaaaaaaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabaaaabbbbbbbbbbbbbbbbbaaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbaaaabbbbbbbbbbbbbbbbbaaaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaaabbbbbbbbbbbbbbbbbbbbaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbaaabbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbaabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaabbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabaaabbbaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbabbbbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabaabbbbaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbaabbbbabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbababaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbbaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaabaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaababbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaaaaaaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbaaaaaaaaabbaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababaaaabaaaaabbbaabbbbaabbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbaabbbaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaabbbbbabbbbaabbbbbbbbbbbbbaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbbabbbaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabaabbbbbaabbbbabbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbbbbabbbaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabaaaaaaabbbbbbbaabbbabbbbbbbbbbbaabbaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbaaaaaaaaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbaaabaaaaabbbbbbbbabbbabbbbbbbaaaaaaababbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaabbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbbbbaaaabbbbbbbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaabbbbbbbaaaabbabbbbbbaabbaabaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbaaaaaaabbbaaabbbaabaaabbbbbbbbbbbbbbbbaaabbbbbbbbaaabbbbbbabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbaababaaabbbbbbbaaaaababbbbbaaaaaabbbaaababbabbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaabbbbbabaaabbbabbbaaaaabbbabbbbbbbbbbbbbbbaaaabbbbbbbbaaabbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabaaaabbbbbbbaaaaaaaabbbbbbabaaabbbbabbabaabbbbbbbbbbbbbbbaaabbbbbbaaabbbaaaabbbbbaaaabbbaabaaabbbaaabaaabbbbbbbbbbbbbaaaaabbbbbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaabbbaaabbbbbbaaaaaabaabbbbbbbbbaabbbbbbaababbbbbbbbbbbbbbbbaaaaabbbaaaaabbaaaabbbbbbaaabababbabbbbbbbaabaabbbbbbbbbbbbbaaaaabbbbbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabbbbbbaabbbbbbaaaaaabbaabbbbbbbbbaaaabbaabbbaabbbbbbbbbbbbbbbbaabaabbaaabbbbbaaaaabbbbaaaaababaabbbbbbbbaababbbbbbbbbbbbbaaaaaaabbbbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaabbbbbbbabbbbbbaaaaaabbbabbbbbbbbbbbaaabbabbbbabbbbbbbbbbbbbbbbaabbaababbbbbbbbbbbaaaaabbaabaababbaaabbbbaabaabbbbbbbbbbbbaaaaaaabbbbbbaaabbbaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbabbbbbbaaaaabbbbabbbbbbbbbbbaaabbaabbbabbbbbbbbbbbbbbbbbabbbabaabbbbbbbbbbbbbbaabaabaababaabaabbbbabbabbbbbbbbbbbbaaaaaaabbbbbbaabbbbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbaabbbbbaaabbbbbbbabbbbbbbbbaaabbbaabbbbabbbbbbbbbbbbbbbbbabbbabaabbbbbbbbbbbbbbaabaabaababbabaabbbbabbabbbbbbbbbbbbaabbaaaaabbbbbabbbbaaaaaaabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbaabbbbaaaabbbbbbbabbbbbbbaaaaabbbaabbbbaabbbbbbbbbbbbbbbbabbbaaaabbbbbbbbbbbbbbaabbaaaabaababbabbbbabbabbbbbbbbbbbbaabbbaaaabbbbbabbbbbbaaabbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbaabbbaaaaabbbbbbaabbbbbbbabbbabbbbabbbbbaabbbbbbbbbbbbbbbabbbbbaaaaaabbbbbbbbbbabbbaaaabbaaabbaabbbabbabbbbbbbbbbbbaabbbaaaaabbbbabbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbaabbaaaaaabbbbbaaabbbbbbbabaaabbbbabbbbbbaaabbbbbbbbbbbbbaabbbbaaaaaaaabbbbbbbbaaabaaaabbbbbbaabbbbabbaabbbbbbbbbbbaabbbaaaaaabbbabbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaabbbbbbbbbbbbbbabbaaaaabbbbbbababbbbbbbaaaaabbbbbbbbbbbbbaaabbbbbbaaaaabaabbbbbbaabbabbbbbbbbbbababaabbbbbaabbbbbabbaaabaaaabbbbbaabbbbaaaaabbbabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbabaaaaabbbbbbbababbbbbbbaabbaaabbbbbbbbbbbbaaabbbbbaaabaabaaaabbbbaababbbbbbbbbbababababbbaabbbbbbabbaaaaabbaabbbbaabbbbbaaaaabbabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaaabbabbbbbbabaaaaabbbbbbaababbbbbbbaabbbbaaabbbbbbbbbbbbaaaabbbaabbaabbaaaaaabaaabbbbbbbbbbbbaaaaaabbaabbbbbaabaaaaabaaaaabbbaabbbbbaaaaabbabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaaaaaaaabbbbbabaaaabbbbbbbaababbbbbbbbbbbbbbaabbbbbbbbbbbbbbaaabbbabbbaababbbbaaaabbbbbbbbbbbbbaaaabaabaabbbbbabbabaaababaaabbbaabbbbbbaaaabbabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababbaaaaaaaaabbbbbaaaaaabbbbbbbaababbbbbbbbbbbbbbaabbabbbbbbbbbbbbaaaaaaaabbaaaaabbbabaabbbbbbbbbbbbaaabbaabbaabaaaabaabaaababbaabbbaabbbbbbaaaaaaabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababbbabbaaaaabbbbbaaaabbbbbbbbbaababbbbbbbbbbbbbbaabaabbbbbbbbbbbbbbbaaababbaaababbbabaabbbbbbbbbbbbaaabbbabbaabaaabbaabaabaabbbbbbbaabbbbbbbbaaaaabbbbbbabbbaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababbbabbbaaabbbaaaaaaabbbbbbbbbaababbbbbbbbbbbbbbabbbaabbbbbbbbbbbbbbbaaaaabbbaaabbbaaabbbbbbbbbbbbbaaababaabaaaaaabaabbabbaaaabbbbbaabbbbbbbbaaaaabbbbbaaabaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaabaaaaaaaaaaaaaaaaabbbbbbbbbbababbbbbbbbbbbbbbabbbaabbbbbbbbbbbbbaaabbbabbbbbbbbbbbbbbbbbbbbabbbbabbbaababaaabaababbaabbaaaabbbbbaabbbbbbbbaaaaabbbbbaaaaaababababaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbababbaaaaaaaaaaaaaaaabbbbbbbbbbababbbbbbbbbbbbbbabbbbabbbbbbbabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabaaaabaaaaabbaaabaabbaaaaabbbbbaabbbbbbbbaaaaabbbbbaaaaaababbbabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabaabbaabbaaaabaaaaabbbbbbbbbbbaaabbbbbbbbbbbbbbaabababbbbbbbababbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbbabaabaaaaaabbbaabbabbbaaabbbbbbbaabbbbbbbbbaabaabbbbaaaaabaabbaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaaaaaaaaabaabbaaaababaaaaaaaabbbbbbbbbbaaabbbbbbbbbbbbbbbababbbbbbbbbaaaaaaaaaaabbbbbbbbbbbbbbbbbbabbaabbabaaaabbaaaaabbaaaaaabbaaaabbbbbbbaabbbbbbbbbaaaaabbbbbaaabaabbaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaaaaabbbbbaaabbbaabbaaaaaaaaabbbbbbbbbbbaabbbbbbbbbbbbbbbaaabbbbbbbbbbabaaaaaaabbbbbbbbbbbbbbbbbbaabbaabbabbaaabbbbaabbbaaaabbbaaaaabbbbbbbaabbbbbbbbbaaaaaabbaaaaaaaaabaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaaaaabaababaaaaaabaaaaaabaabbbbbbbbbbaabbbbbbbbbbbbbbbaaabbbabbaabbaabaaaaaabaaaaaaaaaaaaaaabaaabbaaaaaabaaaaaaaaabbaaaaabaaaaaabbbbbbbbaabbbbbbbbaaaaaaaaaaaaaaaaaaaaaabaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaaaaaaaaaabaabaabaaababaabbbaabbbbbbbbbbbabbbbbbbbbbbbbbbbbabbbabaaabbbabbaabbaaaaaabaaaaaaabbbaaaabaabaabaaaabbbababbbaaabbbaaaabbbbbbbbbbaabbbbbbbbabbbaaabaabaaaaaaaaabaabbbaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaaaabbabbabaaabaaabaaaabbbbabbbbbbbbbbbabbbbbbbbbbbbbbbbaabaaabaaabbbabaabaaaabbbbbbbbbbbbbbaaabaaabbaaababbbbbbbabbaaaabaaaaabbbbbbbbbbbaabbbbbbbbabbbaaabaaaaaaaaaaabbbbaabaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaaabbbbbbaaaaaabbaaaaaaabbbabbbbbbbbbbbabbbbbbbbbbbbbbbbaaaababababbbababaaabbaaaaaabbbbbbaaabbbbabbbbaaaaabbbbbbabbaabbaaaaaabbbbbbbbbbbaabbbbbbbaabbbaaaaaaabbabaaaaabbaaaaaaaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaaaaabbbbbbbaaababaabaaaaaaaabbaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbaaababbbaaabababaaaaaaaaaaaaaaabbbabbbbbaabbabbbbbbbabbabbaaaaabaaabbbbbbbbbaabbbbbbbaabbbaaaaaaaaaaaaaabaaaabaaaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaabbbbbbbababaababbbaaaaaabbaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbaabaabaaaaaaaaaabbbbbbbbbbbbbbbbbababbbaabbbaaaaabbabbabbaabbbbbbaabbbbbbbbaabbbbbbaabbbbaaabaabaaaaaaaabbbbbbaaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbaabbbbbbbbaaaababaabaaaaabaabbabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaaaaabbbbbbbbbbbbbbaabbababbbaabaaaaaaaaaabbabbabaaaabbbabbbbbbbbaabbbbbbaabbbbaaaaaaaaaaaababbbbbbbaaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbaaabbbbbbbbbbabbaaabbaaaabbbabbaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbaaabababaaabbbbbbbbbbbbabbabbbababbbbaaaabbbbbbaabbabbbaaaaabbbabbbbbbbbaabbbbbbabbbbbaaaaaabaaabaaaabbbbbbbaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaabbaaaaaaabbbbbbbbbaaaabbbabbaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaaabbbbbbbbbbbbabbabbbaaaaabaaaabaaaabbbbbbbbbbaaaaaabbbabbbbbbbaabbbbbbabbbbaaaaaaabbabaaaaabbbbbbbaaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaaaaaaabbbaaaaabbbbbbbaaabbbabbbabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbabbbbbabbababaabaaaaaaaaabbabbbbbbbbbbaabaaabbbabbbbbbbaabbbbbaabbbbabaaaaabaaaabaaaabbbbbbaaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaaaabbbbaaaaaaaaaaabbaaabbbbabbbabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbabbbbbaabababbaababbaaaabaaaabbbbbbbbbaaaaaabbbabbbbbbbaabbbbbaabbbaabbaaaabaaabbaaabbbbbbbbaaabbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaabbbbaaaaaabbbbbabbaabbbbbabbbabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbabbbbbaabbbbbaabaaabbbabaababaabaaaabbbbbbbbbaaaaaabbbabbbbbbbaabbbbbabbbbaabbbaabbaaabbbabaaaaabbbbaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaabbbaaaaaaaabbaaaaaaaaabbbbaaaaabbbbaabbbabbbbbbbbbabbbbbbbbaabbbbbbbbbbbbbbbbaaabbbbbbabbbbbaabbbbbbabbaaabbaabaaabaaaaabaabbbbbbbbbabaaaabbaabbbbbbaabbbbbabbbbabbbbaaabbbaaaaaaabbbaaaaaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabbbbbabaaaaabaaaaaaaaaabbbbbaaaaabbbaabbbaabbbbbbbbabbbbbbbaaaaaaabbbbbbbbbbbaaabbbbbbbabbbbbaabbbbbbaabaaaabbaabaabbaaabbaabbbbbbbbbaaaaaaabbabbbbbbaabbbbbabbbbabbbbaaabbaabbbbbbbbbbbaaaaababbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbabbbbbabaaaaaaaaaabbbaaabbbbbaaaaabbbabbbbaabbbbbbbbabbbbbbaaabaabaaabbbbbbaaaabbbbbbbbbaabbbbaabbbbabbaabaaaabbabaabbbbbbbbabbbbbbbbbaaaaaaabbaabbbbbaabbbbbabbbbaabbbaaaaaaabbbbbbbbbbbbbaaabaaaaabbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaabbbbbbaabbbbabaaaabbaaaabbbaaabbbbbaaaaabbaabbbbaabbbbbbbbabbbbbbaaaaabbbaabbbbbaabbbbbbbbbbbbbaabbbaabbbbaabbabbaaaabaaaabbbbbbbbaabbbbbbbbaaaaaaaabbaabbbbaabbbbbabbbbaabbaaaaaabbbbbaaaabbbbbbaaababbaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbaaaababbaaabbaaaaaaaaaaabbbbaaaaabbaaabaaaabbbbbbbbabbbbbbbbbabbbbaabbbbaabbbbbbbbbbbbbbbaabbaaabbbaaabbabaabaabaaabbbbbbbbbaabbbbbbbaabaaaaaaaaabbbbaabbbbbabbbbbabbaaaaabbbbbaaaaaaabbbbaaaaabbbbbbaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaaabbaaabbbaaaaaaaaaabbbbaaaabbbabaaabaabbbbbbbbabbbbbbbbbaabbbabbbbaabbbbbbbbbbbbbbbbaabbbaabbbaaaabbbbaabaaaaabbbbbbbbbaabbbbbbbaabbbbbbbbbbbbbbaabbbbbabbbbbabbbaaaaabbbbaaaaaaaabbbbaaaabbbbbbaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaabbbbbbbbbbbbbaaaaaaaabbaaaaaaaaaaabbbaaaabbbabbbbbaabbbbbbbbabbbbbbbbbaabbbabbbaabbbbbbbbbbbbbbbbbbabbbaaabbaabaaabbbaaaaaaaabbbbbbbbbaabbbbbbaabbbbbbbbbbbbbbaabbbbbaabbbbaabbaaaaabbbaaaaaaaaaabaaaaaabbbbbaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbaaaaaaabbaaaaabbaaaabbbaaaabbbabbbbbabbbbbbbbaabbbbbbaaaabbbbaabaabbbbbbbbbbbbbbbbbbbabbaaaabbabbbaaabbaabaaababbbbbbbbbbaabbbbbabbbbbbbbbbbbbbbaabbbbbaaaaaaaabbaaababbbaaaabbaaaaaaabaabbbbaaabbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaaabbbbbbbbbbbbbbaaaaaaaabbaaaabbbaaaabbbbaaabbbabbbbbabbbbbbbaaabbbbbaaabbbbbbbaaabbbbbbbbbbbbbbbbbbbbabbabbabbabbbbbaabbabaabbaabbbbbbbbbbaaabbbabbbbbbbbbbbbbbbaabbbbbabbaaaaabbaaababbbaaaaaabaaabbaaaabbbaabbbbbbbbbbaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaaaaaaaabbaaaabbaaaabbbbbaaaabaabbbbaabbbbbbbaaabbbaaaaabbbbbbbbbbbbbbbbbbbbbbbabaabaaabaabbabaabbbbbbaababaabbbaabbbbbbbbbbaaabbabbbbbbbbbbbbbbbaabbbbbabbbbbbabbaaaaabbbaaaaaaaaaabbaaaaabaabbbbbbbbbbbabbbbbbbbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbaaaaaaaaaabaaaaaabbaaaaaaaaaaaaaaaaaaaabaaaaaaabbbbbbaababbbaaaaabbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbaaaabbbbbbbbaaababbbbbabbbbbbbbbbbaaabaabbbbbbbbbbbbbbaabbbbbaabbbbbaabaaabbbbaaaaaaaaaaabbaaaaababbbbbbbbbbbbaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbaaabbbbbbbbbaaaaaabbaaababbbabbaaaaaaababaabbbabbbbbbaabbabbbaaaaabbbbbbbbbbbbbbbbbabbbaaababbbbaaaabaaabbbbbbbbbaabbbbbbbbaabbbbbbbbbbbaabaabbbbbbbbbbbbbbaabbbbbbabbbbbaabbaaabbbaabaaaaaaaabaaaaaababbbbbbbbbbbbaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaabbbaabbbbbbbbbbbaaaaaabbaaaaabbbabaaaaaaaabaaaabaaabbbbbaaabbabbbaabaaaaaabbbbbabbbbaababaaaabbbaaaaaaaaaaaabbbbbbbbbaabbbbbbbbbaabbbbbbbbbbbabaaabbbbbbbbbbbbbaabbbbbbabbbbbbabbaaaabbaaaabbaaaabbaaaaaababbbbbbbbbbbaaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbaabbbbbbbbbbbbbaaababbaaaaaaaaaaaaaaaaaabbaaaaabbbbbbaabbbbabbbaabbbbbabbbbbaabbbaaabaaaabbbbaaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbbbbbbbbabbbbabbbbbbbbbbbbaabbbbbbaabbbbbabaaaaabaaaaabbaaaabbabaaaababbbbbbbbbbbbaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaaaaaabbbbbbbbbbbbbbbaababbaaaabbaaaabbbaaaaabbbaaaabbbaaaabbbbbabbbbbbbbbbaaabbaaabbaabaaaabbbbaaabbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbaabbbbbbbbaabaaaaabbbbbbbbbbbaaabbbbbbaabbbaaaaaabaaaaaaaabaaaabbabaaaabbaaaaaaaaaabbaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbaaababbaaaabbaaaabbbaaaaabbbbbbaaaaabbbbbbbbabbbbbbbbbbaaaaaabaaaabaaaaaabbbabbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbaabbbbbbbaabbbaabbbbbbbbbbbbaaaabbbbbbaaaaaaaaaabaaabaaaaaaaaabbabaaaabbbbbbbbbbbaabaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbaaaaabaaaabbbaaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbaaaaaabbbbbbbaaaaaabbaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbaaabbbaaabbaaaabbbbbbbbbbbbaabaaabbbbbbaaaabaaabaaabaaaaaaaaabbabaaabbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaaaaaaaabbbbbaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbaaabbbbbbbbbbbbaaaabaabbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbaaaaaabbaaaabbbbbbbbbbbbbaabbbaaaaaaaaabbbaaabaaaaaaaaaaaaabbabbaabbbbbbbbbbbbbbaabbbbbbbbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaaaaaaaabbbbbaabbbbbbbbbbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbbbaabaaabbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbaabbbbbbaabbbbbbbaaaaabaaaaabbaaaabbabaaaabbbbbbbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaabaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbaaaaabaaaabbbaaaabbabaaaabbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabaaaaabbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbaaaabbbbbaaaabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbaaaabbbaaabbbaaaabbabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaaaaaaaabbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbabbaabbbbabbaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbaabbbbaaaaaaaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbaaaaaaaabbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbaabbaaaaaaabaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbaaabbbbaaaaaaaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaaabbbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbaabbaabbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaaabbbbaaaaaaaaaabbabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbaaaaabbbbbbbaaaaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbaaaabaabbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbaaabbabbaabbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaaabbbbaaaaabaaaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaaaabbbbbabaaaabbbbbbbbbbbbbbbbbbaaaabbabbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaaabbbbaaabbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaabbaabbbbabaababbbbbbbbbbbbbbbbabaaabbaabbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaabbbbbaaaaaaaaaababaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbaabaaabbaaabbaabbbbbbbbbbbbbbaabaaaabaabbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaaaaabbbbbbaaaaaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbaabbbaaaabaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbaaaabaabbaaabbabbbbbbbbbbbbbbaabaaaababbbbbbbbbbbbbbaaaaaaaabbaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbbaaaaabbbbbbaaaaaabbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbaaabbaaaabbaaabbbbbbbbbbbbbbbbbabbbbbbbbbbbaabbbbabbbbbabbbaabbaabbbbbbbbbbbaaaaaabaababbbbbbbbbbbbbbbaabaabaaaabbaabbbbbbbbbbbbbabbbbbbbbbbbbbbaaaaabbbbbbbaabbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbaababaabaaaaaaabbbbbbbbbbbbbbbbbabbbbbbbbbaaaaaaabaabbbbabbbbbbbbabbbbbbbbbbbaaaaaabaababbbbbbbbbbbbbbaaaaaaabaabbababbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbabaaabaaabaaaabbbbbbbbbbbbbbbbbabbbbbbbbbababbaaababbbbabbbbbbbbaabbbbbbbbbaaaaababbbbabbbbbbbbbbbbbbaaababbbbbbaaaabbbbbbbbbbbbbabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbabaaaaaaaaaaaaabbbbbbbbbbbbbbbbabbbbbbbbbaaaaaabbaabbbaabbbbbbbbbabbbbbbbbbaabaabbbbbbabbbbbbbbbbbbbbaaababbbbbaabaabbbbbbbbbbbbbabbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbaabbbaaaaaaaaaabbbbbbbbbbbbbbbbabbbbbbbbbaababbbbbbbbbbabbbbbbbbbaaabbbbbbbbabbbbbbbbbaabbbbbbbbbbbbbbaaaabbbbbabbbbbbbbbbbbbbbbbabbbbbbbbbbbbbaaaabaaabbbaabbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaabaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbaabbbbbbbbaabbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbaaaaaaaabbbaaabbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabababababbaaaaaaaaaaaaabbbbbbbbbbbbbbbabbbbbbbbbbbbaabbbbbbbbbbaaabbbbbbaabbbbbbbbbbaaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbabbbbbbbbbbbbaaaaabababbbaaabbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaabaaabbbbaaaaaaabbbbbbbbbbbbbbbabbbbbbbbbbbbbaabbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbaabbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbabbbbbbbbbbbbaaaaaaaaaaaaaabbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaabaabaabbbaaaaaaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaaabbbbbbbbbbbbaabbbbbbbbbbbbbbbbabbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbabbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaabaaaaaabaaaaaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbabbbbbbbbbbbaaaaaaaaaaaababbbaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaabbaaaaaaaabaaaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaaaaaabababbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbabbbbbbbbbbbaaaaabaaaaaababbaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbaabaabaaaaabbbbaaaaabbbbbbbbbbbbbabbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaabbbaaaaaabbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbabbbbbbbbbbbaaaaaaaabaaaaabaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaabbabbaaaabbbbbaaaaabbbbbbbbbbbbbabbbbbbbbbbbbabbabbbaaabbbbbbbbbbbbbbbbbbbbbbbabbaaaaaaaaaababaabbaaabbbbbbbbbbbbbaaaabbbbbbbbbbbbabbbbbbbbbbbaaaaaaaaaabaaaaabaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaabbaaaaaaabbbbbaaaaaabbbbbbbbbbbbabbbbbbbbbbbaabaabbbaaabbbbbbbbbbbbbbbbbbbbbbbabaaabbbaaaabaaaaaaaaaaaabbbbbbbbbbbaaaabbbbbbbbbbbbabbbbbbbbbaaaaaaabaaaabaaabbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaaaaaaaaaaabbbbbbaaaaabbbbbbbbbbbbabbbbbbbbbbbaaaaaaaabbabbbbbbbbbabbbbbbbbbbaabababaaaaabaabbaaabbbbbbbabbbbbbbbbbaaaabbbbbbbbbbbbbabbbbbbbbbaaaaaaaaaaaaaaabbbabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbaabbbbbbbbaaaaabbbbbbbbbbbabbbbbbbbbbbbaabbbbbbbabbbbbabaabbbbbbbbaabaaaaaabbaaaaabaabababbbbbbbabbbbbbbbbbaaaaabbbbbbbbbbbbabbbbbbbbaaaaaaaaaaaaaaabbbaabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbaaaabbbbbbbbbbbbabbbbbbbbbbbbaabbbbbbbabbbbaabaabbaabbbbaaaabaaaaabaabbbbbaaaabaabbbbbabbbbbbbbbbbaaaabbbbbbbbbbbbabbbbbbbbaaaaabbbbbaaabaabbaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbaaaaaaabaabaaabaaaabaaabbbbaaabbbbbbaaaaaaaaabbaabbbbbbbbbaaaaabbbbbbbbbbbbbabbbbbbbaaaaabbbbbaaaaababbaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaabbaababaabaaaaaaaabbaabbbbbbbbbbbbaaaaabbbbabaabbbbbbbbbbaabbbbbbbbbbbbbbbbabbbbbbbaaaaabbbbbaaaaabaabbabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbabbbbbbbbbbbbbbbbbbbaaaaaabaaaaaaaaaaaaaabbbbbbbbbbbbbbbbaabaabbbbaaaabbbbbbbbbaaaabbbbbbbbbbbbbbbabbbbbbbaaaabbbbbbbaaaaaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbaaaabaabaaabaaabbbbbbbbbbbbbbbbbbbbabbbbaabbbbbbbabaaaaaabbbbbbbbbbbbbbbabbbbbbbaaabbbbbbbbbbbbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbaaabbaaaaaabaaabbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbabbbbbaaaabbbbbbbbbbbbbbbbbabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbabbbbaaaaabbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbabbbbbbbbbbbbbbaaabbbbbbbbbbbaabbbbaaabbbbbbbbbbbbbbbbbbbabbbaaaaaabbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbaaaaaaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbababbbbbbbbbbbaaaabbabbbbbbbbbbbbbbbbbbbbbabbbaaaaabbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbbbbbbbbbbbbbbbb",
        "bbbbbbbbbabbbbbbbbbbabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbaaabbaaaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbababbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbabbaaaaaabbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbbbbbbbbbbbbbbbb",
        "bbbbbbbbbaabbbbbbbbbabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbaaaaaaaaaaaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaaabbbaababaabbbbbbbbbbbbbbbbbbbbbbabaaaaaabbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbabbbbbbbbbbbbbbbbb",
        "bbbbbbbbbaaabbbbbbbbabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbaaabaabbabaaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabaaabbaabaabbbbbbbbbbbbbbbbbbbbbbbbabbaaaaaaaabbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbabbbbbbbbbbabbbbbb",
        "bbbbbbbbbabaaabbbbbbaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbaaabaabbaaaaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabaaaabaabbaabbbbbbbbbbbbbbbbbbbbbbbbabaaaaabaaaabbbbbbbbaaaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabbbbbbbbbaabbbbbb",
        "bbbbbbbbbaabbaaabbbbaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbabbbbbbbbbaabbbbbb",
        "bbbbbbbbbaabbbaaaabbbabbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaabaaaaaabbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbabbbbbbbaaaabbbbbb",
        "bbbbbbbbbbabbbbbbaaababbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaabaabbaaaaaaaabbaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaaaaaaaaabaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbabbbbbbaabbabbbbbb",
        "bbbbbbbbbbaabbbbbbbaaaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaabbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbaabbbaaaabbaabbbbbb",
        "bbbbbbbbbbaaabbbbbbbbaabbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbabaaaaaaaaaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbaabaaaabbbbaabbbbbb",
        "bbbbbbbbbbbaabbbbbbbbbabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaabaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbaaaaabbbbbbabbbbbbb",
        "bbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaaaaaaaaaababbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbabbbbbbbbbaabbbbbbb",
        "bbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaaabaaaaabaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbaabbbbbbbb",
        "bbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaababbbbaaaaaaaaabaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabaaaabbaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbb",
        "bbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabaaaabaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaabaaabaaaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbaaaaaaaaabaabaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaaaaaaabaaaaaaaabaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbabaaaaaaabaaaaaaaaaabbaaaaaababbbbbabbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbabbbbaabbbbbaaaaaaaabaaaaaaaaabbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabaaaaaaaaaaaaabaaabbbaaaaaaabbbbaabbbbbbbbbbbbbbbaaaabbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbaabbbbabbabaaaaaaababaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbaaaaaaaaaabbbbaaaaaaaabbaabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbaaaaaaaaabaaaaaaabaaaaaaaaaaaabbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaababbbbabaaabaaaabbbbbbaaaaaaababbbbbbbbbbbbbbbbbbbbbaaabbbbbbaaaabbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbaaaaaaaaaaaaaaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaabbaaaaaaaaaabbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbaaabaaaaabbbbbbaaaaaaaabaaaaaaaaabaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaaaaaaaaaaaabbbbbbbbaabbbbaaaaaaaabbbbbbbbbbbbbbbbbbaaabbaaabbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbaaaaaaaaaabbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaabaaaabbbbbbbbbaabbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbabbaabbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbabbaaaaaaabbaaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabaaaabbbbbbbbaabbbbaabaaaaaaaaabbaabbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbaabbbbbbaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbbbbbbabbbbbabbaaaaaaaaaaaaaaaabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaabbbbabbbbabbbbbbbbbaaaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaaaabbaaaabbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbbbbaabbbbaabbbaaaaaaaaaaaaaaaaabbbabbbbbbbabbbbbbbbbbaaaaaaaaaaaaaaaaabbbbaabbbaabbbbbbbbaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbaaabbbbbbbaaabbbbbbbbbbbbbbbbbbaaaaaabaababaaaabbbbaabbbbaabbbbaaaaaaabbaaaaaaaaaaaaaaaaaabbaaaaaaaabbaaaaaaaaaaaaaaaaabbbbbabbbbaabbbbbbbbaaaaababaaaaaaaaabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbaaaabbbbbbbbbbaaabbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaabbbaabbbbaabbbbbaaaaaaaaabaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbaaaaaaaabbbbabbbaaabbbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbaaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabbabbbbbaabbbbbaaabaaaaabaabbbabbbaaaaaaaaaaaaaaaaaaaaaaaaaaaabbaaaabbbaaaaaaaabbbaabbbbbaaabaaaabbabaaaaabbbbbbbbbbbbbbbbbaaabbbbbbaaabbbbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbaaaaabbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabaabbbbaabbaaaaaaabaaaaaaaaabbbbbbaaaaaaaaaaaaaaaaaabbaabbbbaaaaaaaabaaaaaaaabaabbbaabbbaaaabaaaaaaaaaaaabbbbbbbbbbbbbbbbaaabbbbbaaaabaaabbbbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbaaaabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbababaaaaaaaaaaabbbbaabbbaaaaaaabaaaaabaaabbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbaababaaabaaaaaaabababbbbaabaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbaaabbbbbaaaaabbbaaabbbbbbbbbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaaaaaaaaaaabbbbaabbbaaaaaaaaaaaabaaaabbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbaabbbaabaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbaaabbbbbbaaaaaabbbbaaabbbbbbaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbabbbbbaaaaaaaaabbaabbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbaabbaababaabaaabbbaabbbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbaabbbbbbbaabaaaaabbbbbaaabbbbabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbaaaaaaaaabbbbaabbbbaaaaaaaaaabbaabbbbbbbbbbbaaaaaaaaaaaaaaaabbbbbbbbbbbbaabaaaaaaaabaaabbbabbbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbaabbbbbbbaabaaaaaaaabbbbbaaaaaabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbaaaaaaabbbbaabbbbbaaaabbbbbbaabaaabbbbbbaaaabaaaaaaaaaaaaaabbbbbbbbbbbbaaababbaaaabaaabbbaabbbbaaaaaaaaaaabbbbbbbbbbbbbbbbbbaabbbbbaaaaaababaaaaaabbbbbbaaaaaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbbbaaabbbbbbbbbbbbbbbaaabbbbbbaabbbbbbbbbbbbbbbbbbaaaaaaaaaaabbbbbbabbbbaaaaaaaaababbbbbaaaaaaaaaaaaaaaaaaaaaaaabbbbbbaaaaaaaabbbbaaaaabbbbaabbbaaaaaaaaaabbbbbbbbbbbbbbbbbbaabbbbaaaaaaaaabbaaabaabbbbaaabbbaaabbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbaabbbbbbbbbbaabbbbbbbbbbbbbaabaabbbbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaaabbbaaaabbbaabaaabbbaaabbbbaaaaaaaabbbaabaaaaaaaaaaaabbbbbaaaabbaaaaaabbaaabbbbbabbaaaaaaaabbbbbbbbbbbbbbbbbbbbaabbbbbaabaaabbaabaaababbbbaabbbbbbbabbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbaaabbbbbbbbbaaabbbbbbbbbbbaaabaabbbbbbbaabbbbbbbbbbbbbbbbbbabbaaaaaaaabaaabaaaaaabbaabbbaabbbbaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbaabbbaaabaaabbbaaabbbaabaaaaaaaabbbbbbbbbbbbbbbbbbbaabbbbbbabaaaabbbaabbaaabbaaabbbbbbbbaabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbaabbbbbbbbbbbaabbbbbbbbbaabbaabbbbbbbbbaabbbbbbbbbbbbbbbbaabbbaaaaaaaaaaaaabbbaaabbabbbbbbbbbaaaaaaaaabbbaaaabbaaaaaaaaabbbbbbbbbaabbbaaaabaaaabbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbaabbbbbbbabaabbaaabaababbbaabbbbbbbbbbaabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbbbbbbaabbbbbbbaaabaaabbbaabbbbbaabbbbbbbbbbbbbbaabbbbaaaaaaaaaaabbbbbbaabaabbbbbbbbbbaaabbaaaaaaaaaaaaaaaaaaaaaabbbbbbbbaabaaaabaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbaaabbbaaaabaaaabaaaaabaaabaaabbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbaabbbbbaabbaabbbbbaaabbbbbaabbbbbbbbbbbaaabbbbbabbaaaaaaaaaabbbbbababbbbbbbbbbbaaaaaaabaaaabaaaabaaaaaaabbbbbbbbbbbabaabbbbbbaaaaaaaaaabbbbabbbbbbbbbbbbbbbbbaaabbbbaaaaababaabaaaabbbbaaabbbbbbbbbbbbaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaaaabbbbbbbbbaabbbaaabaaabbbbaabaabbbbbaabbbbbbbbaaaaaabbbaabbbbbbaaaaaaaaabaababbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbaaaabbbbbaaaaaaaaaaabbbaabbbbbbbbbbbbbbbaaabbbaaabbbaaaabaaabaabbbaaabbbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaaabbbbbbbaabbbaabaabbbbaaaaabaabbbbaabbbbbbbabbbbaabaabbbbbbbbaaaaaaaabbaaaaabbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbaabaaaaaaaaaaaaabbbabbbaaaaabbbbbbbbbbbaabbbbbabaaabbaaaabbbaabbbaabbbbbbbbbbbbbbaabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbaaaaabbbbbbaabbbaabaabbbaaaaaaaabbbbbaaabbbbbabbbbbaaabbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbaaaaaaaaaaaabaaaaaaaabbbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbaaaaabbbaabbbbbbbbaaabbbaabaaaaaabaabaaaaaabbaabbbbbbbbbbbbbaaabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbaaabbbbbaabbbaabaabbaaabbabaabbbbbaabbbbbaabbbbbbabbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbbbbaabaaaaaaaabaaaabaabbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbbaabbbbbabbbbbbbbaaabbaaaaaaaaaaabaaaabbbbbaaabbbbbbbbbbbbbaaabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaaaabbbbaabbbaaaaabbbbaaabaabbbbbbaaabbbaaabbbbbabbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbaabaaaaaaaaaaaabaaabbbbbbaaaaaaaaaaaaaaaaabbbbbbbbbbbbabbbbbbaabbbbbbaaabbaabbbaaaaaabaabaaaabbaaabbbbbbbbbbaaaaabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaaabbbbaabbbaabbbbbbaabbabbaabbbbbaaaaabaaabbbabbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaabbaaaabbbbbbbbbaaaaaaaaabaaaaaaaaaaaaaaabbbbbbbbbbbbbbbabbbbbaabbbbbaaabbbbabaaaabaaaaaaaabaabbaaaabbbbbbbbaaaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaaabbbbaabbbbbbbbbaabbaabaaaaabbbbaaaabbbaaaaabbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbaabbbbbbbbbbbbbbbbbaaaabaaabaabbaaabbaaaabaaaaaaaaabaaaaabbaaababbbbbaaaabbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbabbbbbaabbbbbbbbabbaabbaabaabbbbbbaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbaabbbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbaaaaabbbaaaaabbbaaaaabaabbabaaaabaabbbaaabbabbbbaabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbbaabbaabaabaaababbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbaaabbbbbbbbaaaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaaaaabbbaabaaaaaabbaabaaaaaabbaaabbbabbaaabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbbbbaabbbbbabbaabaabbaabaaaabbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbaaabbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbaaabaabbabaabbaaaabaabbaabbbbaabaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbabbbbbbbaabbbbaabaabaabaabaaaaabbbbbbbbbaaaaaaabbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbaaabaaaaaabaaaaaaabbbbaabbbbbaaaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbabbbbbbbbaabbbaabaaaabbaabaabbabbaabbbbbbbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbbbbbbbbbaaaaabbbbbbbbbbaabaaabaaabaaabaabbbaabbbbbbaaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbaabbbbbbbbaabbbaaaaabbaabbabbbabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbabaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbaaaabbbbbaabbaaabaaabaaabbbaabbbbbbbaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbaabbbbbbbbbaaabbaaabbaabbaababababaabaabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbabaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbabbaabbbbbaabaabbbaaaaabbbaabbbbbbbbabbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbaabbbbbbbbbbaaabbbaaaabbbaababaaabaaaaaaabbaaaaaabbbaaabbaaaabbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbbbbbaabaaaaaabbabbaaaaaaaaaaaabbbaaabbbbaabaaabbbbaabbaabbbbbbbbaaabbbbbbbbbabbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbabbbbbbbbbbbbbaabbbbbbbbaabaabaaababaabaabaaabbbaabbaaaaaaaaabbbbbbbbbbbbbbbbbbaaabbbaaaaaaabbbaaaabbbbaaaabaaabababbabaaabbaaaaabbaaaabbbbaabbbaabbbbaabbabbbbbbbaaabbbbbbbbbbabbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbaaabbbbbbbbbbbbbbaaabbbbbbaaaaabaabaabaabaababbaaabaababbaaaababbbbbbbbbbbbbbbaaaabbbbbaaaaaaabbbbbaaaabbabaaaaaaaabaaaabaaaabbbbaabbaababbbbaaaabaaabbbbaabaabbbbbaaabbbbbbbbbbbaabbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbbbbbaaabbbbaabaaaaabbabbabbabaabaabaababababaaababbbbbbbbbbbbbbaaabbbbbbbbaabbaabbbbbbbaaaaababbabaaabaaaabaaaaabaaaabbbababbbbaaaaaabaabbbbaaabbbbbaabbbbbbbbbbbbbaabbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbaaabbbaaabaabbaabbabaabaababbaababaaaaaaababbbbbbbbbbbaaaabbbbbbaaaaaaaaaaaaabbbbbbaaaaabaabaaabaaaabaabaabaabbbbbabaabbbaaaaaabaaabbbaabbbbaaabbbbbbbbbbbbbbbaaabbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaabbabbbabaabaababbbababaabaabababbbbbbbbbbaaabbbbbbbaaaaaaaaaaaaaabbbbbbbbaabaaaaaaaaaaaababbaabaabbbbbabaabbbaabbaaabbabbbbbbbaaabbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabbbbaaaabbaabaabaabaabaababaabaaaabaabbbbbbbaaabbbbbbbbaaaaaaaaaaaaaaaabbbbbbbbaaaaaaaaaaaaaababbaabaabbbbbabbabbbaabaaaaaaaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaaabbbbbaabbaababbbabaaaaababbabaaaaaaabbbbbaaabbbbbbbbbbaaaaaaaaaaabaaaabbbbbbbbbbaaabbbaaaaabbabbaabaabbbbbaababaaaababbbaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaabbbbbbaaaabbbaaaaabaaabbaaaabaaabbbaaaaabbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbbaaaaaaaaabbabbaabaabbbbbaabaaaaaababbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbbbaaaaabbbbbbbbbbbbaaaaaaabbbaabbbbbbbbaaabbbbbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbbbbaaabbbaaaabbaabaabbbbbaabbbbaaaaabbbbbbaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaababbbaabaaaaabbbbbbbbbbbaabbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbaaaabbaabbaaaaabbbbbaaaaaaaaabbbbbbaaaabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaabbaabbbbbaaaaabbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbaaaabbbaaaaabbbbbbabbbbbbbbbbaaaaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaabbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbaaaaaabbaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaaaaaaabbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbaaaaaaabbbbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbbbaaaaaababaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbabbababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbaabaaaaabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbabaaaababbabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaaaaaababbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaaaaaaabaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbaaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaabbaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabaaaaabaaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababaaababaaaababaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaaababbbbbaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabaaabaaaaaaaaaaabaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaabaaaaabaaabbbbbbaaaaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaaaaabbbbbabbbbaaaaaaaabaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaaaabaaaabbbaaaaaaabbaaabaaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbaaabaaaaaabbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbaaaaabaaaaaaaaabaabbaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabaaabbabaaaaabaaaaabaabaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaabbaabaaaaaaaaaabaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababbaabbaaaaaaaaaaaababbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaabbabbaaaaaaabaaabbabbaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbabbaabaaaaaaaaababaaaaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababbbaabbababaaaaaabaabaaaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbaaaaabaaaabaabaababaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabbaaabaaaaabbaaaaabbaaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababaaaaaabbaaabbbaaaabbaabaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaabaaaabbbaaaaaaabbaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaabaaaabbbbbbbbbbaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabaabbaaaaaaaabbbbbbaaaaaaaaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaabaabaaaaaaaaaaaaaaaaaabaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaabaababbbbbaaaabaaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaabbbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaabbaaaaaaababbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaaaaabbbaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaabbababaaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaaaaaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
        return bitmap;
    }
    if (index == 15)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "284 314 2 1",
        "a c Black",
        "b c #FFFFFF",
        /* pixels */
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaabbbbaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaabbbaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababbbbaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabbaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabbaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaaabbbaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbabbbbbaaaaaaaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaabbbaabbaaabbbbbbbbbbbaaaaaaaabbbbaaaaaaaabbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbaaaaaaaabbbbbbbbbaaaabbbaaaaabbbbbaaabbbbbbbbbbaaaaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbbaabbbbaaaaabbbbbaabbbbbabbbaabbbbbbabbbbbbbbbaabbbaabbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababbbbbbbabbbbbbbabbbbbaaaaabbbbbabbbbbaaaaaaabbbbaabbbbaaaaaabbbbbabbbbbbaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaabbbbbbbabbbbbbaabbbbbabbbaaaaababbbbbabbbaaabbbbaabbbaabbbabbbbbbabbbbbbabbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbaabbbbbbbaabbbbaaabbbbaabbbbabbbaaaabbabbaabaabbaaaaaaaabbbbaabbbbbaabbbbbabbbbbbbaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbabbbbbbbaaaaaaaaaabbaaabbbbabbaabaaabaaaaaaaabaabbaabbabbbbbabbbbbaaabbbaabbbbbbbabbbbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabbbaaaaaabbbaaaaaabbbaaaaaaabbbaabbabbbbaaabbbbbaaaabbbabbbaabbbbaaaaaaaaaaaaaabbbbbbaabbbbbaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbabbaaabbbaaaaaabbbbbbbbbbbbaaaaaaabbabbbbbaabaaabbaabbbbabbbbaabbaaaaaabbbbbbbaaabbbaaaabbbbbabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbabaabbbbbbaaaabbbaaaaaaabbbbbbbbaaaaabbbbbaaaaaaaaaabbbbabbbaaaaaaabbbbbbbbbbbbbaaaaabaaabbbaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbaaaabbbbbbbaabbaaabbbbaaaaaaaaabbbbbabbbbbaabbbbbaaabbbbaaaaaabbbbbbaaaaaaaaabbbaaaabbbbaabbabbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabbbbaaaabbbbbbbbabbaabbbbbbbbbbbbaaaaaaaaabbbbbabbbbbbbaabbbbabbbbbaaaaaaaaabbbbbaaabbaabbbbbbaaaaabbbbbbaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaabaaabaabbbbbbbaabbabbaaaaaaaaaabbbbbbaaaabbbbbabbbbbbbaabbbbaaaaaaaaabbbbaaaaaaabaabbaabbbbbbbaaaaaabbbaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaabbbaabbbbbbbabbbababbbbbbbbaaaaaaaabbbabbbbbaaaaaaabaabbbbaaaaaaaaaaaaaaaaabaaababbaabbbbbbbaaabbaaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaabbbaaaaaaaabbabbaabaaaaaaaaaaaaaaaaaaaaabbbbbaaaabbaaaabbbbaaaaaaaaaabbbbbbbbbbabaabbabbbbbbbababbbbaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbabbbbbabbaaaaaaaabbaababbbbbbbbbaaaaaaaaaaabbbbbaabbbbbbaabbbbaaaaaaaaaaaaaaaaaaaaaababbaabbbbbaabaabbbbbabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbaaabbbaabbbbbaabaabbbbbaaabaababbbbbbbbbbbbbbbbbbbabbbbbabbbbbbbaabbbbabbbbbbbbbbbbbbbbbbaaababaaaaaaaaabbaaaabbbaabbbbbabbbbbbbbbbbbbbbbbbbbbaaabbbabaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbaabbaababbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbaababbbbbbbaabbababbbbbbbbbbbbbbbbbbbabbbbbabbbbbbbaabbbbabbbbbbbbbbbbbbbbbbbaababaabbbbbbaabbabaabbbaabbbaabbbbbbbbbbbbbbbbbbbbaaaabbaabaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbaababbabbbbbbbbbbbbbbbbbbbbbaaabbbaaaabbbbbbabaabbbbbbbbabbababbbbbbbbaaaaaaaaaaaabbbbaabbbbbbbaabbbbaaaaaaaaaaaaabbbbbbbaababaabbbbbbbabbaabaaabbaaaaaaaabbbbbbbbbbbbbbbbbbaabaaaabbaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbbaaabbabbbbbbbbbbbbbbbbbbbbbaabbbbbbaabbbbbbababbbbbbbbbabbababaaaaaaaabbbbbbbbbbabbbbaaaaaaaabaabbbbabbbbbbbbbbaaaaaaabbabaababbbbbbbbaabaaabbabbaaabbbaabbbbbbbbbbbbbbbbbbaaaabaabbabaaaabababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbaaabaabbbbbbbbbbbbbbbbbbbaabbbbbbbabbbbbbbababbbbbbbbbaababaaaaabbbbbbbbbbbbbbbabbbbaaaabbbaaaabbbbabbbbbbbbbbbbbbbbaaaabaababbbbbbbbaababaababbaabbbbbabbbbbbbbbbbbbbbbbbbbaaabaaaaaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbaabbaabbbbbbbbbbbbbbbbbbaabbbbbbbabbbbbbbaaaabbbbbbbaaabaababbbbbbbbbbbbbbbbbbabbbbaaabbbbbbaabbbbabbbbbbbbbbbbbbbbbbbababaabbbbbbbbaaaabbababbbabbbbbaabbbbbbbbbbbbbbbbbbbbbabbbbaaaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbaabbaabbbbbbbbbbbbbbbbbbaabbbbbbbabbbbbbbaababbbbbbbaaabbabaabbbbbbbbbbbbbbbbbabbbbaabbbbbbbaabbbbabbbbbbbbbbbbbbbbbbaababaaabbbbbbbaaaabbaaabbaabbbbbaabbbbbbbbbbbbbbbbbbbbbaaabaabbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbaabbabbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbbbbabaaabbbaaaaabbabaabbbbbbbbbbbbbbbbbabbbbaabbbbbbbaabbbbabbbbbbbbbbbbbbbbbbabaababaabbbbbbababbbbaabbaabbbbbaabbbbbbbbbbbbbbbbbbbbbbaaabaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaaaaabbaabbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbabbbaaaaaaaaaabaababbbbbbbbbbbbbbbbbabbbbaabbbbbbbaabbbbabbbbbbbbbbbbbbbbbbabaababbaaaaaaaababbbbaabbaaabbbbabbbbbbbbbbbbbbbbbbbbbbbabaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbaaabbaaabbbbbbbabbbaabbbbbaaabbababbbbbbbbbbbbbbbbbabbbbaaaaaaaabaabbbbabbbbbbbbbbbbbbbbbaababbaaaabbaaabbbaaaabaabbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbabbbaaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbabbbbbbbbaabbbbbbbbbbbbbbbbbbbaabbbbaabbbbbbbbabbabbbbbbbaabbabaabbbbbbbbbbbbbbbbabbbbaaaabbbaaaabbbbabbbbbbbbbbbbbbbbbabaabaaabbbbbbabbbabbaaaabaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbabbbaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabaabbbbbbbbabbbbbbbbbbbbbbbbbbaabbbbbbabbbbbbbbabaabbbbbbbbaababaabbbbbbbbbbbbbbbbabbbaaaaaabaaaaabbbbabbbbbbbbbbbbbbbbbababbaabbbbbbbbabaabbbbaabaabbbbbabbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabaabbbbbbbaabbbbbbbbbbbbbbbbbabbbbbbbaabbbbbbbaaabbbbbbbbbaabaababbbbbbbbbbbbbbbbabbbaaaaabaabaaaaabbabbbbbbbbbbbbbbbbbababaaabbbbbbbbababbbbaabbabbbbbbaabbbbbbbbbbbbbbbbbbbaabaaabbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaababbbbbbbaabbbbbbbbbbbbbbbbbabbbbbbbaabbbbbbbbaabbbbbbbbbaabbabaabbbbbaaaaabbbbbabbaabbbabbbaabbaabbabbbbbbbbbbbbbbbbaababababbbbbbbbaaabbbbaabbabbbbbbbabbbbbbbbbbbbbbbbbbbaabbbabbaabaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaabbbbbbbbabbbbbbbbbbbbbbbbbaabbbbbbaaabbbbbbbaaabbbbbaaaaabbaaaabbbaaabbbaaabbbabaaaabbabbbabbaaaaaabbbaaaaaaaabbbbbabaababaabbbbbbbaaabbbbabbaabbbbbbbabbbbbbbbbbbbbbbbbabaaaaaaababbbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabbbbbbbbbbabbbbbbbbbbbbbbbbbaabbbbbaaaabbbbbbbaaaabbbaabbaaabaababbbabbbbbbbabbbaaabaabbaaaaabbaaabaabbbabbbbbbbabbbbababaabaaabbbbbaaabbbbbabbaabbbbbbaabbbbbbbbbbbbbbbbaaaaaaaaaababbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbbaaaaaaabbbaaaabababbbabbbbbbbabbbaaabaabbaaaaaabaabbaaabbabbbbbbbaabbaaaaaaaaabaaabaaaaabbbbaabaaaaabbbaabbbbbbbbbbbbbbbbaaaaaaabbabbabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbaabbbbaabbbbbbbaabbaabbbaaabaaababbaabbbbbbbaabbababbbbbabbbbabbbbaaaabbabbbbbbbbabbabaaaabaaabbaaaabaabbbbabbaabbaaaaabbbbbbbbbbbbbbbbaabbbbaabbabbaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbabbbbbbabbbbbbbbabaaabaaaaaaabaaaabaabbbbbbbaabaabaaaaaaabbbbaaaaaaabaababbbbbbbbabbababaabbbaaaaaabaabbbbaabbabbbbbabbbbbbbbbbbbbbbbbaaaabbaaaababbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbaabbaabbbbbbbbbbbbbbbbbbbabbbbbbaabbbbbbbaaaabbbababaababaabbabbbbbbbaabaababaaaaabbbbabbbbaabaababbbbbbbbabaaaabaaabbaabaaaaabbbbbabbaabbbbbaabbbbbbbbbbbbbbbbaabaaaabaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaabbbbaaaaabbbbbbbbbbbbbbbabbbbbbbabbbbbbbaabaabbaaaabbbabbaabaabaaaaaabbaaabbabbbabbbbaaaaabaaaabaaaabbbbaabaaaabbabaaaababaaabbbbbabbaabbbbbbabbbbbbbbbbbbbaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbbbbaaabbabbbbbbbbbbbbbbbabbbbbbbabbbbbbbbaaaaababbaaaaabbaabbaaaabbbabbbaabbbaabaabbaababaabaabbabaaaaaaabaababaabaaaaabaaaaabbbbaabaaabbbbbaabbbbbbbbbbbbaabbabaabbbaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbaaaabbaabbbbbbbbbbbbbbbaaabaaaaaabbbbbaaaabaababbbaaaaabaabbaabbaaaabbbaaaaaaabbaaaaaaaaaaaabbbaaabbbbaabaaaaaaaaabbaabbaabaaabbabbaaabbbbbaabbbbbbbbbbbbaaabaabaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaaaabbaabbbbbbbbbbbbbbbbbaaaabbaaabbbbaabaabbbbaabbabbbaaaabbbaaaaababbbbaaaaaabbbaabbbaabbbabbbbaaaaaaabbaaaaaaaabbbaabbbbaababaaaaaaaaabbaabbbbbbbbbbbbbbaaababbbaabaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaababbbaabbbbbbbbbbbbbbbbbbbabbaaaaabbbabaabaabbbabaabbbaaaabbbaabbabaaabbabaaabbbaaaabbbaabbabbaaabbbaabbbaaaaaaaabbbabbbbbaababaaaaaabbaaaabbbbbbbbbbbbbbbaaaaaaaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbabbbbabbbbbbbbbbbbbbbbbbbaaaaaabaaababaabbabbbbaaaabbbabaabbabbaaabbaaaaaaabbbaabaaabbbaaaabaaabaabbabbbabaabaaabbaabbbbbbababaaabababbabbbbbbbbbbbbbbbbbaabaaababbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbaabbbaabbbbbbbbbbbbbbbbbbbaaabababaaaabaababbaabbbaaaaabaaaaabbaaaaabbbbbbaaaaaaaaaaabbbbaaaabbaaaabaabbabaabaaaaaabbbbbbbabaaababbbaaaabbbbbbbbbbbbbbbbaabaaaabaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaabaaabbaaabbbbbbbbbbbbbbbbbbbaabbabbbaaabaaabbaabbbaaabbbaaabbbaabbaaaaaaaaaaaaaaaaaaaaaaaaaabaaabaabbaaaabbaaaabbbbbbbbbbbababababbaababbbbbbbbbbbbbbbbaabbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbabaaaaaaabaaabbbbbbbbbbbbbbbbbbbaaabbbbbaaaababaaabbabbaaaaabbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabbaaaaaaaabaabaabbbbaabaabbbbbbaabbbbbbbbbbbbbbbbbaabbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaaaabbbbbabbbbbbbbbbbbbbbbbbbbababbbaaabbbaaaaabbaabbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbaaabaaaaaaabaaabbbaaaabbbbbbbbbbbbbbbbbaabbaaaaabaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaabbbbabbbbbbbbbbbbbbbbbbaabaabbaaaaaabaaaabaaaaaaaaaabbbbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbbbbaaaaaaaaaaaabbaaaaaabaaaaaaababbbbbbbbbbbbbbbbbaaabbbaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaaaabaabbbbbbbbbbbbbbbbbbabbabbaaaaabbbbbbbaaaaabbbbbbbbbbbbbaaaaaaaaaabaaaaaaaaaaaaaaaabbbbbbbbbbbbbaaaabaabbbaaabaaabaaaabbabbbbbbbbbbbbbbbbbaabbbaaabababbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaabbbbbbbbbbbbbbbbbbaaaaaaaaaaabbbbbaaaaabbbbbbbbaaaaaaaaaaaaabbaaaaaaaaaaaabbbbbaaaaaaaaabbbbbbbbaaaaaabbbbbbabbaaaaabaabbbbbbbbbbbbbbbbaabbaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaabbaabbbbbbbbbbbbbbbbbbbbbabaaaaabbbbaaabbbbbbbbbaaaaabbaabbbabbaaaaaaaaaaaaaaaabbbaababbbaaaaaaabbbbbbbbaaaabbabaabbaaaaaabbbbbbbbbbbbbbbbbabbbbaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabaaaaabbbbbbbbbbbbbbbbbbbbaaaaaaabbaaaabbbbbbbaaaaaaaaabaababbaaaaaaaaaabbabbaaaaaaaaaaabbaaaaaaaaaaaabbbbbbbaaaaabaaaaabaabbbbbbbbbbbbbbbbbaabbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabaababbaaabbbbbbbbbbbbbbaaaaabbbaabbbbbbbbaaaabaaaaaaaaaabaaaabaaaaaaaaaaaaaaaaaaaaaaaaababaaabaaaaaaaaabbbbbbbaabbbbbbaabbbbbbbbbbbbbbbbbbaabbabaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabaaaaaaabbbbbbbbbbbbaaaaaaaaaaabbbbbbaaaaaaaaabbaaaaaaaababaabaaaaaaaababbaaaaaaaabbaaaaaaaaaaabaaaaaaaaabbbbbaaaabaaaaabbbbbbbbbbbbbbaaaaaabaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbbaabbbbbbbbbbbbbaaaaaabaabbbbbbaaaaabaaaabbaabbaaabbbababaaabaaaaaaaaaaaaaabbbaaabaabaaabbaabbbababbaaabbbbbaaaaaaaaabbbbbbbbbbbbbaabbbaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbaabbbbbbbbbbaaaaaaaabbaabbbaaaaababaaabaaaaaaaaaaaaaaaabababbaaaaaaaaaaabbbbabaaaaaaaaabaaaaaaaaabaabaaaabbbaaaaaaaaaabbbbbbbbbbbbabbbbaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbbbbaaaaaabbbbbbbaabaabaaabaaaaabbaabbaaaababbabbbababbbbaaaaaabbbbbbbaaabbbabaaaaaaaaabbaaaaabbaaaabbbabbaaaaaabbbbbbbbbbbbabbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbaaabbbbbbbaaaaaaaaaabbbbbaaaaaaaaaaabaaaaabaaaaaabaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbabaaaaabbbaaaaaaaaaaaaaaaaaabbbaaaaaaaabbbbbbbbbaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaabaabbbbbaaaaaaaaaaabbbbbbaaaaaabababaaaaaaaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabaaabbaababaaaaaaaaaabbbbaabaaaaaaabbbbbbbaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbaabbbaaaaaaaaabaabbbbbbbabaaaaaaabaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaabababaaaaaabbbaaaaaaaaaaaabbbbbaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabbbaaaaaababaaaabbbbbbabaaaabbbababaaaaaabbbbbbbbbaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbaaaaaaaaaaaaaaaaaabbabbabaabaaaabaaaaabbbabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaaaaaaaaaaaaaaaaaaaaabbaaaaaaaaaaaaaaabbbbbbaaaaaaaabbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbaaaaaaaaaaaaaabbaabbaaaaabbaaaaaaaabbaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaaabaaaaaaaaaaabbaaaaaabaaaabbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbaaaaaabaaabbbaaaaaaaaaaababaaabaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaaaabbbbbbbaaaaaaaaaaaaaabbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbaaaaaaaaaaaaabbbbbbbaaaaaaaaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaabaaaabbbbbbbbbbbaaaaaaaaabbbbbaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbaaaaaaaabbbbbbbbbbbbbaabbbaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaaaaabbbbbbbbbbbbbbaaaaaaabbaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabbbaaaaabbbbbbbbbbbbbbbabbbabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbaaaabbbbbbbbbbbbbbbbbaaabaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaaaaabbbbbbbbbbbbbbbbbbaaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbababbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabbbbaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaabbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabbbbabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbabbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbbbaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaaaaaabbabbbbaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabaabbbbabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbababbbbaaaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaaabaaabbbbabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbababaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabaaabababbbbaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaaaaaaabaabbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaababaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaaaaaaabbaabbbbaaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaabbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaabbbbabbbbbaabbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbabbbbabbbaaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabaaaaaabbbbaabbbbaabbbbbbbbbbbbbaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbbbaabbaaaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbaaaabbabbbbbbaabbbbabbbbbbbbbbbbbbbaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbbbabbaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaabbbbbbbaabbbabbbbbbbaaaaaabbabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaaabbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbababbbbbbbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaabaabaaaaabbbbbbbbbabbbabbbbbbaabaabaababbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaababbbbbbbbbaaabbaaaabbbbbbbbbbbbbbbbbbaaabbbbbbbaaaaaabbbabaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaababbbbbbbbaaaabbabbbbbaabbbabbaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbaaaaaabbbbaabbbaaabbaaabbbbbbbbbbbbbbbbaaabbbbbbbaabbbbbbbabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaababaaabaaaabbbbbbbaaaaaababbbbbaaaaaabbbaabbabaabbbbbbbbbbbbbbbbbbbbbbbbbaaabbaaaabbbbbabaabbbbabbaaabaaabbaabbbbbbbbbbbbbbbaaabbbbbbbbaaabaabaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaaabbaaaabbbbbbaaaaaaaaabbbbbbbbaabbbbbbbaababbbbbbbbbbbbbbbbaaaabbbbaaaabbbaaaabbbbbbababbbaabaabbbbbaaababbbbbbbbbbbbbbbaaaabbbbbbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbbaaabbbbbbaaaaaabbaabbbbbbbbbaabbbbaaabbabbbbbbbbbbbbbbbbbabaabbbabaaabbbaaaabbbbbaaaaababaabbbbbbbaabbabbbbbbbbbbbbbbaaaaabbbbbbbaaaaaaaaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabbbbbbaabbbbbbaaaaabbbaabbbbbbbbbaaaabbaabbbabbbbbbbbbbbbbbbbbabbaabbaaabbbbbaaabaabaaaaaaababaabbbbbbbbaabaabbbbbbbbbbbbbaaaaabbbbbbbaaaaabaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaabbbbbbbbabbbbbbbaaaaabbbbabbbbbbbbbbbbaabbabbbaabbbbbbbbbbbbbbbbabbbabbabbbbbbbbbbbbaaaabbaabbababaaaabbbbaabbabbbbbbbbbbbbbaaaaabbbbbbbababbbaabaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbabbbbbbbaaaabbbbbabbbbbbbbbbaaaabbabbbaabbbbbbbbbbbbbbbbabbbaabaabbbbbbbbbbbbbbaabaabaababaabaabbbbabbabbbbbbbbbbbbbabaaaabbbbbbaaabbbaaaaabbabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbabbbbbbaaabbbbbbbabbbbbbbbaaabbbbaabbbbabbbbbbbbbbbbbbbbabbbbaaaabbbbbbbbbbbbbbaabbabaababbaababbbbabbabbbbbbbbbbbbbabbbaaaabbbbbabbbbbaaaaaaabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbabbbbaaaabbbbbbbbabbbbbbbaababbbbaabbbbaabbbbbbbbbbbbbbbabbbbbaaabbbbbbbbbbbbbbaabbaaaabaabaababbbbabbabbbbbbbbbbbbbabbbaaaaabbbbabbbbbbbaabbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbabbbaaaaabbbbbbbaabbbbbbbabbabbbbbabbbbbaabbbbbbbbbbbbbbaabbbbaaaaaaaabbbbbbbbbaabbaaaabbaaabbabbbbabbabbbbbbbbbbbbbabbbaaaaabbbbabbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbabbbaaaaabbbbbbaaabbbbbbaaaaabbbbbabbbbbbaabbbbbbbbbbbbbbabbbbbbaaabaaabbbbbbbbbaabaababbbbbbbabbbbabbaaabbbbbbbbbbbabbbbaaaaabbbabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababbbbbbbbbbbbbbabbaaaaaabbbbbaababbbbbbaaabaabbbbabbbbbbbaaaabbbbbbaaaaaaaabbbbbbaabbabbbbbbbbbaababaabbbbaaaabbbbabbaaabaaaaabbbbbabbbbaaaaaabbabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababbbbbbbbbbbbbbaabaaaaabbbbbbabbabbbbbbbaabbaaaabbbbbbbbbbbbaabbbbbaaabaabbaaaabbbbababbbbbbbbbbbbabababbbaabbbbbaabbabaaabbbabbbbbabbbbbaaaaabbabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabaabbbbbaaaaaaabbbbbbbabbabbbbbbbbbbbbbbaabbbbbbbbbbbbaaabbbbbabbaabaaaaaaabaaabbbbbbbbbbbbaaaaaabbaabbbbbabbaabaabaaaaabbbbabbbbbaaaaabbabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaaabaabbbbbbaaaaaabbbbbbbabbabbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaabbbabbbabaabbbbaaaabbbbbbbbbbbbbaaabbabbbabbbbbabbabbabbabbaabbbbabbbbbbaaaabbabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaababbbaabaaaaabbbbbbaaaaabbbbbbbbabbabbbbbbbbbbbbbbabbaabbbbbbbbbbbbbaaaaaaabaaaaaabbaaaaabbbbbbbbbbbbaaabbaabbabbaaaabaabbabaabbaabbbbabbbbbbbbaaaaabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababbbaabbaaaabbbbbaaaabbbbbbbbbbabbabbbbbbbbbbbbbbabbaabbbbbbbbbbbbbbbbbababbbaaaabbbaaaabbbbbbbbbbbaababbbaababaaaaababbaababaabbbbbbabbbbbbbbbaaabbbbbbbaabbaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaabbaabbaaaaabbabaaaaabbbbbbbbbabbabbbbbbbbbbbbbbabbbabbbbbbbbbbbbbbbaaaaaabbbbaabbbaaabbbbbbbbabbbaaaabaababaaabaabaabbabbaaaaabbbbbabbbbbbbbaaaaabbbbbaaabaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaabbaaaaaaaaaaaaaaaaabbbbbbbbbaababbbbbbbbbbbbbbabbbabbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbabbbaabbaaababaaabaaaabbaabbaaaaabbbbbabbbbbbbbaaaaabbbbbabaaaabaabbabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaaabbaaabaaabaaaaaaabbbbbbbbbbbababbbbbbbbbbbbbbabbbabbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabaabababaaabaaabbaabbaaaabbbbbbbabbbbbbbbbaaaaabbbbaaaaabaabbbabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaabbabbbaabbaaaaaaaaaabbbbbbbbbbbaaabbbbbbbbbbbbbbabbabbbbbbbbbaaabbbbbbaaabbbbbbbbbbbbbbbbbbbbaabbbbabaabaaabaabbababaabbbaaaabbbbbbbabbbbbbbbbaaaaabbbbaaaaababbbabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaabbaabbbaabbbaaaaaaaaabbbbbbbbbbaaabbbbbbbbbbbbbbabaabbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbabbaabbabaaaabbaababbbaaaaabbbaaaabbbbbbbbabbbbbbbbbaaaaabbbbbbbaaaabbaabbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaaaaabbbbbaaabbbaabbbaaaaaaaaabbbbbbbbbbbaabbbbbbbbbbbbbbaaaabbbbbbbbbbabaabbbaabbbbbbbbbbbbbbbbbbaabbaabaabbababbbbaabbbaaaabbbaababbbbbbbbbabbbbbbbbbaaaaaabbaaaaaaaaabaaabaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaaaaaabababbaaaaaaaaaaabbaabbbbbbbbbbbaabbbbbbbbbbbbbbaaaabbbabaabbbabbaaaabbbaaaaaaaaaaaaaaabaaabaaaaaaabaaaaaaaaabbaaaabbaaaaaabbbbbbbbbabbbbbbbbbabaaabaaaaaabaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaabaabbaaababaabbaaaabaaabbbabbbbbbbbbbbaabbbbbbbbbbbbbbbbabbbaabaabbbabbaabbaaaabbbbbbbbbbbbbbaabababbaabaaaabbbbbabbbaaabbaabaabbbbbbbbbbbabbbbbbbbaabbaaaaabbaabaaaaabbaabbbaabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaaaaaabbbbbaaaaaaaaaaaaaaabbbaabbbbbbbbbbbabbbbbbbbbbbbbbbbaaaaaabaaabbaaaabbaaabbbbbbbbbbbbbbaaabbaaabbbaabaabbbbbbabbaaabbaaaaabbbbbbbbbbbbabbbbbbbbabbbbaaaaaabaaaaaaaabbbaabaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaaaaaabbbbbbabaababbaaaaaaabbbaabbbbbbbbbbbabbbbbbbbbbbbbbbbaaaaaaaababbaaabbaaabbaaaaaaabbbbaaabbbbbabbbbaaaaabbbbbaabbabbbaaaaaaabbbbbbbbbbbabbbbbbbaabbbbaaaaaaaaabbaaaaabaaaaaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaaaaabbbbbbaabaaababaaaaabaabbbabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbaaababbaaabaaabaaabbbbbaaaaaabbbbabbbbbbbabbbbbbbbbaabbabbaaaabbbaabbbbbbbbbbabbbbbbbabbbbaaaaaaaaaaaaaaabaaabaaaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbaaabbbbbbbaabababbabbaaaaaaabbaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbaababbabababababbbbbbbbbbbbbbbbbaababbbbabbbaaaaabaabbabbabbbbbbbaabbbbbbbbbabbbbbbbabbbbaaaaabaaaaaaaaabbbbbbaaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbaabbbbbbbbbaaabbaaaabaaaabbabbaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbaabaaaaaabaaaaabbbbbbbbbbbabbaabbababbbbabaaabbbaaaabbabbbbaaaabbbabbbbbbbbbabbbbbbaabbbbbaaaaaaaaabaaaabbbbbbbaaaaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbaabbbbbbbbbbbbbbaaabbaaaabbabbbabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabaaabbbbbbbbbbbbabbabbbabaabbbaaabbbbbbbaabbabbbaaaaabbbabbbbbbbbbabbbbbbabbbbbaaaaaabaaabaababbbbbbbabababbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbaaaaabaaaaaaabbbbbbbbbaaaaabbabbbabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbabbbaaaaaaabbbbbbbbbbbbabbabbbaaaaabaaaabaaaabbbbbbbbbbaabaaabbaabbbbbbbbabbbbbbabbbbaaaaaaabbabaaababbbbbbbaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbabaaaaabbbbbaaaaaabbbbbaabbbbabbbabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbabbbbbabbaabbbabaaaaaaaaabaabbbbbbbbbbababaabbbabbbbbbbbabbbbbaabbbbababaaabbaaabaaabbbbbbbbaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbaaaaaabbbbaaaaabbaaaabbbaabbbbabbbaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbabbbbbabbaaabbaabaababaabaaaabbbbbbbbbaaabaabbbabbbbbbbbabbbbbaabbbbabbaaaaaaaabbaaabbbbbbbbbaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaabbbbaaaaaaabbbbaabbaabbbbabbbaabbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbaabbbbbaabaaabbaabbababaaaaababbbbbbbbbaaaaaaabbabbbbbbbbabbbbbabbbbbabbbaabbaaabaabaaaaaaabbbaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabbbbbabaaaabbaaaaaaaaabbbbbaaaaabbbbabbbbabbbbbbbbbabbbbbbbaaaabbbbbbbbbbbbbbbaaabbbbbaabbbbbaabbbbbbaabaaabbaabaaabaaaaabaabbbbbbbbbaaaababbbabbbbbbbabbbbbabbbbbabbbaaabbbaaaaaaabbbaaaaaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbabbbbbaaaaaaabbaaaaabaaabbbbbaaaaaabbbabbbbabbbbbbbbbabbbbbbaabbaaaabbbbbbbbbbaaabbbbbbbbabbbbbaabbbbbbbabaaabbbaabaabbbbbbbaabbbbbbbbbaaaaaabbbabbbbbbbabbbbbabbbbbabbbaaabbaabbbbbbbbbbbbbaaaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbaabbbbaaaaaaaaaaaaabbaaaabbbbbaaaabbbaabbbbabbbbbbbbbabbbbbbaaaaabbaabbbbbbaaaabbbbbbbbbbaabbbbaabbbbabbaabaaaabbaababbbbbbbbaabbbbbbbbaaaaaaaabaaabbbbbabbbbbabbbbbabbbaaaaaabbbbbbbbbbbbbbbaaaaaaaaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbaabbbabbaaaabbaaaabbaaaabbbbbaaaabbbaabbbbabbbbbbbbbabbbbbbaaaabbbbabbbbbaaabbbbbbbbbbbbbaabbbaabbbbaabbaababaabbababbbbbbbbaabbbbbbbbbabaaababbbabbbbbabbbbbabbbbbabbbaaaaabbbbbbaaabbbbbbbaaaabbbbaaaaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbaaababbabaabbaaaaabaaaaabbbbaaaabbbaabaaaabbbbbbbbbabbbbbbbbaabbbbabbbbbabbbbbbbbbbbbbbbaaabbaabbbbaaabbbbaabaabababbbbbbbbbabbbbbbbbbabaaaaaaaaabbbbbabbbbbabbbbbabbbaaaabbbbbaaaaaaabbbbbaaaabbbbbbaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaaabbaaaabbaaaaaaaaaaabbbbaaaabbaaaaabbabbbbbbbbbabbbbbbbbbaabbbabbbbabbbbbbbbbbbbbbbbbaabbbaabbbaaaabbbbaababaaabbbbbbbbbaabbbbbbbaabbbbbbbbbbbbbbbabbbbbabbbbbabbbaaaabbbbbaaabaaaabbbbaaaabbbbbbaaabbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaaaabbbbbbbbbbbbbaaaaaaaabbaaabaaaaaaabbbbaaaabbaabbbbbabbbbbbbbaabbbbbbbbaaabbbabbbaabbbbbbbbbbbbbbbbbbabbbaaabbaabaaabbbabaaaaaabbbbbbbbbaabbbbbbaabbbbbbbbbbbbbbbabbbbbaaabbbaabbaaaaabbbbaaaaaaaaabaaaaaabbbbbaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbaabaaaabbaaaaabbaaaabbbbaaaabbabbbbbaabbbbbbbbaabbbbbbaaabbbbbaaaaabbbbbbbbbbbbbbbbbbbabbaababbabbbbaabbabaaabaabbbbbbbbbbaabbbbbabbbbbbbbbbbbbbbbabbbbbabaaaaaabbaabaabbbaaaabbbaaaaaabaabbbbbabbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbbabaaaaabbaaaaabbaaaabbbbabaabbabbbbbaabbbbbbbaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbabaabbbbbaabaabaabbaabbbbbbbbbbaaabbbabbbbbbbbbbbbbbbbabbbbbabbbbbbabbaaaaabbbaaaaaabaaaabaaaabbbaaabbbbbbbbbaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbaabaaaaabbaaaaabaaaaabbbbaaaabbabbbbbabbbbbbbbababbbaababbbbbbbbbbbbbbbbbbbbbbbbaababaaabaabbababbbbbbbaaaabaabbbabbbbbbbbbbbbaabbabbbbbbbbbbbbbbbbabbbbbabbbbbbaabaaaaabbbaaaaaaaaaabbaaaaaababbbbbbbbbbbaaabbbbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbaaaaaaaaaabbaaaaaabaaaaaaabaaaaaaaaaaaabaaaaaaabbbbbbbaababbaabaabbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaabbaaaabbbbbbbaaabbbbbbbaabbbbbbbbbbbbaabaabbbbbbbbbbbbbbbabbbbbaabbbbbbabbaaabbbaaaaaaaaaaabbaaaabaaabbbbbbbbbbbaaaaaaabbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbaaabbbbbbbbbbaaaababaaabaabbabbbaaaaaabaaaabbbaabbbbbbaabbabbabaaabbbbbbbbbbbbbbbbbaabbaaaabbbbbbaaaaaaaabbbbbbbbbaabbbbbbbbaabbbbbbbbbbbaabbabbbbbbbbbbbbbbbabbbbbbabbbbbbabbaaabbbaaaaaaabaaabbaaaabaabbbbbbbbbbbbaaaaabbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaaaabbaaabbbbbbbbbbbaaaababaaaaaaabaabaaaaaaabbaaaabaabbbbbbaabbbabbaaabaaaaabbbbbaabbbbabaaaaaabbbbaaaaaaaaaaaabbbbbbbbbaabbbbbbbbbaabbbbbbbbbbaabbaaabbbbbbbbbbbbaabbbbbbaabbbbbabaaaaabbaaaabbaaaaabaaaaabaabbbbbbbbbbbbabaaaaabbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbaaabbbbbbbbbbbbbaabbabaaaaabaaaaaaaaaaaabbbaaaaabbbbbaaabbbbabbbabbbbbbabbbbbaabbbaaaaaaaabbbaaabbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbbbbbbbaabbbbabbbbbbbbbbbbaabbbbbbbabbbbbabaaaaabbaaaabbaaaaababaaabaaabbbbbaaabbbaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbaaaaaabbbbbbbbbbbbbbaababbaaaabbbaaabbbbaaaabbbbaaaaaaaaaaabbbbbabbbbbbbbbbaabbaaaabbaaaaaaabbbbaabbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbaabbbbbbbbaabbaaabbbbbbbbbbbbaaabbbbbbaabbbaaaaaaaaaaaaaaabaaaaababaaababaaaaaaaaaabbaaaaaaabbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbaaababbaababbbaaabbbbaaaabbbbbbbaaabbbbbbbbbbabbbbbbbbbaaaaaabbaaaabaabaabbbaabbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbaabbbbbbbabbbbaabbbbbbbbbbbbaaaabbbbbbaaaaaaaaaaaaaabbaaaaabaabbabaaaaabbbbbbbbbbbabaaaabbbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaabbaaabbbbaaaabbbbbbbbbbbbbbbbbbbbabbbbbbbbbaaaaabbbbbbbbaaaaabbbabbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbaaabbbaaabbaaaabbbbbbbbbbbbaabaaabbbbbbbaaabaaaaaaabbaaaaaaaabbabaaabbbbbbbbbbbbbaaaaaaaaaaababbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaaaaaaabbbbbaaabbbbbbbbbbbbbbbbbbbbabbbbbbbbbaaabbbbbbbbbbbbababbaabbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbaaaaaabbaaaabbbbbbbbbbbbbaabbbaaaaaaaaabbbaaaaaaaaaaaaaaababbabbaabbbbbbbbbbbbbbbaabbbbbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaaaaaaabbbbbababbbbbbbbbbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbbbabaaaabbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbaaaaabbaaaabbaaaaababaaaabbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaabaaaaabbbbbbaaabbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbaaaabbbaaabbbaaaaababaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbaaaaabbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaaaabbbbbaaaaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbaaabbbaaabbbaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaaaaaabbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbaabaabbbbabaaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbaabbbbaaaaaaabaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababbbaaaaaaaaabbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbaabbaaaaaaabaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbaaabbbbaaaaaaaaaaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbabaaaabbbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbabbbaaabaabbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaaaaabbbaaaaabaaaaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbaaaaabbbbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbaaabbaabbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbaaabbabbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaaaaabbbaaaaaabbaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaaabbbbbabaaaabbbbbbbbbbbbbbbbbbaaaabaabbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaaaaabbbbaaaabaaaaaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaabaabbbbababbabbbbbbbbbbbbbbbaabaaabbabbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaaaaabbbbaaaaaaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbaaaaaabbaaabbabbbbbbbbbbbbbbbaabaaaababbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaaaaaabbbbbaaaaaaabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbaaabbbaaabbaabbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbaaabbabbbaaabaabbbbbbbbbbbbbbaabaaaababbbbbbbbbbbbbbaaaaaaaabbaaaabbbbbbbbbbbbbbaabbbbbbbbbbbbbaaaaabbbbbbaaaaaabbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabbbbbbbaaabbbaaaabaaabbbbbbbbbbbbbbbbbbabbbbbbbbbbaaabbbbabbbbbabbbaabbaabbbbbbbbbbbabaaaaaaababbbbbbbbbbbbbbbaabbababaabbaabbbbbbbbbbbbbaabbbbbbbbbbbbbaaaaabbbbbbbbabbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbaaabbaaaabaaaaabbbbbbbbbbbbbbbbbabbbbbbbbbaabaaaabaabbbbabbbbbbbbabbbbbbbbbbbaaabaabaababbbbbbbbbbbbbbaaaaaabbaabbababbbbbbbbbbbbbaabbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbabababaaaaaaaaabbbbbbbbbbbbbbbbbabbbbbbbbbababaaaababbbaabbbbbbbbabbbbbbbbbbaabaaaabbbbabbbbbbbbbbbbbbbaababbbbbbaaaabbbbbbbbbbbbbaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbabababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbaabaabaaaabaaaabbbbbbbbbbbbbbbbbabbbbbbbbaaaaaabbaaabbbabbbbbbbbbaabbbbbbbbbaabaabbbbbbabbbbbbbbbbbbbbbaababbbbbaabaabbbbbbbbbbbbbaabbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbabbbbaaaaaaaaabbbbbbbbbbbbbbbbbabbbbbbbbaaababbbbbbbbbabbbbbbbbbbaabbbbbbbbbabbbbbbbbbabbbbbbbbbbbbbbbaaaabbbbbabbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaababaaabbbaabbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaabbabaaaaaaaaaaaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbabbbbbbbbbaaabbbbbbbbbabbbbbbbbbaabbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbaabbbbbbbbbbbbaaaaaaaabbbaaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaaabaabaaaaaaaaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbabbbbbbbbbbbaaabbbbbbaabbbbbbbbbbaaaabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbaaaaabaaaabbaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaabbaaabbbaaaaaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbaaabbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbaabbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbbbbbbaaaaaaaabaaaaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaababbaabbbaabaaaaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbaaaabbbbbbbbbbbbaabbbbbbbbbbbbbbbbabbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbaabbbbbbbbbbbaaaaaaaaaaaababbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaababbaaaaaaaaaaaaaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaaaaababbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbaabbbbbbbbbbaaaaaaaaaaaabaabbaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbaaabaaaabaaabaabaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaaaaaabababbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbaaaaaaaabaababbaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaababaaaaabbbbaaaaabbbbbbbbbbbbbaabbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaabbbaaaaaabbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbaabbbbbbbbbbbaaaaaaaabbaaabaabaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbabbaabaaaabbbbbbaaaaabbbbbbbbbbbbaabbbbbbbbbbbbababbbbaabbbbbbbbbbbbbbbbbbbbbbbbabbaaaaaaaaabaabaabbbaabbbbbbbbbbbbbaaaabbbbbbbbbbbbaabbbbbbbbbbaabaaaaaaabaaaaabaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbabbaaaaaaabbbbbbaaaaabbbbbbbbbbbbaabbbbbbbbbbbaabaabbaaaabbbbbbbbbbbbbbbbbbbbbbbabaaabbbaaaabaaaaaaaaaaabbbbbbbbbbbbbaaabbbbbbbbbbbbaabbbbbbbbaaaaaaabaaaaaaaabbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbabaaaaabaabbbbbbbaaaaabbbbbbbbbbbaabbbbbbbbbbbabaaaaaabaabbbbbbbbabbbbbbbbbbbaabababaaaaabbabaaaabbbbbbabbbbbbbbbbbaaaaabbbbbbbbbbbbaabbbbbbbbaabaaaaaaaaaaaabbbabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabaabbbbbbbbaaaaabbbbbbbbbbbaabbbbbbbbbbbaaabbbbbbabbbbbaabaabbbbbbbbaabaaaaaabbaaaaabaabaaabbbbbbbabbbbbbbbbbaaababbbbbbbbbbbbaabbbbbbbaaaaaaabaaaaaaabbbaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbaabbbbaababbbaabbbaaababaaaaabaabbbbbaaaababbbbbbabbbbbbbbbbbaaaabbbbbbbbbbbbaabbbbbbbaaaaabbbbbaaabaabbbabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaaaaaaababbaaabababaaabbbbbaaabbbbbaaaaaaaaabbbaabbbbbbbbbaaaaaabbbbbbbbbbbbaabbbbbbaaaaaabbbbaaaaababbbabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbaabbbbbbbbbbbbbbbbbbaaaabbaabaaabbabaaababbbaabbbbbbbbbbbbaaaaabbbbabbabbbbbbbbbbbabbbbbbbbbbbbbbbbaabbbbbbaaaaabbbbbaaaaababbbabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbaabbbbbbbbbbbbbbbbbbbaabaaabaaaabaaaaaababbbbbbbbbbbbbbbbbaabaabbbbaaaabbbbbbbbbbbaaabbbbbbbbbbbbbbaabbbbbbbaaabbbbbbbaaaaaaaababaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbaabbbbbbbbbbbbbbbbbbbbaaabbaaaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbabbbbaaabbbbbbbbaaaaaaabbbbbbbbbbbbbbaabbbbbbaaaabbbbbbbbabaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabaaabaaabbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbaabbbbaaaabbbbbbbbbbbbbbbbbabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbaaabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbaabbbaaaaabbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbaaababbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbababbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbaaaaaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbaaaaabbabbbbbbbbbbbbbbbbbbbbbaabaaaaaaabbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaabbbbbbbbbbbbbbbbbb",
        "bbbbbbbabbbbbbbbbbaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbaaabbaaaaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbbbbbbbbaaaaabaabbbbbbbbbbbbbbbbbbbbbaababaaaabbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbbbbbbbbbbbbbbbbb",
        "bbbbbbbaabbbbbbbbbabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbaaaaaaaaaaaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabbaaaabbbabbaaaabbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbbbbbbbbbbbbbbbbb",
        "bbbbbbbaaabbbbbbbbaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaaabbbaaaaaabbaaaaaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbababaaaaaaabbbabbaabbbbbbbbbbbbbbbbbbbbbbbbabbaaaaaaabbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbbbbbbbbaabbbbbb",
        "bbbbbbbabaaabbbbbbaabbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbaaaaaabbaaaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbaababaabbabaaabbbbbbbbbbbbbbbbbbbbbbbbabaaaaaabaaabbbbbbbbaaaabbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaabbbbbbbbbaabbbbbb",
        "bbbbbbbaabbaaabbbbbabbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaaaaaabaaaaaaaaaaaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaababbbbbbbbaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbbbbbaaabbbbbb",
        "bbbbbbbbabbbaaaabbbabbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaaaabbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbaabbbbbbbaaaabbbbbb",
        "bbbbbbbbabbbbbbaaabaabbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaabaaaaaaaaabaaaaaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbaaaaaabaaaaaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbaabbbbbaaabaabbbbbb",
        "bbbbbbbbaabbbbbbbaaaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabbaaaaaaaaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbabbbbaaabbbabbbbbbb",
        "bbbbbbbbbaabbbbbbbbaabbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbaaaaaaaabababbaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbaabbaaabbbbbabbbbbbb",
        "bbbbbbbbbaabbbbbbbbbabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaaabaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbaaaaabbbbbbaabbbbbbb",
        "bbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaababaaaaaaaaaaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaaaaaabbabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbabbbbbbbbbaabbbbbbbb",
        "bbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbaabbbbbbbb",
        "bbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbaaaaaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabaaaabbbaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbb",
        "bbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaabaaaabaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbb",
        "bbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaabaaaabaabaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaaaaaababaaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaabaaaaaaaaaaabababaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaaabbabaaaaaaabaaaaabaaabbaaaaaaababbbbaabbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbaaaaaaaabbaaaaaaaaabbbabbbbbbaaaaaaaababaaabaaabbbaaabaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaabaaaaaaaaaaabaaabbbaaaaaaaabbbbabbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbaabbbbabbbbaaaaaaababaaaaaaaaaaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaabbabaaaaaaaababbbbaaaaaaaabbaabbbbbbbbbbbbbbbbbbaabbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbbaaaaaaaaabaaaaaaaaaaaaaaaaaaabbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbaaaaaabaaaabbbbbaaaaaaabaabbbbbbbbbbbbbbbbbbbbaaabbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbabbaaaaaaaaabbbaaaaaaaaabaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaabbbbbbabaaaaaaaabbbbbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbaabbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbaaaaaaaaaaaaabaaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabaaaaaaaaaaaaaabbbbbbbbaabbbaaaaaaaabbbbbbbbbbbbbbbbbbbaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbaaaaaaaaaabbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabaaaaaaaaaababbbbbbbbbbaabbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbaabbaabbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbbbbabbaaaaaaabbaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaaabaaabbbbbbbbbaabbbbaabaaaaaaaaabaabbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbaabbbbbbaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaaaaabbbbbbbaabbbbaabbaaaaaaaaaaaaaaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaabbbaabbbbabbbbbbbbbaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbabbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaabbbbbbabbbbbabbbaaaaaaaaaaaaaaaaabbbbbbbbbbbaabbbbbbbbbbbaaaaaaaaaaaaaaaabbbbaabbbaabbbbbbbbaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbabbbbbbbbbbbbbbbaaabbbbbbbaabbbbbbbbbbbbbbbbbbaaaaaabbaabaaaaaabbbbaabbbbaabbbaaaaaaaabbaaaaaaaaabaaaaaaaabbaaaaaaaabbaaaaaaaaaaaaaaaaabbbbbabbbbaabbbbbbbbaaaaaabbaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbbaaaabbbbaabbbaaabbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaabbbaabbbbaabbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaababaaabaabbbbaabbbbabbbbbbbaaaaaaaaaaabaaaaabbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbaaabbbbbaaaabbbbaabbbbbbbbbbbbbbbbbaaaaaaaabaaaaaabbbabbbbbabbbbbaaaaaaaaabbaabbaabbbaaabaaaabbbbaaaaaaaaaaaaaaaabbbaabbbaaabaabaabbbaabbbbbaaaaaabaaaaaaaaaabbbbbbbbbbbbbbbbbbaabbbbaabaabbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbaaaabbbbbbaabaaabbbaaabbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaabbbbaabbaaaaaaabaaaaaaaabbbbbbbaaaaaaaaaaaaaaaaaaabaaabbbaaaaaaaabaaaaaaaababbbbaabbbaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbaaabbbbaaabbaaabbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbabbbbbbaaaabbbbbbbaabbabaabbbbaabbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbaabbaaaaaababaaaabbbabbbbbbbbbbbbbbaababbbbbbbbbbbbbbbaaaabbabbaabaaaaabaabbbbabbaabaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbaabbbbbbababbbbaaabbbbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaaaaaaaaabbbbbbbbaabaaaaaaabbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbaabbbaaaaaaaabaaabaaaabbbbbbbbbbbbbbaababbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbaabbbaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbaaabbbaaaaababbbbbaaaabbbbbbbabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbaaaaaabbbbbbbbbbaabbbaaaababbbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaaaabbbbaabbbbbaaaaaaababbaabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbaabbabbaaaabaaabbbabbbbaaaaaabaaaaaaaaabbbbbbbbbbbbbbbbbbaabbbbaaaaabaabbbbbbbaaabbbbaabbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbaaabbbbbbbaabaaabaaaaababbbbaabbbbbbbbbbbbbbbbbbaaaaaaababbbbbabbbbbaaaaaaaaaabbabbbbbbbbbbbbbaaaaaaabaaaaababbbbbbbbbbbbaabaaaaaaabbaaabbaabbbbaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbaaabbbbbaabaabaaaaabbbbbaaaaaaabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbaabbbbbbaabbbbbbaabaaaabaabbaaabbbbaabbbbbbbbbbbbbbbbbbbabaaaaabbbbaabbbbbaaaabbbbbbabaabbbbbbbbaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbabbaaaaaabbbaabbbaabbbaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbabbbbbbbbaabaabbbbaaabbbbbbbaaaaabbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbabbbbbbbbaaabbbbbaaaaaaaabbaaaaabbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaabaabbbbbbaaabbaaaaaaaaaaabbbbbaaaaaaaaaaaaaaaaaaaaaaaabbbbbaaaaaaaabbbbaaaaaabbbbabbbbaaaaaaaabaabbbbbbbbbbbbbbbbbaaabbbaaaaabaabaaaabbaabbbbbaaabbaaabbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbabbbbbbbbbbaabbbbbaabaaabbaabaaabbbbbaabbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbaabbbaabaabbbaaaabbbbaaaaaaaaaaaaabaaaaabaaaaabbbbbaaaaaaaaaaaabbbbabbbbbaabbbaaaaaaabbbbbbbbbbbbbbbbbbbbaabbbbaabbbaabaabaaaaaabbbbaaabbbbbbaabbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbbbbbaabbbbbaaaabbaabaaabbabbbbaabbbbbbbbbbbbbbbbbbaabaaaaaaaabaaaaaaaaaabbaabbbaabbbbbaaaaaaaaaaaaabaaaaaaaaaaaaabbbbaaabbbbaaaaaabbaaaabbbaabaaaaaaaabbbbbbbbbbbbbbbbbbbaaabbbaaaaaaaabbaaaaabbbbbaaabbbbbbbbaabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbaabbbbbbbbbbbaabbbbbaaabaabaaabbaaabbbbaabbbbbbbbbbbbbbbbbabbbaaaaaaababaaaaabbaabbaabbbbbbbbbaaaaaaaaabbbaaaabaaaaaaaaaabbbbbbbbbaaabbbaaabaababbbbaaabaaaabbbbbbbbbbbbbbbbbbbbaabbbbaabaaaaaaabbaababbbbbaabbbbbbbbbbabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbbbbbbaabbbbbabaabaaabbaaaaabbbbaabbbbbbbbbbbbbbbaabbbbaaaaaaaaaabbbbbbbaabaabbbbbbbbbaaaabaabaabaaaaaaaaaaaaaaaabbbbbbbbbabbaaaabaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbaabbbbbaabaaaaaaaaaaaaabbbaaabbbbbbbbbbbabbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaabbbbbbbbbbbaabbbbbaabaaabbaabbaabbbbbaabbbbbbbbbbbbbaabbbbbabbaaaaaaaaabbbbbaaaabbbbbbbbbbaaaaababbaaabbaaabaaabbaaaabbbbbbbbbaabaabbbbbbaaaaaaaaaabbbbabbbbbbbbbbbbbbbbbbaabbbbbbbaabbbaaaabaabbbbbaabbbbbbbbbbbbbabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbaaaabbbbbbbbbaabbbbbaaaabbaabbbaababbbbaabbbbbbbbbaaaaabbbbaabbbabbaaaaaaaabbabaabbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbabaabbbbbaaaaaaaababbbbaabbbbbbbbbbbbbbbaaabbbbaaabbaabbaaaaaaabbbbaabbbbbbbbbbbbbaabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbaaaabbbbbbbbaabbbbbaabbaabaababaaabbbbaabbbbbbbaabbbaabbaabbbbbbbaaaaaaaabbaaaaaabbbbbbbbbbaaaaaaabaaaababaaaabaaabbbbbbbbbbbbbaabaaaabaaaaabaabbbabbbbaaaabbbbbbbbbbbbaabbbbaaaaabbaabbabbaabbbaaabbbbbbbbbbbbbaabbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbaaaaabbbbbbaabbbbbbbaabaaaaaaabaabbbbaaabbbbbaabbbbaaaabbbbbbbbbaaaaaaaaaaaaaaaabbbbbbbbbbaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbaaaaaaaaaaaaaaaabbbbbaabaabaaaabbbbbbbbbaaabbbbaaabaaaabaabaaabbbbaaabbbbbbbbbbbbbaaabbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbaaaabbbbbaabbbbbaabaaabaaabbabbbbbbbaabbbbaabbbbbbabbbbbbbbbbbbbaaaaaaaaaaaaabbbbbbbbbbbaababaaaaaabababbaabbbbbbbbbbbbbaaaaaaaaaabbabbbbbbbbbaaabbbbaabbbbbbbbaabbbbabaaaaabaaabaabaabbbaabbbbbbbbbbbbbaaabbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaaaabbbbaabbbbbaaaaabaabaaabaabbbbaaabbbaaaabbbbabbbbbbbbbbbbbbbabbaaaaaaaaaaaaaaabbbbaabaaaaaaaaaaaabaaabbbbbbbaaaaaaaaaaaaaaaabbbbbbbbbbbbabbbbbbaabbbbbbaaabbbbaaabaaaaabbaaaaaabbbaabbbbbbbbbbbaaaaabbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaaabbbbaabbbbbabbabbbaabbaaaabbbbbaaababbaabbbaabbbbbbbbbbbbbbbbbbaaaaaaabaaaaaaaaabbaaaaabbbbbbaaaaaaabaaabaaaaaaaaaaaaaaaabbbbbbbbbbbbbbabbbbbaaabbbbbaaabbbaaabaaaaaaabbbbaaabbbaaabbbbbbbbbaaaabbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaaabbbbaabbbbbbaabbaabbaabaabbbbbbaaaabbbaaaaaabbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaabaaaaaaaaaaaaaaaaabaaabbbbbbbbbbbbbbbbbabbbbaababbbaaabbbbaaabaabbaaaaaaaaaabbbaababbbbbaaaaabbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbaabbbbaabbbbbaabaabbaabaaabbbbbbbbbaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbaabbbbaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbaaababbbaabaaabbbbaaabbaabbabaaabaaabbbaabbabbbbaaabbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbaaaabbaaabaabbaaaabbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbaaabbbbbbbaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaaabbbbbbaaaaabaabaababbbbbbbaabbbabbbaaabbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbaabbbbbaabbbbaabbaabbaabaaabaaabbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbaaabbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbaaaaaaaabaabbabaabbbbbaabbbbabaaabbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbaabbbbbbaabbbbbbbaabaabbaabaabaabbbbbbbbaaaaaabbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbababbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbaaaaaabbaabaaaaaaabbbaaabbbbbaaaabbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbaabbbbbbbaabbbbbaabaabbaabaaaabaabbbbbbbbbbbaaaaaaaabbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbaaaaaaaabbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbaaaaabbbbaabaabaabbbbaabbbbbbaabbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbabbbbbbbbbaabbbbaaaabaabaabaaababaaaabbbbbbbbbbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbaaaaaaaabbbaabaabbbbaaabbbbbbbabbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbabbbbbbbbbbaabbbbabbbaababaaaaaababbabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbaabbbbbbbbbbbbbbbbbaabbbbbbbbbbbbaaabbbaabaaaaaabbaaaabbbbbabbbbbbbbaabbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbabbbbbbbbbbbaabbbbbbbabaaaaaaaaababaaaaaaaaaaaaaaabbbbbbaaaaaaaabbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbaaabaaabbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbaabaaabaabbaabbbbaaabbbbbbbbaabbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbaabbbbbbbbbbbbaabbbbbbaabaaaabaabbabaaabbaabaaaaaaabbaaabaabbbbbabbbbbbbbbbbbbbbaaabbbaaaaaaabbbaaabbbbbbbbaabaaababbbaaabbbbbbbbbbbbaaaaabbbaaaabbbbaaaaaababbbbbbbaabbbbbbbbbbaabbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbaaabbbbbbbbbbbbbaaabbbbbaaaaaababbaabaabaaabbabaaaaabbababaaaabaaabbbbbbbbbbbbbaaabbbbbaaaaaaabbbbbaaabbbbbbaaaaaababaaaaabbaaaaaaaaabaaaaaaaaaabbbbbbbbbbaababbbbbbaabbbbbbbbbbbaabbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbaaabbbbbbbbbbbbbbbbbaabbbbbaabbbaabbaabbbbaabbbabaaaaabbababaaaababbbbbbbbbbbbbaaabbbbbbbaaabaaabbbbbbbaaabbbaaaabaaaabaaababaabaabaababaabaaaaababbbbbbbaaaabaabbbbaaabbbbbbbbbbbbbabbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbaaabbbbaaaaabbbabbaabaabbbabaaaaabbababbbaababbbbbbbbbbbaaabbbbbbbaaaaaaaaaaabbbbbbaaaabbaaaaaaaaaaaabababaaaaaabaabababbbababbbbbbbaaaaaabbbbaabbbbbbbbbbbbbbbaaabbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbbbbbbbaabaaabbabbbabbbbbabbabaabbbababbbbbbbbbaaabbbbbbbaaaaaaaaaaaaaabbbbbbbbaabbbbbaaaaabaababababbbbabaaaababbbababbbbbbbaaabbbbbaaabbbbbbbbbbbbbbbbbaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbaababaababbbabaaaaabbabaabbbababbbbbbbaaabbbbbbbbaaaaaabaaaaaaaaabbbbbbbbaaabbbaaaabaaababababbbbabbbbbbabbbabaabbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaabbbbbbaaaabaababbaababbbbbbabaabbbaaabbbbbaaabbbbbbbbbbaaaaaababaaaaaaabbbbbbbbbbaabbbbbaaabababababbbbaabaaababbbaababbbbbbbbbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabaaaabbbbbbbbbaaaaabaabaaaaabbabaabbbabbbbbaaaabbbbbbbbbbbaaaaaaaaaaaabaaabbbbbbbbbbbaaaabbbbbbaaababaaaaaaabababaabbaaaabbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbababbbbbbaaabbbbbbbbbaaabaaaaaaaabbaaaabbbbbbbaaabbbbbbbbbbbbbbbaaabaaaaaaabaaabbbbbbbbbbbbbaaabbbbbbbabaaabbaaaabababaabbbabbbbbbbbbaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbabbbbbaabaaaabbbbbbbbbbaaaaaaaabbbbbbbbbbaaaaabbbbbbbbbbbbbbbbaaabaaaaaaaaaaabbbbbbbbbbbbbbbaaaaabbbbbbaaaaabaaaabaaaabbbbbbbbbbbaaabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbbabbbbbaaaabbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbaaaaaaabaaaaaaabbbbbbbbbbbbbbbbbbaaaabbbbbbbbbbbabbbbbbbbbbbbbbbbaaabbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaabbbbbbbaaaaaaaabbbbbbbbbbbaaaaaaabbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaaaaaabbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbbbbbbbbbaaaaabaabaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaaaaaaaabbbbbbbbbbbbaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbbbbbbbbbaaaaabbbbbbaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaabbbbbbbaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaaabababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbababbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbaabaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbabbbabbaaababbaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabaabaabababbabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbabbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaaabaaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbababaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaababaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbabaaaaaaabbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaaabaaabbbbbabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaababaababaaaaaaabaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaaabaabbbabaabaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaabaabaaaaaaaaaabaaabababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabaaabaaaaaaabbbbaaaaaababaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaababaaaaaaaaabbbbbbbbaaaaaabaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaabaabbaaabbbaaaaaabbbaabaaabaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbaaaaabaaaabbaaaaaaaaabbbaabbaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbaaababbbaaababaaaaabaaaaaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaabbaaabbaaaaaabaabbabbaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaaaabaabaabaaabbabaaabbaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabaabaaaabaaaaaaaaabaaaabbaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaababbbabbaaaaaabaabaababbabababababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbabbabbabaaaaaaaaaababbaaaaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaababbbabbabbaaaaaababaabbaaaaabababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaabaaaabaaaaaaaaabababbaabaaaaababbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaaabbabbaabbabbaaaaabbaababaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabaaaabbbaaaabbaaaaabaaaaaaabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaabbbbaaaaaabbbaaabbaaabbbaaabbabaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabaaaaaabaaabbbbaaaaabbaaaaaaabaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaabbaabaaaaabbbbbbbbaaaabaaaaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaabaabbaaaaaaaaaabbaaaaaaabaabaabbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbbaaaaaabaabaaaaaaabaabaaabaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaabbbbbbbabaaaaaaabbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabbbaababbbaabbabaaabbaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaabbbabbbaabaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaabbaaaaaaaaabbbaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaaaaaaaaaaaaabaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbaaabaaaabaaaaaaabbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaaaaaaaabbaaabaaababbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbaabaaabbbbbbbaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
        return bitmap;
    }
    if (index == 16)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "16 16 9 1",
        "a c Black",
        "b c #FF0000",
        "c c #808000",
        "d c #C0C0C0",
        "e c #FFFF00",
        "f c #FFFFFF",
        "g c #000080",
        "h c #808080",
        "i c #008000",
        /* pixels */
        "bbbbbbbbbbbbbbbb",
        "iiiiiiiiiiiiiiib",
        "ihddddhdddhddhia",
        "idefffeffefffdia",
        "idfdcdfffffefdia",
        "ihfchcfgffdffhia",
        "idfdcdgedgfgfdia",
        "idffeffgffgefdia",
        "ihefffffeffffhia",
        "idffgggggggggdia",
        "idffefffffeffdia",
        "ihdddhddddhddhia",
        "iiiiiiiiiiiiiiia",
        "baaaaaaaaaaaaaaa",
        "bbbbbbbbbbbbbbbb",
        "bbbbbbbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, *wxRED));
#endif		
        return bitmap;
    }
    if (index == 17)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "16 16 8 1",
        "a c Black",
        "b c #FF0000",
        "c c #808000",
        "d c #C0C0C0",
        "e c #FFFF00",
        "f c #008080",
        "g c #FFFFFF",
        "h c #808080",
        /* pixels */
        "ahbbbbbbbhbbbbbb",
        "bahbbbbhhdhbbbbb",
        "bbahbhhddddhbbbb",
        "bbbhhddddhhdhbbb",
        "bhhddddhhddddhbb",
        "hgdddhhdddddddhb",
        "hhghhdddddddddhb",
        "ahhgddddddddhaab",
        "bahhgdddddhaadab",
        "bbahhgddhaaddgfb",
        "bbbahhgaaeecgggf",
        "bbbbahhadccggffa",
        "bbbbbaaafggffaab",
        "bbbbbbbbaffaabbb",
        "bbbbbbbbbaabbbbb",
        "bbbbbbbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, *wxRED));
#endif		
        return bitmap;
    }
    if (index == 25)
    {
        static const unsigned char data[] = 
        {
            212,208,200,212,208,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,208,200,212,208,200,212,208,200,0,
            0,0,0,124,127,0,124,127,0,124,127,0,0,0,252,252,1,252,252,1,252,252,1,252,252,
            1,252,252,1,252,252,1,252,252,1,252,252,1,252,252,1,252,252,1,252,252,1,252,252,1,
            252,252,1,252,252,1,252,252,1,252,252,1,252,252,1,252,252,1,252,252,1,252,252,1,0,
            0,0,0,124,127,0,124,127,0,124,127,0,0,0,212,208,200,0,0,0,0,123,127,0,123,
            127,0,123,127,0,124,127,0,0,0,210,210,0,210,210,0,210,210,0,214,214,0,221,221,0,
            229,229,0,229,229,0,238,238,0,245,245,0,252,252,1,252,252,1,252,252,1,251,251,0,249,
            249,0,245,245,0,245,245,0,245,245,0,238,238,0,238,238,0,238,238,0,0,0,0,0,124,
            127,0,124,127,0,124,127,0,124,127,0,0,0,0,0,0,0,118,127,0,118,127,0,120,127,
            0,120,127,0,0,0,210,210,0,210,210,0,210,210,0,214,214,0,221,221,0,229,229,0,229,
            229,0,238,238,0,245,245,0,252,252,1,252,252,1,252,252,1,251,251,0,249,249,0,245,245,
            0,245,245,0,245,245,0,238,238,0,238,238,0,238,238,0,0,0,0,0,124,127,0,124,127,
            0,124,127,0,124,127,0,0,0,0,0,0,0,114,127,0,0,0,212,208,200,0,117,127,0,
            0,0,146,146,21,146,146,21,146,146,21,146,146,21,149,149,17,149,149,17,149,149,17,149,149,
            17,149,149,17,149,149,17,149,149,17,210,210,0,210,210,0,210,210,0,210,210,0,210,210,0,
            210,210,0,210,210,0,214,214,0,221,221,0,0,0,0,0,124,127,0,124,127,0,124,127,0,
            124,127,0,0,0,0,0,0,0,110,127,0,0,0,212,208,200,0,113,127,0,0,0,254,250,
            238,254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,
            254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,254,
            250,238,254,250,238,254,250,238,0,0,0,0,124,127,0,123,127,0,123,127,0,123,127,0,0,
            0,0,0,0,0,105,127,0,0,0,0,0,0,0,110,127,0,0,0,254,251,235,254,251,235,
            161,161,161,145,145,143,126,126,126,108,108,109,89,93,94,62,62,65,56,56,58,40,40,41,40,
            40,41,36,36,37,31,31,31,27,27,27,22,22,22,19,19,20,16,16,16,9,9,9,254,250,
            238,254,250,238,0,0,0,0,122,127,0,122,127,0,121,127,0,121,127,0,0,0,0,0,0,
            0,100,127,0,102,127,0,104,127,0,106,127,0,0,0,254,251,229,254,251,230,254,251,232,254,
            251,232,254,251,233,254,251,235,254,251,235,254,251,235,254,250,238,254,250,238,254,250,238,254,250,
            238,254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,254,251,235,254,251,235,254,251,235,
            0,0,0,0,121,127,0,121,127,0,120,127,0,120,127,0,0,0,0,0,0,0,96,127,0,
            98,127,0,100,127,0,102,127,0,0,0,254,251,224,254,251,225,254,251,227,254,251,229,254,251,
            232,254,251,232,254,251,235,254,251,235,254,250,238,254,250,238,254,250,238,254,250,238,254,250,238,
            254,250,238,254,251,235,254,251,235,254,251,235,254,251,235,254,251,235,254,251,235,0,0,0,0,
            120,127,0,120,127,0,120,127,0,120,127,0,0,0,0,0,0,0,90,127,0,93,127,0,96,
            127,0,98,127,0,0,0,254,251,217,254,251,220,161,161,161,144,144,139,112,112,113,89,93,94,
            62,62,65,40,40,41,40,40,41,33,33,33,28,28,29,22,22,22,16,16,16,9,9,9,254,
            251,235,254,251,235,254,251,235,254,251,235,254,251,235,254,251,235,0,0,0,0,120,127,0,120,
            127,0,118,127,0,118,127,0,0,0,0,0,0,0,86,127,0,90,127,0,93,127,0,96,127,
            0,0,0,254,251,212,254,251,215,254,251,219,254,251,222,254,251,225,254,251,228,254,251,232,254,
            251,235,254,251,235,254,250,238,254,250,238,254,250,238,254,250,238,254,251,235,254,251,235,254,251,
            235,254,251,235,254,251,233,254,251,232,254,251,232,0,0,0,0,120,127,0,118,127,0,117,127,
            0,117,127,0,0,0,0,0,0,0,82,127,0,85,128,0,90,127,0,90,127,0,0,0,254,
            252,208,254,251,210,254,251,215,254,251,217,254,251,222,254,251,225,254,251,229,254,251,232,254,251,
            235,254,250,238,254,250,238,254,250,238,254,250,238,254,251,235,254,251,235,254,251,235,254,251,235,
            254,251,233,254,251,232,254,251,232,0,0,0,0,117,127,0,116,127,0,115,127,0,115,127,0,
            0,0,0,0,0,0,77,127,0,81,127,0,84,128,0,86,127,0,0,0,254,252,201,254,252,
            205,161,161,161,145,145,143,120,120,121,101,101,102,84,92,93,60,60,62,40,40,41,40,40,41,
            36,36,37,30,30,30,25,25,25,19,19,20,16,16,16,9,9,9,254,251,230,254,251,229,254,
            251,229,254,251,229,0,0,0,0,117,127,0,116,127,0,115,127,0,114,127,0,0,0,0,0,
            0,0,75,127,0,77,127,0,81,127,0,84,128,0,0,0,254,252,196,254,252,201,254,252,203,
            254,252,205,254,252,208,254,251,212,254,251,215,254,251,219,254,251,222,254,251,226,254,251,226,254,
            251,226,254,251,226,254,251,226,254,251,226,254,251,227,254,251,227,254,251,227,254,251,227,254,251,
            228,0,0,0,0,116,127,0,115,127,0,114,127,0,113,127,0,0,0,0,0,0,0,68,127,
            0,71,127,0,77,127,0,81,127,0,0,0,254,252,193,254,252,196,254,252,199,254,252,201,254,
            252,204,254,252,208,254,251,210,254,251,212,254,251,215,254,251,220,254,251,220,254,251,220,254,251,
            220,254,251,222,254,251,222,254,251,222,254,251,224,254,251,225,254,251,226,254,251,227,0,0,0,
            0,115,127,0,114,127,0,113,127,0,111,127,0,0,0,0,0,0,0,61,127,0,68,127,0,
            75,127,0,77,127,0,0,0,254,253,186,254,253,189,161,161,161,145,145,143,120,120,121,101,101,
            102,84,92,93,60,60,62,40,40,41,36,36,37,30,30,30,25,25,25,19,19,20,16,16,16,
            9,9,9,254,251,219,254,251,220,254,251,222,254,251,222,254,251,225,0,0,0,0,114,127,0,
            113,127,0,111,127,0,111,127,0,0,0,0,0,0,0,61,127,0,68,127,0,75,127,0,77,
            127,0,0,0,254,253,183,254,253,183,254,253,186,254,253,189,254,252,193,254,252,196,254,252,199,
            254,252,201,254,252,203,254,252,205,254,252,205,254,252,208,254,251,210,254,251,212,254,251,214,254,
            251,215,254,251,217,254,251,220,254,251,222,254,251,224,0,0,0,0,114,127,0,113,127,0,111,
            127,0,111,127,0,0,0,0,0,0,0,59,127,0,61,127,0,68,127,0,71,127,0,0,0,
            254,253,183,254,253,183,254,253,183,254,253,183,254,253,186,254,253,189,254,252,193,254,252,193,254,
            252,196,254,252,199,254,252,199,254,252,203,254,252,205,254,252,208,254,251,210,254,251,212,254,251,
            215,254,251,217,254,251,220,254,251,222,0,0,0,0,111,127,0,110,127,0,110,127,0,110,127,
            0,0,0,0,0,0,0,54,127,0,58,127,0,61,127,0,68,127,0,71,127,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,110,127,0,110,127,0,110,127,0,108,127,0,108,127,0,0,0,0,
            0,0,0,52,127,0,54,127,0,58,127,0,61,127,0,68,127,0,71,127,0,75,127,0,81,
            127,0,84,128,0,90,127,0,93,127,0,97,127,0,101,127,0,105,127,0,110,127,0,110,127,
            0,110,127,0,110,127,0,110,127,0,110,127,0,108,127,0,108,127,0,108,127,0,108,127,0,
            108,127,0,108,127,0,108,127,0,108,127,0,108,127,0,108,127,0,0,0,0,0,0,0,47,
            127,0,47,127,0,52,127,0,56,127,0,61,127,0,68,127,0,71,127,0,75,127,0,79,127,
            0,82,127,0,86,127,0,90,127,0,96,127,0,99,127,0,104,127,0,104,127,0,104,127,0,
            104,127,0,104,127,0,104,127,0,104,127,0,104,127,0,105,127,0,105,127,0,105,127,0,105,
            127,0,105,127,0,105,127,0,105,127,0,106,127,0,0,0,0,0,0,0,42,127,0,47,127,
            0,47,127,0,52,127,0,56,127,0,61,127,0,68,127,0,71,127,0,75,127,0,79,127,0,
            82,127,0,86,127,0,90,127,0,94,127,0,99,127,0,99,127,0,99,127,0,99,127,0,100,
            127,0,100,127,0,100,127,0,101,127,0,101,127,0,101,127,0,102,127,0,102,127,0,102,127,
            0,103,127,0,103,127,0,104,127,0,0,0,0,0,0,0,36,127,0,42,127,0,42,127,0,
            47,127,0,52,127,0,56,127,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
            192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
            192,192,192,192,192,192,192,192,192,0,98,127,0,99,127,0,100,127,0,100,127,0,101,127,0,
            102,127,0,103,127,0,0,0,0,0,0,0,32,127,0,36,127,0,36,127,0,42,127,0,47,
            127,159,159,160,128,128,127,128,128,127,128,128,127,128,128,127,128,128,127,181,181,181,192,192,192,
            188,188,188,192,192,192,191,191,191,190,190,190,190,190,190,189,189,189,189,189,189,188,188,188,188,
            188,188,187,187,187,187,187,187,0,96,127,0,97,127,0,98,127,0,99,127,0,100,127,0,102,
            127,0,0,0,0,0,0,0,27,127,0,28,127,0,36,127,0,36,127,0,42,127,127,127,127,
            128,128,127,128,128,127,0,2,127,0,2,127,0,2,127,170,170,171,192,192,192,184,184,184,192,
            192,192,191,191,191,190,190,190,189,189,189,188,188,188,187,187,187,186,186,186,185,185,185,184,184,
            184,183,183,183,0,93,127,0,96,127,0,96,127,0,98,127,0,99,127,0,101,127,0,0,0,
            0,0,0,0,21,127,0,25,127,0,28,127,0,32,127,0,36,127,93,94,95,128,128,127,128,
            128,127,0,2,127,0,2,127,0,2,127,159,159,160,192,192,192,181,181,181,192,192,192,190,190,
            190,189,189,189,187,187,187,186,186,186,184,184,184,183,183,183,181,181,181,180,180,180,180,180,180,
            0,90,127,0,93,127,0,94,127,0,96,127,0,98,127,0,100,127,0,0,0,0,0,0,0,
            18,127,0,21,127,0,25,127,0,28,127,0,32,127,62,62,65,128,128,127,128,128,127,0,2,
            127,0,2,127,0,2,127,148,148,147,192,192,192,178,178,178,192,192,192,190,190,190,188,188,188,
            186,186,186,184,184,184,182,182,182,180,180,180,178,178,178,176,176,176,176,176,176,0,90,127,0,
            90,127,0,93,127,0,94,127,0,96,127,0,98,127,0,0,0,0,0,0,0,13,127,0,18,
            127,0,21,127,0,21,127,0,27,127,62,62,65,128,128,127,128,128,127,0,2,127,0,2,127,
            0,2,127,128,128,127,192,192,192,158,158,159,170,170,171,170,170,171,170,170,171,170,170,171,170,
            170,171,170,170,171,170,170,171,170,170,171,170,170,171,170,170,171,0,85,128,0,86,127,0,90,
            127,0,93,127,0,94,127,0,97,127,0,0,0,0,0,0,0,8,127,0,13,127,0,18,127,
            0,18,127,0,21,127,62,62,65,128,128,127,128,128,127,0,2,127,0,2,127,0,2,127,120,
            120,121,192,192,192,144,144,139,151,151,152,151,151,152,153,153,154,156,156,157,156,156,157,159,159,
            160,161,161,161,161,161,161,163,163,164,167,167,168,0,82,127,0,85,128,0,86,127,0,90,127,
            0,93,127,0,96,127,0,0,0,0,0,0,0,4,127,0,8,127,0,8,127,0,13,127,0,
            18,127,62,62,65,128,128,127,128,128,127,128,128,127,128,128,127,128,128,127,108,108,109,192,192,
            192,122,122,123,128,128,127,128,128,127,144,144,135,144,144,139,145,145,143,148,148,147,151,151,152,
            153,153,154,158,158,159,161,161,161,0,79,127,0,82,127,0,85,128,0,90,127,0,90,127,0,
            96,127,0,0,0,0,0,0,0,0,0,0,2,127,0,8,127,0,8,127,0,13,127,62,62,
            65,62,62,65,62,62,65,84,92,93,84,92,93,89,93,94,93,94,95,99,99,100,105,105,105,
            108,108,109,115,115,116,120,120,121,126,126,126,128,128,127,144,144,135,144,144,139,148,148,147,151,
            151,152,158,158,159,0,77,127,0,81,127,0,84,128,0,86,127,0,90,127,0,94,127,0,0,
            0,212,208,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,208,200
        };
        wxImage image( 32, 32, (unsigned char*)data, TRUE );
        image.SetMaskColour( 212, 208, 200);
        wxBitmap bitmap( image );
        return bitmap;
    }
    if (index == 26)
    {
        static const unsigned char data[] = 
        {
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,0,0,0,255,242,177,255,241,177,255,240,177,
            255,239,177,255,238,177,255,238,177,255,237,177,255,236,177,255,235,177,255,234,177,0,0,0,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,255,241,177,255,240,177,255,239,177,255,238,177,255,238,177,255,
            237,177,255,236,177,255,235,177,255,235,177,255,234,177,255,233,177,255,232,177,0,0,0,255,0,
            255,255,0,255,255,0,255,255,0,255,0,0,0,255,252,177,255,251,177,255,250,177,255,249,177,
            255,248,177,255,247,177,255,246,177,255,245,177,255,244,177,255,243,177,255,242,177,255,241,177,255,
            240,177,255,240,177,255,239,177,255,238,177,255,238,177,255,237,177,255,236,177,255,236,177,255,235,
            177,255,235,177,255,234,177,255,233,177,255,233,177,255,232,177,255,232,177,0,0,0,255,0,255,
            255,0,255,255,0,255,0,0,0,255,250,177,255,249,177,255,248,177,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,255,231,177,0,0,0,255,0,255,255,0,255,255,
            0,255,0,0,0,255,249,177,255,248,177,255,247,177,0,0,0,255,255,255,255,254,253,255,253,
            251,255,253,250,255,252,248,255,252,247,255,251,245,255,250,243,255,250,242,255,249,240,255,249,239,
            255,248,237,255,247,235,255,247,234,255,246,232,255,246,231,255,245,229,255,244,227,255,244,226,255,
            243,224,255,243,223,0,0,0,255,231,177,0,0,0,255,0,255,255,0,255,255,0,255,0,0,
            0,255,247,177,255,246,177,255,245,177,0,0,0,255,253,250,255,252,248,255,251,246,162,162,162,
            255,250,243,255,250,241,162,162,162,255,248,238,255,248,236,180,180,180,255,247,233,255,246,231,180,
            180,180,255,245,229,255,245,228,180,180,180,255,244,225,255,243,224,180,180,180,255,242,222,255,242,
            221,0,0,0,255,231,177,0,0,0,255,0,255,255,0,255,255,0,255,0,0,0,255,246,177,
            255,245,177,255,244,177,0,0,0,255,251,246,255,250,244,255,249,242,136,136,136,255,248,238,255,
            248,237,136,136,136,255,246,233,255,246,231,144,144,144,255,245,228,255,244,227,144,144,144,255,244,
            225,255,243,224,144,144,144,255,243,223,255,242,222,144,144,144,255,242,220,255,242,220,0,0,0,
            255,230,177,0,0,0,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,255,244,225,128,128,128,255,243,222,255,242,221,128,128,128,255,242,221,255,242,220,
            128,128,128,255,241,220,255,241,219,144,144,144,255,241,219,255,241,219,0,0,0,255,230,177,0,
            0,0,0,0,0,255,255,107,255,253,107,255,252,108,255,251,109,255,250,110,255,249,111,255,248,
            112,255,247,113,255,245,113,255,244,114,255,243,115,255,242,116,255,241,117,255,240,118,255,239,119,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,128,128,128,255,241,217,255,241,218,0,0,0,255,229,177,0,0,0,0,0,
            0,255,251,109,255,249,109,255,248,110,255,247,111,255,246,112,255,245,113,255,244,114,255,243,115,
            255,241,116,255,240,117,255,239,118,255,238,119,255,237,120,255,236,121,255,235,122,255,234,122,255,
            233,123,255,232,124,255,231,124,255,230,125,255,229,126,255,228,127,255,227,127,255,226,128,255,225,
            129,0,0,0,255,240,216,255,241,217,0,0,0,255,229,177,0,0,0,0,0,0,255,248,111,
            255,246,112,255,245,113,255,244,114,255,243,115,255,241,116,255,240,117,255,239,118,255,238,119,255,
            237,120,255,235,121,255,234,122,255,233,123,255,232,124,255,231,125,255,230,125,255,229,126,255,228,
            126,255,228,127,255,227,127,255,226,128,255,226,129,255,225,129,255,224,130,255,223,130,0,0,0,
            255,240,215,255,240,216,0,0,0,255,229,177,0,0,0,0,0,0,255,245,114,255,243,115,255,
            242,116,255,241,117,255,239,118,255,238,119,255,237,120,255,236,121,255,234,122,255,233,123,255,232,
            124,255,230,125,255,229,126,255,228,127,255,227,128,255,226,128,255,226,128,255,225,129,255,225,129,
            255,224,130,255,224,130,255,223,131,255,223,131,255,222,131,255,222,132,0,0,0,255,240,214,255,
            240,215,0,0,0,255,228,177,0,0,0,255,0,255,0,0,0,255,240,117,255,239,118,255,237,
            119,255,236,120,255,235,121,255,233,122,255,232,124,255,231,125,255,229,126,255,228,127,255,227,128,
            255,225,129,255,224,130,255,223,132,255,222,132,255,222,132,255,222,132,255,221,132,255,221,132,255,
            221,132,255,221,133,255,220,133,255,220,133,255,220,133,255,219,133,0,0,0,255,240,214,0,0,
            0,255,228,177,0,0,0,255,0,255,0,0,0,255,237,120,255,236,121,255,234,122,255,233,123,
            255,231,124,255,230,125,255,229,127,255,227,128,255,226,129,255,224,130,255,223,131,255,221,132,255,
            220,133,255,219,135,255,218,135,255,218,135,255,218,135,255,218,135,255,218,135,255,218,135,255,218,
            135,255,218,135,255,218,135,255,218,135,255,218,135,0,0,0,255,240,213,0,0,0,255,228,177,
            0,0,0,255,0,255,0,0,0,255,234,122,255,233,123,255,231,124,255,230,125,255,228,127,255,
            227,128,255,225,129,255,224,130,255,222,131,255,221,133,255,219,134,255,218,135,255,216,136,255,215,
            138,255,215,137,255,215,137,255,215,137,255,215,137,255,215,137,255,215,137,255,216,137,255,216,136,
            255,216,136,255,216,136,255,216,136,0,0,0,255,240,212,0,0,0,255,227,177,0,0,0,255,
            0,255,255,0,255,0,0,0,255,230,126,255,228,127,255,227,129,255,225,130,255,224,131,255,222,
            133,255,221,134,255,219,135,255,218,136,255,216,138,255,215,139,255,213,140,255,212,142,255,212,141,
            255,212,141,255,213,140,255,213,140,255,213,140,255,214,139,255,214,139,255,214,139,255,215,138,255,
            215,138,255,215,138,255,216,137,0,0,0,0,0,0,255,227,177,0,0,0,255,0,255,255,0,
            255,0,0,0,255,227,128,255,226,129,255,224,130,255,223,131,255,222,132,255,221,134,255,219,135,
            255,218,136,255,217,137,255,215,138,255,214,139,255,213,140,255,212,142,255,212,141,255,212,141,255,
            212,140,255,213,140,255,213,140,255,213,139,255,214,139,255,214,139,255,214,138,255,214,138,255,215,
            138,255,215,137,0,0,0,0,0,0,255,227,177,0,0,0,255,0,255,255,0,255,0,0,0,
            255,224,130,255,223,131,255,222,132,255,221,133,255,220,134,255,219,135,255,218,136,255,217,137,255,
            216,138,255,215,139,255,214,140,255,213,141,255,212,142,255,212,141,255,212,141,255,212,141,255,212,
            140,255,213,140,255,213,140,255,213,140,255,213,139,255,213,139,255,214,139,255,214,138,255,214,138,
            0,0,0,0,0,0,255,226,177,0,0,0,255,0,255,255,0,255,255,0,255,0,0,0,255,
            221,133,255,220,134,255,219,134,255,218,135,255,218,136,255,217,137,255,216,138,255,215,138,255,214,
            139,255,213,140,255,212,141,255,212,142,255,212,141,255,212,141,255,212,141,255,212,141,255,212,140,
            255,212,140,255,213,140,255,213,140,255,213,140,255,213,139,255,213,139,255,213,139,255,213,139,0,
            0,0,255,226,177,0,0,0,255,0,255,255,0,255,255,0,255,0,0,0,255,219,135,255,218,
            136,255,217,136,255,217,137,255,216,138,255,215,138,255,215,139,255,214,139,255,213,140,255,213,140,
            255,212,141,255,212,142,255,212,141,255,212,141,255,212,141,255,212,141,255,212,140,255,212,140,255,
            213,140,255,213,140,255,213,140,255,213,139,255,213,139,255,213,139,255,213,139,0,0,0,255,226,
            177,0,0,0,255,0,255,255,0,255,255,0,255,0,0,0,255,216,137,255,216,137,255,215,138,
            255,215,138,255,215,139,255,214,139,255,214,139,255,213,140,255,213,140,255,212,141,255,212,141,255,
            212,142,255,212,141,255,212,141,255,212,141,255,212,141,255,212,141,255,212,141,255,212,141,255,212,
            140,255,212,140,255,212,140,255,212,140,255,212,140,255,212,140,0,0,0,255,226,177,0,0,0,
            255,0,255,255,0,255,255,0,255,255,0,255,0,0,0,255,214,139,255,213,140,255,213,140,255,
            213,140,255,213,140,255,213,140,255,212,141,255,212,141,255,212,141,255,212,141,255,212,142,255,212,
            141,255,212,141,255,212,141,255,212,141,255,212,141,255,212,141,255,212,141,255,212,141,255,212,141,
            255,212,141,255,212,141,255,212,141,255,212,141,255,212,141,0,0,0,0,0,0,255,0,255,255,
            0,255,255,0,255,255,0,255,0,0,0,255,212,142,255,212,142,255,212,142,255,212,142,255,212,
            142,255,212,142,255,212,142,255,212,142,255,212,142,255,212,142,255,212,142,255,212,142,255,212,142,
            255,212,142,255,212,142,255,212,142,255,212,142,255,212,142,255,212,142,255,212,142,255,212,142,255,
            212,142,255,212,142,255,212,142,255,212,142,0,0,0,0,0,0,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,
            255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,
            0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,
            255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255
        };
        wxImage image( 32, 32, (unsigned char*)data, TRUE );
        image.SetMaskColour( 255, 0, 255);
        wxBitmap bitmap( image );
        return bitmap;
    }
    if (index == 27)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "16 15 3 1",
        "a c Black",
        "b c #808000",
        "c c #C0C0C0",
        /* pixels */
        "caaaaaaaaaaaaaac",
        "cabaccccccccacac",
        "cabaccccccccaaac",
        "cabaccccccccabac",
        "cabaccccccccabac",
        "cabaccccccccabac",
        "cabaccccccccabac",
        "cabbaaaaaaaabbac",
        "cabbbbbbbbbbbbac",
        "cabbaaaaaaaaabac",
        "cabbaaaaaaccabac",
        "cabbaaaaaaccabac",
        "cabbaaaaaaccabac",
        "ccaaaaaaaaaaaaac",
        "cccccccccccccccc"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, *wxLIGHT_GREY));
#endif		
        return bitmap;
    }
    if (index == 28)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "16 15 5 1",
        "a c Black",
        "b c #808000",
        "c c #C0C0C0",
        "d c #FFFF00",
        "e c #FFFFFF",
        /* pixels */
        "ccccccccccaaaccc",
        "cccccccccacccaca",
        "ccccccccccccccaa",
        "ccaaaccccccccaaa",
        "caedeaaaaaaacccc",
        "cadededededacccc",
        "caededededeacccc",
        "cadedeaaaaaaaaaa",
        "caedeabbbbbbbbba",
        "cadeabbbbbbbbbac",
        "caeabbbbbbbbbacc",
        "caabbbbbbbbbaccc",
        "caaaaaaaaaaacccc",
        "cccccccccccccccc",
        "cccccccccccccccc"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, *wxLIGHT_GREY));
#endif		
        return bitmap;
    }
    if (index == 29)
    {
        /* XPM */
        static const char *xpm_data[] = {
        /* columns rows colors chars-per-pixel */
        "16 15 5 1",
        "a c Black",
        "b c #C0C0C0",
        "c c #FFFF00",
        "d c #FFFFFF",
        "e c #808080",
        /* pixels */
        "bbbbbaaaaaaaaabb",
        "bbbbaddddddddabb",
        "bbbbadaaaaadabbb",
        "bbbaddddddddabbb",
        "bbbadaaaaadaaaab",
        "bbaddddddddababa",
        "baaaaaaaaaababaa",
        "abbbbbbbbbbababa",
        "aaaaaaaaaaaaabba",
        "abbbbbbeeebbabab",
        "abbbbbbcccbbaaab",
        "aaaaaaaaaaaaabab",
        "babbbbbbbbbababb",
        "bbaaaaaaaaaaabbb",
        "bbbbbbbbbbbbbbbb"
        };
        wxBitmap bitmap( xpm_data );
#ifndef _WIN32	
	bitmap.SetMask(new wxMask(bitmap, *wxLIGHT_GREY));
#endif		
        return bitmap;
    }
    if (index == 30)
    {
        static const unsigned char data[] = 
        {
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,65,104,95,45,85,71,45,85,
            71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,
            45,85,71,45,85,71,45,85,71,45,85,71,87,123,111,112,155,135,112,155,135,187,225,202,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,65,104,95,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,26,75,59,45,85,71,87,123,111,157,180,176,230,238,230,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,45,
            85,71,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,0,47,29,0,47,29,0,47,29,1,57,38,26,75,59,79,120,94,157,
            180,176,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,45,85,71,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,0,47,29,26,75,59,45,85,71,157,180,176,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,45,85,71,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,65,104,95,187,225,202,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,26,75,59,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,0,47,
            29,26,75,59,112,155,135,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,45,85,71,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,65,104,95,207,235,222,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,26,
            75,59,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,0,47,29,45,85,71,165,213,
            182,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,26,75,59,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            0,47,29,26,75,59,157,180,176,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,87,123,111,45,85,71,45,85,71,45,85,71,45,85,71,45,
            85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,
            71,1,57,38,26,75,59,45,85,71,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,0,47,29,26,75,59,124,187,147,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,207,235,222,124,187,147,112,155,135,45,85,71,26,
            75,59,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,0,47,29,26,75,59,165,213,182,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,187,225,202,79,120,94,26,75,59,0,47,29,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,0,
            47,29,45,85,71,207,235,222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,230,238,230,
            187,225,202,187,225,202,187,225,202,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,
            221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,
            189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,
            170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,
            221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,
            189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,
            170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,
            221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,
            189,170,221,189,170,221,189,170,221,189,170,221,189,170,221,189,187,225,202,187,225,202,187,225,202,
            230,238,230,255,255,255,255,255,255,255,255,255,255,255,255,187,225,202,87,123,111,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,0,47,29,65,104,95,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,187,225,202,151,
            213,175,151,213,175,140,208,165,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,
            159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,
            131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,
            206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,
            159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,
            131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,
            206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,
            159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,
            131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,
            206,159,140,208,165,140,208,165,151,213,175,187,225,202,239,248,242,255,255,255,255,255,255,255,255,
            255,157,180,176,26,75,59,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,112,155,135,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,151,213,
            175,140,208,165,131,206,159,131,206,159,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,131,206,159,131,206,159,131,206,159,131,206,159,151,213,175,187,225,202,
            255,255,255,255,255,255,255,255,255,187,225,202,45,85,71,0,47,29,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,26,75,
            59,187,225,202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,207,235,222,151,213,175,
            131,206,159,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,151,213,175,207,235,222,255,255,255,255,255,255,230,238,230,65,104,95,0,47,
            29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,0,47,29,65,104,95,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,187,225,202,140,
            208,165,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,131,206,159,140,208,165,187,225,202,255,255,255,255,255,255,
            219,241,227,45,85,71,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,157,180,176,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,187,225,
            202,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,170,
            221,189,255,255,255,255,255,255,187,225,202,26,75,59,0,47,29,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            187,225,202,140,208,165,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,187,225,202,255,255,255,255,255,255,124,187,147,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,157,180,176,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,207,235,222,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,207,235,222,255,255,255,255,255,255,65,
            104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,0,47,29,79,120,94,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,151,213,175,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,255,255,
            255,255,255,255,187,225,202,26,75,59,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,26,75,59,230,238,230,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,187,225,202,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,187,225,202,255,255,255,255,255,255,79,120,94,0,47,29,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,124,187,147,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,151,213,175,131,206,159,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,131,206,159,151,213,175,239,248,242,255,255,255,170,221,189,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            87,123,111,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,187,225,202,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,187,225,202,255,255,255,255,255,255,
            45,85,71,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,26,75,59,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,151,213,175,131,
            206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,131,206,
            159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,
            131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,
            206,159,131,206,159,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,255,
            255,255,255,255,255,79,120,94,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,0,47,29,45,85,71,187,225,202,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,230,238,
            230,151,213,175,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,124,187,147,124,187,147,124,187,147,124,187,147,124,187,147,131,206,159,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,131,206,159,131,206,159,131,206,159,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,230,238,230,255,255,255,124,187,147,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,112,155,135,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,187,225,202,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,124,187,147,0,47,29,9,13,11,9,13,11,9,13,11,9,13,11,79,120,94,
            151,213,175,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,
            206,159,151,213,175,239,248,242,239,248,242,239,248,242,239,248,242,239,248,242,170,221,189,131,206,
            159,140,208,165,239,248,242,239,248,242,239,248,242,239,248,242,239,248,242,239,248,242,239,248,242,
            239,248,242,239,248,242,239,248,242,239,248,242,239,248,242,239,248,242,219,241,227,187,225,202,165,
            213,182,131,206,159,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,207,235,222,255,255,255,170,221,189,26,75,59,1,57,38,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,112,155,
            135,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,124,187,147,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,79,120,94,151,213,175,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            187,225,202,131,206,159,140,208,165,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,219,241,227,165,213,182,131,206,159,131,206,159,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,170,221,189,255,255,255,207,235,222,45,85,
            71,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,87,123,111,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,
            0,0,0,0,0,0,0,79,120,94,151,213,175,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,187,225,202,255,255,255,
            255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,65,104,95,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,
            0,0,0,0,0,0,0,0,0,0,0,0,79,120,94,151,213,175,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,170,221,189,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,170,
            221,189,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,
            189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,
            187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,79,120,94,151,213,175,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,
            248,242,254,254,254,254,254,254,254,254,254,254,254,254,207,235,222,151,213,175,151,213,175,151,213,
            175,151,213,175,165,213,182,170,221,189,207,235,222,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,140,208,165,131,206,159,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,131,206,159,187,225,202,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,79,120,94,
            151,213,175,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,
            206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,
            159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,
            131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,151,213,175,239,248,242,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,131,206,159,170,221,189,255,255,255,255,255,255,65,104,95,0,47,29,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,
            71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,
            0,0,79,120,94,151,213,175,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,
            225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,
            159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,239,248,242,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,131,206,159,187,225,202,255,255,255,255,255,255,65,104,
            95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,
            0,0,0,0,0,0,0,79,120,94,151,213,175,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,
            254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,131,206,159,187,225,202,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,165,213,182,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,170,221,189,255,255,255,
            255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,
            0,0,0,0,0,0,0,0,0,0,0,0,79,120,94,151,213,175,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,
            254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,187,
            225,202,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,
            189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,
            187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,79,120,94,170,221,189,140,208,
            165,131,206,159,131,206,159,131,206,159,140,208,165,151,213,175,151,213,175,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,151,
            213,175,151,213,175,131,206,159,131,206,159,131,206,159,151,213,175,151,213,175,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,
            248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,239,248,242,
            254,254,254,254,254,254,254,254,254,254,254,254,207,235,222,131,206,159,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,131,206,159,170,221,189,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,63,67,58,
            45,85,71,0,47,29,9,13,11,9,13,11,9,13,11,26,75,59,45,85,71,112,155,135,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,112,155,135,45,85,71,26,75,59,9,13,11,9,13,11,0,47,29,26,75,59,79,120,94,
            124,187,147,151,213,175,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,
            206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,
            159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,
            206,159,219,241,227,254,254,254,254,254,254,254,254,254,254,254,254,219,241,227,131,206,159,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,131,206,159,187,225,202,255,255,255,255,255,255,65,104,95,0,47,29,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,
            71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,47,29,112,155,135,151,213,175,140,208,165,140,208,165,140,208,165,151,213,175,
            124,187,147,45,85,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,9,13,11,65,104,95,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,
            225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,131,206,159,207,235,222,254,254,254,254,254,254,254,254,254,254,254,254,230,238,230,
            131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,131,206,159,170,221,189,255,255,255,255,255,255,65,104,
            95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,120,94,151,213,175,140,208,165,151,
            213,175,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,67,58,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,
            254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,131,206,159,207,235,222,254,254,254,254,254,254,254,254,254,254,
            254,254,230,238,230,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,187,225,202,255,255,255,
            255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,120,
            94,151,213,175,131,206,159,0,47,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,
            85,71,151,213,175,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,
            254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,207,235,222,254,254,254,254,254,
            254,254,254,254,254,254,254,230,238,230,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,170,
            221,189,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,
            189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,
            187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,67,58,113,84,
            21,113,84,21,113,84,21,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,124,187,147,45,85,71,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,192,11,13,192,11,13,239,16,16,192,11,13,9,13,11,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,87,123,111,151,213,175,140,208,165,140,208,165,131,206,159,151,213,175,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,
            248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,207,235,222,
            254,254,254,254,254,254,254,254,254,254,254,254,230,238,230,131,206,159,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,131,206,159,187,225,202,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,170,156,34,
            255,255,51,255,255,51,255,255,51,255,255,51,254,232,51,170,156,34,9,13,11,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,47,29,9,13,11,0,0,0,0,0,0,0,0,
            0,0,0,0,192,11,13,239,16,16,239,16,16,239,16,16,239,16,16,239,16,16,9,13,11,
            0,0,0,0,0,0,0,0,0,0,0,0,0,47,29,140,208,165,140,208,165,140,208,165,131,
            206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,
            159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,
            206,159,207,235,222,254,254,254,254,254,254,254,254,254,254,254,254,230,238,230,131,206,159,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,131,206,159,170,221,189,255,255,255,255,255,255,65,104,95,0,47,29,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,
            71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,
            0,0,181,166,37,255,255,51,254,232,51,254,232,51,254,232,51,254,232,51,255,255,51,181,166,
            37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,192,11,13,239,16,16,239,16,16,239,16,16,239,16,16,239,16,16,239,
            16,16,192,11,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,155,135,151,213,
            175,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,
            225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,131,206,159,207,235,222,254,254,254,254,254,254,254,254,254,254,254,254,230,238,230,
            131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,131,206,159,187,225,202,255,255,255,255,255,255,65,104,
            95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,
            0,0,0,0,0,0,0,170,156,34,255,255,51,254,232,51,254,232,51,254,232,51,254,232,51,
            254,232,51,255,255,51,113,84,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,239,16,16,239,16,16,239,16,16,239,16,16,239,16,
            16,239,16,16,239,16,16,239,16,16,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,
            65,104,95,151,213,175,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,
            254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,131,206,159,207,235,222,254,254,254,254,254,254,254,254,254,254,
            254,254,230,238,230,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,170,221,189,255,255,255,
            255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,
            0,0,0,0,0,0,0,0,0,0,0,0,170,156,34,255,255,51,254,232,51,254,232,51,254,
            232,51,254,232,51,254,232,51,254,232,51,206,188,42,9,13,11,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,11,13,192,11,13,192,11,13,
            192,11,13,192,11,13,192,11,13,192,11,13,192,11,13,9,13,11,0,0,0,0,0,0,0,
            0,0,0,0,0,63,67,58,151,213,175,140,208,165,131,206,159,151,213,175,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,
            254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,207,235,222,254,254,254,254,254,
            254,254,254,254,254,254,254,230,238,230,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,187,
            225,202,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,
            189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,
            187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,170,156,34,255,255,51,254,232,
            51,254,232,51,254,232,51,254,232,51,254,232,51,254,232,51,254,232,51,9,13,11,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,1,57,38,140,208,165,140,208,165,131,206,159,151,213,175,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,
            248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,207,235,222,
            254,254,254,254,254,254,254,254,254,254,254,254,230,238,230,131,206,159,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,131,206,159,170,221,189,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,170,156,34,
            255,255,51,254,232,51,254,232,51,254,232,51,254,232,51,254,232,51,254,232,51,254,232,51,113,
            84,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,57,38,140,208,165,140,208,165,131,
            206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,
            159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,
            206,159,207,235,222,254,254,254,254,254,254,254,254,254,254,254,254,239,248,242,131,206,159,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,131,206,159,187,225,202,255,255,255,255,255,255,65,104,95,0,47,29,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,
            71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,
            0,0,170,156,34,255,255,51,254,232,51,254,232,51,254,232,51,254,232,51,254,232,51,254,232,
            51,254,232,51,63,67,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,29,140,208,
            165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,
            225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,131,206,159,219,241,227,254,254,254,254,254,254,254,254,254,254,254,254,230,238,230,
            131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,131,206,159,170,221,189,255,255,255,255,255,255,65,104,
            95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,0,0,0,0,0,
            0,0,0,0,0,0,0,170,156,34,255,255,51,254,232,51,254,232,51,254,232,51,254,232,51,
            254,232,51,254,232,51,254,232,51,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,26,75,59,45,85,71,45,85,71,45,85,71,45,85,
            71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,45,85,71,
            65,104,95,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,
            254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,131,206,159,230,238,230,254,254,254,254,254,254,254,254,254,254,
            254,254,207,235,222,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,187,225,202,255,255,255,
            255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,187,147,9,13,11,
            0,0,0,0,0,0,0,0,0,0,0,0,170,156,34,255,255,51,254,232,51,254,232,51,254,
            232,51,254,232,51,254,232,51,254,232,51,206,188,42,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,123,111,170,221,189,151,213,175,
            151,213,175,151,213,175,151,213,175,151,213,175,151,213,175,151,213,175,151,213,175,151,213,175,151,
            213,175,151,213,175,151,213,175,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,
            254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,131,206,159,140,208,165,239,248,242,254,254,254,254,254,
            254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,170,
            221,189,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,
            189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,124,
            187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,170,156,34,255,255,51,254,232,
            51,254,232,51,254,232,51,254,232,51,254,232,51,255,255,51,113,84,21,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,75,59,151,
            213,175,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,
            248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,170,221,189,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,170,221,189,131,206,159,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,131,206,159,187,225,202,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,151,213,175,131,206,159,124,187,147,140,208,
            165,151,213,175,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,170,156,34,
            255,255,51,254,232,51,254,232,51,254,232,51,254,232,51,255,255,51,181,166,37,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,87,123,111,151,213,175,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,
            206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,
            159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,140,208,165,239,
            248,242,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,140,208,165,131,206,159,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,131,206,159,170,221,189,255,255,255,255,255,255,65,104,95,0,47,29,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,
            71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,79,120,94,9,13,11,
            9,13,11,26,75,59,124,187,147,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,
            0,0,181,166,37,255,255,51,255,255,51,255,255,51,255,255,51,255,255,51,181,166,37,9,13,
            11,0,0,0,0,0,0,0,0,0,0,0,0,9,13,11,79,120,94,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,87,123,111,151,213,175,151,213,175,151,213,175,151,
            213,175,151,213,175,151,213,175,151,213,175,112,155,135,79,120,94,140,208,165,140,208,165,140,208,
            165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,254,254,254,254,187,
            225,202,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,131,206,159,151,213,
            175,230,238,230,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,207,235,222,131,206,159,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,131,206,159,187,225,202,255,255,255,255,255,255,65,104,
            95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,
            1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,112,155,135,0,
            0,0,0,0,0,0,0,0,0,0,0,26,75,59,124,187,147,9,13,11,0,0,0,0,0,
            0,0,0,0,0,0,0,113,84,21,181,166,37,206,188,42,206,188,42,170,156,34,113,84,21,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,120,94,151,213,175,26,
            75,59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,75,59,79,120,
            94,112,155,135,112,155,135,87,123,111,79,120,94,26,75,59,0,0,0,0,0,0,124,187,147,
            140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,254,254,254,254,254,
            254,254,254,254,207,235,222,151,213,175,165,213,182,165,213,182,165,213,182,165,213,182,170,221,189,
            207,235,222,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,151,
            213,175,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,170,221,189,255,255,255,
            255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,
            57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,189,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,151,213,
            175,45,85,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,155,135,9,13,11,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,104,95,151,213,
            175,151,213,175,124,187,147,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,65,104,95,151,213,175,131,206,159,131,206,159,131,206,159,151,213,175,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,248,242,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,131,206,159,187,
            225,202,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,1,57,38,1,57,
            38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,221,
            189,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,151,213,175,45,85,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,
            155,135,9,13,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,120,94,
            151,213,175,140,208,165,140,208,165,151,213,175,112,155,135,9,13,11,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,9,13,11,140,208,165,140,208,165,140,208,165,131,206,159,151,213,175,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,159,140,208,165,239,
            248,242,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,254,187,225,202,131,206,159,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,
            165,131,206,159,187,225,202,255,255,255,255,255,255,65,104,95,0,47,29,1,57,38,1,57,38,
            1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,45,85,71,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,187,225,202,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,
            208,165,140,208,165,140,208,165,140,208,165,112,155,135,0,0,0,0,0,0,0,0,0,0,0,
            0,63,67,58,131,206,159,0,47,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,75,59,112,
            155,135,151,213,175,140,208,165,140,208,165,140,208,165,140,208,165,151,213,175,124,187,147,26,75,
            59,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,26,75,59,112,155,135,140,208,165,140,208,165,140,208,165,131,
            206,159,151,213,175,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,187,225,202,131,206,
            159,140,208,165,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,
            254,254,219,241,227,165,213,182,131,206,159,131,206,159,140,208,165,140,208,165,140,208,165,140,208,
            165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,140,208,165,
            140,208,165,140,208,165,140,208,165,170,221,189,255,255,255,207,235,222,45,85,71,0,47,29,1,
            57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,1,57,38,87,123,
            111,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
            255,255,255,255,255,255,255,255,187,225,202,140,208,165,140,208,165,140,208,165,140,208,165,1