/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.Feature;
import com.springrts.ai.oo.clb.FeatureDef;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.ResourceManager;
import hughai.basictypes.TerrainPos;
import hughai.mapping.Maps;
import hughai.unitdata.UnitController;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import java.util.List;

public class ReclaimHelper {
    final int maxreclaimradius = 500;
    final int reclaimradiusperonehundredmetal = 150;
    PlayerObjects playerObjects;
    LogFile logfile;
    OOAICallback aicallback;
    UnitController unitController;
    UnitDefHelp unitDefHelp;
    ResourceManager resourceManager;
    DrawingUtils drawingUtils;
    CSAI csai;
    Maps maps;

    public ReclaimHelper(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.logfile = playerObjects.getLogFile();
        this.aicallback = playerObjects.getAicallback();
        this.unitController = playerObjects.getUnitController();
        this.unitDefHelp = playerObjects.getUnitDefHelp();
        this.resourceManager = playerObjects.getResourceManager();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.csai = playerObjects.getCSAI();
        this.maps = playerObjects.getMaps();
    }

    public TerrainPos GetNearestReclaim(Unit unit) {
        TerrainPos terrainPos = this.unitController.getPos(unit);
        if (this.playerObjects.getFrameController().getFrame() == 0) {
            return null;
        }
        UnitDef unitDef = unit.getDef();
        if (!this.unitDefHelp.IsMobile(unitDef)) {
            return null;
        }
        int n = this.maps.getMovementMaps().GetArea(unitDef, terrainPos);
        float f = 0.0f;
        Feature feature = null;
        int n2 = (int)(this.resourceManager.getMetalStorage() - this.resourceManager.getCurrentMetal());
        this.logfile.WriteLine("available space in metal storage: " + n2);
        List list = this.aicallback.getFeaturesIn(terrainPos.toAIFloat3(), 500.0f);
        boolean bl = false;
        for (Feature feature2 : list) {
            TerrainPos terrainPos2;
            float f2;
            float f3;
            FeatureDef featureDef = feature2.getDef();
            float f4 = featureDef.getContainedResource(this.resourceManager.getMetalResource());
            if (!(f4 > 0.0f) || !(f4 <= (float)n2) || !((f3 = f4 / (f2 = (float)Math.sqrt((terrainPos2 = TerrainPos.fromAIFloat3(feature2.getPosition())).GetSquaredDistance(terrainPos)))) > f) || this.maps.getMovementMaps().GetArea(unitDef, terrainPos2) != n) continue;
            this.logfile.WriteLine("Potential reclaim, distance = " + f2 + " metal = " + f4 + " ratio = " + f3);
            f = f3;
            feature = feature2;
            bl = true;
        }
        if (bl && (double)f > 6.666666666666667E-5) {
            TerrainPos terrainPos3 = TerrainPos.fromAIFloat3(feature.getPosition());
            this.logfile.WriteLine("Reclaim found, pos " + terrainPos3.toString());
            if (this.csai.DebugOn) {
                this.drawingUtils.DrawUnit("ARMMEX", terrainPos3, 0.0f, 200, this.aicallback.getSkirmishAI().getTeamId(), true, true);
            }
            return terrainPos3;
        }
        return null;
    }
}

