/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.concurrent.AbstractAggregateSearchExecutor;
import org.ldaptive.concurrent.OperationWorker;
import org.ldaptive.concurrent.SearchOperationWorker;
import org.ldaptive.handler.SearchEntryHandler;

public class AggregateSearchExecutor
extends AbstractAggregateSearchExecutor<ConnectionFactory> {
    public AggregateSearchExecutor() {
        this(Executors.newCachedThreadPool());
    }

    public AggregateSearchExecutor(ExecutorService es) {
        super(es);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<Response<SearchResult>> search(ConnectionFactory[] factories, SearchFilter[] filters, String[] attrs, SearchEntryHandler ... handlers) throws LdapException {
        void var10_13;
        ConnectionFactory[] sr;
        ExecutorCompletionService searches = new ExecutorCompletionService(this.getExecutorService());
        Request[] requests = new SearchRequest[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            sr = AggregateSearchExecutor.newSearchRequest(this);
            if (filters[i] != null) {
                sr.setSearchFilter(filters[i]);
            }
            if (attrs != null) {
                sr.setReturnAttributes(attrs);
            }
            if (handlers != null) {
                sr.setSearchEntryHandlers(handlers);
            }
            requests[i] = sr;
        }
        ArrayList futures = new ArrayList(factories.length * filters.length);
        sr = factories;
        int n = sr.length;
        boolean bl = false;
        while (var10_13 < n) {
            ConnectionFactory factory = sr[var10_13];
            Connection conn = factory.getConnection();
            SearchOperation op = this.createSearchOperation(conn);
            SearchOperationWorker worker = new SearchOperationWorker(op, this.getExecutorService());
            futures.add(searches.submit(AggregateSearchExecutor.createCallable((Connection)conn, (OperationWorker)worker, (Request[])requests)));
            ++var10_13;
        }
        ArrayList<Response<SearchResult>> responses = new ArrayList<Response<SearchResult>>(factories.length * filters.length);
        for (Future future : futures) {
            try {
                responses.addAll((Collection)future.get());
            }
            catch (ExecutionException e) {
                this.logger.debug("ExecutionException thrown, ignoring", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.logger.warn("InterruptedException thrown, ignoring", (Throwable)e);
            }
        }
        return responses;
    }

    protected static <Q extends Request, S> Callable<Collection<Response<S>>> createCallable(Connection conn, OperationWorker<Q, S> worker, Q[] requests) {
        return () -> {
            try {
                conn.open();
                Collection collection = worker.executeToCompletion((Request[])requests);
                return collection;
            }
            finally {
                conn.close();
            }
        };
    }
}

