/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

a convenient class to convert a label image to a label map and valuate
the statistics attributes at once



Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


See:
 StatisticsLabelObject , LabelStatisticsOpeningImageFilter , LabelStatisticsOpeningImageFilter

 itk::LabelImageToStatisticsLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelIntensityStatisticsImageFilter.h
*/
public class LabelIntensityStatisticsImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelIntensityStatisticsImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelIntensityStatisticsImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelIntensityStatisticsImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelIntensityStatisticsImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelIntensityStatisticsImageFilter::~LabelIntensityStatisticsImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelIntensityStatisticsImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelIntensityStatisticsImageFilter::LabelIntensityStatisticsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelIntensityStatisticsImageFilter() {
    this(SimpleITKJNI.new_LabelIntensityStatisticsImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelIntensityStatisticsImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.LabelIntensityStatisticsImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetBackgroundValue() const

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelIntensityStatisticsImageFilter::SetComputeFeretDiameter(bool ComputeFeretDiameter)

Set/Get whether the maximum Feret diameter should be computed or not.
The default value is false, because of the high computation time
required.

*/
public  void setComputeFeretDiameter(boolean ComputeFeretDiameter) {
    SimpleITKJNI.LabelIntensityStatisticsImageFilter_setComputeFeretDiameter(swigCPtr, this, ComputeFeretDiameter);
  }

  /**
Self&amp; itk::simple::LabelIntensityStatisticsImageFilter::ComputeFeretDiameterOn()

Set the value of ComputeFeretDiameter to true or false respectfully.

*/
public  void computeFeretDiameterOn() {
    SimpleITKJNI.LabelIntensityStatisticsImageFilter_computeFeretDiameterOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelIntensityStatisticsImageFilter::ComputeFeretDiameterOff()
*/
public  void computeFeretDiameterOff() {
    SimpleITKJNI.LabelIntensityStatisticsImageFilter_computeFeretDiameterOff(swigCPtr, this);
  }

  /**
bool itk::simple::LabelIntensityStatisticsImageFilter::GetComputeFeretDiameter() const

Set/Get whether the maximum Feret diameter should be computed or not.
The default value is false, because of the high computation time
required.

*/
public  boolean getComputeFeretDiameter() {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getComputeFeretDiameter(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelIntensityStatisticsImageFilter::SetComputePerimeter(bool ComputePerimeter)

Set/Get whether the perimeter should be computed or not. The default
value is false, because of the high computation time required.

*/
public  void setComputePerimeter(boolean ComputePerimeter) {
    SimpleITKJNI.LabelIntensityStatisticsImageFilter_setComputePerimeter(swigCPtr, this, ComputePerimeter);
  }

  /**
Self&amp; itk::simple::LabelIntensityStatisticsImageFilter::ComputePerimeterOn()

Set the value of ComputePerimeter to true or false respectfully.

*/
public  void computePerimeterOn() {
    SimpleITKJNI.LabelIntensityStatisticsImageFilter_computePerimeterOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelIntensityStatisticsImageFilter::ComputePerimeterOff()
*/
public  void computePerimeterOff() {
    SimpleITKJNI.LabelIntensityStatisticsImageFilter_computePerimeterOff(swigCPtr, this);
  }

  /**
bool itk::simple::LabelIntensityStatisticsImageFilter::GetComputePerimeter() const

Set/Get whether the perimeter should be computed or not. The default
value is false, because of the high computation time required.

*/
public  boolean getComputePerimeter() {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getComputePerimeter(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelIntensityStatisticsImageFilter::SetNumberOfBins(uint32_t NumberOfBins)

Set/Get the number of bins in the histogram. Note that the histogram
is used to compute the median value, and that this option may have an
effect on the value of the median.

*/
public  void setNumberOfBins(long NumberOfBins) {
    SimpleITKJNI.LabelIntensityStatisticsImageFilter_setNumberOfBins(swigCPtr, this, NumberOfBins);
  }

  /**
uint32_t itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfBins() const

Set/Get the number of bins in the histogram. Note that the histogram
is used to compute the median value, and that this option may have an
effect on the value of the median.

*/
public  long getNumberOfBins() {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getNumberOfBins(swigCPtr, this);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetBoundingBox(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorUInt32 getBoundingBox(long label) {
    return new VectorUInt32(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getBoundingBox(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetRegion(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorUInt32 getRegion(long label) {
    return new VectorUInt32(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getRegion(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetCentroid(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getCentroid(long label) {
    return new VectorDouble(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getCentroid(swigCPtr, this, label), true);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetElongation(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getElongation(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getElongation(swigCPtr, this, label);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetEquivalentEllipsoidDiameter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getEquivalentEllipsoidDiameter(long label) {
    return new VectorDouble(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getEquivalentEllipsoidDiameter(swigCPtr, this, label), true);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetEquivalentSphericalPerimeter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getEquivalentSphericalPerimeter(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getEquivalentSphericalPerimeter(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetEquivalentSphericalRadius(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getEquivalentSphericalRadius(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getEquivalentSphericalRadius(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetFeretDiameter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFeretDiameter(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getFeretDiameter(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetFlatness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFlatness(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getFlatness(swigCPtr, this, label);
  }

  /**
std::vector&lt;int64_t&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetLabels() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorInt64 getLabels() {
    return new VectorInt64(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getLabels(swigCPtr, this), true);
  }

  /**
uint64_t itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfPixels(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  java.math.BigInteger getNumberOfPixels(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getNumberOfPixels(swigCPtr, this, label);
  }

  /**
uint64_t itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfPixelsOnBorder(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  java.math.BigInteger getNumberOfPixelsOnBorder(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getNumberOfPixelsOnBorder(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetPerimeter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getPerimeter(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getPerimeter(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetPerimeterOnBorder(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getPerimeterOnBorder(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getPerimeterOnBorder(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetPerimeterOnBorderRatio(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getPerimeterOnBorderRatio(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getPerimeterOnBorderRatio(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetPhysicalSize(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getPhysicalSize(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getPhysicalSize(swigCPtr, this, label);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetPrincipalAxes(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getPrincipalAxes(long label) {
    return new VectorDouble(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getPrincipalAxes(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetPrincipalMoments(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getPrincipalMoments(long label) {
    return new VectorDouble(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getPrincipalMoments(swigCPtr, this, label), true);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetRoundness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getRoundness(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getRoundness(swigCPtr, this, label);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetCenterOfGravity(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getCenterOfGravity(long label) {
    return new VectorDouble(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getCenterOfGravity(swigCPtr, this, label), true);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetKurtosis(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getKurtosis(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getKurtosis(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetMaximum(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMaximum(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getMaximum(swigCPtr, this, label);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetMaximumIndex(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorUInt32 getMaximumIndex(long label) {
    return new VectorUInt32(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getMaximumIndex(swigCPtr, this, label), true);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetMean(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMean(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getMean(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetMedian(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMedian(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getMedian(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetMinimum(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMinimum(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getMinimum(swigCPtr, this, label);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetMinimumIndex(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorUInt32 getMinimumIndex(long label) {
    return new VectorUInt32(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getMinimumIndex(swigCPtr, this, label), true);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetSkewness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getSkewness(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getSkewness(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetStandardDeviation(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getStandardDeviation(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getStandardDeviation(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetSum(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getSum(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getSum(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetVariance(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getVariance(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getVariance(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedElongation(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getWeightedElongation(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getWeightedElongation(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedFlatness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getWeightedFlatness(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getWeightedFlatness(swigCPtr, this, label);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedPrincipalAxes(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getWeightedPrincipalAxes(long label) {
    return new VectorDouble(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getWeightedPrincipalAxes(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelIntensityStatisticsImageFilter::GetWeightedPrincipalMoments(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getWeightedPrincipalMoments(long label) {
    return new VectorDouble(SimpleITKJNI.LabelIntensityStatisticsImageFilter_getWeightedPrincipalMoments(swigCPtr, this, label), true);
  }

  /**
std::string itk::simple::LabelIntensityStatisticsImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelIntensityStatisticsImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_toString(swigCPtr, this);
  }

  /**
void itk::simple::LabelIntensityStatisticsImageFilter::Execute(const Image &amp;image, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  void execute(Image image, Image featureImage) {
    SimpleITKJNI.LabelIntensityStatisticsImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(featureImage), featureImage);
  }

  /**
bool itk::simple::LabelIntensityStatisticsImageFilter::HasLabel(int64_t label)

Does the specified label exist? Can only be called after a call a call
to Update().

*/
public  boolean hasLabel(long label) {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_hasLabel(swigCPtr, this, label);
  }

  /**
uint64_t itk::simple::LabelIntensityStatisticsImageFilter::GetNumberOfLabels()

Return the number of labels after execution.

*/
public  java.math.BigInteger getNumberOfLabels() {
    return SimpleITKJNI.LabelIntensityStatisticsImageFilter_getNumberOfLabels(swigCPtr, this);
  }

}
