/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.applaunch;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UnattendedProgressInterface;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.runtime.installer.helper.applaunch.InProcessCommunication;
import com.install4j.runtime.installer.helper.applaunch.NullCommunication;
import com.install4j.runtime.installer.helper.applaunch.ProgressInterfaceWrapper;
import com.install4j.runtime.installer.helper.applaunch.RemoteCommunication;
import com.install4j.runtime.installer.helper.applaunch.UnattendedProgressInterfaceWrapper;
import com.install4j.runtime.installer.helper.comm.InterProcessCommunication;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressCommunication
implements ApplicationLauncher.ProgressListener {
    private static volatile ProgressCommunication progressCommunication;

    @NotNull
    public static ProgressCommunication getCurrent() {
        ProgressCommunication progressCommunication = ProgressCommunication.progressCommunication;
        if (progressCommunication == null) {
            return NullCommunication.INSTANCE;
        }
        return progressCommunication;
    }

    public static void registerInProcess(@Nullable ApplicationLauncher.ProgressListener progressListener) {
        progressCommunication = progressListener == null ? NullCommunication.INSTANCE : new InProcessCommunication(progressListener);
    }

    public static void init() {
        try {
            String id = System.getProperty("install4j.progressId");
            String hash = System.getProperty("install4j.progressHash");
            if (id != null && hash != null) {
                InterProcessCommunication communication = new InterProcessCommunication(id, hash, true, InterProcessCommunication.INSTALLER_APP_LOGGER);
                Thread thread2 = new Thread(() -> {
                    try {
                        if (communication.connect()) {
                            progressCommunication = new RemoteCommunication(communication);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                });
                thread2.setDaemon(true);
                thread2.start();
                thread2.join(4000L);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public ProgressInterface wrap(ProgressInterface progressInterface) {
        if (progressInterface == null) {
            return null;
        }
        if (progressInterface instanceof UnattendedProgressInterface) {
            return new UnattendedProgressInterfaceWrapper((UnattendedProgressInterface)progressInterface, (ApplicationLauncher.ProgressListener)this);
        }
        return new ProgressInterfaceWrapper(progressInterface, this);
    }

    public final UnattendedProgressInterface wrap(UnattendedProgressInterface progressInterface) {
        return (UnattendedProgressInterface)this.wrap((ProgressInterface)progressInterface);
    }

    public abstract void exiting();
}

