/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class TranslationSource {
    private static Properties translationResources;
    private static final String propertiesFileName = "/TranslationResources.properties";

    public static String getTranslation(Locale locale, String key, String defaultText) {
        TranslationSource.initializePropertiesIfNeeded();
        String language = locale.getLanguage();
        if (language == null || language.isEmpty()) {
            return defaultText;
        }
        String propertyKey = language + ".text." + key;
        String result = translationResources.getProperty(propertyKey, defaultText);
        return result;
    }

    private static void initializePropertiesIfNeeded() {
        if (translationResources != null) {
            return;
        }
        try {
            translationResources = new Properties();
            translationResources.load(TranslationSource.class.getResourceAsStream(propertiesFileName));
        }
        catch (IOException exception) {
            throw new RuntimeException("TranslationSource.initializePropertiesIfNeeded(): Could not load TranslationResources.properties file.", exception);
        }
    }
}

